#include "pm3.h"

#include XRect_i
#include XString_i
#include XMenuBar_i
#include XControlEvent_i
#include XResourceLibrary_i
#include XFileDialog_i
#include XColor_i

#include <stdlib.h>


//create a window out of the resource-file, the last parameter tells the library
//to build the window with the ID given in XResource. 
pm3Window :: pm3Window( XResource * r ): XFrameWindow( r, "pm3", XFrameWindow::defaultStyle | FRM_ICON | FRM_TASKLIST | FRM_CENTER /MENU | FRM_MENU | FRM_ACCELTABLEMENU/)
{
   //Set background-color
   XColor color( COL_WHITE);
   SetBackgroundColor( &color );

   //Set size
   XRect rect( 100,100, 400, 300);
   SetSize(&rect);

/HELP
   //create a helpinstance
   help = new XHelpInstance( "pm3.hlp", GetProcess(), "pm3 - Help");
   //associate the help with this function
   help->AssociateWindow( this );HELP/

   //Activate the window
   Activate();
}


pm3Window :: ~pm3Window()
{
}

//draw the window-content
void pm3Window :: Draw( void )
{
   //fill the background
   FillBackground( );
}


/* here the commands of the menu are posted */
BOOL pm3Window :: DoCommand( LONG command)
{
   switch( command )
      {
         //which menuitem was selected?
         case IDM_OPEN:
/MENU       {
              
               /*File/Open selected */
               /* display the file-dialog defined by the system */
               /* set the file-suffix and title of the dialog */
               XFileDialog fileDlg(this, "*.TXT", NULL, NULL, FD_OPEN | FD_CENTER | FD_MULTIPLESEL);

               /* the user selected a file */
               if( fileDlg.GetCommand() == USER_OK)
                 {
                    XString fileName;
                    SHORT i, files = fileDlg.GetFileCount();  //how much files are selected?
                    for(i=0; i < files; i++)
                       {
                          fileDlg.GetFileName( &fileName, i );        //get filename and path for every file
                          pm3 * thread = new pm3( (char*) fileName ); //start a new thread with the selected file(s)
                          thread->Run();
                       }
                 }
             }MENU/
             break;
         case IDM_SAVEAS:
/MENU       {
              
               /*File/Open selected */
               /* display the file-dialog defined by the system */
               /* set the file-suffix and title of the dialog */
               XFileDialog fileDlg(this, "*.TXT", NULL, NULL, FD_SAVEAS | FD_CENTER );

               /* the user selected a file */
               if( fileDlg.GetCommand() == USER_OK)
                 {
                    XString fileName;
                    fileDlg.GetFileName( &fileName);  //get filename and path where to save
                    //perfor your save_as code here
                 }
            }MENU/
            break;
/MENU/HELP
         case IDM_HELP_HELP:
            help->ShowHelpForHelp();/HELP
            break;
         case IDM_HELP_INDEX:
            help->ShowHelpIndex();
            break;
         case IDM_HELP_GENERAL:
            help->ShowHelpForId( 100 );
            break;HELP/ MENU/
         default:
            break;
      }
   return TRUE;
}


//here the control-events of our window-contents are posted
void pm3Window :: DoControl( XControlEvent * event)
{
   switch( event->GetEventID())              //what type of event?
      {
         case WIN_CHANGED:                   //window-content changed!
            {
               switch( event->GetWindowID()) //which window posted the event?
                  {
                     default:
                        break;               
                  }
            }
      }
}


pm3 :: pm3(char * arg): XThread()
{

}


void pm3 :: Init( void )
{
   //create a resource wich is used to load the menu
   resLib = new XResourceLibrary(this);
   XResource r( IDM_MENU, resLib);

   //create the window
   window = new pm3Window( &r );
}


int main ( int argc, void ** argv)
{
  if( argc > 1)  //there were arguments
     {
        SHORT i;
        for(i=1; i < argc; i++)                           //we asume that every argument is a filename
           {                                              // so we
               pm3 * thread = new pm3( (char*) argv[i] ); //start for every filename a new thread
               thread->Run();                             //let the thread run
           }
     }
  else
     {
        pm3 * thread = new pm3();                //create a thread
        thread->Run();                           //let the thread run
     }

  XThread :: RunThreads();                       //let all threads work

}
