/*
** keys.h - contains definitions of all the keys which invoke commands.
**
** keys.h 1.10   Delta'd: 17:01:20 10/31/92   Mike Lijewski, CNSF
**
** Copyright (c) 1991, 1992 Cornell University
** All rights reserved.
**
** Redistribution and use in source and binary forms are permitted
** provided that: (1) source distributions retain this entire copyright
** notice and comment, and (2) distributions including binaries display
** the following acknowledgement:  ``This product includes software
** developed by Cornell University'' in the documentation or other
** materials provided with the distribution and in all advertising
** materials mentioning features or use of this software. Neither the
** name of the University nor the names of its contributors may be used
** to endorse or promote products derived from this software without
** specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
** IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef __KEYS_H
#define __KEYS_H

const char KEY_CTL_D = 4;       // forward half window - ASCII CTL-D
const char KEY_CTL_U = 0x15;    // backward half window - ASCII CTL-U
const char KEY_TOP   = '<';     // go to first line in listing
const char KEY_BOT   = '>';     // go to last line in listing
const char KEY_CTL_L = '\f';    // repaint screen -- CTR-L
const char KEY_a     = 'a';     // append to current problem
const char KEY_c     = 'c';     // close current problem
const char KEY_d     = 'd';     // delete current problem
const char KEY_e     = 'e';     // examine current problem
const char KEY_l     = 'l';     // log new problem
const char KEY_m     = 'm';     // examine current problem -- aka "more"
const char KEY_q     = 'q';     // quit
const char KEY_r     = 'r';     // reorganize the database for current area
const char KEY_s     = 's';     // subscribe to a problem area
const char KEY_u     = 'u';     // unsubscribe from a problem area
const char KEY_v     = 'v';     // view problem summaries
const char KEY_K     = 'K';     // keyword search over entire problem text
const char KEY_M     = 'M';     // modify keywords
const char KEY_P     = 'P';     // modify priority/severity of problem
const char KEY_R     = 'R';     // reopen a closed problem
const char KEY_S     = 'S';     // save problem listing to file
const char KEY_V     = 'V';     // print out version string
const char KEY_T     = 'T';     // transfer problem to another area
const char KEY_BKSP  = '\b';    // backspace works as expected while in a prompt
const char KEY_BANG  = '!';     // run shell command
const char KEY_ESC   = 0x1B;    // for GNU Emacs compatibility -- ASCII-ESC

// display help
const char KEY_QM    = '?';
const char KEY_H     = 'H';

// forward one line
const char KEY_j          = 'j';
const char KEY_n          = 'n';
const char KEY_CTL_N      = 0xE;   // ASCII CTL-N
const char KEY_SPC        = ' ';
const char KEY_CR         = '\r';  // carriage return
const int  KEY_ARROW_DOWN = 300;   // an arbitrary value

// backward one line
const char KEY_k        = 'k';  // or keyword search over problem headers
const char KEY_p        = 'p';
const char KEY_CTL_P    = 0x10; // ASCII CTL-P
const char KEY_CTL_Y    = 0x19; // ASCII CTL-Y
const int  KEY_ARROW_UP = 301;  // an arbitrary value

// forward one window
const char KEY_CTL_F = 6;    // ASCII CTL-F
const char KEY_CTL_V = 0x16; // ASCII CTL-V

// backward one window
const char KEY_b     = 'b';
const char KEY_CTL_B = 2;   // ASCII CTL-B
const char KEY_CTL_Z = 0x1A; // ASCII CTL-Z

// abort from a prompt - CTL-G
//
// Can't use '\a' here due to some C compilers not recognizing this
// as the terminal bell.
//
const char KEY_ABORT = 0x7;

#endif /* __KEYS_H */
