#include "glMathUtils.h"
/*===========================================================================*/
/* Reduces a normal vector specified as a set of three coordinates, to a unit*/
/* normal vector of length one.                                              */
/*===========================================================================*/
void  glMathNormalizefv ( float vector[3] )
{
   static   float length;
   
   /* Calculate the length of the vector. */
   length = sqrt( (vector[0]*vector[0]) + 
                  (vector[1]*vector[1]) +
                  (vector[2]*vector[2]) );

   /*  Keep the program from blowing up by providing an exceptable */
   /* value for vectors that may calculated too close to zero.     */
   if ( length == 0.0 )
      length = 1.0;

   /*  Dividing each element by the length will result in a */
   /* unit normal vector.                                   */
   vector[0] /= length;
   vector[1] /= length;
   vector[2] /= length;
}

/*===========================================================================*/
/* Points p1, p2, & p3 specified in counter clock-wise order.                */
/*===========================================================================*/
void  glMathGetNormal2fv   ( float v[3][3], float out[3] )
{
   static   float  v1[3], 
                     v2[3];

   /* Calculate two vectors from the three points. */
   v1[0] = v[0][0] - v[1][0];
   v1[1] = v[0][1] - v[1][1];
   v1[2] = v[0][2] - v[1][2];

   v2[0] = v[1][0] - v[2][0];
   v2[1] = v[1][1] - v[2][1];
   v2[2] = v[1][2] - v[2][2];

   /* Take the cross product of the two vectors to get */
   /* the normal vector which will be stored in out.   */
   out[0] = v1[1]*v2[2] - v1[2]*v2[1];
   out[1] = v1[2]*v2[0] - v1[0]*v2[2];
   out[2] = v1[0]*v2[1] - v1[1]*v2[0];

   /* Normalize the vector (shorten length to one). */
   glMathNormalizefv( out );
}

/*===========================================================================*/
/* Points p1, p2, & p3 specified in counter clock-wise order.                */
/*===========================================================================*/
void     glMathGetNormalfv3f( float v1[3], float v2[3], float v3[3], float out[3] )
{
   static   float vector1[3],
                  vector2[3];

   /* Calculate two vectors from the three points. */
   vector1[0] = v1[0] - v2[0];
   vector1[1] = v1[1] - v2[1];
   vector1[2] = v1[2] - v2[2];

   vector2[0] = v2[0] - v3[0];
   vector2[1] = v2[1] - v3[1];
   vector2[2] = v2[2] - v3[2];

   /* Take the cross product of the two vectors to get */
   /* the normal vector which will be stored in out.   */
   out[0] = vector1[1]*vector2[2] - vector1[2]*vector2[1];
   out[1] = vector1[2]*vector2[0] - vector1[0]*vector2[2];
   out[2] = vector1[0]*vector2[1] - vector1[1]*vector2[0];

   /* Normalize the vector (shorten length to one). */
   glMathNormalizefv( out );
}
/*===========================================================================*/
/* This function will give the right angle for 'fovy' given the objects size */ 
/*===========================================================================*/
float glMathGetFovy2f   ( float size, float distance )
{
   float radtheta, 
         degtheta;

   radtheta = 2.0 * atan2( (size/2.0), distance );
   degtheta = ( 180.0 * radtheta ) / PIE;

   return degtheta;
}


