/*
This program accompanies the article WPS PROGRAMMING THE EASY WAY in EDM.
It is used to set up an environment for following the explanations in the article.
*/

call SetLocal                             /* Save current status */
Signal on Halt name StopIt                /* Ctrl-C trap */
Signal on Error name Error                /* Error trap */

/* Article specific information */
ZipFile = "WPSPROG2.ZIP"
Article = "2"

/* General info */
FileDir = ".\SOURCES"
Version = "1.0"
ArticleStem = "Art."
Success = 0
FullScreen = 0

Parse upper Arg Input Art
if Pos("INSTALL", Input)\=0 Then Signal Install
if DataType(Input)\="NUM" Then Signal Syntax

if \IsDir(FileDir) then Signal NotInstalled

Num=4
Src.1="m0201 p0201.rc p0201.ico d0201.h p0201.c p0201.csc paths.inc"
Dst.1="Makefile datadel.rc datadel.ico datares.h datadel.c datadel.csc paths.inc"
Src.2="v0202.h v0202.c m0202 p0202.c p0202.csc"
Dst.2="values.h values.c Makefile datadel.c datadel.csc"
Src.3="v0203.c v0203.h p0203.c p0203.csc"
Dst.3="values.c values.h datadel.c datadel.csc"
Src.4="r0204.c r0204.h p0204.c p0204.csc d0204.rc m0204 r0204.dlg d0204.h"
Dst.4="dialog.c dialog.h datadel.c datadel.csc datadel.rc Makefile datadel.dlg datares.h"
Src.5="p0105.C"
Dst.5="datadel.c"

if Input<1 Then Signal StopIt
if Input>Num Then Signal StopIt

WordNum=1
From=Word(Src.Input, WordNum)
do while From<>""
  To=Word(Dst.Input, WordNum)
  WordNum=WordNum+1
  "@Copy "FileDir"\"From To" > nul"      /* Copy file to working directory */
  "@copy "To"+nul "To" > nul 2> nul"     /* Update the file date (touch) */
  From=Word(Src.Input, WordNum)
  end

Say "Example" Input "is ready."
Signal StopIt

/*****************************************************************************/
Install:
FullScreen = 1
'@ANSI ON >nul'                         /* Turn ANSI on for colors */
ESC='1B'x
Kleur.Kader=ESC || "[1;33;46m"          /* Colordefinitions */
Kleur.Window=ESC || "[1;37;46m"
Kleur.ZwartWit=ESC || "[0m"
Kleur.Onder=ESC || "[1;37;44m"
Kleur.Warning=ESC || "[1;31;44m"

call RxFuncAdd 'SysCurPos','RexxUtil','SysCurPos'
call RxFuncAdd 'SysTextScreenRead','RexxUtil','SysTextScreenRead'
call RxFuncAdd 'SysGetKey','RexxUtil','SysGetKey'
call RxFuncAdd 'SysMkDir','RexxUtil','SysMkDir'
call RxFuncAdd 'SysCurState','RexxUtil','SysCurState'
call RxFuncAdd 'SysFileDelete','RexxUtil','SysFileDelete'
call RxFuncAdd 'SysSearchPath','RexxUtil','SysSearchPath'
call RxFuncAdd 'SysGetMessage','RexxUtil','SysGetMessage'
call RxFuncAdd 'SysTextScreenSize','RexxUtil','SysTextScreenSize'
call RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'

Direc = "C:\WPSPROG"

call SysCurState('Off')
say Kleur.Onder
'@cls'
parse value SysTextScreenSize() with Rows Cols
say Copies('',79)
say Center("Installation program for the samples",79)
say Center("from the article",79)
say Center("WPS PROGRAMMING THE EASY WAY (PART 2)",79)
say Copies('',79)
call ShowDir
call SysCurPos 11,0
say 'Type D to change the install directory.'
say 'Press ENTER to start installation.'
say 'Press ESC to stop.'

do until (Key=13) | (Key=27)
  Key=C2D(Translate(SysGetKey('NoEcho')))
  select
    /* User pressed D */
    when (Key=68) then do
      Antw=GetDirectory()
      if Antw<>"" then do; Direc=FullDir(Antw); call ShowDir; end
      end
    /* User pressed V */
    when (key=86) then call MsgBox " WPS Installation program ", "This is version "Version". Press any key to continue...", ""
    /* User pressed special key, ignore */
    when (key=0) then call SysGetKey('NoEcho')
    otherwise nop
  end
end
if Key=27 then Signal StopIt

call Warning 2                         /* Show msg that we're working */
if \IsDir(Direc) then do                    /* Make sure directory exists */
    Maak = MsgBox(" Directory does not exist ", "Create directory (Y/N) ?","JYN"ESC)
    if Pos(Maak, 'N'ESC)<>0 then Signal StopIt /* Stop on N or Esc */
    call SysMkDir(Direc)
    if Result<>0 then do
       call ErrorMsg(Result)
       Signal Error
       end
    call ClearWarning 1                /* Directory exists, clear warning msg */
  end

/* Remember current directory and go to install directory */
FromDir=Directory()
Direc = FullDir(Direc)
call Directory Direc

/* Check if we're already istalled */
Cont = ""
Status = ""
/* If directory already exists, there may be a previous installation */
if IsDir(FileDir) then do
  /* There was a complete install if our article file exists */
  if Stream(FileDir'\'ArticleStem||Article, 'C', 'Query Exists')<>"" then Status = "completely"
  else do
    /* If other articles were installed, it's perfectly normal that the directory exists */
    /* but if no articles were completely installed, there was a partial attempt */
    call SysFileTree FileDir'\'ArticleStem'*', 'Files', 'F'
    if Files.0=0 then Status = "partially"
    end
  end
if Status<>"" then do
  Cont = MsgBox(" Already installed ", "You already have (probably "Status") installed the sample files. Do you want to continue installation (Y/N) ?", "YJN"ESC)
  if Pos(Cont, 'N'ESC)<>0 then Signal StopIt /* Stop on N or Esc */
  end

/* Don't make this directory if previously installed, because it exists */
if \IsDir(FileDir) then do
  call SysMkDir(FileDir)
  if Result<>0 then do
    call ErrorMsg(Result)
    Signal Error
    end
  end

/* See if we can find the unzipper */
UnZip=SysSearchPath('PATH', 'UNZIP.EXE');
if UnZip="" Then do
  call MsgBox " Installation error ", "Cannot find UNZIP.EXE anywhere in the PATH. Unable to continue the installation. Press any key to stop...", ""
  Signal Error
  end

/* See if we're installing from the right directory */
if Stream(FromDir'\'ZipFile, 'C', 'Query Exists')="" then do
  call MsgBox " Installation error ", "Cannot find the file "ZipFile" containing the sample files. Unable to continue the installation. Press any key to stop...", ""
  Signal Error
  end

/* OK, now we can proceed. Give the cursor back when unzipping. */
call SysFileDelete(FileDir'\'ArticleStem||Article)
call SysCurState('On')
/* Copy ourselves first */
'@copy 'FromDir'\WPS.CMD . > nul'
/* Let's unzip */
'@cls'
call Directory FileDir
UnZip FromDir'\'ZipFile
ReturnCode = RC
/* Cursor off and go to the working directory */
call SysCurState('Off')
'@copy reg.cmd .. > nul'
'@copy dereg.cmd .. > nul'
'@copy instance.cmd .. > nul'
'@copy restart.cmd .. > nul'
'@copy kill.exe .. > nul'
'@del reg.cmd > nul'
'@del dereg.cmd > nul'
'@del instance.cmd > nul'
'@del restart.cmd > nul'
'@del kill.exe > nul'
'@cd ..'

if ReturnCode<>0 then do
  Cont = MsgBox(" Error unzipping files ", "There was an error while unzipping the sample files. The return code is "||ReturnCode||". The files are probably not properly installed. Do you want to mark this installation as successful anyway (Y/N) ?", "YJN"ESC)
  If Pos(Cont, 'N'ESC)<>0 then Signal StopIt /* Stop on N or Esc */
  end

/* Mark this installation as successful */
call Stream FileDir'\'ArticleStem||Article, 'C', 'Open Write'
call Stream FileDir'\'ArticleStem||Article, 'C', 'Close'
Success = 1

/* Tell 'em it's all over */
DestDir=FullDir(Direc"\"FileDir)
call MsgBox " Installation done ", "The files have been unzipped into the directory "||DestDir||". The directory "||Direc||" will be your working directory for the samples. Press any key to stop...", ""
Signal StopIt

/*****************************************************************************
 Labels
 *****************************************************************************/
Error:
if FullScreen=0 then Say "An error has occurred. Please try again."
Signal StopIt

NotInstalled:
Say "The samples are not installed, or you're in the wrong directory. Please"
Say "type 'WPS INSTALL' to install the samples."
Signal StopIt

Syntax:
Say "Please provide the number mentioned in the article. Refer to the article"
Say "for more information."

StopIt:
If FullScreen=1 Then do
  say Kleur.ZwartWit
  '@cls'
  If Success=0 Then Say "The files were NOT installed."
               Else Say "Files installed successfully."
  end
exit

/*****************************************************************************
 Supporting routines
 *****************************************************************************/
Warning: Procedure Expose Rows Kleur.
/* Shows a message near the bottom of the screen */
arg Nummer
call SysCurPos Rows+Nummer-5,0
select
  when Nummer=1 then Message='Directory does not exist'
  when Nummer=2 then Message='Installing sample files. Please wait...'
  otherwise nop
end
say Kleur.Warning || Center(Message,79) || Kleur.Onder
return

ClearWarning: Procedure Expose Rows Kleur.
/* Clears a warning message */
arg Nummer
call SysCurPos Rows+Nummer-5,0
say Copies(' ',79)
return

GetDirectory: procedure Expose Kleur. Window.
/* Displays a window asking for a directory name. Returns the answer in uppercase. */
  call CreateWindow 12,10,55,4,' Directory '
  call GotoXY 2,1
  say 'Enter the install directory :'
  Antw=Translate(GetString(2,2,51))
  call CloseWindow
return Antw

ShowDir: Procedure Expose Direc Kleur. Rows
/* Shows the currently selected directory and indicates if it exists */
  parse var Direc Drive '\' Rest
  if Rest<>"" then
    Direc=Strip(Direc,'Trailing','\')
  call SysCurPos 8,0
  say Copies(' ',79)
  call SysCurPos 8,0
  say 'Directory you want to work in : 'Direc
  if IsDir(Direc) then call ClearWarning 1
                  else call Warning 1
return

CreateWindow: Procedure Expose Kleur. Onder. Window.
/*
  Creates a window on screen. Syntax: CreateWindow x, y, Width, Heigth, Title.
  The title will be centered in the window. The contents of the screen under the
  window will be preserved (one level only!). Use CloseWindow to restore the
  previous contents, removing the window from screen. The global variable Window
  contains all info CloseWindow will need. Onder contains the screen contents
  under the window. The color of the border is determined by Kleur.Kader.
*/
parse arg x,y,Breedte,Hoogte,Titel
Window.0=x; Window.1=y; Window.2=Hoogte; Window.3=Breedte
Sp=Copies(' ',Breedte-2)
Title=Center(Titel,Breedte-2,'')
Window.4=SysCurPos(y,x)
Onder.0=SysTextScreenRead(y,x,Breedte)
say Kleur.Kader''Title''
do i=1 to Hoogte-2
  call SysCurPos y+i,x
  Onder.i=SysTextScreenRead(y+i,x,Breedte)
  say Kleur.Kader''Kleur.Window || Sp || Kleur.Kader''
  end
Hoogte=Hoogte-1
call SysCurPos y+Hoogte,x
Onder.Hoogte=SysTextScreenRead(y+Hoogte,x,Breedte)
say Kleur.Kader''Copies('',Breedte-2)''
return

CloseWindow: Procedure Expose Kleur. Onder. Window.
/* Restores the screen after a call to CreateWindow. Fails if called without
   a previous call to CreateWindow! */
do i=0 to Window.2-1
call SysCurPos Window.1+i,Window.0
say Kleur.Onder || Onder.i
end
parse var Window.4 row col
call SysCurPos Row,Col
return

GotoXY: Procedure Expose Window. Kleur.
/*
  Positions the cursor in a window and sets the color for the window text. This
  color is determined by Kleur.Window. Only call this if there actually IS
  a window.
*/
arg x,y
say Kleur.Window
call SysCurPos Window.1+y,Window.0+x
return

GetString: Procedure expose Window. Kleur.
/*
  Inputs a string. Syntax : GetString x, y, MaxLen.
  Only call this function in a window (calls GotoXY)!

  Complete the input by pressing ENTER (input is returned) or ESC (empty string
  is returned). Ctrl-Y erases the whole input line. MaxLen is the maximum length
  of the input.
*/
arg x,y,MaxLen
Invoer=""
Len=0
do until (Key=13) | (Key=27)
  call GotoXY x+Len,y
  call SysCurState('On')
  Key=C2D(SysGetKey('NoEcho'))
  call SysCurState('Off')
  select
    when (Key=8) & (Len>0) then Len=Len-1
    when (Key=0) | (Key=224) then call SysGetKey('NoEcho') /* Special keys */
    when Key=25 then Len=0         /* Ctrl-Y: erase whole input line */
    when (Key=13) | (Key=27) then nop
    when Key=9 then nop
    when (Len>=MaxLen) then nop
  otherwise
    Len=Len+1
    Invoer=Invoer || D2C(Key)
  end
  Invoer=Left(Invoer,Len)
  call GotoXY x,y
  say Invoer || Copies(' ',MaxLen-Len)
end
if Key=27 then Invoer=""
return Invoer

MsgBox: Procedure Expose Window. Kleur. Rows Cols
/*
Displays a messagebox with the given titel. Also displays a message in the box
and waits for the user to press one of the possible keys. Possible is a string
with all possible answers, e.g. "YN" if "Y", "y", "N" or "n" are allowed. If
Possible is an empty string, any key is allowed. The messagebox grows to display
the whole message, using word wrap if necessary. The messagebox is placed in
the middle of the screen.
*/
parse arg Title, Message, Possible
Width=50
Line=1                         /* Starting line number */
WordNum=1                      /* Starting word number */
TempText=""                    /* We build each line in TempText. Start empty. */
Message=Space(Translate(Message, , XRANGE('0'x, '1F'x))) /* Remove unwanted characters */
/* Perform word wrap */
do until Word=""
  Word=Word(Message, WordNum)
  if (Length(TempText)+Length(Word)>=Width-3) | Word="" then do
    /* Add current line to the text. We do this if the current word would
       make the current text too wide for the window, OR if this is the end
       of the message. */
    Text.Line=TempText
    /* Spread the word over multiple lines if it is too long. Width = width of
    the window, so Width-4 = maximum width of the text (exclude box and space).
    We'll be adding a - so we  use Width-5. */
    do while length(word)>Width-5
      Line=Line+1
      Text.Line = Left(Word, Width-5)'-';
      Word = Strip(SubStr(Word, Width-4, Length(Word)-Width+5))
    end
    Line=Line+1
    TempText=Word||" "        /* Wrap the word into the next line */
    end
  else TempText = TempText||Word||" "
  WordNum=WordNum+1
  end
LastLine=Line-1
/* LastLine contains the number of lines needed to display the whole word wrapped
   message. We create a window just large enough to hold the message. */
call CreateWindow (Cols-Width)%2,(Rows-Line-1)%2,Width,Line+1,Title
/* Display the complete message */
do i=1 to LastLine
  call GotoXY 2,i
  say Text.i
  end
/* Put cursor at the end of the last line */
call GotoXY Length(Text.LastLine)+2,LastLine
/* Wait for a valid key */
call SysCurState('On')
if Possible="" then Value=1
               else Value=0
do until Pos(Input, Possible)<>Value
  Input=Translate(SysGetKey('NoEcho'))  /* User input in uppercase */
  if Input=D2C(0) then call SysGetKey('NoEcho') /* ignore F-keys */
  end
call SysCurState('Off')
call CloseWindow
return Input

IsDir: Procedure
/* Checks if the argument is a directory */
arg Dir
call SetLocal
NewDir=Directory(Dir)
call EndLocal
return (NewDir\="")

FullDir: Procedure
/*
Converts the argument into a fully qualified directory name if it denotes a
valid directory, or returns the argument unaltered otherwise.
*/
arg Dir
call SetLocal
NewDir=Directory(Dir)
call EndLocal
if NewDir="" then NewDir=Dir
return NewDir

ErrorMsg: Procedure Expose Kleur. Window. Rows Cols
/*
  Shows the error message with the given number in a message box and waits
  for a keypress.
*/
arg Errno
Txt=SysGetMessage(Errno)
if Txt="" then Txt="Unknown error."
call MsgBox " An error has occurred ", Txt||" Press any key to stop...", ""
return
