/*******************************************************************************
*      File: server1.c                                                         *
*                                                                              *
*      Property of Edward D. Boykin                                            *
*      Permission is herby granted to use this code as long as credit          *
*      or beer money is donated to the origional author.                       *
*                                                                              *
*******************************************************************************/
#include <os2.h>
#include <types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <stdio.h>

/* Server main - Set up single socket connection
   Arguments:
       port    port number to accept socket connection from client
*/

main (int argc, char **argv)
{

       ushort  port;   /* Port server is bound to*/
       char    srbuf[50];      /* Character buffer for sending and receiving
                                  data from client */
       int     csocket;        /* Socket for accepting the client connection */
       int     nsocket;        /* Socket which client is connected to */
       int     cname_length;   /* Length of the client name */

       struct  sockaddr_in client;     /* Client's address information */
       struct  sockaddr_in server;     /* Server;s address information */

       /* Make sure a port number was given in the args */

       if (argc != 2) {

               fprintf(stderr, "Usage: %s port\n.", argv[0]);  /* Must have a
                                                            port to bind to */
               exit(1);                                        /* Bye Bye */

               } /* End if */

       /* Here we will initialize the sockets. This check to see if there is a
          network running */

       sock_init();            /* returns 0 - failed
                                          1 - success */

       /* The port is now prepped by converting the argument to an integer and
          then running htons()
          to convert it from host to network byte order . It is then placed in
          the servers sockaddr_in
          struct's sin_port field.*/

       port = (ushort) atoi(argv[1]);

       server.sin_port = htons(port);

       /* Now the socket for creating connections is made using the socket()
          call
          It returns > 0 if succes and this is the socket descriptor. -1
          Indicates an error.
          Check error by calling psock_errno() */

       if ((csocket = socket(AF_INET, SOCK_STREAM, 0)) < 0) {

               psock_errno("Socket()");
               exit(2);

               }

       /* Now the new socket is bound to the server's address by calling bind()
          First the rest of the neccessary field in the server's sockaddr_in
          struct are filled*/

       server.sin_family = AF_INET;
       server.sin_addr.s_addr = INADDR_ANY;

       if (bind (csocket, (struct sockaddr *)&server, sizeof(server)) < 0) {

               psock_errno("Bind()");
               exit(3);

               }

       /* The server is now prepped to be a server. Now lets set it up to
          actually listen for and accept connections from the client */

       /* Listen for a connection */

       if (listen(csocket, 1) != 0) {

               psock_errno("Listen()");
               exit(4);

               }

       /* Accept the new client connection. Set cname_length to the size of the
          sockaddr_in struct */

       cname_length = sizeof(client);

       if ((nsocket =
            accept(csocket, (struct sockaddr *)&client, &cname_length)) == -1){

               psock_errno("Accept()");
               exit(5);

               }

       /* We now have the new connection lets get this guys name... */

       if (recv(nsocket, srbuf, sizeof(srbuf), 0) == -1) {

               psock_errno("Recv()");
               exit(6);

               }

        /* Print out who jsut called us */

        fprintf(stderr, " Server message: %s just gave us a call\n", srbuf);

        /* Now lets reply to the clinet and tell him we heard him */

        sprintf (srbuf, "Hi, we read you loud and clear");

        if (send(nsocket, srbuf, sizeof(srbuf), 0) <0) {

               psock_errno("Send()");
               exit(7);

               }

        /* Thats it lets close up shop by closing the sockets...*/

        soclose(csocket);
        soclose(nsocket);

        printf("Server Test was successful\n");
        exit(0);

}


