/*****************************************************************************
 * RmxComms
 ***************************************************************************** 
 *
 * Source:   $Source$
 *
 * Overview: This module contains the source for RMXCOMMS.DLL, a DLL
 *           that eases the use of an actual RMX communications DLL. 
 *
 * $Log$
 *
 *****************************************************************************
 *
 * Copyright (c) 1995 Johan Wikman
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear in 
 * supporting documentation.
 *
 * THERE IS NO WARRANTY FOR THIS SOFTWARE, TO THE EXTENT PERMITTED BY
 * APPLICABLE LAW. THE SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM
 * IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF
 * ALL NECESSARY SERVICING, REPAIR OR CORRECTION. 
 *
 *****************************************************************************/

/*****************************************************************************
 * Include Files
 *****************************************************************************/

#define INCL_NOCOMMON
#define INCL_NOPMAPI
#define INCL_DOSERRORS
#define INCL_DOSFILEMGR
#define INCL_DOSMISC
#define INCL_DOSMODULEMGR
#include <rmxcomms.h>
#include <os2.h>


/****************************************************************************
 * MODULE TYPES
 ****************************************************************************/

typedef PFN* PPFN;

struct Function
{
  ULONG ulOrdinal;
  PPFN  ppfnAddress;
};


/****************************************************************************
 * MODULE VARIABLES
 ****************************************************************************/

static HMODULE hmodRmxComms;

static ULONG RMXENTRY (*rmxClose)         (HCONNECTION);
static ULONG RMXENTRY (*rmxConnect)       (HCONNECTION);
static ULONG RMXENTRY (*rmxCreate)        (PCSZ, HCONNECTION*);
static ULONG RMXENTRY (*rmxCreateUnique)  (ULONG*, PSZ, HCONNECTION*);
static ULONG RMXENTRY (*rmxDisConnect)    (HCONNECTION);
static ULONG RMXENTRY (*rmxGetServiceName)(PCSZ, ULONG*, PSZ);
static ULONG RMXENTRY (*rmxOpen)          (PCSZ, PCSZ, HCONNECTION*);
static ULONG RMXENTRY (*rmxRead)          (HCONNECTION, 
					   PBYTE, ULONG, ULONG*);
static ULONG RMXENTRY (*rmxWrite)         (HCONNECTION, 
					   PCBYTE, ULONG);


static Function afFunctions[] =
{
  { ORD_RMXCLOSE,          (PPFN) &rmxClose },
  { ORD_RMXCONNECT,        (PPFN) &rmxConnect },
  { ORD_RMXCREATE,         (PPFN) &rmxCreate },
  { ORD_RMXCREATEUNIQUE,   (PPFN) &rmxCreateUnique },
  { ORD_RMXDISCONNECT,     (PPFN) &rmxDisConnect },
  { ORD_RMXGETSERVICENAME, (PPFN) &rmxGetServiceName },
  { ORD_RMXOPEN,           (PPFN) &rmxOpen },
  { ORD_RMXREAD,           (PPFN) &rmxRead },
  { ORD_RMXWRITE,          (PPFN) &rmxWrite }
};

const ULONG cFunctions     = sizeof(afFunctions)/sizeof(Function);


static CHAR acMsgName[]    = "rmxcomms: Environment variable RMXCOMMS "
	                     "is not specified.\n";
static CHAR acMsgDll[]     = "rmxcomms: Failed to load DLL as specified "
			     "by RMXCOMMS.\n";
static CHAR acMsgResolve[] = "rmxcomms: Failed to resolve functions from "
			     "DLL specified by envvar RMXCOMMS.\n";

const ULONG cbMsgName      = sizeof(acMsgName) - 1;
const ULONG cbMsgDll       = sizeof(acMsgDll) - 1;
const ULONG cbMsgResolve   = sizeof(acMsgResolve) - 1;


const HFILE STDERR         = 2;


/****************************************************************************
 * DLL INITIALIZATION FUNCTION
 ****************************************************************************/

#ifdef __BCPLUSPLUS__
// This forces the DLL to be initialized even if the program that
// loads the DLL is not a Borland executable.
extern int _multidll = 0;
#define DLLMAIN _dllmain
#else
#error Verify that this works with your compiler and remove this error \
       directive. You may have to provide an #elif, particular for your \
       compiler. 
#endif

extern "C" ULONG DLLMAIN(ULONG termFlag, HMODULE hMod);

// A return value of 0 tells the loader that the initialization
// failed. 

ULONG _dllmain(ULONG terminating, HMODULE)
{
  // If 'terminating' is zero, DLL initialization is performed. If
  // 'termintaing' is one, DLL termination is performed.
  
  if (!terminating)
    {
      ULONG
	ulNotUsed;
      PCSZ
	pcszRmxComms;

      // First we must get the value of RMXCOMMS.

      if (DosScanEnv("RMXCOMMS", &pcszRmxComms) != NO_ERROR)
	{
	  DosWrite(STDERR, acMsgName, cbMsgName, &ulNotUsed);
	  return 0;
	}

      // Then we can load the actual communications DLL.
      
      if (DosLoadModule(0, 0, pcszRmxComms, &hmodRmxComms) != NO_ERROR)
	{
	  DosWrite(STDERR, acMsgDll, cbMsgDll, &ulNotUsed);
	  hmodRmxComms = 0;
	  return 0;
	}
      
      // Finally we resolve the functions pointers.

      for (int i = 0; i < cFunctions; i++)
	{
	  ULONG
	    ulOrdinal   = afFunctions[i].ulOrdinal;
	  PPFN
	    ppfnAddress = afFunctions[i].ppfnAddress;
	  
	  ULONG
	    rc = DosQueryProcAddr(hmodRmxComms, ulOrdinal, 0, ppfnAddress);

	  if (rc != NO_ERROR)
	    {
	      DosFreeModule(hmodRmxComms);
	      hmodRmxComms = 0;
	      DosWrite(STDERR, acMsgResolve, cbMsgResolve, &ulNotUsed);
	      return 0;
	    }
	}
    }
  else
    DosFreeModule(hmodRmxComms);

  return 1; // Success
}


/****************************************************************************
 * GLOBAL FUNCTIONS
 ****************************************************************************/

ULONG RMXENTRY RmxClose(HCONNECTION hConn)
{
  return rmxClose(hConn);
}


/****************************************************************************/

ULONG RMXENTRY RmxConnect(HCONNECTION hConn)
{
  return rmxConnect(hConn);
}


/****************************************************************************/

ULONG RMXENTRY RmxCreate(PCSZ pszName, HCONNECTION* hConn)
{
  return rmxCreate(pszName, hConn);
}


/****************************************************************************/

ULONG RMXENTRY RmxCreateUnique(ULONG* pulSize, PSZ pszName, HCONNECTION* hConn)
{
  return rmxCreateUnique(pulSize, pszName, hConn);
}


/****************************************************************************/

ULONG RMXENTRY RmxDisConnect(HCONNECTION hConn)
{
  return rmxDisConnect(hConn);
}


/****************************************************************************/

ULONG RMXENTRY RmxGetServiceName(PCSZ service, ULONG* size, PSZ pszName)
{
  return rmxGetServiceName(service, size, pszName);
}


/****************************************************************************/

ULONG RMXENTRY RmxOpen(PCSZ pcszHost, PCSZ pcszPort, HCONNECTION* hConn)
{
  return rmxOpen(pcszHost, pcszPort, hConn);
}


/****************************************************************************/

ULONG RMXENTRY RmxRead(HCONNECTION hConn, 
		       PBYTE       buffer,
		       ULONG       ulSize,
		       ULONG*      pulBytesRead)
{
  return rmxRead(hConn, buffer, ulSize, pulBytesRead);
}


/****************************************************************************/

ULONG RMXENTRY RmxWrite(HCONNECTION       hConn, 
			PCBYTE            buffer,	
			ULONG             ulBytesToWrite)
{
  return rmxWrite(hConn, buffer, ulBytesToWrite);
}
