#ifndef common_h
#define common_h
/*****************************************************************************
 * common
 ***************************************************************************** 
 *
 * Source:   $Source$
 *
 * Overview: This file declares common constants and functions for 
 *           the RMX test programs client.exe, engine.exe and server.exe.
 *
 * $Log$
 *
 ***************************************************************************** 
 *
 * Copyright (c) 1995 Johan Wikman
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear in 
 * supporting documentation.
 *
 * THERE IS NO WARRANTY FOR THIS SOFTWARE, TO THE EXTENT PERMITTED BY
 * APPLICABLE LAW. THE SOFTWARE IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM
 * IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF
 * ALL NECESSARY SERVICING, REPAIR OR CORRECTION. 
 *
 *****************************************************************************/

/*****************************************************************************
 * INCLUDE FILES
 *****************************************************************************/

#include <rmxcomms.h>
#include <os2def.h>


/*****************************************************************************
 * CONSTANTS
 *****************************************************************************/

const ULONG REQUEST_CONNECT       = 1;

const ULONG REPLY_OK              = 1;
const ULONG REPLY_INVALID_REQUEST = 2;
const ULONG REPLY_SPAWNING_FAILED = 3;
const ULONG REPLY_ENGINE_FAILED   = 4;

const ULONG SIZE_MESSAGE          = 4096;
const ULONG SIZE_NAME             = 256;
const ULONG SIZE_PAGE             = 4096;
const ULONG SIZE_STACK            = 8 * SIZE_PAGE;


/*****************************************************************************
 * VARIABLES
 *****************************************************************************/

extern PSZ pszAppName; // Used by print, define in all applications.


/*****************************************************************************
 * FUNCTIONS
 *****************************************************************************/

extern PCSZ  ErrorAsString(ULONG rc);
extern PSZ   GetPortName  ();
extern void  Print        (PCSZ message1, PCSZ message2 = 0);
extern ULONG ReadMessage  (HCONNECTION hConn, 
			   PBYTE* ppbMessage, ULONG* pulBufferSize);
extern BOOL  WriteMessage (HCONNECTION hConn,
			   PBYTE  pbMessage,  ULONG  ulMessageSize);

#endif
