#define INCL_WINBUTTONS
#define INCL_WINDIALOGS
#define INCL_WININPUT
#define INCL_WINWINDOWMGR
#include <os2.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <viowin.h>
#include "cl.h"

#define RB_SELECTED              'o'
#define CB_SELECTED              'x'

typedef struct _INSTDATA {
   ULONG ulSzStruct;
   ULONG ulStyle;
   BOOL bChecked;
} INSTDATA, *PINSTDATA;

MRESULT EXPENTRY pushButtonProc(HVWWND hwndWnd,
                                ULONG ulMsg,
                                MPARAM mpParm1,
                                MPARAM mpParm2)
//-------------------------------------------------------------------------
// This "sub-window procedure" handles the push button-specific messages
//-------------------------------------------------------------------------
{
   PINSTDATA pidData;

   pidData=vwQueryWindowPtr(hwndWnd,1);

   switch (ulMsg) {
   case WM_PAINT:
      {
         RECTL rclWnd;
         CHAR achText[256];
         ULONG ulFore;
         ULONG ulBack;

         vwQueryWindowRect(hwndWnd,&rclWnd);
         rclWnd.xRight--;
         rclWnd.yTop--;

         vwQueryWindowText(hwndWnd,sizeof(achText),achText);

         ulFore=vwQueryForeColor(hwndWnd);
         ulBack=vwQueryBackColor(hwndWnd);

         //----------------------------------------------------------------
         // Fill ourselves with the background color.
         //----------------------------------------------------------------
         vwFillRect(hwndWnd,&rclWnd,ulBack);

         //----------------------------------------------------------------
         // If we have the focus, invert the colors to indicate this
         //----------------------------------------------------------------
         if (vwQueryFocus()==hwndWnd) {
            ulFore^=0x000000FF;
            ulBack^=0x000000FF;
         } /* endif */

         //----------------------------------------------------------------
         // Draw the button text
         //----------------------------------------------------------------
         vwDrawText(hwndWnd,
                    -1,
                    achText,
                    &rclWnd,
                    ulFore,
                    ulBack,
                    DT_CENTER|DT_VCENTER);
      }
      break;
   case WM_CHAR:
      {
         USHORT usFlags;
         USHORT usMods;

         //----------------------------------------------------------------
         // Code like this is what makes me appreciate the similarities
         // of the library to the corresponding PM code.  Here, we
         // check to see if we've been selected using the <SPACE> or
         // <ENTER> keys (either one).
         //----------------------------------------------------------------
         usFlags=KC_VIRTUALKEY | KC_KEYUP;
         usMods=KC_ALT | KC_CTRL | KC_SHIFT;

         if ((CHARMSG(&ulMsg)->fs & usFlags)!=usFlags) {
            return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endif */

         if ((CHARMSG(&ulMsg)->fs & usMods)!=0) {
            return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endif */

         switch (CHARMSG(&ulMsg)->vkey) {
         case VK_SPACE:
         case VK_ENTER:
         case VK_NEWLINE:
            vwPostMsg(hwndWnd,BM_CLICK,0,0);
            break;
         default:
            return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endswitch */
      }
      break;
   case WM_QUERYDLGCODE:
      return MRFROMLONG(DLGC_BUTTON);
   case BM_CLICK:
      vwPostMsg(VWHWND_DESKTOP,
                WM_COMMAND,
                MPFROMSHORT(vwQueryWindowUShort(hwndWnd,QWS_ID)),
                0);
      break;
   case BM_QUERYCHECKINDEX:
      return MRFROMSHORT(-1);
   case BM_QUERYHILITE:
      break;
   case BM_SETHILITE:
      break;
   case BM_QUERYCHECK:
      return MRFROMSHORT(FALSE);
   case BM_SETCHECK:
      return MRFROMSHORT(FALSE);
   case BM_SETDEFAULT:
      break;
   default:
      return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
   } /* endswitch */

   return MRFROMLONG(FALSE);
}

MRESULT EXPENTRY checkBoxProc(HVWWND hwndWnd,
                              ULONG ulMsg,
                              MPARAM mpParm1,
                              MPARAM mpParm2)
//-------------------------------------------------------------------------
// This "sub-window procedure" handles the check box-specific messages
//-------------------------------------------------------------------------
{
   PINSTDATA pidData;

   pidData=vwQueryWindowPtr(hwndWnd,1);

   switch (ulMsg) {
   case WM_PAINT:
      {
         CHAR achFmt[256];
         CHAR chCheck;
         CHAR achText[256];
         ULONG ulFore;
         ULONG ulBack;

         vwQueryWindowText(hwndWnd,sizeof(achFmt),achFmt);

         //----------------------------------------------------------------
         // See if we're checked and, if so, display the appropriate
         // character in the brackets.  Note our choice of character
         // to display ("x").  While ("") is probably the better choice,
         // we must remember that this character might not be available
         // in other codepages.
         //----------------------------------------------------------------
         chCheck=pidData->bChecked?CB_SELECTED:' ';

         sprintf(achText,"[%c] %s",chCheck,achFmt);

         ulFore=vwQueryForeColor(hwndWnd);
         ulBack=vwQueryBackColor(hwndWnd);

         //----------------------------------------------------------------
         // If we have the focus, invert the colors to indicate this
         //----------------------------------------------------------------
         if (vwQueryFocus()==hwndWnd) {
            ulFore^=0x000000FF;
            ulBack^=0x000000FF;
         } /* endif */

         //----------------------------------------------------------------
         // Draw the button text as we have built it above
         //----------------------------------------------------------------
         vwDrawText(hwndWnd,
                    -1,
                    achText,
                    NULL,
                    ulFore,
                    ulBack,
                    DT_LEFT|DT_VCENTER|DT_ERASERECT);
      }
      break;
   case WM_CHAR:
      {
         USHORT usFlags;
         USHORT usMods;

         usFlags=KC_VIRTUALKEY | KC_KEYUP;
         usMods=KC_ALT | KC_CTRL | KC_SHIFT;

         if ((CHARMSG(&ulMsg)->fs & usFlags)!=usFlags) {
            return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endif */

         if ((CHARMSG(&ulMsg)->fs & usMods)!=0) {
            return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endif */

         //----------------------------------------------------------------
         // If the user pressed the spacebar, toggle the checked state
         // by sending ourselves a BM_CLICK message
         //----------------------------------------------------------------
         switch (CHARMSG(&ulMsg)->vkey) {
         case VK_SPACE:
            vwPostMsg(hwndWnd,BM_CLICK,0,0);
            break;
         default:
            return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endswitch */
      }
      break;
   case WM_QUERYDLGCODE:
      return MRFROMLONG(DLGC_BUTTON);
   case BM_CLICK:
      //-------------------------------------------------------------------
      // Toggle the check state, repaint ourselves, and send the
      // notification to our owner, which is always the desktop.
      //-------------------------------------------------------------------
      pidData->bChecked=!pidData->bChecked;
      vwSendMsg(hwndWnd,WM_PAINT,0,0);

      vwSendMsg(VWHWND_DESKTOP,
                WM_CONTROL,
                MPFROM2SHORT(vwQueryWindowUShort(hwndWnd,QWS_ID),
                             BN_CLICKED),
                MPFROMHWND(hwndWnd));
      break;
   case BM_QUERYCHECKINDEX:
      return MRFROMSHORT(-1);
   case BM_QUERYHILITE:
      break;
   case BM_SETHILITE:
      break;
   case BM_QUERYCHECK:
      return MRFROMSHORT(pidData->bChecked);
   case BM_SETCHECK:
      pidData->bChecked=SHORT1FROMMP(mpParm1);
      vwSendMsg(hwndWnd,WM_PAINT,0,0);
      break;
   case BM_SETDEFAULT:
      break;
   default:
      return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
   } /* endswitch */

   return MRFROMLONG(FALSE);
}

MRESULT EXPENTRY radioButtonProc(HVWWND hwndWnd,
                                 ULONG ulMsg,
                                 MPARAM mpParm1,
                                 MPARAM mpParm2)
//-------------------------------------------------------------------------
// This "sub-window procedure" handles the radio button-specific messages
//-------------------------------------------------------------------------
{
   PINSTDATA pidData;

   pidData=vwQueryWindowPtr(hwndWnd,1);

   switch (ulMsg) {
   case WM_PAINT:
      {
         CHAR achFmt[256];
         CHAR chCheck;
         CHAR achText[256];
         ULONG ulFore;
         ULONG ulBack;

         vwQueryWindowText(hwndWnd,sizeof(achFmt),achFmt);

         //----------------------------------------------------------------
         // See if we're checked and, if so, display the appropriate
         // character in the brackets.
         //----------------------------------------------------------------
         chCheck=pidData->bChecked?RB_SELECTED:' ';

         sprintf(achText,"(%c) %s",chCheck,achFmt);

         ulFore=vwQueryForeColor(hwndWnd);
         ulBack=vwQueryBackColor(hwndWnd);

         //----------------------------------------------------------------
         // If we have the focus, invert the colors to indicate this
         //----------------------------------------------------------------
         if (vwQueryFocus()==hwndWnd) {
            ulFore^=0x000000FF;
            ulBack^=0x000000FF;
         } /* endif */

         //----------------------------------------------------------------
         // Draw the button text as we have built it above
         //----------------------------------------------------------------
         vwDrawText(hwndWnd,
                    -1,
                    achText,
                    NULL,
                    ulFore,
                    ulBack,
                    DT_LEFT|DT_VCENTER|DT_ERASERECT);
      }
      break;
   case WM_CHAR:
      {
         USHORT usFlags;
         USHORT usMods;

         usFlags=KC_VIRTUALKEY | KC_KEYUP;
         usMods=KC_ALT | KC_CTRL | KC_SHIFT;

         if ((CHARMSG(&ulMsg)->fs & usFlags)!=usFlags) {
            return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endif */

         if ((CHARMSG(&ulMsg)->fs & usMods)!=0) {
            return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endif */

         //----------------------------------------------------------------
         // If the user pressed <SPACE> or either <ENTER> key, select
         // ourselves.  If they pressed the <UP> or <LEFT> keys, click the
         // previous button in the group.  If they pressed the <DOWN> or
         // <RIGHT> keys, click the next button in the group.
         //----------------------------------------------------------------
         switch (CHARMSG(&ulMsg)->vkey) {
         case VK_SPACE:
         case VK_ENTER:
         case VK_NEWLINE:
            vwPostMsg(hwndWnd,BM_CLICK,0,0);
            break;
         case VK_UP:
         case VK_LEFT:
            {
               HVWWND hwndPrev;

               hwndPrev=findGroupButton(hwndWnd,QW_PREV);
               if (hwndPrev==NULLHANDLE) {
                  hwndPrev=findGroupButton(hwndWnd,QW_BOTTOM);
               } /* endif */

               vwSendMsg(hwndPrev,BM_CLICK,MPFROMSHORT(TRUE),0);
            }
            break;
         case VK_DOWN:
         case VK_RIGHT:
            {
               HVWWND hwndNext;

               hwndNext=findGroupButton(hwndWnd,QW_NEXT);
               if (hwndNext==NULLHANDLE) {
                  hwndNext=findGroupButton(hwndWnd,QW_TOP);
               } /* endif */

               vwSendMsg(hwndNext,BM_CLICK,MPFROMSHORT(TRUE),0);
            }
            break;
         default:
            return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
         } /* endswitch */
      }
      break;
   case WM_QUERYDLGCODE:
      return MRFROMLONG(DLGC_BUTTON);
   case BM_CLICK:
      {
         SHORT sIndex;
         HVWWND hwndCheck;

         //----------------------------------------------------------------
         // If we've been clicked, we need to find the button _within our
         // group_ that is currently selected, unselect it, and then
         // select ourselves.  This is not as trivial as it sounds, but
         // the code below doesn't indicate this.  See findGroupButton().
         // - - - - - - - - - - - - - -
         // Send ourselves a BM_QUERYCHECKINDEX to see who currently is
         // selected in the group.
         //----------------------------------------------------------------
         sIndex=SHORT1FROMMR(vwSendMsg(hwndWnd,BM_QUERYCHECKINDEX,0,0));

         //----------------------------------------------------------------
         // If sIndex is not -1, find the button and uncheck it.
         //----------------------------------------------------------------
         if (sIndex!=-1) {
            hwndCheck=findGroupButton(hwndWnd,QW_TOP);
            while (sIndex>0) {
               hwndCheck=findGroupButton(hwndCheck,QW_NEXT);
               sIndex--;
            } /* endwhile */
         } else {
            hwndCheck=NULLHANDLE;
         } /* endif */

         if (hwndCheck!=NULLHANDLE) {
            vwSendMsg(hwndCheck,BM_SETCHECK,MPFROMSHORT(FALSE),0);
         } /* endif */

         //----------------------------------------------------------------
         // Check ourselves, set the focus to us, and send the notification
         // to our owner (the desktop).
         //----------------------------------------------------------------
         vwSendMsg(hwndWnd,BM_SETCHECK,MPFROMSHORT(TRUE),0);
         vwSetFocus(hwndWnd);

         vwSendMsg(VWHWND_DESKTOP,
                   WM_CONTROL,
                   MPFROM2SHORT(vwQueryWindowUShort(hwndWnd,QWS_ID),
                                BN_CLICKED),
                   MPFROMHWND(hwndWnd));
      }
      break;
   case BM_QUERYCHECKINDEX:
      {
         HWND hwndGroup;
         SHORT sIndex;

         //----------------------------------------------------------------
         // Moving the findGroupButton() code to a separate function
         // made this a lot easier.  Amen to code-readability!
         // - - - - - - - - - - - - - -
         // Start from the top and enumerate all of the buttons in the
         // group until we find one that is checked.
         //----------------------------------------------------------------
         hwndGroup=findGroupButton(hwndWnd,QW_TOP);
         if (hwndGroup==NULLHANDLE) {
            return MRFROMSHORT(-1);
         } /* endif */

         sIndex=0;

         if (SHORT1FROMMR(vwSendMsg(hwndGroup,BM_QUERYCHECK,0,0))==TRUE) {
            return MRFROMSHORT(sIndex);
         } /* endif */

         hwndGroup=findGroupButton(hwndGroup,QW_NEXT);

         while (hwndGroup!=NULLHANDLE) {
            sIndex++;

            if (SHORT1FROMMR(vwSendMsg(hwndGroup,BM_QUERYCHECK,0,0))==TRUE) {
               return MRFROMSHORT(sIndex);
            } /* endif */

            hwndGroup=findGroupButton(hwndGroup,QW_NEXT);
         } /* endwhile */

         return MRFROMSHORT(-1);
      }
   case BM_QUERYHILITE:
      break;
   case BM_SETHILITE:
      break;
   case BM_QUERYCHECK:
      return MRFROMSHORT(pidData->bChecked);
   case BM_SETCHECK:
      pidData->bChecked=SHORT1FROMMP(mpParm1);
      vwSendMsg(hwndWnd,WM_PAINT,0,0);
      break;
   case BM_SETDEFAULT:
      break;
   default:
      return vwDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
   } /* endswitch */

   return MRFROMLONG(FALSE);
}

MRESULT EXPENTRY VwButtonClassProc(HVWWND hwndWnd,
                                   ULONG ulMsg,
                                   MPARAM mpParm1,
                                   MPARAM mpParm2)
//-------------------------------------------------------------------------
// This window procedure simply processes the WM_CREATE and WM_DESTROY
// messages and otherwise calls the appropriate "sub window procedure"
// to handle the other messages.  This must be done this way since all
// button types are of the same class.
//-------------------------------------------------------------------------
{
   PINSTDATA pidData;

   pidData=vwQueryWindowPtr(hwndWnd,1);

   switch (ulMsg) {
   case WM_CREATE:
      pidData=calloc(1,sizeof(INSTDATA));
      if (pidData==NULL) {
         return MRFROMSHORT(TRUE);
      } /* endif */

      vwSetWindowPtr(hwndWnd,1,pidData);

      pidData->ulSzStruct=sizeof(INSTDATA);
      pidData->ulStyle=vwQueryWindowULong(hwndWnd,QWL_STYLE);
      pidData->bChecked=FALSE;
      return MRFROMSHORT(FALSE);
   case WM_DESTROY:
      vwSetWindowPtr(hwndWnd,1,NULL);
      free(pidData);
      return MRFROMSHORT(FALSE);
   default:
      if ((pidData->ulStyle & BS_AUTOCHECKBOX)!=0) {
         return checkBoxProc(hwndWnd,ulMsg,mpParm1,mpParm2);
      } else
      if ((pidData->ulStyle & BS_CHECKBOX)!=0) {
         return checkBoxProc(hwndWnd,ulMsg,mpParm1,mpParm2);
      } else
      if ((pidData->ulStyle & BS_AUTORADIOBUTTON)!=0) {
         return radioButtonProc(hwndWnd,ulMsg,mpParm1,mpParm2);
      } else
      if ((pidData->ulStyle & BS_RADIOBUTTON)!=0) {
         return radioButtonProc(hwndWnd,ulMsg,mpParm1,mpParm2);
      } else {
         //----------------------------------------------------------------
         // Assume it is a pushbutton.
         //----------------------------------------------------------------
         return pushButtonProc(hwndWnd,ulMsg,mpParm1,mpParm2);
      } /* endif */
   } /* endswitch */
}

HVWWND findGroupButton(HVWWND hwndWnd,LONG lCmd)
//-------------------------------------------------------------------------
// This function finds the group button in the appropriate position given
// a button handle in the same group.
//
// Input:  hwndWnd - button handle in the group to check
//         lCmd - a QW_ constant (from the vwQueryWindow() function)
// Returns:  specified button handle if successful, NULLHANDLE otherwise
//-------------------------------------------------------------------------
{
   HVWWND hwndTop;
   HVWWND hwndBottom;
   HVWWND hwndReturn;
   ULONG ulStyle;
   CHAR achClass[256];
   BOOL bIsRadioButton;
   HVWWND hwndLast;

   //----------------------------------------------------------------------
   // Of the four QW_ constants, QW_PREV and QW_NEXT make recursive calls
   // specifying QW_TOP and QW_BOTTOM respectively.  Thus, the latter two
   // must be entirely self-contained in order to avoid an endless
   // recursive loop.  Additionally, QW_PREV cannot call QW_NEXT, nor can
   // QW_NEXT call QW_PREV.
   //----------------------------------------------------------------------

   switch (lCmd) {
   case QW_PREV:
      //-------------------------------------------------------------------
      // Query the top of the group and check for equality with the
      // specified window.  If they match, return NULLHANDLE.
      //-------------------------------------------------------------------
      hwndTop=findGroupButton(hwndWnd,QW_TOP);

      if (hwndWnd==hwndTop) {
         return NULLHANDLE;
      } /* endif */

      hwndReturn=hwndWnd;

      //-------------------------------------------------------------------
      // Work our way backwards in the window chain until we find the
      // first radio button.
      //-------------------------------------------------------------------
      do {
         hwndReturn=vwQueryWindow(hwndReturn,QW_PREV);
         if (hwndReturn==NULLHANDLE) {
            return NULLHANDLE;
         } /* endif */

         ulStyle=vwQueryWindowULong(hwndReturn,QWL_STYLE);
         vwQueryClassName(hwndReturn,sizeof(achClass),achClass);

         bIsRadioButton=((strcmp(achClass,VWWC_BUTTON)==0) &&
                         (((ulStyle & BS_AUTORADIOBUTTON)!=0) ||
                          ((ulStyle & BS_RADIOBUTTON)!=0)));
      } while (!bIsRadioButton); /* enddo */

      return hwndReturn;
   case QW_NEXT:
      //-------------------------------------------------------------------
      // Query the bottom of the group and check for equality with the
      // specified window.  If they match, return NULLHANDLE.
      //-------------------------------------------------------------------
      hwndBottom=findGroupButton(hwndWnd,QW_BOTTOM);

      if (hwndWnd==hwndBottom) {
         return NULLHANDLE;
      } /* endif */

      hwndReturn=hwndWnd;

      //-------------------------------------------------------------------
      // Work our way forewards in the window chain until we find the
      // first radio button.
      //-------------------------------------------------------------------
      do {
         hwndReturn=vwQueryWindow(hwndReturn,QW_NEXT);
         if (hwndReturn==NULLHANDLE) {
            return NULLHANDLE;
         } /* endif */

         ulStyle=vwQueryWindowULong(hwndReturn,QWL_STYLE);
         vwQueryClassName(hwndReturn,sizeof(achClass),achClass);

         bIsRadioButton=((strcmp(achClass,VWWC_BUTTON)==0) &&
                         (((ulStyle & BS_AUTORADIOBUTTON)!=0) ||
                          ((ulStyle & BS_RADIOBUTTON)!=0)));
      } while (!bIsRadioButton); /* enddo */

      return hwndReturn;
   case QW_TOP:
      //-------------------------------------------------------------------
      // Start with the window specified and work our way backwards until
      // we either reach the beginning
      //-------------------------------------------------------------------
      hwndReturn=hwndWnd;
      hwndLast=hwndReturn;

      ulStyle=vwQueryWindowULong(hwndReturn,QWL_STYLE);

      while ((ulStyle & WS_GROUP)==0) {
         hwndReturn=vwQueryWindow(hwndReturn,QW_PREV);

         //----------------------------------------------------------------
         // If we've reached the beginning of the window chain return the
         // last valid one that we saw
         //----------------------------------------------------------------
         if (hwndReturn==NULLHANDLE) {
            return hwndLast;
         } /* endif */

         ulStyle=vwQueryWindowULong(hwndReturn,QWL_STYLE);
         vwQueryClassName(hwndReturn,sizeof(achClass),achClass);

         bIsRadioButton=((strcmp(achClass,VWWC_BUTTON)==0) &&
                         (((ulStyle & BS_AUTORADIOBUTTON)!=0) ||
                          ((ulStyle & BS_RADIOBUTTON)!=0)));

         //----------------------------------------------------------------
         // If the current window (hwndReturn) is of the class VWWC_BUTTON
         // and the style indicates it's a radio button, remember this
         // window handle
         //----------------------------------------------------------------
         if (bIsRadioButton) {
            hwndLast=hwndReturn;
         } /* endif */
      } /* endwhile */

      return hwndReturn;
   case QW_BOTTOM:
      hwndReturn=hwndWnd;
      hwndLast=hwndReturn;

      //-------------------------------------------------------------------
      // Start here and search forward until we find either the end of
      // the window chain or the beginning of the next group.  Note that
      // we can't set ulStyle to the window style because, if this is
      // the first button in the group, we will return it instead of the
      // proper value.
      //-------------------------------------------------------------------
      ulStyle=0;

      while ((ulStyle & WS_GROUP)==0) {
         hwndReturn=vwQueryWindow(hwndReturn,QW_NEXT);

         //----------------------------------------------------------------
         // If we've reached the end of the window chain return the
         // last valid one that we saw
         //----------------------------------------------------------------
         if (hwndReturn==NULLHANDLE) {
            return hwndLast;
         } /* endif */

         ulStyle=vwQueryWindowULong(hwndReturn,QWL_STYLE);
         vwQueryClassName(hwndReturn,sizeof(achClass),achClass);

         bIsRadioButton=((strcmp(achClass,VWWC_BUTTON)==0) &&
                         (((ulStyle & BS_AUTORADIOBUTTON)!=0) ||
                          ((ulStyle & BS_RADIOBUTTON)!=0)));

         //----------------------------------------------------------------
         // If the current window (hwndReturn) is of the class VWWC_BUTTON
         // and the style indicates it's a radio button, remember this
         // window handle
         //----------------------------------------------------------------
         if ((bIsRadioButton) && ((ulStyle & WS_GROUP)==0)) {
            hwndLast=hwndReturn;
         } /* endif */
      } /* endwhile */

      return hwndLast;
   default:
      return NULLHANDLE;
   } /* endswitch */
}
