/***************************************************************************************
                  C++ BenchMark program (C) Gordon W. Zeglinski

        Redistribution of the source is permitted provided the entire
	              copyright notice and comments are retained.


****************************************************************************************



Test 1:
      Constructing/destructing a complex object and calling a virtual function.


Test 2:
      Constructing/destructing a differnet complex object with virtual destructors
      and calling a virtual function.

Test 3:
      Calling a function that creates a complex object on the stack from within a catch/throw
      block but does not throw an exception

Test 4:
      Throwing an exception from a function that creates a complex object on the stack.

Test 5:
      Assigning a complex object to another complex object.


***************************************************************************************/

#include <stdio.h>
#include <time.h>

//---------- test 1 classes --------------------------------------------
class T1B1{
   int Val;
   static int Count;
public:
   T1B1(int X){Val=X;Count++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCount(){return Count;}
   static void    ResetCounts(){Count=0;}
};

class T1B2:virtual public T1B1{
   int Val;
   static int Count;
public:
   T1B2(int Y):T1B1(Y){Val=Y;Count++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCount(){return Count;}
   static void    ResetCounts(){Count=0;}
};

class T1B3:virtual public T1B1, virtual public T1B2{
   int Val;
   static int Count;
public:
   T1B3(int Y):T1B1(Y),T1B2(Y){Val=Y;Count++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCount(){return Count;}
   static void    ResetCounts(){Count=0;}
};

class T1B4{
   int Val;
   static int Count;
public:
   T1B4(int Y){Val=Y;Count++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCount(){return Count;}
   static void    ResetCounts(){Count=0;}
};

class T1B5:public T1B4{
   int Val;
   static int Count;
public:
   T1B5(int Y):T1B4(Y){Val=Y;Count++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCount(){return Count;}
   static void    ResetCounts(){Count=0;}
};

class T1B6:public T1B5,virtual public T1B3,virtual public T1B2,virtual public T1B1{
   int Val;
   static int Count;
public:
   T1B6(int Y):T1B5(Y),T1B3(Y),T1B1(Y),T1B2(Y){Val=Y;Count++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCount(){return Count;}
   static void    ResetCounts(){Count=0;}
};

int T1B1::Count=0;
int T1B2::Count=0;
int T1B3::Count=0;
int T1B4::Count=0;
int T1B5::Count=0;
int T1B6::Count=0;

//test 1 functions
int Test1Fnc2();
void Test1Fnc1(T1B1 &Inst);
void Test1Func();

void Test1Fnc1(T1B1 &Inst){
   Inst.IncVal();
}

int Test1Fnc2(){
   T1B6 foo(0);

   Test1Fnc1(foo);

   if(foo.GetVal()!=1){
      printf("%s\n\r","Val NOT EQUAL to 1. Aborting test!!");
      return 1;
   }

   if(foo.T1B1::GetVal()!=0){
      printf("%s\n\r","T1B1::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B2::GetVal()!=0){
      printf("%s\n\r","T1B2::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B3::GetVal()!=0){
      printf("%s\n\r","T1B3::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B4::GetVal()!=0){
      printf("%s\n\r","T1B4::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B5::GetVal()!=0){
      printf("%s\n\r","T1B5::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B6::GetVal()!=1){
      printf("%s\n\r","T1B6::Val NOT EQUAL to 1. Aborting test!!");
      return 1;
   }


return 0;
}

void Test1Func(){
   int i;
   double T1,T2,Diff;

   T1=clock();
   for(i=0;i<500000;i++)
      if(Test1Fnc2())
         break;

   T2=clock();

   Diff=(T2-T1)/((double)CLOCKS_PER_SEC);
   printf("Test 1. Elapsed time= %f seconds\r\n", Diff);
   printf("%s\r\n","Construction Count");
   printf("T1B1=%i T1B2=%i T1B3=%i T1B4=%i T1B5=%i T1B6=%i\r\n",
            T1B1::GetCount(),T1B2::GetCount(),T1B3::GetCount(),
            T1B4::GetCount(),T1B5::GetCount(),T1B6::GetCount());


}

#ifdef _DoClass2Test_
// Okey CSet barfs on this set of classes
// so we use  _DoClass2Test_ to hide it and loose tests 2 and 5
//---------- test 2 classes --------------------------------------------
class T2B1{
   int Val;
   static int CCount;
   static int DCount;
public:
   T2B1(int X){Val=X;CCount++;}
   virtual ~T2B1(){DCount++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCCount(){return CCount;}
   static int     GetDCount(){return DCount;}
   static void    ResetCounts(){CCount=DCount=0;}
};

class T2B2: public T2B1{
   int Val;
   static int CCount;
   static int DCount;
public:
   T2B2(int X):T2B1(X){Val=X;CCount++;}
   virtual ~T2B2(){DCount++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   int            GetB1Val(){return T2B1::GetVal();}

   static int     GetCCount(){return CCount;}
   static int     GetDCount(){return DCount;}
   static void    ResetCounts(){CCount=DCount=0;}
};


class T2B3: public T2B1,public T2B2{
   int Val;
   static int CCount;
   static int DCount;
public:
   T2B3(int X):T2B1(X),T2B2(X){Val=X;CCount++;}
   virtual ~T2B3(){DCount++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   int            GetB2B1Val(){return T2B2::GetB1Val();}
   static int     GetCCount(){return CCount;}
   static int     GetDCount(){return DCount;}
   static void    ResetCounts(){CCount=DCount=0;}
};


class T2B4{
   int Val;
   static int CCount;
   static int DCount;
public:
   T2B4(int X){Val=X;CCount++;}
   virtual ~T2B4(){DCount++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCCount(){return CCount;}
   static int     GetDCount(){return DCount;}
   static void    ResetCounts(){CCount=DCount=0;}
};

class T2B5{
   int Val;
   static int CCount;
   static int DCount;
public:
   T2B5(int X){Val=X;CCount++;}
   virtual ~T2B5(){DCount++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCCount(){return CCount;}
   static int     GetDCount(){return DCount;}
   static void    ResetCounts(){CCount=DCount=0;}
};


class T2B6:virtual public T2B3,virtual public T2B4, virtual public T2B5{
   int Val;
   static int CCount;
   static int DCount;
public:
   T2B6(int X):T2B3(X),T2B4(X),T2B5(X){Val=X;CCount++;}
   virtual ~T2B6(){DCount++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCCount(){return CCount;}
   static int     GetDCount(){return DCount;}
   static void    ResetCounts(){CCount=DCount=0;}
};


class T2B7{
   int Val;
   static int CCount;
   static int DCount;
public:
   T2B7(int X){Val=X;CCount++;}
   virtual ~T2B7(){DCount++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCCount(){return CCount;}
   static int     GetDCount(){return DCount;}
   static void    ResetCounts(){CCount=DCount=0;}
};


class T2B8{
   int Val;
   static int CCount;
   static int DCount;
public:
   T2B8(int X){Val=X;CCount++;}
   virtual ~T2B8(){DCount++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCCount(){return CCount;}
   static int     GetDCount(){return DCount;}
   static void    ResetCounts(){CCount=DCount=0;}
};

class T2B9:virtual public T2B7, virtual public T2B8{
   int Val;
   static int CCount;
   static int DCount;
public:
   T2B9(int X):T2B7(X),T2B8(X){Val=X;CCount++;}
   virtual ~T2B9(){DCount++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCCount(){return CCount;}
   static int     GetDCount(){return DCount;}
   static void    ResetCounts(){CCount=DCount=0;}
};

class T2B10:virtual public T2B9, virtual public T2B6,virtual public T2B7{
   int Val;
   static int CCount;
   static int DCount;
public:
   T2B10(int X):T2B7(X),T2B9(X),T2B6(X),T2B8(X),T2B3(X),T2B4(X),T2B5(X){Val=X;CCount++;}
   virtual ~T2B10(){DCount++;}

   virtual void   IncVal(){Val++;}
   int            GetVal(){return Val;}
   static int     GetCCount(){return CCount;}
   static int     GetDCount(){return DCount;}
   static void    ResetCounts(){CCount=DCount=0;}
};


int T2B1::CCount=0;
int T2B1::DCount=0;
int T2B2::CCount=0;
int T2B2::DCount=0;
int T2B3::CCount=0;
int T2B3::DCount=0;
int T2B4::CCount=0;
int T2B4::DCount=0;
int T2B5::CCount=0;
int T2B5::DCount=0;
int T2B6::CCount=0;
int T2B6::DCount=0;
int T2B7::CCount=0;
int T2B7::DCount=0;
int T2B8::CCount=0;
int T2B8::DCount=0;
int T2B9::CCount=0;
int T2B9::DCount=0;
int T2B10::CCount=0;
int T2B10::DCount=0;

//test 2 functions

int Test2Fnc2();
void Test2Fnc1(T2B6 &Inst);
void Test2Func();

void Test2Fnc1(T2B6 &Inst){
   Inst.IncVal();
}

int Test2Fnc2(){
   T2B10 foo(0);

   Test2Fnc1(foo);

   if(foo.GetVal()!=1){
      printf("%s\n\r","Val NOT EQUAL to 1. Aborting test!!");
      return 1;
   }

   if(foo.GetB2B1Val()!=0){
      printf("%s\n\r","T1B1::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T2B2::GetVal()!=0){
      printf("%s\n\r","T2B2::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T2B3::GetVal()!=0){
      printf("%s\n\r","T2B3::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T2B4::GetVal()!=0){
      printf("%s\n\r","T2B4::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T2B5::GetVal()!=0){
      printf("%s\n\r","T2B5::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T2B6::GetVal()!=0){
      printf("%s\n\r","T2B6::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }

   if(foo.T2B7::GetVal()!=0){
      printf("%s\n\r","T2B7::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T2B8::GetVal()!=0){
      printf("%s\n\r","T2B8::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T2B9::GetVal()!=0){
      printf("%s\n\r","T2B9::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T2B10::GetVal()!=1){
      printf("%s\n\r","T2B10::Val NOT EQUAL to 1. Aborting test!!");
      return 1;
   }


return 0;
}

void Test2Func(){
   int i;
   double T1,T2,Diff;

   T1=clock();
   for(i=0;i<500000;i++)
      if(Test2Fnc2())
         break;

   T2=clock();
   Diff=(T2-T1)/((double)CLOCKS_PER_SEC);

   printf("\r\nTest 2. Elapsed time= %f seconds\r\n", Diff);
   printf("%s\r\n","Construction Count");
   printf("T2B1=%i T1B2=%i T2B3=%i T2B4=%i T2B5=%i T2B6=%i T2B7=%i T2B8=%i T2B9=%i T2B10=%i\r\n",
            T2B1::GetCCount(),
            T2B2::GetCCount(),
            T2B3::GetCCount(),
            T2B4::GetCCount(),
            T2B5::GetCCount(),
            T2B6::GetCCount(),
            T2B7::GetCCount(),
            T2B8::GetCCount(),
            T2B9::GetCCount(),
            T2B10::GetCCount() );

}
#endif

//test 3 error class

class Error{

public:
   class Test{
         int Val;
      public:
         Test(int X){Val=X;}
         int GetVal(){return Val;}
   };

};

//------------------------- test 3 functions --------------------


int Test3Fnc1();
void Test3Func();

int Test3Fnc1(){
   T1B6 foo(0);

   foo.IncVal();

   if(foo.GetVal()!=1){
      printf("%s\n\r","Val NOT EQUAL to 1. Aborting test!!");
      return 1;
   }

   if(foo.T1B1::GetVal()!=0){
      printf("%s\n\r","T1B1::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B2::GetVal()!=0){
      printf("%s\n\r","T1B2::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B3::GetVal()!=0){
      printf("%s\n\r","T1B3::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B4::GetVal()!=0){
      printf("%s\n\r","T1B4::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B5::GetVal()!=0){
      printf("%s\n\r","T1B5::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B6::GetVal()!=1){
      printf("%s\n\r","T1B6::Val NOT EQUAL to 1. Aborting test!!");
      return 1;
   }
return 0;
}

void Test3Func(){
   T1B1::ResetCounts();
   T1B2::ResetCounts();
   T1B3::ResetCounts();
   T1B4::ResetCounts();
   T1B5::ResetCounts();
   T1B6::ResetCounts();


   int i;
   double T1,T2,Diff;

  
   T1=clock();
   for(i=0;i<500000;i++)
      try{
         if(Test3Fnc1())
            break;
      }
      catch ( Error::Test X ) {
         if(X.GetVal()!=1){
            printf("%s\n\r","Exception Value NOT EQUAL to 1. Aborting test!!");
            return;
         }
      } 
      catch(...){
         throw;
      }

   T2=clock();
   Diff=(T2-T1)/((double)CLOCKS_PER_SEC);

   printf("\r\nTest 3. Elapsed time= %f seconds\r\n", Diff);
   printf("%s\r\n","Construction Count");
   printf("T1B1=%i T1B2=%i T1B3=%i T1B4=%i T1B5=%i T1B6=%i\r\n",
            T1B1::GetCount(),T1B2::GetCount(),T1B3::GetCount(),
            T1B4::GetCount(),T1B5::GetCount(),T1B6::GetCount());

}

// ------------------------- test 4 functions ------------------
int Test4Fnc1();
void Test4Func();


int Test4Fnc1(){
   T1B6 foo(0);

   foo.IncVal();

   if(foo.GetVal()!=1){
      printf("%s\n\r","Val NOT EQUAL to 1. Aborting test!!");
      return 1;
   }

   if(foo.T1B1::GetVal()!=0){
      printf("%s\n\r","T1B1::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B2::GetVal()!=0){
      printf("%s\n\r","T1B2::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B3::GetVal()!=0){
      printf("%s\n\r","T1B3::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B4::GetVal()!=0){
      printf("%s\n\r","T1B4::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B5::GetVal()!=0){
      printf("%s\n\r","T1B5::Val NOT EQUAL to 0. Aborting test!!");
      return 1;
   }
   if(foo.T1B6::GetVal()!=1){
      printf("%s\n\r","T1B6::Val NOT EQUAL to 1. Aborting test!!");
      return 1;
   }

   throw Error::Test(1);
return 0;
}

void Test4Func(){
/*
   T2B1::ResetCounts();
   T2B2::ResetCounts();
   T2B3::ResetCounts();
   T2B4::ResetCounts();
   T2B5::ResetCounts();
   T2B6::ResetCounts();
   T2B7::ResetCounts();
   T2B8::ResetCounts();
   T2B9::ResetCounts();
   T2B10::ResetCounts();
*/
   T1B1::ResetCounts();
   T1B2::ResetCounts();
   T1B3::ResetCounts();
   T1B4::ResetCounts();
   T1B5::ResetCounts();
   T1B6::ResetCounts();


   int i;
   double T1,T2,Diff;

  
   T1=clock();
   for(i=0;i<500000;i++)
      try{
         if(Test4Fnc1())
            break;
      }
      catch ( Error::Test X ) {
         if(X.GetVal()!=1){
            printf("%s\n\r","Exception Value NOT EQUAL to 1. Aborting test!!");
            return;
         }
      } 
      catch(...){
         throw;
      }

   T2=clock();
   Diff=(T2-T1)/((double)CLOCKS_PER_SEC);

   printf("\r\nTest 4. Elapsed time= %f seconds\r\n", Diff);
   printf("%s\r\n","Construction Count");
   printf("T1B1=%i T1B2=%i T1B3=%i T1B4=%i T1B5=%i T1B6=%i\r\n",
            T1B1::GetCount(),T1B2::GetCount(),T1B3::GetCount(),
            T1B4::GetCount(),T1B5::GetCount(),T1B6::GetCount());

/*
   printf("T2B1=%i T1B2=%i T2B3=%i T2B4=%i T2B5=%i T2B6=%i T2B7=%i T2B8=%i T2B9=%i T2B10=%i\r\n",
            T2B1::GetCCount(),
            T2B2::GetCCount(),
            T2B3::GetCCount(),
            T2B4::GetCCount(),
            T2B5::GetCCount(),
            T2B6::GetCCount(),
            T2B7::GetCCount(),
            T2B8::GetCCount(),
            T2B9::GetCCount(),
            T2B10::GetCCount() );
*/

}


#ifdef _DoClass2Test_
//-------------------------- Test 5 functions ------------------

int Test5Fnc1(T2B10 &Inst);
void Test5Func();

int Test5Fnc1(T2B10 &Inst){
   T2B10 foo(1111);

   foo=Inst;

   if( foo.GetB2B1Val()!=Inst.GetB2B1Val()){
      printf("%s\n\r"," foo.T2B1::Val NOT EQUAL to Inst.T2B1::Val. Aborting test!!");
      return 1;
   }


   if(foo.T2B2::GetVal()!=Inst.T2B2::GetVal()){
      printf("%s\n\r"," foo.T2B2::Val NOT EQUAL to Inst.T2B2::Val. Aborting test!!");
      return 1;
   }
   if(foo.T2B3::GetVal()!=Inst.T2B3::GetVal()){
      printf("%s\n\r"," foo.T2B3::Val NOT EQUAL to Inst.T2B3::Val. Aborting test!!");
      return 1;
   }
   if(foo.T2B4::GetVal()!=Inst.T2B4::GetVal()){
      printf("%s\n\r"," foo.T2B4::Val NOT EQUAL to Inst.T2B4::Val. Aborting test!!");
      return 1;
   }
   if(foo.T2B5::GetVal()!=Inst.T2B5::GetVal()){
      printf("%s\n\r"," foo.T2B5::Val NOT EQUAL to Inst.T2B5::Val. Aborting test!!");
      return 1;
   }
   if(foo.T2B6::GetVal()!=Inst.T2B6::GetVal()){
      printf("%s\n\r"," foo.T2B6::Val NOT EQUAL to Inst.T2B6::Val. Aborting test!!");
      return 1;
   }
   if(foo.T2B7::GetVal()!=Inst.T2B7::GetVal()){
      printf("%s\n\r"," foo.T2B7::Val NOT EQUAL to Inst.T2B7::Val. Aborting test!!");
      return 1;
   }
   if(foo.T2B8::GetVal()!=Inst.T2B8::GetVal()){
      printf("%s\n\r"," foo.T2B8::Val NOT EQUAL to Inst.T2B8::Val. Aborting test!!");
      return 1;
   }
   if(foo.T2B9::GetVal()!=Inst.T2B9::GetVal()){
      printf("%s\n\r"," foo.T2B9::Val NOT EQUAL to Inst.T2B9::Val. Aborting test!!");
      return 1;
   }
   if(foo.T2B10::GetVal()!=Inst.T2B10::GetVal()){
      printf("%s\n\r"," foo.T2B10::Val NOT EQUAL to Inst.T2B10::Val. Aborting test!!");
      return 1;
   }

return 0;
}

void Test5Func(){
   T2B1::ResetCounts();
   T2B2::ResetCounts();
   T2B3::ResetCounts();
   T2B4::ResetCounts();
   T2B5::ResetCounts();
   T2B6::ResetCounts();
   T2B7::ResetCounts();
   T2B8::ResetCounts();
   T2B9::ResetCounts();
   T2B10::ResetCounts();

   int i;
   double T1,T2,Diff;

   {
      T2B10 Base(0);

      T1=clock();
      for(i=0;i<500000;i++)
         if(Test5Fnc1(Base))
            break;

      T2=clock();
   }

   Diff=(T2-T1)/((double)CLOCKS_PER_SEC);
   printf("\r\nTest 5. Elapsed time= %f seconds\r\n", Diff);
   printf("%s\r\n","Construction-Destruction  Count");
   printf("T2B1=%i T1B2=%i T2B3=%i T2B4=%i T2B5=%i T2B6=%i T2B7=%i T2B8=%i T2B9=%i T2B10=%i\r\n",
            T2B1::GetCCount()-T2B1::GetDCount(),
            T2B2::GetCCount()-T2B2::GetDCount(),
            T2B3::GetCCount()-T2B3::GetDCount(),
            T2B4::GetCCount()-T2B4::GetDCount(),
            T2B5::GetCCount()-T2B5::GetDCount(),
            T2B6::GetCCount()-T2B6::GetDCount(),
            T2B7::GetCCount()-T2B7::GetDCount(),
            T2B8::GetCCount()-T2B8::GetDCount(),
            T2B9::GetCCount()-T2B9::GetDCount(),
            T2B10::GetCCount()-T2B10::GetDCount() );
   printf("%s\r\n","Construction  Count");
   printf("T2B1=%i T1B2=%i T2B3=%i T2B4=%i T2B5=%i T2B6=%i T2B7=%i T2B8=%i T2B9=%i T2B10=%i\r\n",
            T2B1::GetCCount(),
            T2B2::GetCCount(),
            T2B3::GetCCount(),
            T2B4::GetCCount(),
            T2B5::GetCCount(),
            T2B6::GetCCount(),
            T2B7::GetCCount(),
            T2B8::GetCCount(),
            T2B9::GetCCount(),
            T2B10::GetCCount() );

}

#endif

//---------------------------- main --------------------------------------

int main(){

   Test1Func();
#ifdef _DoClass2Test_
   Test2Func();
#endif
   Test3Func();
   Test4Func();
#ifdef _DoClass2Test_
   Test5Func();
#endif
return 0;
}
