// ***********************************************************************
// SPRITE.HPP
// ***********************************************************************
//
// Written by Michael T. Duffy
//
// Sprite routines for Canvas graphics object.
//
// ***********************************************************************

#ifndef SPRITE_HPP
#define SPRITE_HPP

// ***********************************************************************
//  Constant Definitions
// ***********************************************************************

#define MAX_NUMBER_BOOKS     25


#define SPR_FLG_EMPTY        0x0001

// ***********************************************************************
//  Internal structures
// ***********************************************************************


typedef struct _SPRITEDATA
  {
  SHORT            sXPos;
  SHORT            sYPos;
  SHORT            sWidth;
  SHORT            sHeight;
  USHORT           usFlags;
  } SPRITEDATA;    /* sprd */
typedef SPRITEDATA *  PSPRITEDATA;


// ***********************************************************************
//  Class Definitions
// ***********************************************************************


class SpriteManager
  {
  private:
    USHORT         usLastErrorCode;

    PCANVAS        pcnvEncode;
    PCANVAS        pcnvDisplay;

    PSPRITEDATA    asprdData [MAX_NUMBER_BOOKS];
    USHORT         ausCount  [MAX_NUMBER_BOOKS];


  public:

    SpriteManager ();

    ~SpriteManager ();

    ERRORSTATUS FindEmptySlot
      (
      BYTE         byBookNumberIn,
      PUSHORT      pusSpriteNumberOut
      );

    ERRORSTATUS FindEmptyBook
      (
      PBYTE            pbyBookNumberOut
      );

    ERRORSTATUS SetSprite
      (
      BYTE         byBookNumberIn,
      USHORT       usSpriteNumberIn,
      PBYTE        pbyDataIn,
      ULONG        ulDataSizeIn
      );

    ERRORSTATUS EraseSprite
      (
      BYTE         byBookNumberIn,
      USHORT       usSpriteNumberIn
      );

    ERRORSTATUS EraseAllSprites
      (
      BYTE         byBookNumberIn
      );

    ERRORSTATUS DestroyBook
      (
      BYTE         byBookNumberIn
      );

    VOID SetEncodeCanvas
      (
      PCANVAS      pcnvCanvasIn
      );

    VOID SetDisplayCanvas
      (
      PCANVAS      pcnvCanvasIn
      );

    ERRORSTATUS EncodeSprite
      (
      SHORT        sX1In,
      SHORT        sY1In,
      SHORT        sX2In,
      SHORT        sY2In,
      BYTE         byBookNumberIn,
      USHORT       usSpriteNumberIn
      );

    ERRORSTATUS SetNumSprites
      (
      BYTE         byBookNumberIn,
      USHORT       usNumOfSpritesIn
      );

    USHORT QueryNumSprites
      (
      BYTE         byBookNumberIn
      );

    ERRORSTATUS SpritesFromBlock
      (
      BYTE         byBookNumberIn,
      PBYTE        pbyBlockIn,
      ULONG        ulBlockSizeIn
      );

    ERRORSTATUS BlockFromSprites
      (
      BYTE         byBookNumberIn,
      PBYTE *      ppbyBlockOut,
      PULONG       pulBlockSizeOut
      );

    ERRORSTATUS DisplayUnclippedSprite
      (
      USHORT       usXPosIn,
      USHORT       usYPosIn,
      BYTE         byBookNumberIn,
      USHORT       usSpriteNumberIn
      );

    USHORT QueryLastErrorCode
      (
      VOID
      ) {return (usLastErrorCode);};

  };
typedef SpriteManager * PSPRITEMANAGER;






#endif // SPRITE_HPP

