#define INCL_WINFRAMEMGR
#define INCL_WININPUT
#define INCL_WINMENUS
#define INCL_WINPOINTERS
#define INCL_WINSYS
#define INCL_WINWINDOWMGR
#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include "rc.h"

#define CLS_CLIENT               "menuExample"

typedef struct {
   HAB habAnchor;
   HWND hwndFrame;
   HWND hwndMenu;
   BOOL bUndo;
} INSTDATA, *PINSTDATA;

MRESULT EXPENTRY wndProc(HWND hwndWnd,
                         ULONG ulMsg,
                         MPARAM mpParm1,
                         MPARAM mpParm2)
{
   PINSTDATA pidData;

   pidData=(PINSTDATA)WinQueryWindowPtr(hwndWnd,0);

   switch (ulMsg) {
   case WM_CREATE:
      //-------------------------------------------------------------------
      // Allocate memory for the instance data and initialize it
      //-------------------------------------------------------------------
      pidData=(PINSTDATA)calloc(1,sizeof(INSTDATA));
      if (pidData==NULL) {
         WinAlarm(HWND_DESKTOP,WA_ERROR);
         return MRFROMSHORT(TRUE);
      } /* endif */

      WinSetWindowPtr(hwndWnd,0,pidData);

      pidData->habAnchor=WinQueryAnchorBlock(hwndWnd);
      pidData->hwndFrame=WinQueryWindow(hwndWnd,QW_PARENT);
      pidData->hwndMenu=WinLoadMenu(HWND_OBJECT,NULLHANDLE,RES_CLIENT);
      pidData->bUndo=TRUE;
      break;
   case WM_DESTROY:
      WinDestroyWindow(pidData->hwndMenu);
      free(pidData);
      break;
   case WM_CONTEXTMENU:
      {
         POINTL ptlMouse;

         WinQueryPointerPos(HWND_DESKTOP,&ptlMouse);

         WinPopupMenu(HWND_DESKTOP,
                      hwndWnd,
                      pidData->hwndMenu,
                      ptlMouse.x,
                      ptlMouse.y,
                      0,
                      PU_HCONSTRAIN |
                         PU_VCONSTRAIN |
                         PU_MOUSEBUTTON1 |
                         PU_KEYBOARD);
      }
      break;
   case WM_INITMENU:
      switch (SHORT1FROMMP(mpParm1)) {
      case M_EDIT:
         {
            //-------------------------------------------------------------
            // Set the Edit pulldown items to the correct state
            //-------------------------------------------------------------
            CHAR achText[32];
            MENUITEM miItem;

            if (pidData->bUndo) {
               strcpy(achText,"~Undo");
            } else {
               strcpy(achText,"~Redo");
            } /* endif */

            WinSendMsg(pidData->hwndMenu,
                       MM_QUERYITEM,
                       MPFROM2SHORT(M_EDIT,TRUE),
                       MPFROMP(&miItem));

            WinSendMsg(miItem.hwndSubMenu,
                       MM_SETITEMTEXT,
                       MPFROMSHORT(MI_UNDO),
                       MPFROMP(achText));
         }
         break;
      default:
         return WinDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
      } /* endswitch */
      break;
   case WM_COMMAND:
      switch (SHORT1FROMMP(mpParm1)) {
      case MI_UNDO:
         pidData->bUndo=!pidData->bUndo;
         break;
      case MI_EXIT:
         WinPostMsg(hwndWnd,WM_CLOSE,0,0);
         break;
      default:
         return WinDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
      } /* endswitch */
      break;
   case WM_PAINT:
      {
         HPS hpsWnd;
         RECTL rclPaint;

         hpsWnd=WinBeginPaint(hwndWnd,NULLHANDLE,&rclPaint);
         WinFillRect(hpsWnd,&rclPaint,SYSCLR_WINDOW);
         WinEndPaint(hpsWnd);
      }
      break;
   default:
      return WinDefWindowProc(hwndWnd,ulMsg,mpParm1,mpParm2);
   } /* endswitch */

   return MRFROMSHORT(FALSE);
}

INT main(VOID)
{
   HAB habAnchor;
   HMQ hmqQueue;
   ULONG ulCreate;
   HWND hwndFrame;
   HWND hwndClient;
   BOOL bLoop;
   QMSG qmMsg;

   habAnchor=WinInitialize(0);
   hmqQueue=WinCreateMsgQueue(habAnchor,0);

   WinRegisterClass(habAnchor,CLS_CLIENT,wndProc,CS_SIZEREDRAW,sizeof(PVOID));

   ulCreate=FCF_SYSMENU | FCF_TITLEBAR | FCF_MINMAX | FCF_ICON |
               FCF_SIZEBORDER | FCF_TASKLIST | FCF_SHELLPOSITION;

   hwndFrame=WinCreateStdWindow(HWND_DESKTOP,
                                WS_VISIBLE,
                                &ulCreate,
                                CLS_CLIENT,
                                "Menu sample",
                                0,
                                NULLHANDLE,
                                RES_CLIENT,
                                &hwndClient);
   if (hwndFrame!=NULLHANDLE) {
      bLoop=WinGetMsg(habAnchor,&qmMsg,NULLHANDLE,0,0);
      while (bLoop) {
         WinDispatchMsg(habAnchor,&qmMsg);
         bLoop=WinGetMsg(habAnchor,&qmMsg,NULLHANDLE,0,0);
      } /* endwhile */

      WinDestroyWindow(hwndFrame);
   } /* endif */

   WinDestroyMsgQueue(hmqQueue);
   WinTerminate(habAnchor);
   return 0;
}
