
// -- a small C++ program to extract some text from an OS/2 INF file.

#include <iostream.h>
#include <fstream.h>

#include "infhead.h"  // and InfHeader class
 // (includes int_8, int_16 and int_32 classes )

#ifdef __EMX__
  #define IOS_BIN 0 // Ok... compile with -Zbin-files!
#else
  #define IOS_BIN ios::binary
#endif

// I have included the infhead.cc and infhead.h files to let us
// get the header without mucking around.

int main( int argc, char **argv )
{
    if( argc != 2 ) return( 1 ); // check args
	
    ifstream infInput( argv[1], ios::in | IOS_BIN ); // open file

    if( !infInput ) // did we open for input?
        return( 2 );

    InfHeader infHeader; // define a InfHeader

    infInput >> infHeader; // load the header
    
    if( !infHeader.IsValid() ) 
    {
	cerr << "-ERROR - couldn't load the INF file header!\n";
	return( 1 );
    }
    // cout << infHeader; // print the header

    // -- Load the Dictionary
    
    char * dictstore;
    char ** dict;
    unsigned int add, i=0, j=0;
    
    infInput.seekg( infHeader.dictstart );        // move to the dictionary
    dictstore = new char[ infHeader.dictlen+1 ];  // allocate +1 for last null terminator
    dictstore[ infHeader.dictlen ] = '\0';
    infInput.read( dictstore, infHeader.dictlen ); // get the whole dictionary in one go!
    dict = new char*[ infHeader.ndict ]; // our array of pointers

    // change all length bytes to '\0' and set pointers to start of each word
    while( i < infHeader.dictlen && j < infHeader.ndict )
    {
	add = (unsigned int)dictstore[i];
	dict[j++] = (char *)&( dictstore[i+1] );
	dictstore[i] = '\0';
	i += add;
    }

    // -- print the dictionary
    // for( i = 0 ; i < infHeader.ndict ; i++ ) cout << i << ". (" << dict[i] << ")\n";

    // -- get the slots array
    
    int_32 * slots = new int_32[ infHeader.nslots ];
    infInput.seekg( infHeader.slotsstart );  
    for( i = 0 ; i < infHeader.nslots ; i++ )
	infInput >> slots[i];

    int space = 1;   // when space==TRUE we put a space after each word
    int mono_space = 0; // when mono_space==TRUE we have a monospaced example!

    int_8  stuff;          // the slots structure
    int_32 localdictpos;
    int_8  nlocaldict;
    int_16 ntext;
    unsigned char *text;

    int_16 *localdict;  // a place to hold the local dictionary

    // process each "slot"
    
    for( j = 0 ; j < infHeader.nslots ; j++ )
    {
	space = 1;
	
	cout << "\n------------------------- " << j << "'th slot ----------\n";
	
	if( j == 45 )
	{
	    cout << "";
	}
	
	// get the j'th slot
    
	infInput.seekg( slots[j] );  // seek the first article
	infInput >> stuff
	    >> localdictpos
	    >> nlocaldict
	    >> ntext;
	
	text = new unsigned char[ ntext ];
	infInput.read( (char *)text, ntext );

	// get the local dictionary (each slot has one)

	infInput.seekg( localdictpos );
	localdict = new int_16[ nlocaldict ];
	for( i = 0 ; i < nlocaldict ; i++ )
	    infInput >> localdict[i];

	for( i = 0 ; i < ntext ; i++ )
	    switch( text[ i ] )
	{
	case 0xfa: // end of paragraph, sets space to TRUE
	    cout << "\n";
	    space = 1;
	    break;
	case 0xfb: // [unknown]
	    break;
	case 0xfc: // spacing = !spacing
	    space = !space;
	    break;
	case 0xfd: // line break, set space to TRUE if not monospaced example
	    cout << "\n";
	    if( !mono_space ) space = 1;
	    break;
	case 0xfe: // space
	    cout << " ";
	    break;
	case 0xff: // escape code
	    if( text[i+1] == 0x02 && text[i+2] == 0x0B )
	    {
		mono_space = 1;  // begin monospaced example!
		space = 0;
	    }
	    else if( text[i+1] == 0x02 && text[i+2] == 0x0C )
	    {
		mono_space = 0;  // end monospaced example!
                space = 1;
	    }
	    i = i + ( text[ i+1 ] ); // skip the esccode!
	    break;
	default:   // output dict[localdict[text[i]]] and, if space==TRUE a space.
	    cout << dict[ localdict[ text[i] ]];
	    if( space )
		cout << " ";
	    break;
	}
	// ---- delete allocated arrays
	
	delete[] text;
	delete[] localdict;
    }
    
    delete[] dict;
    delete[] dictstore;
    delete[] slots;

    return 0;
}
