//
// the InfHeader class for use with the InfFile class
//
// friend istream & operator>>( istream & is, InfHeader & header )
//   -- load the infheader, sets infIsValid == TRUE!
//
// public
//   LoadInfHeader( istream & is ) - load the header from the current stream
//   (bool) IsValid() - is the header loaded, (correct "magic" number etc...)
//
// #ifdef DEBUG then 
//  ostream & operator<<( ostream & os, InfHeader & header )
// output the header data
//
// see the infhead.h file for the protected data members... of which contain
// offsets, titles, and assorted bits and bytes.
//

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include "infhead.h"

InfHeader::InfHeader()
{
#ifdef DEBUG2
  cout << "constructing infheader\n";
#endif
  infIsValid = FALSE;
}

InfHeader::~InfHeader()
{
#ifdef DEBUG2
  cout << "destroying infheader\n";
#endif
}

int InfHeader::LoadInfHeader( istream & is )
{
    is >> magicID;
    if( magicID != 0x5348 )
    {
	cerr << "ERROR (InfHeader::LoadInfHeader)\n\
  magicID is " << hex << magicID << " not 0x5348\n";
	return ( infIsValid = FALSE );  // well no point in going on
    }
    else
	cout << "InfHeader has correct magicID\n";

    is >> unknown1
       >> flags
       >> hdrsize
       >> unknown2
       >> ntoc
       >> tocstrtablestart 
       >> tocstrlen
       >> tocstart
       >> nres
       >> resstart
       >> nname
       >> namestart
       >> nindex
       >> indexstart
       >> indexlen;
    
    is.read( (char *)unknown3, 10 );
    
    is >> searchstart
       >> searchlen
       >> nslots
       >> slotsstart
       >> dictlen
       >> ndict
       >> dictstart
       >> imgstart
       >> unknown4
       >> nlsstart
       >> nlslen
       >> extstart;
    
    is.read( (char *)unknown5, 12 );
    is.read( title, sizeof( title ) );
    
    return ( infIsValid = !is.bad() );
    
}

int InfHeader::IsValid()
{
    return infIsValid;
}

// load the infHeader

istream & operator>>( istream & is, InfHeader & header )
{
  header.LoadInfHeader( is );
  return is;
}

#ifdef DEBUG
ostream & operator<<( ostream & os, InfHeader & header )
{
  os << "+- DEBUG INFO -- InfHeader Structure --\n"
    << "| infIsValid " << ( header.infIsValid ? "True" : "False" ) << "\n";
  if( !header.infIsValid )
    {
      os << "+- END DEBUG INFO -- \n";
      return os;
    }
  os.setf( ios::showbase );
  os << "| magicID          " << hex << header.magicID 
   << "\n| unknown1         " << (int)header.unknown1
   << "\n| flags            " << (int)header.flags
   << "\n| hdrsize          " << dec << header.hdrsize
   << "\n| unknown2         " << hex << header.unknown2
   << "\n| ntoc             " << dec << header.ntoc
   << "\n| tocstrtablestart " << header.tocstrtablestart
   << "\n| tocstrlen        " << header.tocstrlen
   << "\n| tocstart         " << header.tocstart
   << "\n| nres             " << header.nres
   << "\n| resstart         " << header.resstart
   << "\n| nname            " << header.nname
   << "\n| namestart        " << header.namestart
   << "\n| nindex           " << header.nindex
   << "\n| indexstart       " << header.indexstart
   << "\n| indexlen         " << header.indexlen 
   << "\n| unknown3[10]     " << hex
     << (int)header.unknown3[0]
     << (int)header.unknown3[1]
     << (int)header.unknown3[2]
     << (int)header.unknown3[3]
     << (int)header.unknown3[4]
     << (int)header.unknown3[5]
     << (int)header.unknown3[6]
     << (int)header.unknown3[7]
     << (int)header.unknown3[8]
     << (int)header.unknown3[9] << dec
   << "\n| searchstart      " << header.searchstart
   << "\n| nslots           " << header.nslots
   << "\n| slotsstart       " << header.slotsstart
   << "\n| dictlen          " << header.dictlen
   << "\n| ndict            " << header.ndict
   << "\n| dictstart        " << header.dictstart
   << "\n| imgstart         " << header.imgstart
   << "\n| unknown4         " << (int)header.unknown4 
   << "\n| nlsstart         " << header.nlsstart
   << "\n| nlslen           " << header.nlslen
   << "\n| extstart         " << header.extstart
   << "\n| unknown5[12]     " << hex
     << (int)header.unknown5[0]
     << (int)header.unknown5[1]
     << (int)header.unknown5[2]
     << (int)header.unknown5[3]
     << (int)header.unknown5[4]
     << (int)header.unknown5[5]
     << (int)header.unknown5[6]
     << (int)header.unknown5[7]
     << (int)header.unknown5[8]
     << (int)header.unknown5[9]
     << (int)header.unknown5[10]
     << (int)header.unknown5[11] << dec
   << "\n| title[48]        ";
  os.width( sizeof( header.title ) );
  os.fill( '_' );
  os << header.title << "\n";

  os << "+- END DEBUG INFO -- \n";
  os.unsetf( ios::showbase );
  return os;
}
#endif
