//
// the InfHeader class for use in the InfFile class
//

#ifndef _INF_INFHEADER
#define _INF_INFHEADER

#ifndef _INF_VARS
#include "vars.h"
#endif

class InfHeader
{
  friend class InfFile;
  friend int main( int argc, char ** argv );
#ifdef DEBUG
  friend ostream & operator<<( ostream & os, InfHeader & header );
#endif
  friend istream & operator>>( istream & is, InfHeader & header );
public:
    InfHeader();
    ~InfHeader();
    int LoadInfHeader( istream & is );
    int IsValid();
protected:
    int infIsValid;
    
    // Structure of the INF file format header
    int_16 magicID;          // ID magic word (5348h = "HS")
    int_8  unknown1;         // unknown purpose, could be third letter of ID
    int_8  flags;            // probably a flag word... bit0 if INF, bit 4 if HLP
    int_16 hdrsize;          // total size of header
    int_16 unknown2;         // unknown purpose
    int_16 ntoc;             // number of entries in the tocarray
    int_32 tocstrtablestart; // file offset of the start of the strings for the table-of-contents
    int_32 tocstrlen;        // number of bytes in file occupied by the table-of-contents strings
    int_32 tocstart;         // file offset of the start of tocarray
    int_16 nres;             // number of panels with ressource numbers
    int_32 resstart;         // file offset of ressource number table
    int_16 nname;            // number of panels with textual name
    int_32 namestart;        // file offset to panel name table
    int_16 nindex;           // number of index entries
    int_32 indexstart;       // file offset to index table
    int_32 indexlen;         // size of index table
    char  unknown3[10] ;     // unknown purpose
    int_32 searchstart;      // file offset of full text search table
    int_32 searchlen;        // size of full text search table
    int_16 nslots;           // number of "slots"
    int_32 slotsstart;       // file offset of the slots array 
    int_32 dictlen;          // number of bytes occupied by the "dictionary"
    int_16 ndict;            /* number of entries in the dictionary */
    int_32 dictstart;        /* file offset of the start of the dictionary */
    int_32 imgstart;         /* file offset of image data */
    int_8  unknown4;         /* unknown purpose */
    int_32 nlsstart;         /* file offset of NLS table */
    int_32 nlslen;           /* size of NLS table */
    int_32 extstart;         /* file offset of extended data block */
    char   unknown5[12];     /* unknown purpose */
    char   title[48];        /* ASCII title of database */
};

#endif // (define _INF_INFHEADER )