
// -- a couple of classes for 32bit ints and 16bit ints

#ifndef _INF_VARS
#define _INF_VARS

#ifndef TRUE
  #define TRUE 1
#endif

#ifndef FALSE
  #define FALSE 0
#endif

#define int16 unsigned short int
#define int32 unsigned int
#define int8  unsigned char

// byteswapping stuff!
#define swps(x) x = (int16)( (int16)((x & 0xFF) << 8)  | (int16)((x & 0xFF00) >> 8) )
#define swpl(x) x = (int32)( (int32)((x & 0xFF) << 24) | (int32)((x & 0xFF00) << 8 ) | (int32)((x & 0xFF0000) >> 8) | (int32)((x & 0xFF000000) >> 24) )

class int_32
{
  friend istream & operator>>( istream & is, int_32 & var );
 public:
  operator unsigned int ();
  unsigned int value;
};

class int_16
{
  friend istream & operator>>( istream & is, int_16 & var );
 public:
  operator unsigned int ();
  unsigned short int value;
};

class int_8
{
  friend istream & operator>>( istream & is, int_8 & var );
 public:
  operator unsigned int ();
  unsigned char value;
};

#endif // (define _INF_VARS)
