#define INCL_WIN

#include "client.h"

main(int argc, char **argv)
{
   HAB   hab;
   HMQ   hmq;
   QMSG  qmsg;

   hab = WinInitialize(0);
   hmq = WinCreateMsgQueue(hab, 15);

   hwndClient = WinLoadDlg ( HWND_DESKTOP,
                             HWND_DESKTOP,
                             ClientDlgProc,
                             NULLHANDLE,
                             WND_CLNT,
                             NULL);

   /*Fill in a bit of structure data */
   cData = malloc(sizeof(clientData));
   cData->nick = argv[1];

   if (hwndClient)
      while (WinGetMsg ( hab, &qmsg, NULLHANDLE, 0, 0))
         WinDispatchMsg(hmq, &qmsg);

   free(cData);
   WinDestroyWindow(hwndClient);
   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);


}

MRESULT EXPENTRY ClientDlgProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   int   tid;       /* beginthread return id*/
   CHAR  *szBuffer; /* Remember out packet max size is this */
   ULONG ulRetLen;
   CHAR  *pktptr;
   CHAR  *locator;
   CHAR  *fieldptr1;
   CHAR  *fieldptr2;
   CHAR  *fieldptr3;
   CHAR  formatOutputBuf[1024];

   switch (msg) {
      case WM_INITDLG:
         WinPostMsg(WinWindowFromID(hwnd,WND_INPUT), EM_SETTEXTLIMIT,
                    MPFROMSHORT(253),NULL);
         WinEnableWindow(WinWindowFromID(hwnd, ID_CONNECT), TRUE);
         WinEnableWindow(WinWindowFromID(hwnd, ID_DISCONNECT), FALSE);
      break;

      case WM_COMMAND:
         switch (LOUSHORT (mp1)) {
            case ID_CONNECT:
               /*Here is where we begin to connect to our server.
                 In this case we will call the functions to initialize the socket
                 environment. If this all goes well, we  will post a user message
                 to let us know we can know set up our threads for outgoing and
                 incoming packets on our socket. If setupSockets() works we will
                 get the socket descriptor for our client socket otherwise we get 0*/
               clientSocket = setupSockets();
               if (clientSocket > 0) {
                  /* send SM_SOCKETGO so we know there is a good socket
                     the socket is mp1 */
                  WinPostMsg(hwnd, SM_SOCKETGO, clientSocket, 0);
               } else {
                  /* We must inform the user here that socket initialization failed */
                  /* We either say to check inet.sys or jsut display the error result */
                  if (clientSocket == 0) {
                     /* sock_init failed */
                  } else {
                     /* socket failed and we can get the socket error number by losing the negative */
                  }
               }

            break; /* ID_CONNECT */
            case ID_DISCONNECT:
            /* Disconnect from the server and do clean up*/
            /* Lets post a message to our thread to shut the socket system down */
            WinPostQueueMsg(hmqt, SM_KILL, 0, 0);
            break;
         }
      break; /*WM_COMMAND */

      case WM_CLOSE:
        WinPostMsg(hwnd, WM_QUIT, 0, 0);
        return FALSE;
      break;

      case SM_SOCKETGO:
         /* With the message that our socket system is running we will now connect to the
            server and wait for a SM_CONNECETED message to be sent */
         connectToServer(clientSocket, serverName, serverPort);
      break;

      case SM_CONNECTED:
         /* We are connected to the server lets set up the receive and transmit threads
            Receive first...*/
            cData->SocketID = clientSocket;
            cData->mainHWND = hwnd;

            /* Our socket will be on a searate thread */
            tid = _beginthread(socketThread, NULL, 16384, cData);
            WinEnableWindow(WinWindowFromID(hwnd, ID_CONNECT), FALSE);
            WinEnableWindow(WinWindowFromID(hwnd, ID_DISCONNECT), TRUE);
      break;

      case SM_DISCONNECTED:
           WinEnableWindow(WinWindowFromID(hwnd, ID_CONNECT), TRUE);
           WinEnableWindow(WinWindowFromID(hwnd, ID_DISCONNECT), FALSE);
      break;

      case SM_RECV:
            /* This is a public message from one client to be seen by all other clients */
            /* The packet type id is 'b' The packet has this format: bMessageText */
            pktptr = (char*)mp1;
            /* An open message packet contains the nick of the sender and the message itself
               So we will use two of the field pointers to grab those fields */
            locator = strchr(pktptr, '\001'); /* This now makes pktptr point t the nickname */
            fieldptr1 = pktptr;
            fieldptr2 = ++locator; /*This will be the message*/
            locator--;
            *locator = '\0'; /* Now we have to null terminated strings and we can display our message */
            sprintf(formatOutputBuf, "<%s> %s\n", fieldptr1, fieldptr2);

            WinPostMsg(WinWindowFromID(hwnd, WND_OUTPUT), MLM_INSERT, MPFROMP(formatOutputBuf), 0);

            /* last thing to do is to free the mp1 memeory */
            free (mp1);
      break;

     case WM_CHAR:
        if (CHARMSG(&msg)->fs & KC_VIRTUALKEY)
           switch (CHARMSG(&msg)->vkey) {
                case VK_NEWLINE:
                case VK_ENTER:
                      /* Here we will get the input from the WND_INPUT window */
                      /* We put hte text in one byte forward so we can put the length byte in there */
                      szBuffer = malloc(255);
                      ulRetLen = WinQueryDlgItemText(hwndClient, WND_INPUT, 255, &szBuffer[2]);
                      if (ulRetLen != 0) {
                          szBuffer[ulRetLen+2] = '\0';
                          szBuffer[1] = 'b';
                          szBuffer[0] = strlen(&szBuffer[1])+1;
                          WinPostQueueMsg(hmqt, SM_SEND, szBuffer, 0);
                          sprintf(formatOutputBuf, "---> %s\n", &szBuffer[2]);
                          WinPostMsg(WinWindowFromID(hwnd, WND_OUTPUT), MLM_INSERT, MPFROMP(formatOutputBuf), 0);

                        }
                      /* Clear the input window now */
                      WinSetDlgItemText(hwnd, WND_INPUT, "\0");

                break;
             }
      break;

      default:
        return WinDefDlgProc(hwnd, msg, mp1,mp2);

   } /* End Switch */

   return (MRESULT)FALSE;
}

