@echo off

REM *************************************************************************
REM QVision driver for IBM OS/2 2.1 or greater
REM
REM INSTALL %1
REM
REM %1 = destination drive
REM 
REM NOTE: The directory containing this batch file must be the 
REM       current directory when this batch file is executed.
REM 
REM             Example:        
REM 
REM                             INSTALL C:
REM 
REM *************************************************************************

if (%1) == () goto Usage

REM *************************************************************************
REM  Print message to remind user to change source directory
REM  when DSPINSTL prompts him for source directory
REM *************************************************************************

@echo.
@echo **********************************************************************
@echo.
@echo   Installing QVision Driver....
@echo.
@echo   NOTE: 
@echo.
@echo      When DSPINSTL prompts you for a source directory, make sure 
@echo      that you specify the directory '%1\OS2\INSTALL\DSPITEMP'. 
@echo      Otherwise, it will not be able to find the driver files.
@echo.
@echo **********************************************************************
@echo.
@echo. 
@echo.


REM *************************************************************************
REM  Save the original files so user can restore to his original configuration
REM *************************************************************************

if NOT exist %1\OS2\INSTALL\RESTORE.CPQ md %1\OS2\INSTALL\RESTORE.CPQ

REM *************************************************************************
REM  Remove System and Hidden attributes from INI files 
REM  so the copy command won't fail
REM *************************************************************************

attrib -s -h %1\os2\os2.ini
attrib -s -h %1\os2\os2sys.ini

if NOT exist %1\OS2\INSTALL\RESTORE.CPQ\CONFIG.SYS copy %1\CONFIG.SYS %1\OS2\INSTALL\RESTORE.CPQ >NUL
if NOT exist %1\OS2\INSTALL\RESTORE.CPQ\OS2.INI copy %1\OS2\OS2.INI %1\OS2\INSTALL\RESTORE.CPQ >NUL
if NOT exist %1\OS2\INSTALL\RESTORE.CPQ\OS2SYS.INI copy %1\OS2\OS2SYS.INI %1\OS2\INSTALL\RESTORE.CPQ >NUL
if NOT exist %1\OS2\INSTALL\RESTORE.CPQ\DISPLAY.DLL copy %1\OS2\DLL\DISPLAY.DLL %1\OS2\INSTALL\RESTORE.CPQ >NUL

:CHK_SYS_INI
if exist %1\OS2\INSTALL\RESTORE.CPQ\SYSTEM.INI goto CHK_WIN_INI
if exist %1\OS2\MDOS\WINOS2\SYSTEM.INI copy %1\OS2\MDOS\WINOS2\SYSTEM.INI %1\OS2\INSTALL\RESTORE.CPQ

:CHK_WIN_INI
if exist %1\OS2\INSTALL\RESTORE.CPQ\WIN.INI goto INI_CHK_DONE
if exist %1\OS2\MDOS\WINOS2\WIN.INI copy %1\OS2\MDOS\WINOS2\WIN.INI %1\OS2\INSTALL\RESTORE.CPQ

:INI_CHK_DONE

REM *************************************************************************
REM  Copy the packed files from floppy to the \os2\install\dspitemp directory
REM *************************************************************************

if NOT exist %1\OS2\INSTALL\DSPITEMP md %1\OS2\INSTALL\DSPITEMP

copy .\qv_32bit\cpqqv.dl@         %1\os2\install\dspitemp
copy .\qv_32bit\cpqqv.r0@         %1\os2\install\dspitemp
copy .\qv_32bit\cpqqv.sm@         %1\os2\install\dspitemp
copy .\qv_32bit\cpqqv.vd@         %1\os2\install\dspitemp
copy .\qv_32bit\display.dl@       %1\os2\install\dspitemp

copy .\qv_32bit\cpqos2su.exe      %1\os2\install\dspitemp
copy .\qv_32bit\cpqhwqry.exe      %1\os2\install\dspitemp

copy .\qv_32bit\cpqmode.ini       %1\os2\install\dspitemp
copy .\qv_32bit\cpqmon.ini        %1\os2\install\dspitemp

copy .\qv_32bit\winfonts.fo@      %1\os2\install\dspitemp

copy .\qv_32bit\cpqqvp.dsp        %1\os2\install\dspitemp
copy .\qv_32bit\rest_21p.dsp      %1\os2\install\dspitemp

REM *************************************************************************
REM Copy our dspinstl ACTION DLL to the OS2\DLL directory!
REM *************************************************************************

copy .\qv_32bit\cpqqv.dll         %1\os2\dll

REM *************************************************************************
REM Copy the DSC files to the \os2\install directory
REM *************************************************************************

copy .\qv_32bit\cpqqvc.dsc        %1\os2\install
copy .\qv_32bit\rest_21c.dsc      %1\os2\install

REM *************************************************************************
REM  At this point, we invoke DSPINSTL from the dspitemp sub-directory
REM *************************************************************************

%1
cd \os2\install\dspitemp
\os2\install\dspinstl.exe

REM *************************************************************************
REM  Print message to remind user to remove diskette from drive
REM *************************************************************************

@echo.
@echo **********************************************************************
@echo.
@echo                       Installation Complete
@echo.
@echo   If you installed the driver from a diskette, please remove 
@echo   the diskette from the drive before you reboot your system.
@echo.
@echo **********************************************************************
@echo.
@echo. 
@echo.


goto End


:Error
@echo.
@echo Install was not successful: no changes made.
goto End

:Usage

@echo.
@echo Usage error - INSTALL ^<Drive where OS/2 is installed^>
@echo.
@echo Example:      INSTALL C:
@echo.
pause
:End
