#include "includes.h"



#pragma argsused

APIRET EXPENTRY FS_FILEINFO (
    USHORT	flag,
    struct sffsi *psffsi,
    struct sffsd *psffsd,
    USHORT	level,
    PCHAR	pData,
    USHORT	cbData,
    USHORT	IOflag )	/* not used */
{
  int       rc;
  POPENFILE pOpenfile;
  DIRENTRY  Entry;

  UtilEnterRamfs();
  DEBUG_PRINTF3 ("FS_FILEINFO  sfn=%d, flag=%d, level=%d",
		 psffsi->sfi_selfsfn, flag, level);

  pOpenfile = psffsd->pOpenfile;
  VMRead (&Entry, pOpenfile->flatEntry, sizeof(Entry)-sizeof(Entry.achName));

  if (flag == 0)
  {
    /* retrieve information */
    rc = InfoQuery (pData, cbData, level, &Entry);
  }
  else
  {
    /* set information */
    rc = InfoSet (pData, cbData, level, &Entry, psffsi);
    if (rc == NO_ERROR)
      VMWrite (pOpenfile->flatEntry, &Entry, sizeof(Entry)-sizeof(Entry.achName));
  }

  DEBUG_PRINTF1 (" => %d\r\n", rc);
  UtilExitRamfs();
  return rc;
}
