#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <string.h>
#include <stdio.h>
#include "qtplay.h"
#include "filedlg.h"

#include <qtw.h>                          /* Apple : QuickTime Movie header */
MovieFile mfMovie;
RECT rcMovie;
Movie mMovie;
MovieController mcController;

/*
 * Function prototypes
 */
MRESULT EXPENTRY MyWindowProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 );

                                        /* Define parameters by type    */
HAB  hab;                               /* PM anchor block handle       */
CHAR szFilename[256];
char *pMovieFile = 0;
HWND hwndClient = NULLHANDLE;         /* Client area window handle    */
HWND hwndFrame = NULLHANDLE;          /* Frame window handle          */
RECTL rectlTmp;

#define wMessageBox(msg,title) WinMessageBox(HWND_DESKTOP,HWND_DESKTOP,msg,title,0,MB_OK)

void OffsetRect(RECT *rcMovie, int x, int y)
{
   rcMovie->left   += x;
   rcMovie->right  += x;
   rcMovie->top    += y;
   rcMovie->bottom += y;
}

void OpenMovie (CHAR *pMovieFile)
{

  WinSetWindowText(hwndFrame, pMovieFile);

  if (OpenMovieFile (pMovieFile, &mfMovie, OF_READ) != noErr)
  {
     wMessageBox ("OpenMovieFile failure", "QT");
     return ;
  }

  NewMovieFromFile (&mMovie, mfMovie, NULL, NULL, 0, NULL);
  CloseMovieFile (mfMovie);

  // ** QuickTime ** : Instantiate the movie controller
  GetMovieBox (mMovie, &rcMovie);
  OffsetRect(&rcMovie, -rcMovie.left, -rcMovie.top);
  mcController = NewMovieController (mMovie, &rcMovie,
     mcTopLeftMovie + mcScaleMovieToFit, hwndClient);

  // ** QuickTime ** : Make the movie paused initially
  MCDoAction (mcController, mcActionPlay, 0);


  // ** QuickTime ** : Eliminate the grow box
  // ** QuickTime ** : Make the frame just big enough for the movie

  MCGetControllerBoundsRect(mcController, &rcMovie);
  rectlTmp.xLeft   = rcMovie.left;
  rectlTmp.xRight  = rcMovie.right;
  rectlTmp.yTop    = rcMovie.bottom;
  rectlTmp.yBottom = rcMovie.top;
  WinCalcFrameRect(hwndFrame, &rectlTmp, FALSE);

  if (!WinSetWindowPos( hwndFrame,      /* Shows and activates frame    */
                   HWND_TOP,            /* window at position 100, 100, */
                   10, 10,
                   rectlTmp.xRight - rectlTmp.xLeft,
                   rectlTmp.yTop   - rectlTmp.yBottom,
                   SWP_SIZE | SWP_MOVE | SWP_ACTIVATE
                 ))
  {
    wMessageBox("No Position !", "QT");
    return;
  }

  // ** QuickTime ** : Make the movie active
  SetMovieActive (mMovie, TRUE);
}

void SetRectEmpty(RECT *rcMovie)
{
   rcMovie->left    = 0;
   rcMovie->top     = 0;
   rcMovie->right   = 0;
   rcMovie->bottom  = 0;
}

//
//  Program entry point.
//
INT main (int argc, char *argv[])
{
  HMQ  hmq;                             /* Message queue handle         */
  HWND hwndOpen = NULLHANDLE;          /* Open button window handle     */
  QMSG qmsg;                            /* Message from message queue   */
  ULONG flCreate;                       /* Window creation control flags*/
  ULONG ulSizeBorderX, ulSizeBorderY, ulSizeTitleBar;

  if ((hab = WinInitialize(0)) == 0L) /* Initialize PM     */
  {
    wMessageBox("No Hab !", "QT");
    return 0;
  }

  if ((hmq = WinCreateMsgQueue( hab, 0 )) == 0L)/* Create a msg queue */
  {
    wMessageBox("No Queue !", "QT");
    return 0;
  }

  //Filename entered at command line as argument
  if (argc >= 2) {
    pMovieFile = argv[1];
  } else {
    pMovieFile = szFilename;
    memset (szFilename, 0, sizeof (szFilename));
  }

  // ** QuickTime ** : QuickTime requires application hab and queue to run !
  // ** QuickTime ** : Establish links to QuickTime for OS/2.
  if (QTInitialize (NULL))
  {
    wMessageBox("QTInitialize failure", "QT");
    return 0;
  }

  // ** QuickTime ** : Allocate memory required for playing movies.
  if (EnterMovies ())
  {
    wMessageBox("EnterMovies failure", "QT");
    return 0;
  }

  if (!WinRegisterClass(                /* Register window class        */
     hab,                               /* Anchor block handle          */
     (PSZ)"MyWindow",                   /* Window class name            */
     (PFNWP)MyWindowProc,               /* Address of window procedure  */
     CS_SIZEREDRAW,                     /* Class style                  */
     0                                  /* No extra window words        */
     ))
  {
    wMessageBox("No Class ! ", "QT");
    return 0;
  }

  flCreate = FCF_STANDARD &            /* Set frame control flags to   */
            ~FCF_SHELLPOSITION;        /* standard except for shell    */
                                        /* positioning.                 */

  if ((hwndFrame = WinCreateStdWindow(
               HWND_DESKTOP,            /* Desktop window is parent     */
               0,                       /* STD. window styles           */
               &flCreate,               /* Frame control flag           */
               "MyWindow",              /* Client window class name     */
               "",                      /* No window text               */
               0,                       /* No special class style       */
               (HMODULE)0L,           /* Resource is in .EXE file     */
               ID_WINDOW,               /* Frame window identifier      */
               &hwndClient              /* Client window handle         */
               )) == 0L)
  {
    wMessageBox("No Window !", "QT");
    return 0;
  }

  // ** QuickTime ** : Get movie filename.
  // ** QuickTime ** : Instantiate the movie if file name passed in
  if (pMovieFile[0]) {
     OpenMovie (pMovieFile);
  } else {
    //Set window to default size
     WinSetWindowPos ( hwndFrame, HWND_TOP, 10, 10,
                       320, 240,
                       SWP_SIZE | SWP_ACTIVATE | SWP_SHOW );
  }

  // Make the main window visible
  WinShowWindow(hwndFrame, TRUE);
  WinUpdateWindow(hwndFrame);

 /*
  * Get and dispatch messages from the application message queue
  * until WinGetMsg returns FALSE, indicating a WM_QUIT message.
  */
  while( WinGetMsg( hab, &qmsg, 0L, 0, 0 ) )
    WinDispatchMsg( hab, &qmsg );

  // ** QuickTime ** : Destroy the movie controller
  DisposeMovieController (mcController);

  // ** QuickTime ** : Destroy the movie
  DisposeMovie (mMovie);

  // ** QuickTime ** : Cut the connections to QuickTime for OS/2
  ExitMovies ();
  QTTerminate ();
  return 0;

  WinDestroyWindow(hwndFrame);           /* Tidy up...                   */
  WinDestroyMsgQueue( hmq );             /* Tidy up...                   */
  WinTerminate( hab );                   /* Terminate the application    */

  return 0;
} /* End of main */

void ClrScn(int x, int y, int cx, int cy)
{
  HPS hps;
  RECTL rectl;

  hps = WinGetScreenPS(HWND_DESKTOP);

  rectl.xLeft   = x;
  rectl.xRight  = x + cx;
  rectl.yBottom = y;
  rectl.yTop    = y + cy;
  WinFillRect(hps, &rectl, CLR_WHITE);

  WinReleasePS(hps);
}


//
//  PM Application Window Procedure.
//
MRESULT EXPENTRY MyWindowProc( HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  INT rc;

  // ** QuicKTime **  Drive the movie controller
  if (MCIsPlayerMessage (mcController, hwnd, msg, (WPARAM)mp1, (LPARAM)mp2))
     return 0;

  switch( msg )
  {
    case WM_BUTTON2DOWN:
    {
      LFIXED lfxRate;
      lfxRate = GetMoviePreferredRate (mMovie);
      MCDoAction (mcController, mcActionPlay, (void *)lfxRate);
      break;
    }
    case WM_ERASEBACKGROUND:
      /*
       * Return TRUE to request PM to paint the window background
       * in SYSCLR_WINDOW.
       */
      return (MRESULT)( TRUE );
    case WM_PAINT:
      /*
       * Window contents are drawn here in WM_PAINT processing.
       */
      {
      HPS    hps;                       /* Presentation Space handle    */
      RECTL  rc;                        /* Rectangle coordinates        */
      POINTL pt;                        /* String screen coordinates    */
                                        /* Create a presentation space  */
      hps = WinBeginPaint( hwnd, 0L, &rc );
      WinEndPaint( hps );                      /* Drawing is complete   */
      break;
      }
    case WM_CLOSE:
      /*
       * This is the place to put your termination routines
       */
      WinPostMsg( hwnd, WM_QUIT, (MPARAM)0,(MPARAM)0 );/* Cause termination*/
      break;

    case WM_SIZE:
      {
        RECT newRect;

        newRect.left = 0;
        newRect.top = 0;
        newRect.right = SHORT1FROMMP(mp2);
        newRect.bottom = SHORT2FROMMP(mp2);
        MCSetControllerBoundsRect(mcController, &newRect);
        break;
      }


    case WM_COMMAND:

       switch (SHORT1FROMMP(mp1))
       {     /* Button ID */
          case ID_OPEN:
          {

             // Close current movie if already open
             if (pMovieFile[0]) {
                MCDoAction (mcController, mcActionPlay, 0);

                // ** QuickTime ** : Destroy the movie controller
                DisposeMovieController (mcController);

                // ** QuickTime ** : Destroy the movie
                DisposeMovie (mMovie);
                pMovieFile[0] = 0;
             } /* endif */

             // Ask for the new filename
             rc = OpenFileDlg ( hwnd, (char *)pMovieFile );

             //Open the new filename under QuickTime
             if (pMovieFile)
                OpenMovie (pMovieFile);

             // Make the main window visible
             WinShowWindow(hwndFrame, TRUE);
             WinUpdateWindow(hwndFrame);

             break;
          }
       } /* end switch      */


    default:
      /*
       * Everything else comes here.  This call MUST exist
       * in your window procedure.
       */

      return WinDefWindowProc( hwnd, msg, mp1, mp2 );
  }
  return (MRESULT)FALSE;
} /* End of MyWindowProc */
