// $$Begin$$ - Everything to the "end" is only for internal use only!!

// Copyright:    (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// Project:      QuickTime for Windows
//
// Component:    QuickTime
//
// Description:  QuickTime for Windows Header File
//
// ---------------------------------------------------------------------
//
//   $Author:   mef  $
//
//     $Date:   01 Jul 1994 02:57:42  $
//
//      $Log:   D:/ethel.vcs/glue/qtw.h_v  $
// 
//    Rev 1.64   01 Jul 1994 02:57:42   mef
// Cale Final -- trial build #2
// 'hlit' and 'hclr' support added
//
//    Rev 1.61   11 Apr 1994 10:39:46   MEF
// Cale Alpha deliverable
//
//    Rev 1.60   11 Mar 1994 17:08:50   MEF
// Added MusicDescription
//
//    Rev 1.59   07 Mar 1994 11:14:14   MEF
// Added MCMovieChanged
//
//    Rev 1.58   07 Feb 1994 08:57:20   MEF
// No change.
//
//    Rev 1.57   04 Feb 1994 11:27:14   MEF
// No change.
//
//    Rev 1.56   12 Mar 1993 10:33:34   MEF
// Added CODEC error codes
//
//    Rev 1.55   11 Mar 1993 17:10:30   MEF
// Corrected mismatch with Galan
//
//    Rev 1.54   11 Mar 1993 10:31:34   MEF
// Component manager update for decompressors
//
//    Rev 1.46   22 Jan 1993 17:45:58   MEF
// Added new MCI flag
//
//    Rev 1.45   07 Jan 1993 17:17:08   MEF
// Added MCI constants
//
//    Rev 1.44   07 Jan 1993 17:09:46   MEF
// No change.
//
//    Rev 1.43   02 Nov 1992 10:04:22   MEF
// Changed error code
//
//    Rev 1.42   30 Oct 1992 08:04:56   MEF
// Added new error codes for pictures
//
//    Rev 1.41   22 Oct 1992 18:28:14   MEF
// No change.
//
//    Rev 1.40   22 Oct 1992 14:33:42   MEF
// QTInitialize now takes version
//
//    Rev 1.39   16 Oct 1992 19:07:34   MEF
// Delete redundant hint
//
//    Rev 1.38   14 Oct 1992 08:52:46   MEF
// Action filter now receives action code value, not reference
//
//    Rev 1.37   06 Oct 1992 11:06:02   MEF
// Spell out interpolate
//
//    Rev 1.36   06 Oct 1992 08:06:30   MEF
// Exposed SetMoviePlayHints
//
//    Rev 1.35   02 Oct 1992 08:49:46   MEF
// Added progress proc to DrawPicture
//
//    Rev 1.34   21 Sep 1992 11:46:02   MEF
// MAKExFIXED parameters reversed
//
//    Rev 1.33   08 Sep 1992 18:35:38   MEF
// No change.
//
//    Rev 1.32   08 Sep 1992 11:45:12   MEF
// No change.
//
//    Rev 1.31   04 Sep 1992 15:48:20   MEF
// Added noPictureInFile
//
//    Rev 1.30   01 Sep 1992 22:54:10   MEF
// NewMovieFromDataFork should have taken flags
//
//    Rev 1.29   31 Aug 1992 21:36:56   MEF
// Added QTTerminateToolBox
//
//    Rev 1.28   31 Aug 1992 21:18:48   MEF
// Changed QTInitializeToolBox calling sequence
//
//    Rev 1.27   31 Aug 1992 21:07:28   MEF
// Cosmetic corrections
//
//    Rev 1.26   31 Aug 1992 21:05:16   MEF
// Added QTInitializeToolBox call for QTNotify
//
//    Rev 1.25   28 Aug 1992 06:45:26   MEF
// Changed mcActionGotoTime to mcActionGoToTime
//
//    Rev 1.24   25 Aug 1992 17:15:04   MEF
// Added invalkidUserDataHandle error
//
//    Rev 1.23   25 Aug 1992 17:06:38   MEF
// Added insufficientMemory error code
//
//    Rev 1.22   21 Aug 1992 10:49:40   MEF
// NewMovieController, DisposeMovieController are now
// ToolBox functions
//
//    Rev 1.21   21 Aug 1992 09:40:08   MEF
// New error codes for Movie Controller; reassignment of
// old codes to acceptable ranges
//
//    Rev 1.20   20 Aug 1992 13:45:08   MEF
// Removed mcActionGotoStart, mcActionGotoEnd, mcActionMuteToggle
//
//    Rev 1.19   19 Aug 1992 14:55:16   MEF
// GetMovieTime must be exposed
//
//    Rev 1.18   18 Aug 1992 22:27:08   MEF
// Beta cleanup
//
//    Rev 1.17   18 Aug 1992 20:42:00   MEF
// Locally include QRWMC.H
//
//    Rev 1.16   18 Aug 1992 18:54:46   MEF
// Beta cleanup
//
//    Rev 1.15   18 Aug 1992 13:42:24   MEF
// Beta cleanup
//
//    Rev 1.14   18 Aug 1992 09:07:50   MEF
// Beta cleanup
//
//    Rev 1.13   17 Aug 1992 15:33:46   MEF
// Beta cleanup
//
//    Rev 1.12   07 Aug 1992 13:25:32   MEF
// Made QTW.H compatible with Borland C
//
//    Rev 1.11   05 Aug 1992 15:55:10   SPT
// Clarified Image Description comments.
//
//    Rev 1.10   31 Jul 1992 18:19:32   MEF
// No change.
//
//    Rev 1.9   31 Jul 1992 17:08:58   MEF
// Added OpenPictureFile, ClosePictureFile
//
//    Rev 1.8   30 Jul 1992 20:43:24   MEF
// Removed HDHIO
//
//    Rev 1.7   29 Jul 1992 10:54:28   MEF
// mcActionSetPosterTime removed
//
//    Rev 1.6   28 Jul 1992 16:45:08   MEF
// PictureToDIB now returns DIBHandle
//
//    Rev 1.5   26 Jul 1992 17:29:24   MEF
// Changed CoverProc prototype to take HDC rather than HRGN
//
//    Rev 1.4   26 Jul 1992 11:39:34   MEF
// Added noErr
//
//    Rev 1.3   25 Jul 1992 18:45:36   MEF
// New glue
//
//    Rev 1.1   01 Jun 1992 14:49:00   MEF
// No change.
//
//    Rev 1.0   01 Jun 1992 14:48:14   MEF
// Initial revision
//
//  $Logfile:   D:/ethel.vcs/glue/qtw.h_v  $
//
// $Workfile:   qtw.h  $
//
// ---------------------------------------------------------------------

// $$End$$


// ---------------------------------------------------------------------
//
// QTW.H - QuickTime for Windows C and C++ Bindings
//
//         Version 2.0
//
//         (c) Copyright 1988-1994 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------


// Prevent multiple inclusion
// --------------------------
#ifndef __QTW_H__
#define __QTW_H__

#include <qt_os2.h>

#ifdef QTW_PASCAL
    #undef QTW_PASCAL
#endif
#ifdef _WIN32
    #define QTW_PASCAL __cdecl
#else
    #define QTW_PASCAL PASCAL
#endif


// $$Begin$$ - Everything to the "end" is only for internal use only!!
#if defined (EXPORT)
	#undef EXPORT
#endif
#ifdef _WIN32
    #define EXPORT
    #ifdef PASCAL
	#undef PASCAL
    #endif
    #define PASCAL __cdecl
#else
    #define EXPORT __export
#endif
// $$End$$


// Movie Controller MCDoAction action constants
// --------------------------------------------
typedef enum
  {mcActionIdle                   =  1, // No Param
   mcActionDraw                   =  2, // No Param
   mcActionActivate               =  3, // No param
   mcActionDeactivate             =  4, // No param
   mcActionMouseDown              =  5, // Param is pointer to EventRecord
   mcActionKey                    =  6, // Param is pointer to MSG
   mcActionPlay                   =  8, // Param is LFIXED play rate
   mcActionGoToTime               = 12, // Param is pointer to TimeRecord
   mcActionSetVolume              = 14, // Param is SFIXED volume
   mcActionGetVolume              = 15, // Param is pointer to SFIXED volume
   mcActionStep                   = 18, // Param is LONG number of steps
   mcActionSetLooping             = 21, // Param is a Boolean
   mcActionGetLooping             = 22, // Param is pointer to a Boolean
   mcActionSetLoopIsPalindrome    = 23, // Param is Boolean
   mcActionGetLoopIsPalindrome    = 24, // Param is pointer to a Boolean
   mcActionSetGrowBoxBounds       = 25, // Param is pointer to a Rect
   mcActionControllerSizeChanged  = 26, // No param
   mcActionSetSelectionBegin      = 29, // Param is pointer to TimeRecord
   mcActionSetSelectionDuration   = 30, // Param is pointer to TimeRecord
   mcActionSetKeysEnabled         = 32, // Param is Boolean
   mcActionGetKeysEnabled         = 33, // Param is pointer to Boolean
   mcActionSetPlaySelection       = 34, // Param is Boolean
   mcActionGetPlaySelection       = 35, // Param is pointer to Boolean
   mcActionSetUseBadge            = 36, // Param is Boolean
   mcActionGetUseBadge            = 37, // Param is pointer to Boolean
   mcActionSetFlags               = 38, // Param is LONG flags
   mcActionGetFlags               = 39, // Param is pointer to LONG flags
   mcActionSetPlayEveryFrame      = 40, // Param is Boolean
   mcActionGetPlayEveryFrame      = 41, // Param is pointer to Boolean
   mcActionGetPlayRate            = 42, // Param is pointer to LFIXED
   mcActionBadgeClick             = 44, // Param is pointer to Boolean
   mcActionMovieClick             = 45, // Param is pointer to event structure
   mcActionGetTimeSliderRect      = 49, // Param is pointer to RECT
   mcActionGetSelectionBegin      = 53, // Param is pointer to TimeRecord
   mcActionGetSelectionDuration   = 54  // Param is pointer to TimeRecord
  } mcActionType;


// Movie Controller MCDoAction, action McActionSetFlags parameter, movie
// controller structure parameter, lfActionFlags
// ---------------------------------------------------------------------
typedef enum
  {mcFlagSuppressStepButtons      = 1<<1,
   mcFlagSuppressSpeakerButton    = 1<<2,
   mcFlagsUseWindowPalette        = 1<<3
  } mcActionFlags;


// Toolbox function NewMovieController and Movie Controller function
// MCPositionController parameter controllerCreationFlags values,
// movie controller structure parameter, lfControllerStateFlags
// -----------------------------------------------------------------
typedef enum
  {mcTopLeftMovie                 = 1<<0,
   mcScaleMovieToFit              = 1<<1,
   mcWithBadge                    = 1<<2,
   mcNotVisible                   = 1<<3
  } mcControllerStateFlags;


// Movie Controller function MCGetControllerInfo parameter mcInfoFlags
// parameter, movie controller structure parameter, lfControllerInfoFlags
// ----------------------------------------------------------------------
typedef enum
  {mcInfoHasSound                 = 1<<5,
   mcInfoIsPlaying                = 1<<6,
   mcInfoIsLooping                = 1<<7,
   mcInfoIsInPalindrome           = 1<<8
  } mcControllerInfoFlags;


// NewMovieFromFile flags
// ----------------------
typedef enum
  {newMovieActive                 = 1<<0,
   newMovieDontResolveDataRefs    = 1<<1,
   newMovieDontAskUnresolvedDataRefs = 1<<2,
   newMovieDontAutoAlternates     = 1<<3
  } newMovieFlags;


// Flags for SetMoviePlayHints
// ---------------------------
typedef enum
  {hintsScrubMode                 = 1<<0,
   hintsLoop                                  = 1<<1,
   hintsInterpolateSound          = 1<<7,
   hintsInactive                  = 1<<11
  } moviePlayHints;


// Flags for MovieSearchText
// -------------------------

#define findTextEdgeOK                (1L << 0)
#define findTextCaseSensitive         (1L << 1)
#define findTextReverseSearch         (1L << 2)
#define findTextWrapAround            (1L << 3)
#define findTextUseOffset             (1L << 4)
#define searchTextDontGoToFoundTime   (1L << 16)
#define searchTextDontHiliteFoundText (1L << 17)
#define searchTextOneTrackOnly        (1L << 18) /*ignored*/
#define searchTextEnabledTracksOnly   (1L << 19)


// Flags for GetMovieIndTrackType
typedef enum
  {movieTrackMediaType        = 1<<0,
   movieTrackCharacteristic   = 1<<1,
   movieTrackEnabledOnly      = 1<<2
  } movieIndTrackTypeFlags;

#define VideoMediaType  QTFOURCC('v','i','d','e')
#define SoundMediaType  QTFOURCC('s','o','u','n')
#define TextMediaType   QTFOURCC('t','e','x','t')
#define MPEGMediaType   QTFOURCC('m','p','e','g')
#define MusicMediaType  QTFOURCC('m','u','s','i')

// Manifest constants for ostypes as flags for Component Manager calls
// -------------------------------------------------------------------
#define kAnyComponentType           0
#define kAnyComponentSubType        0
#define kAnyComponentManufacturer   0
#define kAnyComponentFlagsMask      0


// SetDefaultComponent Flags
// -------------------------
typedef enum
  {defaultComponentIdentical        = 0,
   defaultComponentAnyFlags         = 1,
   defaultComponentAnyManufacturer  = 2,
   defaultComponentAnySubType       = 4
  } defaultComponentFlags;


// RegisterComponent Flags
// -----------------------
typedef enum
  {registerComponentGlobal          = 1,
   registerComponentNoDuplicates    = 2,
   registerComponentAfterExisting   = 4
  } registerComponentFlags;

// putMovieIntoTypedHandle
// -----------------------
typedef enum
  {
    pmithHandleIsPointerToHandle    = 1
  } pmithFlags;


// Error codes
// -------------
enum
  {
   // Shared by QTW and QT Mac
   readErr                        = -19,
   paramErr                       = -50,
   noTypeErr                      = -102,
   insufficientMemory             = -108,
   memWZErr                       = -111,
   notLockedErr                   = -623,
   couldNotResolveDataRef         = -2000,
   badImageDescription            = -2001,
   badPublicMovieAtom             = -2002,
   cantFindHandler                = -2003,
   cantOpenHandler                = -2004,
   badComponentType               = -2005,
   noMediaHandler                 = -2006,
   noDataHandler                  = -2007,
   invalidMedia                   = -2008,
   invalidTrack                   = -2009,
   invalidMovie                   = -2010,
   invalidSampleTable             = -2011,
   invalidDataRef                 = -2012,
   invalidHandler                 = -2013,
   invalidDuration                = -2014,
   invalidTime                    = -2015,
   cantPutPublicMovieAtom         = -2016,
   badEditList                    = -2017,
   mediaTypesDontMatch            = -2018,
   progressProcAborted            = -2019,
   movieToolboxUninitialized      = -2020,
   wffileNotFound                 = -2021,
   cantCreateSingleForkFile       = -2022,
   invalidEditState               = -2023,
   nonMatchingEditState           = -2024,
   staleEditState                 = -2025,
   userDataItemNotFound           = -2026,
   maxSizeToGrowTooSmall          = -2027,
   badTrackIndex                  = -2028,
   trackIDNotFound                = -2029,
   trackNotInMovie                = -2030,
   timeNotInTrack                 = -2031,
   timeNotInMedia                 = -2032,
   badEditIndex                   = -2033,
   internalQuickTimeError         = -2034,
   cantEnableTrack                = -2035,
   invalidRect                    = -2036,
   invalidSampleNum               = -2037,
   invalidChunkNum                = -2038,
   invalidSampleDescIndex         = -2039,
   invalidChunkCache              = -2040,
   invalidSampleDescription       = -2041,
   dataNotOpenForRead             = -2042,
   dataNotOpenForWrite            = -2043,
   dataAlreadyOpenForWrite        = -2044,
   dataAlreadyClosed              = -2045,
   endOfDataReached               = -2046,
   dataNoDataRef                  = -2047,
   noMovieInDataFork              = -2048,
   invalidDataRefContainer        = -2049,
   badDataRefIndex                = -2050,
   noDefaultDataRef               = -2051,
   couldNotUseAnExistingSample    = -2052,
   featureUnsupported             = -2053,
   noVideoTrackInMovie            = -2054,
   noSoundTrackInMovie            = -2055,
   movieTextNotFound              = -2062,

   // -2150 through -2200 reserved for QTW
   soundSupportNotAvailable       = -2150,
   maxControllersExceeded         = -2152,
   unableToCreateMCWindow         = -2153,
   invalidUserDataHandle          = -2154,
   noPictureInFile                = -2155,
   invalidPictureFileHandle       = -2156,
   invalidPictureHandle           = -2157,
   badDisplayContext              = -2158,
   noMusicTrackInMovie            = -2159,
   noTextTrackInMovie             = -2160,
   noMPEGTrackInMovie             = -2161,

   // Shared by QTW and QT Mac
   invalidComponentID             = -3000,
   validInstancesExist            = -3001,
   componentNotCaptured           = -3002,
   componentDontRegister          = -3003,

   // Odds and ends used by QTW only
   noErr                          = 0,
   mcOK                           = 0,
   mcEventNotHandled              = 0,
   mcEventHandled                 = 1,
   codecConditionErr              = -8972,
   controllerBoundsNotExact       = -9996,
   editingNotAllowed              = -9995
  };


// QTInitialize error codes
// ------------------------
enum
  {QTI_OK                         = 0,
   QTI_FAIL_NOEXIST               = 1,
   QTI_FAIL_CORRUPTDLL            = 2,
   QTI_FAIL_286                   = 3,
   QTI_FAIL_WIN30                 = 4
  };


// Component Manager error codes
// -----------------------------
#define badComponentInstance    0x80008001
#define badComponentSelector    0x80008002


// Special MCI Interface
// ---------------------
#define MCI_QTW_PLAY_WINDOW     0x01000000L
#define MCI_QTW_PLAY_FULLSCREEN 0x02000000L
#define MCI_QTW_SET_USE_MC      0x00100000L
#define MCI_QTW_SET_PAL_ASSERT  0x00200000L
#define MCI_QTW_SET_GROWBOX     0x00400000L


// Declared handles
// ----------------
DECLARE_HANDLE(UserData);              // Hungarian: ud
DECLARE_HANDLE(PicHandle);             // Hungarian: ph
DECLARE_HANDLE(DIBHandle);             // Hungarian: dh
DECLARE_HANDLE(PicFile);               // Hungarian: pic
DECLARE_HANDLE(MovieFile);             // Hungarian: mov

// Typedef's
// ---------
typedef LONG ComponentResult;          // Hungarian: cr
typedef LONG OSErr;                    // Hungarian: oserr
typedef LONG OSType;                   // Hungarian: ostype
typedef void far *ProgressProcRecordPtr; // Hungarian: pprp
typedef LONG TimeScale;                // Hungarian: ts
typedef DWORD TimeValue;               // Hungarian: tv
typedef LONG LFIXED;                   // Hungarian: lfx
typedef LONG Fixed;                    // Hungarian: fx
typedef short SFIXED;                  // Hungarian: sfx
typedef BOOL Boolean;
typedef HWND WindowPtr;
typedef LPBYTE Ptr;
typedef void far *AlignmentProcRecordPtr;

#ifndef RC_INVOKED
    #if defined(_MSC_VER) || defined(__BORLANDC__)
	#pragma pack(1)
    #else
	#error check structure packing options for your compiler
	// search below for "#pragma pack" to find all the places
	// to change for your compiler's pragma.
    #endif
#endif

struct Point {
    short                       v;
    short                       h;
};
typedef struct Point Point;

typedef struct _tagRect {
   short        boxTop ;            // default text box
   short        boxLeft ;
   short        boxBottom ;
   short        boxRight ;
} Rect;
#if !defined(RC_INVOKED) && (defined(_MSC_VER) || defined(__BORLANDC__))
    #pragma pack()
#endif

enum  {
    nullEvent                   = 0,
    mouseDown                   = 1,
    mouseUp                     = 2,
    keyDown                     = 3,
    keyUp                       = 4,
    autoKey                     = 5,
    updateEvt                   = 6,
    diskEvt                     = 7,
    activateEvt                 = 8,
    osEvt                       = 15,
/* event mask equates */
    mDownMask                   = 2,
    mUpMask                     = 4,
    keyDownMask                 = 8,
    keyUpMask                   = 16,
    autoKeyMask                 = 32,
    updateMask                  = 64,
    diskMask                    = 128,
    activMask                   = 256,
    highLevelEventMask          = 1024,
    osMask                      = -32768
};

struct EventRecord {
    short                       what;
    long                        message;
    long                        when;
    Point                       where;
    short                       modifiers;
};
typedef struct EventRecord EventRecord;

typedef struct _tagInt64               // Hungarian: qw (quad word)
  {DWORD dwLo;
   LONG  dwHi;
  } Int64;

#if !defined(RC_INVOKED) && (defined(_MSC_VER) || defined(__BORLANDC__))
    #pragma pack(1)
#endif
typedef struct _tagOpenCPicParms       // Hungarian: ocp
  {Rect   rect;
   LFIXED hRes;
   LFIXED vRes;
   WORD   wVersion;
   WORD   wReserved1;
   DWORD  dwReserved2;
  } OpenCPicParams;

typedef struct _tagTimeBaseRecord      // Hungarian: tbr
  {DWORD FAR *p;
  } TimeBaseRecord;

typedef TimeBaseRecord FAR *TimeBase;  // Hungarian: tb

#define TIMEBASE_DEFAULT ((TimeBase) 0L)

typedef struct _tagTimeRecord          // Hungarian: tr
  {Int64     value;
   TimeScale scale;
   TimeBase  base;
  } TimeRecord;

typedef struct MatrixRecord {          // Hungarian: mrec
    Fixed matrix[3][3];
} MatrixRecord;

typedef struct _tagSoundDescription    // Hungarian: sd (SoundDescription)
  {LONG  descSize;                     // structure size
   DWORD dataFormat;                   // 'raw ','twos','ima4'
   DWORD resvd1;                       // always 0
   WORD  resvd2;                       // always 0
   WORD  dataRefIndex;                 // always 1
   WORD  version;                      // always 0
   WORD  revLevel;                     // always 0
   DWORD vendor;                       // always 0
   WORD  numChannels;                  // 1=mono; 2=stereo
   WORD  sampleSize;                   // 8=8bit sound; 16=16bit sound
   WORD  compressionID;                // always 0
   WORD  packetSize;                   // always 0
   LFIXED sampleRate;                  // eg: 44100.0000 per second
  } SoundDescription;

typedef struct _tagMusicDescription    // Hungarian: md (MusicDescription)
  {LONG  descSize;                     // structure size
   DWORD dataFormat;                   // always 'musi'
   DWORD resvd1;                       // always 0
   WORD  resvd2;                       // always 0
   WORD  dataRefIndex;                 // always 1
   DWORD musicFlags;                   // always 0
  } MusicDescription;

typedef struct _tagRGBColor {
    unsigned short  red;             /*magnitude of red component*/
    unsigned short  green;          /*magnitude of green component*/
    unsigned short  blue;           /*magnitude of blue component*/
} RGBColor;

typedef unsigned char Style;

typedef struct _tagScrpSTElement {
    long                        scrpStartChar;                  /*starting character position*/
    short                       scrpHeight;                     /*starting character position*/
    short                       scrpAscent;
    short                       scrpFont;
    Style                       scrpFace;                       /*unpacked byte*/
    char                        filler;                         /*scrpFace is unpacked byte*/
    short                       scrpSize;
    RGBColor                    scrpColor;
} ScrpSTElement;

typedef struct _tagTextDescription {
   long         descSize;
   long         dataFormat;             // = 'text'
   long         resvd1;
   short        resvd2;
   short        dataRefIndex;
   long         displayFlags;
   long         textJustification;
   RGBColor     bgColor ;               // red, green, blue
   Rect         defaultTextBox;
   ScrpSTElement defaultStyle;          // default style
   char         defaultFontName[ 1] ;   // pascal string ... struct is sized to fit the string
} TextDescription;

typedef struct _tagMPEGDescription {
    long descSize;
    long dataFormat;
    long resvd1;
    short resvd2;
    short dataRefIndex;
} MPEGDescription;

typedef struct _tagImageDescription    // Hungarian: id (ImageDescription)
  {LONG  idSize;                       // structure size
   DWORD CodecType;                    // 'rpza', 'jpeg', 'rle ', 'raw ', 'smc', 'cvid'
   DWORD resvd1;                       //
   WORD  resvd2;                       // always 0
   WORD  dataRefIndex;                 // always 1
   WORD  version;                      //
   WORD  revLevel;                     //
   DWORD vendor;                       // 'appl' or other vendor
   DWORD temporalQuality;              //
   DWORD spatialQuality;               //
   WORD  width;                        // Source image width in pixels
   WORD  height;                       // Source image height in pixels
   LFIXED hRes;                        // Horizontal resolution (eg: 72.0)
   LFIXED vRes;                        // Vertical resolution (eg: 72.0)
   DWORD dataSize;                     // Memory required for image data
   WORD  frameCount;                   // always 0
   char  name[32];                     // Compression algorithm (eg: Animation)
   WORD  depth;                        // Pixel depth of source image
   WORD  clutID;                       // Macintosh ROM Color table ID
  } ImageDescription;
#if !defined(RC_INVOKED) && (defined(_MSC_VER) || defined(__BORLANDC__))
    #pragma pack()
#endif

typedef ComponentResult (FAR  CDECL *ComponentRoutine) (VOID);
typedef DWORD (FAR CDECL *ENTRYFUNC) (VOID);
typedef VOID (FAR * APIENTRY FIXUPFUNC) (ENTRYFUNC);
typedef LONG Component;
typedef LONG ComponentInstance;

typedef struct tagComponentDescription { // Hungarian: cd
  OSType  ostypeComponentType;         // component identifier
  OSType  ostypeComponentSubType;      // sub-type
  OSType  ostypeComponentManufacturer; // vendor ID
  DWORD   dwComponentFlags;            // control flags
  DWORD   dwComponentFlagsMask;        // mask for control flags
  ComponentRoutine   crEntryPoint;     // pointer to entry point
  HRSRC   hrsrcName;                   // handle to name string
  HRSRC   hrsrcInfo;                   // handle to info string
  HRSRC   hrsrcIcon;                   // handle to icon
} ComponentDescription, FAR *LPCD;

// $$Begin$$ - Everything to the "end" is only for internal use only!!

// Support Internal ToolBox Invocations
// ------------------------------------
#ifdef INTERNAL_TB
    #ifndef _WIN32
	typedef struct _tagSTKOFF_QTW
	    {WORD  words[5];
	    } STKOFF_QTW;
    #else
	typedef struct _tagSTKOFF_QTW
	    {DWORD  dwords[3];
	    } STKOFF_QTW;
    #endif
  #define TbCall(n) tb##n
  #define TB_FPARM STKOFF_QTW so,
  #define VOIDPARM ...
#else
  #define TbCall(n) n
  #define TB_FPARM
  #define VOIDPARM VOID
#endif


// Support Internal Component Manager Invocations
// ----------------------------------------------
#ifdef INTERNAL_CM
  #ifndef _WIN32
      typedef struct _tagSTKOFF_QTW
	{WORD  words[3];
	} STKOFF_QTW;
  #else
      typedef struct _tagSTKOFF_QTW
	{ DWORD  dwords[2];
	} STKOFF_QTW;
  #endif
  #define CmCall(n) cm##n
  #define CM_FPARM STKOFF_QTW so,
  #define CMVOIDPARM ...
#else
  #define CmCall(n) n
  #define CM_FPARM
  #define CMVOIDPARM VOID
#endif


// Support Internal Movie Controller Invocations
// ---------------------------------------------
#ifdef INTERNAL_MC
    #ifndef _WIN32
	typedef struct _tagSTKOFF_MC
	    {WORD  words[3];
	    } STKOFF_MC;
    #else
	typedef struct _tagSTKOFF_MC
	    {DWORD  dwords[2];
	    } STKOFF_MC;
    #endif
  #define McCall(n) cf##n
  #define MC_FPARM STKOFF_MC so,
#else
  #define McCall(n) n
  #define MC_FPARM
#endif

// $$End$$

// Macros
// ------
#define MAKELFIXED(integ, fract) ((LONG)(((WORD)(fract)) | (((DWORD)((WORD)(integ))) << 16)))

#define MAKESFIXED(integ, fract) ((int)(((BYTE)(fract)) | (((WORD)((BYTE)(integ))) << 8)))

#define QTFOURCC(ch0, ch1, ch2, ch3)                                \
		 ((DWORD)(BYTE)(ch0) | ( (DWORD)(BYTE)(ch1) << 8 ) |  \
		 ((DWORD)(BYTE)(ch2) << 16 ) | ( (DWORD)(BYTE)(ch3) << 24 ))


// ToolBox Callbacks and Handles
// -----------------------------
typedef const struct _tagQTHandle { int unused; } FAR *Handle;
typedef long Size;
typedef LPVOID Movie;
typedef LPVOID Media;
typedef LPVOID Track;
typedef Handle SampleDescriptionHandle;
typedef Handle PaletteHandle;
enum {
    pmAnimated  = 0x0004   /*reserve an index on each device touched and render ciRGB.*/
};

typedef OSErr (CALLBACK *MovieRgnCoverProc) (Movie, HDC, LONG);


// Movie Controller Callbacks and Handles
// --------------------------------------
// $$$Begin$$
#ifdef INTERNAL_MC
typedef BOOL (CALLBACK *MCActionFilter) (LPVOID, UINT, LPVOID, LONG);
#include "qtwmc.h"
#else
// $$End$$
typedef ComponentInstance MovieController;
typedef BOOL (CALLBACK *MCActionFilter) (MovieController, UINT, LPVOID, LONG);
// $$Begin$$
#endif
// $$End$$

// Support C++ Function Invocations
// --------------------------------
#ifdef __cplusplus
  extern "C" {
#endif


// Function calling convention
// ---------------------------

#define QTAPI _System


// Macintosh toolbox equivalents
// -----------------------------

Handle  QTAPI   TbCall (NewHandle)          (TB_FPARM Size byteCount);
LPVOID  QTAPI   TbCall (DereferenceHandle)  (TB_FPARM Handle theHandle);
void    QTAPI   TbCall (HLock)              (TB_FPARM Handle theHandle);
void    QTAPI   TbCall (HUnlock)            (TB_FPARM Handle theHandle);
Size    QTAPI   TbCall (GetHandleSize)      (TB_FPARM Handle theHandle);
OSErr   QTAPI   TbCall (MemError)           (TB_FPARM VOIDPARM);
void    QTAPI   TbCall (SetHandleSize)      (TB_FPARM Handle theHandle, Size newSize);
void    QTAPI   TbCall (DisposeHandle)      (TB_FPARM Handle theHandle);
signed char QTAPI TbCall (HGetState)        (TB_FPARM Handle theHandle);
void    QTAPI   TbCall (HSetState)          (TB_FPARM Handle theHandle,signed char newState);

// $$Begin$$
#ifdef INTERNAL_TB
    #define NewHandle(a)            tbNewHandle(so,a)
    #define DereferenceHandle(h)    tbDereferenceHandle(so,h)
    #define HLock(h)                tbHLock(so,h)
    #define HUnlock(h)              tbHUnlock(so,h)
    #define GetHandleSize(h)        tbGetHandleSize(so,h)
    #define MemError()              tbMemError(so)
    #define SetHandleSize(h,s)      tbSetHandleSize(so,h,s)
    #define DisposeHandle(h)        tbDisposeHandle(so,h)
    #define HGetState(h)            tbHGetState(so,h)
    #define HSetState(h,n)          tbHSetState(so,h,n)
#endif    
// $$End$$

// Quicktime Functions
// -------------------



OSErr           QTAPI QTInitialize (LPLONG);
VOID            QTAPI QTTerminate (VOID);
VOID            QTAPI TbCall (AddTime) (TB_FPARM TimeRecord FAR *, const TimeRecord FAR *);
VOID            QTAPI TbCall (AlignWindow) (TB_FPARM WindowPtr wp, Boolean front, LPRECT aligmentRect,AlignmentProcRecordPtr alignmentProc);
VOID            QTAPI TbCall (ClearMoviesStickyError) (TB_FPARM VOIDPARM);
OSErr           QTAPI TbCall (CloseMovieFile) (TB_FPARM MovieFile);
OSErr           QTAPI TbCall (ClosePictureFile) (TB_FPARM PicFile);
VOID            QTAPI TbCall (ConcatMatrix)(TB_FPARM const MatrixRecord FAR *srcMatrix,MatrixRecord FAR *destMatrix);
VOID            QTAPI TbCall (ConvertTimeScale) (TB_FPARM TimeRecord FAR *, TimeScale);
LONG            QTAPI TbCall (CountUserDataType) (TB_FPARM UserData, OSType);
OSErr           QTAPI TbCall (DeleteMovieFile) (TB_FPARM LPCSTR);
VOID            QTAPI TbCall (DisposeMovie) (TB_FPARM Movie);
VOID            QTAPI TbCall (DisposeMovieController) (TB_FPARM MovieController);
VOID            QTAPI TbCall (DisposePicture) (TB_FPARM PicHandle);
OSErr           QTAPI TbCall (DrawPicture) (TB_FPARM HDC, PicHandle, const LPRECT, ProgressProcRecordPtr);
OSErr           QTAPI TbCall (DrawPictureFile) (TB_FPARM HDC, PicFile, const LPRECT, ProgressProcRecordPtr);
OSErr           QTAPI TbCall (EnterMovies) (TB_FPARM VOIDPARM);
VOID            QTAPI TbCall (ExitMovies) (TB_FPARM VOIDPARM);
VOID            QTAPI TbCall (GetMediaHandlerDescription)(TB_FPARM Media,OSType FAR *,LPSTR,OSType FAR *);
short           QTAPI TbCall (GetMediaLanguage) (TB_FPARM Media);
OSErr           QTAPI TbCall (GetMediaSample) (TB_FPARM Media, Handle, long, long FAR *,
				TimeValue, TimeValue FAR *, TimeValue FAR *,
				SampleDescriptionHandle,
				long FAR *, long, long FAR *,
				short FAR *);
OSErr           QTAPI TbCall (GetMediaSampleReference) (TB_FPARM Media, long FAR *, long FAR *,
				TimeValue, TimeValue FAR *, TimeValue FAR *,
				SampleDescriptionHandle,
				long FAR *, long, long FAR *,
				short FAR *);
VOID            QTAPI TbCall (GetMediaSampleDescription)(TB_FPARM Media,LONG,SampleDescriptionHandle);
TimeScale       QTAPI TbCall (GetMediaTimeScale) (TB_FPARM Media);
Track           QTAPI TbCall (GetMediaTrack) (TB_FPARM Media);
Boolean         QTAPI TbCall (GetMovieActive) (TB_FPARM Movie);
VOID            QTAPI TbCall (GetMovieActiveSegment) (TB_FPARM Movie, TimeValue FAR *, TimeValue FAR *);
VOID            QTAPI TbCall (GetMovieBox) (TB_FPARM Movie, LPRECT);
LONG            QTAPI TbCall (GetMovieCreationTime) (TB_FPARM Movie);
LONG            QTAPI TbCall (GetMovieDataSize) (TB_FPARM Movie, TimeValue, TimeValue);
TimeValue       QTAPI TbCall (GetMovieDuration) (TB_FPARM Movie);
Track           QTAPI TbCall (GetMovieIndTrack) (TB_FPARM Movie, LONG);
Track           QTAPI TbCall (GetMovieIndTrackType) (TB_FPARM Movie, LONG, OSType, LONG);
VOID            QTAPI TbCall (GetMovieMatrix)(TB_FPARM Movie theMovie,MatrixRecord FAR *theMatrix);
LONG            QTAPI TbCall (GetMovieModificationTime) (TB_FPARM Movie);
PicHandle       QTAPI TbCall (GetMoviePict) (TB_FPARM Movie, TimeValue);
PicHandle       QTAPI TbCall (GetMoviePosterPict) (TB_FPARM Movie);
TimeValue       QTAPI TbCall (GetMoviePosterTime) (TB_FPARM Movie);
LFIXED          QTAPI TbCall (GetMoviePreferredRate) (TB_FPARM Movie);
SFIXED          QTAPI TbCall (GetMoviePreferredVolume) (TB_FPARM Movie);
VOID            QTAPI TbCall (GetMovieSelection) (TB_FPARM Movie, TimeValue FAR *, TimeValue FAR *);
OSErr           QTAPI TbCall (GetMoviesError) (TB_FPARM VOIDPARM);
OSErr           QTAPI TbCall (GetMoviesStickyError) (TB_FPARM VOIDPARM);
ComponentResult QTAPI TbCall (GetMovieStatus) (TB_FPARM Movie, LPVOID);
TimeValue       QTAPI TbCall (GetMovieTime) (TB_FPARM Movie, TimeRecord FAR *);
TimeScale       QTAPI TbCall (GetMovieTimeScale) (TB_FPARM Movie);
LONG            QTAPI TbCall (GetMovieTrackCount) (TB_FPARM Movie);
UserData        QTAPI TbCall (GetMovieUserData) (TB_FPARM Movie);
OSType          QTAPI TbCall (GetNextUserDataType) (TB_FPARM UserData, OSType);
OSErr           QTAPI TbCall (GetPictureFileHeader) (TB_FPARM PicFile, LPRECT, OpenCPicParams FAR *);
OSErr           QTAPI TbCall (GetPictureFileInfo) (TB_FPARM PicFile, ImageDescription FAR *);
PicHandle       QTAPI TbCall (GetPictureFromFile) (TB_FPARM PicFile);
OSErr           QTAPI TbCall (GetPictureInfo) (TB_FPARM PicHandle, ImageDescription FAR *);
HPALETTE        QTAPI TbCall (GetPicturePalette) (TB_FPARM PicHandle);
OSErr           QTAPI TbCall (GetSoundInfo) (TB_FPARM Movie, SoundDescription FAR *);
VOID            QTAPI TbCall (GetTrackDimensions)(TB_FPARM Track theTrack,Fixed FAR *width,Fixed FAR *height);
Boolean         QTAPI TbCall (GetTrackEnabled) (TB_FPARM Track th);
Media           QTAPI TbCall (GetTrackMedia) (TB_FPARM Track);
VOID            QTAPI TbCall (GetTrackMatrix)(TB_FPARM Track theTrack,MatrixRecord FAR *theMatrix);
Movie           QTAPI TbCall (GetTrackMovie) (TB_FPARM Track);
PaletteHandle   QTAPI TbCall (GetTrackPalette)(TB_FPARM Track);
PicHandle       QTAPI TbCall (GetTrackPict) (TB_FPARM Track, TimeValue);
OSErr           QTAPI TbCall (GetUserData) (TB_FPARM UserData, LPHANDLE, OSType, LONG, LPLONG);
OSErr           QTAPI TbCall (GetUserDataText) (TB_FPARM UserData, LPHANDLE, OSType, LONG, UINT, LPLONG);
OSErr           QTAPI TbCall (GetVideoInfo) (TB_FPARM Movie, ImageDescription FAR *);
VOID            QTAPI TbCall (KillPicture) (TB_FPARM PicHandle);
OSErr           QTAPI TbCall (MovieSearchText) (TB_FPARM Movie, Ptr, long, long, Track FAR *, TimeValue FAR *, long FAR *);
MovieController QTAPI TbCall (NewMovieController) (TB_FPARM Movie, const LPRECT, LONG, HWND);
#ifndef _WIN32
 OSErr           QTAPI TbCall (NewMovieFromDataFork) (TB_FPARM Movie FAR *, HFILE, LONG, UINT);
#else
 OSErr           QTAPI TbCall (NewMovieFromDataFork) (TB_FPARM Movie FAR *, HANDLE, LONG, UINT);
#endif
OSErr           QTAPI TbCall (NewMovieFromFile) (TB_FPARM Movie FAR *, MovieFile, LPINT, LPSTR, UINT, Boolean FAR *);
VOID            QTAPI TbCall (NormalizeRect) (TB_FPARM LPRECT);
OSErr           QTAPI TbCall (OpenMovieFile) (TB_FPARM LPCSTR, MovieFile FAR *, UINT);
OSErr           QTAPI TbCall (OpenPictureFile) (TB_FPARM LPCSTR, PicFile FAR *, UINT);
DIBHandle       QTAPI TbCall (PictureToDIB) (TB_FPARM PicHandle);
OSErr           QTAPI TbCall (PrerollMovie) (TB_FPARM Movie, TimeValue, LFIXED);
Boolean         QTAPI TbCall (PtInMovie) (TB_FPARM Movie, POINT);
Boolean         QTAPI TbCall (PtInTrack)(TB_FPARM Track theTrack,POINT thePoint);
OSErr           QTAPI TbCall (PutMovieIntoTypedHandle)(TB_FPARM Movie, Track,
				OSType, Handle,TimeValue,TimeValue,LONG,ComponentInstance);
VOID            QTAPI TbCall (SetEntryUsage)(TB_FPARM PaletteHandle dstPalette,short srcEntry, short srcUsage,short srcTolerance);                                
VOID            QTAPI TbCall (SetMovieActive) (TB_FPARM Movie, Boolean);
VOID            QTAPI TbCall (SetMovieBox) (TB_FPARM Movie, const LPRECT);
VOID            QTAPI TbCall (SetMovieCoverProcs) (TB_FPARM Movie, MovieRgnCoverProc, MovieRgnCoverProc, LONG);
VOID            QTAPI TbCall (SetMoviePlayHints) (TB_FPARM Movie, LONG, LONG);
OSErr           QTAPI TbCall (SetTrackEnabled) (TB_FPARM Track th, Boolean);
VOID            QTAPI TbCall (SetTrackFollowCLUT) (TB_FPARM Track th, Boolean);
VOID            QTAPI TbCall (SubtractTime) (TB_FPARM TimeRecord FAR *, const TimeRecord FAR *);
TimeValue       QTAPI TbCall (TrackTimeToMediaTime) (TB_FPARM TimeValue, Track);
VOID            QTAPI TbCall (TransformRect)(TB_FPARM const MatrixRecord FAR *theMatrix,LPRECT theRect,LPVOID);
OSErr           QTAPI TbCall (UpdateMovie) (TB_FPARM Movie);
// $$$Begin$$
VOID            QTAPI TbCall (QTInitializeToolBox) (TB_FPARM VOIDPARM);
VOID            QTAPI TbCall (QTTerminateToolBox) (TB_FPARM VOIDPARM);
// $$End$$
ComponentResult QTAPI McCall (MCActivate) (MC_FPARM MovieController, HWND, Boolean);
ComponentResult QTAPI McCall (MCClick) (MC_FPARM MovieController, HWND, Point, long, long);
ComponentResult QTAPI McCall (MCDoAction) (MC_FPARM MovieController, UINT, LPVOID);
ComponentResult QTAPI McCall (MCDraw) (MC_FPARM MovieController, HWND);
ComponentResult QTAPI McCall (MCDrawBadge) (MC_FPARM MovieController, HRGN, HRGN FAR *);
ComponentResult QTAPI McCall (MCGetControllerBoundsRect) (MC_FPARM MovieController, LPRECT);
ComponentResult QTAPI McCall (MCGetControllerInfo) (MC_FPARM MovieController, LPLONG);
TimeValue       QTAPI McCall (MCGetCurrentTime) (MC_FPARM MovieController, TimeScale FAR *);
Movie           QTAPI McCall (MCGetMovie) (MC_FPARM MovieController);
ComponentResult QTAPI McCall (MCGetVisible) (MC_FPARM MovieController);
ComponentResult QTAPI McCall (MCIdle) (MC_FPARM MovieController);
ComponentResult QTAPI McCall (MCIsControllerAttached) (MC_FPARM MovieController);
ComponentResult QTAPI McCall (MCIsPlayerMessage) (MC_FPARM MovieController, HWND, UINT, WPARAM, LPARAM);
ComponentResult QTAPI McCall (MCKey) (MC_FPARM MovieController, WPARAM, LPARAM);
ComponentResult QTAPI McCall (MCMovieChanged) (MC_FPARM MovieController, Movie);
OSErr           QTAPI McCall (MCNewMovieController) (MC_FPARM MovieController, ComponentInstance, Movie, const LPRECT, LONG, HWND);
ComponentResult QTAPI McCall (MCNewAttachedController) (MC_FPARM MovieController, Movie, HWND, POINT);
ComponentResult QTAPI McCall (MCPositionController) (MC_FPARM MovieController, LPRECT, LPRECT, LONG);
ComponentResult QTAPI McCall (MCRemoveMovie) (MC_FPARM MovieController);
ComponentResult QTAPI McCall (MCSetActionFilter) (MC_FPARM MovieController, MCActionFilter, LONG);
ComponentResult QTAPI McCall (MCSetControllerAttached) (MC_FPARM MovieController, Boolean);
ComponentResult QTAPI McCall (MCSetControllerBoundsRect) (MC_FPARM MovieController, const LPRECT);
ComponentResult QTAPI McCall (MCSetMovie) (MC_FPARM MovieController, Movie, HWND, POINT);
ComponentResult QTAPI McCall (MCSetVisible) (MC_FPARM MovieController, Boolean);
Component       QTAPI CmCall (CaptureComponent) (CM_FPARM Component cCaptured, Component cCapturing);
OSErr           QTAPI CmCall (CloseComponent) (CM_FPARM ComponentInstance ci);
OSErr           QTAPI CmCall (CloseComponentResFile) (CM_FPARM short sFileNum);
LONG            QTAPI CmCall (ComponentFunctionImplemented) (CM_FPARM ComponentInstance ci, short sFunctionNumber);
LONG            QTAPI CmCall (CountComponentInstances) (CM_FPARM Component c);
LONG            QTAPI CmCall (CountComponents) (CM_FPARM ComponentDescription FAR *lpcdLooking);
Component       QTAPI CmCall (FindNextComponent) (CM_FPARM Component c, ComponentDescription FAR *lpcdLooking);
HINSTANCE       QTAPI CmCall (GetComponentResFileInstance) (CM_FPARM short sFileNum);
OSErr           QTAPI CmCall (GetComponentInfo) (CM_FPARM Component c, ComponentDescription FAR *lpcd);
OSErr           QTAPI CmCall (GetComponentInstanceError) (CM_FPARM ComponentInstance ci);
LPVOID          QTAPI CmCall (GetComponentInstanceStorage) (CM_FPARM ComponentInstance ci);
LONG            QTAPI CmCall (GetComponentListModSeed) (CM_FPARM CMVOIDPARM);
LONG            QTAPI CmCall (GetComponentRefcon) (CM_FPARM Component c);
LONG            QTAPI CmCall (GetComponentVersion) (CM_FPARM ComponentInstance ci);
ComponentInstance QTAPI CmCall (OpenComponent) (CM_FPARM Component c);
short           QTAPI CmCall (OpenComponentResFile) (CM_FPARM Component c);
ComponentInstance QTAPI CmCall (OpenDefaultComponent) (CM_FPARM OSType ostypeComponentType, OSType ostypeComponentSubType);
Component       QTAPI CmCall (RegisterComponent) (CM_FPARM LPCD lpcd, WORD wGlobal, FIXUPFUNC lpfnTBFixup, FIXUPFUNC lpfnCMFixup);
OSErr           QTAPI CmCall (RegisterComponentResourceFile) (CM_FPARM LPCSTR lpszDLL, WORD wGlobal);
VOID            QTAPI CmCall (SetComponentInstanceError) (CM_FPARM ComponentInstance ci, OSErr oserr);
VOID            QTAPI CmCall (SetComponentInstanceStorage) (CM_FPARM ComponentInstance ci, LPVOID lpvStorage);
VOID            QTAPI CmCall (SetComponentRefcon) (CM_FPARM Component c, LONG lRefcon);
OSErr           QTAPI CmCall (SetDefaultComponent) (CM_FPARM Component c, short sFlags);
OSErr           QTAPI CmCall (UncaptureComponent) (CM_FPARM Component c);
OSErr           QTAPI CmCall (UnregisterComponent) (CM_FPARM Component c);
OSErr           QTAPI CmCall (UnregisterComponentResourceFile) (CM_FPARM LPCSTR lpszDLL);

// End of Functions
// ----------------
#ifdef __cplusplus
  }
#endif


// End of QTW.H
// ------------
// $$Begin$$
#undef TbCall
#undef McCall
#undef CmCall
#undef TB_FPARM
#undef MC_FPARM
#undef CM_FPARM
// $$End$$
#endif // __QTW_H__
