#ifndef QT_OS2
#define QT_OS2

#define INCL_DOSMODULEMGR
#define INCL_DOSERRORS
#define INCL_WIN
#define INCL_GPI
#include <os2.h>
#include <mmio.h>

/*******

    Mother of all #defines.

*******/ 
#define OF_READ             0x00000000
#define __far
#define far
#define FAR
#define FIELDOFFSET2(type, field)    ((LONG)&(((type *)0)->field))
#define HIWORD(l)           ((WORD)(((DWORD)(l) >> 16) & 0xFFFF))
#define LOWORD(l)           ((WORD)(l))
#define MAKEWORD(a, b)      ((WORD)(((BYTE)(a)) | ((WORD)((BYTE)(b))) << 8))
#define DECLARE_HANDLE(name) struct name##__ { int unused; }; typedef struct name##__ *name
#define _cdecl
#define __cdecl
#define CDECL _cdecl
#define PASCAL _Pascal
#define WINAPI PASCAL
#define CALLBACK 
#define LRESULT long
#define _MSC_VER
#define WPARAM unsigned long
#define LPARAM unsigned long
#define TBDLL_OS2 "QTIM"
#define CMDLL_OS2 "CMGR"
#define TEXT(txt) txt
#define _huge
#define MAX_MODULE_NAME  8 + 1
#define HLOCAL HANDLE
#define LPBITMAPINFOHEADER PBITMAPINFOHEADER
#define LPBITMAPINFO PBITMAPINFO
#define EXPORT
#define PSTR char *
#define VOID void
#define FARPROC void *
#define CellShapeDescriptor void *
#define NaturalUnsigned unsigned int
#define UtilitySt int
#define jt_filt_type int
#define temp_filt_type int
#define SegmentSt int
#define MainSt int
#define SyntaxSt int
#define MotionSt int
#define BrcSt int
#define TkMatrixSt int
#define LARGEDECINSTINFO void
#define SIZE SIZEL
//#define SIZE int              ***RAR***
#define LPPOINT void *
#define LPSIZE SIZEL *
//#define LPSIZE void  *        ***RAR***
#define HUGE
#define HDWP int

// OLE Crabs !
#define OLESTATUS int
#define LPOLECLIENT void *                     
#define LHCLIENTDOC void *
#define LPLPOLEOBJECT void *
#define OLEOPT_RENDER int
#define OLECLIPFORMAT int
#define CALLBACK_DS
#define LPOLESTREAM  void *
#define LPOLERECT void *
#define LPOLEOBJECT void *
#define OLE_LPCSTR void *
#define QTX_NEAR
#define OLEOBJECTVTBL int


/* Local Memory Flags */
#define LMEM_FIXED          0x0000
#define LMEM_MOVEABLE       0x0002
#define LMEM_NOCOMPACT      0x0010
#define LMEM_NODISCARD      0x0020
#define LMEM_ZEROINIT       0x0040
#define LMEM_MODIFY         0x0080
#define LMEM_DISCARDABLE    0x0F00
#define LMEM_VALID_FLAGS    0x0F72
#define LMEM_INVALID_HANDLE 0x8000
#define LHND                (LMEM_MOVEABLE | LMEM_ZEROINIT)
#define LPTR                (LMEM_FIXED | LMEM_ZEROINIT)

#define WA_INACTIVE     0
#define WA_ACTIVE       1

/*******

     Mother of all typedef

*******/
typedef BYTE *LPBYTE;
typedef long *LPLONG;

#define LPVOID PVOID

typedef struct tagRECT
{
  LONG left;
  LONG top;
  LONG right;
  LONG bottom;
} RECT;

typedef struct tagRECT *LPRECT;

#define LPCSTR LPSTR
#define LPTSTR LPSTR

typedef PVOID HANDLE;
typedef HANDLE *LPHANDLE;

typedef int *LPINT;

typedef void *HINSTANCE;

typedef struct  tagPOINT
{
  LONG x;
  LONG y;
} POINT;

typedef struct tagPOINT *PPOINT;

typedef struct tagPALETTEENTRY {
    BYTE        peRed;
    BYTE        peGreen;
    BYTE        peBlue;
    BYTE        peFlags;
} PALETTEENTRY, *PPALETTEENTRY, FAR *LPPALETTEENTRY;

typedef struct tagLOGPALETTE 
{
  WORD        palVersion;
  WORD        palNumEntries;
  PALETTEENTRY        palPalEntry[1];
} LOGPALETTE, *PLOGPALETTE, *LPLOGPALETTE;


typedef unsigned long * LPDWORD;

typedef struct tagRGBQUAD {
        BYTE    rgbBlue;
        BYTE    rgbGreen;
        BYTE    rgbRed;
        BYTE    rgbReserved;
} RGBQUAD;
typedef RGBQUAD * LPRGBQUAD;
typedef WORD * LPWORD, * PWORD;

typedef HANDLE HGLOBAL;

typedef struct _LIST_ENTRY {
   struct _LIST_ENTRY *Flink;
   struct _LIST_ENTRY *Blink;
} LIST_ENTRY;
typedef LIST_ENTRY *PLIST_ENTRY;

typedef struct _RTL_CRITICAL_SECTION_DEBUG {
    WORD   Type;
    WORD   CreatorBackTraceIndex;
    struct _RTL_CRITICAL_SECTION *CriticalSection;
    LIST_ENTRY ProcessLocksList;
    DWORD EntryCount;
    DWORD ContentionCount;
    DWORD Depth;
    PVOID OwnerBackTrace[ 5 ];
} RTL_CRITICAL_SECTION_DEBUG, *PRTL_CRITICAL_SECTION_DEBUG;

#define RTL_CRITSECT_TYPE 0
#define RTL_RESOURCE_TYPE 1

typedef struct _RTL_CRITICAL_SECTION {
    PRTL_CRITICAL_SECTION_DEBUG DebugInfo;

    //
    //  The following three fields control entering and exiting the critical
    //  section for the resource
    //

    LONG LockCount;
    LONG RecursionCount;
    HANDLE OwningThread;        // from the thread's ClientId->UniqueThread
    HANDLE LockSemaphore;
    DWORD Reserved;
} RTL_CRITICAL_SECTION, *PRTL_CRITICAL_SECTION;
#define DLL_PROCESS_ATTACH 1    
#define DLL_THREAD_ATTACH  2    
#define DLL_THREAD_DETACH  3    
#define DLL_PROCESS_DETACH 0    

typedef RTL_CRITICAL_SECTION CRITICAL_SECTION;

/* timer data types */
typedef VOID (CALLBACK TIMECALLBACK)(UINT uTimerID, UINT uMsg, DWORD dwUser, DWORD dw1, DWORD dw2);
typedef TIMECALLBACK     *LPTIMECALLBACK;

typedef DWORD COLORREF;

typedef struct wavehdr_tag {
    LPBYTE      lpData;               // pointer to locked data buffer
    DWORD       dwBufferLength;       // length of data buffer
    DWORD       dwBytesRecorded;      // used for input only
    DWORD       dwUser;               // for client's use
    DWORD       dwFlags;              // assorted flags (see defines)
    DWORD       dwLoops;              // loop control counter
    struct wavehdr_tag     *lpNext;   // reserved for driver
    DWORD                 reserved;   // reserved for driver
} WAVEHDR;

typedef struct waveformat_tag {
    WORD    wFormatTag;        /* format type */
    WORD    nChannels;         /* number of channels (i.e. mono, stereo...) */
    DWORD   nSamplesPerSec;    /* sample rate */
    DWORD   nAvgBytesPerSec;   /* for buffer estimation */
    WORD    nBlockAlign;       /* block size of data */
} WAVEFORMAT;
typedef WAVEFORMAT       *PWAVEFORMAT;
typedef WAVEFORMAT NEAR *NPWAVEFORMAT;
typedef WAVEFORMAT FAR  *LPWAVEFORMAT;

/* flags for wFormatTag field of WAVEFORMAT */
#define WAVE_FORMAT_PCM     1

/* specific waveform format structure for PCM data */
typedef struct pcmwaveformat_tag {
    WAVEFORMAT  wf;
    WORD        wBitsPerSample;
} PCMWAVEFORMAT;
typedef PCMWAVEFORMAT       *PPCMWAVEFORMAT;
typedef PCMWAVEFORMAT NEAR *NPPCMWAVEFORMAT;
typedef PCMWAVEFORMAT FAR  *LPPCMWAVEFORMAT;

typedef struct _WINRECTL       /* rcl */
{
    LONG    left;
    LONG    top;
    LONG    right;
    LONG    bottom;
} WINRECTL, *PWINRECTL, *LPWINRECTL;

typedef struct tagRGBTRIPLE {
        BYTE    rgbtBlue;
        BYTE    rgbtGreen;
        BYTE    rgbtRed;
} RGBTRIPLE, * LPRGBTRIPLE;

#define RGB(r,g,b)          ((COLORREF)(((BYTE)(r)|((WORD)((BYTE)(g))<<8))|(((DWORD)(BYTE)(b))<<16)))

/*******

     Mother of all notes.

 
 Removed comma from this line in qtw.h to continue compilation.

 pmAnimated  = 0x0004 

*******/


/*******

     Mother of all declare.

*******/
typedef struct _HTASK
{
  LHANDLE hProcessID;
  LHANDLE hThreadID;
} HTASK;

#define SAMETASK(t1,t2)   ((t1.hProcessID == t2.hProcessID) && (t1.hThreadID == t2.hThreadID))
#define NULL_TASK(t)      (!t.hProcessID && !t.hThreadID)
#define MAKE_NULL_TASK(t) {t.hProcessID = 0; t.hThreadID = 0;}

DECLARE_HANDLE(HBRUSH);
DECLARE_HANDLE(HRSRC);
DECLARE_HANDLE(HPALETTE);
DECLARE_HANDLE(HHOOK);
DECLARE_HANDLE(HMIDIOUT);
DECLARE_HANDLE(HWAVEOUT);
DECLARE_HANDLE(QT_UserData);
DECLARE_HANDLE(HICON);
DECLARE_HANDLE(HCURSOR);

/*******

     Missing function prototypes.

*******/
BOOL GetCurrentTask(HTASK *pTask);

typedef LRESULT (CALLBACK* WNDPROC)(HWND, UINT, WPARAM, LPARAM);

typedef struct tagWNDCLASS {
    UINT        cbSize;
    /* Win 3.x */
    UINT        style;
    WNDPROC     lpfnWndProc;
    int         cbClsExtra;
    int         cbWndExtra;
    HINSTANCE   hInstance;
    HICON       hIcon;
    HCURSOR     hCursor;
    HBRUSH      hbrBackground;
    LPCSTR      lpszMenuName;
    LPCSTR      lpszClassName;
    /* Win 4.0 */
    HICON       hIconSm;
} WNDCLASS;

#endif
