groff -man detex.1l



DETEX(1L)                                               DETEX(1L)


NNAAMMEE
       detex - a filter to strip _T_e_X commands from a .tex file.

SSYYNNOOPPSSIISS
       ddeetteexx [ --ccllnnssttww ] [ --ee _e_n_v_i_r_o_n_m_e_n_t_-_l_i_s_t ] [ _f_i_l_e_n_a_m_e[.tex]
       ... ]

DDEESSCCRRIIPPTTIIOONN
       _D_e_t_e_x (Version 2.4) reads each file in  sequence,  removes
       all  comments  and  _T_e_X  control  sequences and writes the
       remainder on the standard output.  All text in  math  mode
       and  display  mode  is removed.  By default, _d_e_t_e_x follows
       \input commands.  If a file cannot be  opened,  a  warning
       message  is printed and the command is ignored.  If the --nn
       option is used, no \input or  \include  commands  will  be
       processed.   This  allows  single  file processing.  If no
       input file is given on the command line, _d_e_t_e_x reads  from
       standard input.

       If  the magic sequence ``\begin{document}'' appears in the
       text, _d_e_t_e_x assumes it is dealing with  _L_a_T_e_X  source  and
       _d_e_t_e_x  recognizes  additional  constructs  used  in _L_a_T_e_X.
       These include the \include and \includeonly commands.  The
       --ll  option  can  be  used  to  force _L_a_T_e_X mode and the --tt
       option can be used to force _T_e_X mode regardless  of  input
       content.

       Text  in  various  environment  modes of _L_a_T_e_X is ignored.
       The default modes are array, eqnarray,  equation,  figure,
       mathmatica,  picture,  table  and verbatim.  The --ee option
       can be used to specify a comma separated  _e_n_v_i_r_o_n_m_e_n_t_-_l_i_s_t
       of environments to ignore.  The list replaces the defaults
       so specifying an empty list effectively causes no environ-
       ments to be ignored.

       The --cc option can be used in _L_a_T_e_X mode to have detex echo
       the arguments to \cite, \ref, and \pageref  macros.   This
       can  be useful when sending the output to a style checker.

       _D_e_t_e_x assumes the standard  character  classes  are  being
       used  for  _T_e_X.   _D_e_t_e_x allows white space between control
       sequences and magic characters like `{'  when  recognizing
       things like _L_a_T_e_X environments.

       If  the  --ww  flag is given, the output is a word list, one
       `word' (string of two  or  more  letters  and  apostrophes
       beginning  with  a letter) per line, and all other charac-
       ters ignored.  Without --ww the output follows the original,
       with  the  deletions  mentioned above.  Newline characters
       are preserved where possible so that the lines  of  output
       match the input as closely as possible.

       The  TEXINPUTS environment variable is used to find \input
       and \include files.



Purdue University       21 September 1992                       1





DETEX(1L)                                               DETEX(1L)


       Detex now handles the basic TeX  ligatures  as  a  special
       case,  replacing  the  ligatures  with acceptable charater
       substitutes.  This eliminates spelling  errors  introduced
       by merely removing them.  The ligatures are \aa, \ae, \oe,
       \ss, \o, \l (and their upper-case equivalents).  The  spe-
       cial "dotless" characters \i and \j are also replaced with
       i and j respectively.

       Note that previous versions of _d_e_t_e_x would replace control
       sequences  with  a  space  character to prevent words from
       running together.  However, this  caused  accents  in  the
       middle  of  words  to  break  words,  generating "spelling
       errors" that were not desirable.  Therefore, the new  ver-
       sion  merely removes these accents.  The old functionality
       can be essentially duplicated by using the --ss option.

SSEEEE AALLSSOO
       tex(1L)

DDIIAAGGNNOOSSTTIICCSS
       Nesting of \input is allowed  but  the  number  of  opened
       files  must not exceed the system's limit on the number of
       simultaneously opened files.  _D_e_t_e_x  ignores  unrecognized
       option characters after printing a warning message.

AAUUTTHHOORR
       Daniel  Trinkle,  Computer Science Department, Purdue Uni-
       versity

BBUUGGSS
       _D_e_t_e_x is not a complete _T_e_X interpreter, so it can be con-
       fused  by some constructs.  Most errors result in too much
       rather than too little output.

       Running  _L_a_T_e_X  source  without   a   ``\begin{document}''
       through _d_e_t_e_x may produce errors.

       Suggestions for improvements are encouraged.



















Purdue University       21 September 1992                       2


