/*****************************************************************************
 * $Id: rmt_disk.c,v 1.6 1994/10/17 01:05:34 ak Exp $
 *****************************************************************************
 * $Log: rmt_disk.c,v $
 * Revision 1.6  1994/10/17  01:05:34  ak
 * DosClose was missing.
 * Restrictive disk sharing modes.
 * Return code checks of locking were missing.
 *
 * Revision 1.5  1994/10/04 21:40:53  ak
 * Added the remaining functions to disk support.
 *
 * Revision 1.4  1994/02/16 15:29:17  edvkai
 * Dummy checkin for CVS 1.3 crlf.
 *
 * Revision 1.3  1993/11/25 18:53:54  edvkai
 * Removed DLL import by number.
 * Changed return codes to avoid ambiguities.
 * Changed lseek into seek, parameter changes.
 *
 * Revision 1.2  1993/05/26  17:06:44  AK
 * 32-bit TCP/IP
 *
 * Revision 1.1.1.1  1993/02/08  21:31:56  AK
 * TAR device interface DLLs.
 *
 * Revision 1.1  1993/02/08  21:31:54  AK
 * Initial revision
 *
 *****************************************************************************/

static char *rcsid = "$Id: rmt_disk.c,v 1.6 1994/10/17 01:05:34 ak Exp $";

/*
 *	disk.c
 *
 * Floppy disk interface for GNU tar.
 *
 * Thanks to Kai Use Rommel for the disk locking code.
 */

#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <io.h>
#define INCL_BASE
#define INCL_DOSDEVIOCTL
#ifndef __IBMC__
# define _Packed
#endif
#include <os2.h>

#ifndef __IBMC__
# define _System
#endif

static int	wrflag;
static unsigned	last_error;

#define ERROR_RETURN(rc) if (rc) { last_error = rc; return -2; }

int _System
rmt_open(char *name, int mode, int prot)
{
	ULONG	rc, handle, action;

	wrflag = (mode & 3) != O_RDONLY;
	rc = DosOpen((PSZ)name, &handle, &action, 0L, 0, FILE_OPEN,
		((mode & 3) ? OPEN_SHARE_DENYREADWRITE : OPEN_SHARE_DENYWRITE)
		+ OPEN_FLAGS_FAIL_ON_ERROR
		+ OPEN_FLAGS_DASD
		+ (mode & 3), 0);
	ERROR_RETURN(rc)
	if (wrflag) {
	        BYTE cmd = 0;
		ULONG ulParmLengthInOut = sizeof(cmd), 
		      ulDataLengthInOut = 0;
		rc = DosDevIOCtl(handle, IOCTL_DISK, DSK_LOCKDRIVE, 
			    &cmd, sizeof(cmd), &ulParmLengthInOut,
			    0, 0, &ulDataLengthInOut);
		ERROR_RETURN(rc)
	}
	return handle;
}

int _System
rmt_read(int fd, void *p, unsigned len)
{
	ULONG actual, rc;
	rc = DosRead(fd, p, len, &actual);
	ERROR_RETURN(rc)
	return actual;
}

int _System
rmt_write(int fd, void *p, unsigned len)
{
	ULONG actual, rc;
	rc = DosWrite(fd, p, len, &actual);
	ERROR_RETURN(rc)
	return actual ? actual : -3;
}

long _System
rmt_seek(int fd, long block, long blocksz, int mode)
{
	ULONG actual, rc;

	switch (mode) {
	case 4:
		mode = 1;
		block = 0;
		break;
	case 5:
		block = 0;
	case 3:
		mode = 0;
	case 2:
	case 1:
	case 0:
		break;
	default:
		return -4;
	}
	rc = DosSetFilePtr(fd, block * blocksz, mode, &actual);
	ERROR_RETURN(rc)
	return actual;
}

int _System
rmt_close(int fd)
{
	ULONG rc;

	if (wrflag) {
		BYTE cmd = 0;
		ULONG ulParmLengthInOut = sizeof(cmd), 
		      ulDataLengthInOut = 0;
		rc = DosDevIOCtl(fd, IOCTL_DISK, DSK_UNLOCKDRIVE, 
			    &cmd, sizeof(cmd), &ulParmLengthInOut,
			    0, 0, &ulDataLengthInOut);
		ERROR_RETURN(rc)
	}
	rc = DosClose(fd);
	ERROR_RETURN(rc)
	return 0;
}

long _System
rmt_error(void)
{
	return last_error;
}

char * _System
rmt_status(long rcode)
{
	static char buf[128];
	ULONG len;

	if (DosGetMessage(NULL, 0, buf, sizeof buf, rcode, "OSO001.MSG", &len))
		sprintf(buf, "System error %u", rcode);
	return buf;
}

#ifdef __EMX__

unsigned long
_DLL_InitTerm(unsigned long mod_handle, unsigned long flag)
{
	if (!flag) {
		_CRT_init();
	} else {
		_CRT_term();
	}
	return 1;
}

#endif
