/*
================================================================================
                        Texinfo converting Tools
                         Release 1.00 28.03.97
                       (c) 1996 by Andreas Kaiser
                    (c) 1997 by Karl Heinz Marbaise
================================================================================

Discription:
    Header which is used for all converters
    (should be changed)

Authors:
   Andreas Kaiser
   Karl Heinz Marbaise

e-mail:
   Internet: KHMarbaise@p69.ks.fido.de
   Fido-net: 2:2452/117.69

Bugs, question:
   to above e-mail adress.

Register:
   Please send a e-mail to above adress to register.
   (include the release you want to register)
   This registration should be done to let me
   know how many people using these tools and
   if it is worth to invest more time in continuing
   development these tools or let the first release
   of them be the last.
   That is the only reason to make a registration.
   I think a e-mail is not to much, isn't it?

License:
   The "Texinfo converting tools" are free software;
   you can redistribute it and/or modify it under the terms of
   the GNU General Public License as published by the Free
   Software Foundation; either version 2, or (at your option)
   any later version.

   The "Texinfo converting tools" are distributed in the hope that
   they will be useful, but WITHOUT ANY WARRANTY; without even the
   implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
   PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with the "Texinfo converting tools" ; see the file COPYING.
   If not, write to the:
   Free Software Foundation,
   59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   See \texicvt1.00\COPYING for details.

================================================================================
*/

#include <iostream.h>
#if defined (__EMX__)
#include <Strng.h>
#else
#include <String.h>
#endif
#include <stdlib.h>
#include <string.h> /* default C string lib */

#define FontSize	"17x10"

const int	MaxW	= 20;

#ifndef EXTERN
 #define EXTERN extern
 #define INIT(x)
#endif

struct Name {
	Name (int i, int d = 0, int l = 0)  { id = i; defined = d; level = l; }
	int	defined;
	int	id;
	int	level;
};

struct XItem {
	XItem ()			: title("?") { id = 0; }
    XItem (String& str, int num)    : title(str) { id = num; }
	String title;
	int id;
};

//#include "XItem_SLBag.h"
#include "xi_slbag.h"

typedef class XItemSLBag XEntry;

//#include "String_XEntry_AVLMap.h"
#include "strxeavl.h"

typedef class StringXEntryAVLMap XClassT;

struct XClass {
	XClass () : entries(XEntry()) {}
	XClassT entries;
};

//#include "String_XClass_VHMap.h"
#include "strxcvhm.h"

typedef class StringXClassVHMap Index;

typedef class StringNameAVLMap Table;
typedef class StringStringAVLMap Flags;

//#include "String_Name_AVLMap.h"
#include "strnavlm.h"
//#include "String_String_AVLMap.h"
#include "strsavlm.h"

EXTERN int	fnid	INIT(0);		// footnote id
EXTERN int	hdid	INIT(0);		// heading id

EXTERN String	node_name;			// name of last node
EXTERN int	node_id;			// heading id of last node

EXTERN String	panel_name;			// heading name of last panel
EXTERN int	panel_id;			// heading id of last panel

EXTERN int	yylineno INIT(1);		// input line number

EXTERN Flags	flags	INIT(Flags(String((const char *)"")));	// TexInfo flags
EXTERN Table	table	INIT(Table(Name(0, 0, 0)));	// table of menu nodes
EXTERN Index	indexes	INIT(Index(XClass(), 10));	// 2-dim index

EXTERN ostream *out	INIT(&cout);		// current output stream
						
EXTERN String	w[MaxW];			// result of words()
EXTERN String	null	INIT("");		// the null string

EXTERN int	debug;				// trace parser
EXTERN int	f_node;				// use chapters(0) or nodes(1)
EXTERN int	f_index;			// create INF index

EXTERN int      IncludeFile;
	// scan.l
extern int	yylex();
extern void	newline();

	// util.cc
extern void	words(String&);
extern void	spaced(String&);
extern void	heading(int level, const char *s);
extern void	footnote();
extern void	item_begin (const char *beg, int it, char *ic);
extern void	item_end (const char *end);
extern void	node(String name, String next, String prev, String up);
extern void	xref(char *see, String name, String entry, String topic, String file, String manual);
extern void	define(String& s, int xflag, const char *index, int typeflag, int argflag, const char *category);

extern void	font(const char *name, const char *size = FontSize);
extern void	beg_example(const char *);
extern void	end_example();
extern int	margin(int);
extern void	single_word(const char *text);
extern void	para();

extern void	indexref(const char *name, const String& text);
extern void	printindex(String& name);

extern void	setflag(String&);

struct Item {
	Item (char *name = 0, int num = 0, char *text = 0)
		{ fontname = name; hpnumber = num; delimiter = text; }
	char *	fontname;	// item font
	int	hpnumber;	// :hp number
	char *	delimiter;	// delimiter text
};

struct ItemType {
	Item	beg;		// before item
	Item	end;		// after item
	int	type;		// 'o' = ordered list, 'l' = unordered list,
				// 'p' = parameters
	char *	cat;		// "Function", "Variable", 0
	short	indent;		// indentation level
	short	nested;		// is nested
	short	count;		// item counter

	void item (const char *text);
};

struct Menu {
	String	line;
	void	flush();
};

EXTERN Menu	menu;

EXTERN int	nofill;				// don't care about paragraphs

EXTERN ItemType   istack[50];
EXTERN ItemType * istackp INIT(istack);

EXTERN int	plines[10];			// line number where arg starts
EXTERN int	plevel;				// scanner level (index to plines)
EXTERN int	newpara;			// new paragraph required
EXTERN int	lastnl;				// last is newline

#define PUT(x)	{*out << x; lastnl = 0;}
#define PUTS(x)	{if (newpara) para(); *out << x; lastnl = 0;}
#define PUTA(x)	{if (!plevel) { if (newpara) para(); *out << x; lastnl = 0;}}
#define PUTL()	{*out << endl; lastnl = 1;}



