;;;
;;; Define a fixed version of ADD-HOOK here so that the CL-19 package
;;; sees ADD-HOOK as FBOUNDP and doesn't install its broken version.
;;; 

(defun add-hook (hook func &optional append)
  "Add to hook variable HOOK the function FUNC.
FUNC is not added if it already appears on the list stored in HOOK."
  (let ((old (and (boundp hook) (symbol-value hook))))
    (if (or (not (listp old))
	    (eq (car old) 'lambda))
	(setq old (list old)))
    (if (not (member func old))
	(set hook (if append (nconc old (list func)) (cons func old))))))


;;;
;;; There are bugs in the internal functions FILE-WRITABLE-P and
;;; FILE-READABLE-P in DEmacs for DOS.  The following provides new function
;;; definitions that work.
;;; 

(if (eq system-type 'ms-dos)
    (progn
      (defun browse-file-readable-p (file)
	(let ((attributes (file-attributes file)))
	  (and attributes
	       (string= (substring (nth 8 attributes) 1 2) "r"))))

      (fset 'file-readable-p (symbol-function 'browse-file-readable-p))

      (defun browse-file-writable-p (file)
	(let ((attributes (file-attributes file)))
	  (or (null attributes)
	      (string= (substring (nth 8 attributes) 2 3) "w"))))

      (fset 'file-writable-p (symbol-function 'browse-file-writable-p))

      (defun browse-file-exists-p (file)
	(not (null (file-attributes file))))

      (fset 'file-exists-p (symbol-function 'browse-file-exists-p))))

(provide 'br-fixes)