;;; vxrexx-mode.el --- Adds intelligence for handling VX-Rexx code.
;;;		       Must be used in conjunction with rexx-mode.

;; Copyright (C) 1994 Scott K. Maxwell

;; Author: Scott Maxwell <scottmax@netcom.com>
;; Keywords: rexx vxrexx

;; Add the following lines to your .emacs
;;   (load "vxrexx-mode")
;; This will only work with rexx-mode so make sure you
;; have already installed that.

;; These extensions cause rexx-mode to automatically
;; rename your VX-Rexx section buffers to the name of
;; the section, instead of the name of the temp file.

;; If you want to have the procedure names from every
;; section added to your local completion table, add:
;;
;;   (setq vxrexx-build-master-table t)
;;
;; Then when you load the first section, vxrexx-mode uses grep
;; to build the procedure table.  After that it will just add
;; new sections as they are created.  If you delete some sections,
;; you may want to force vxrexx-mode to rebuild the table.  This
;; may be accomplished by saving your project.
;;
;; NOTE: You must have grep.exe somewhere in your path to use this
;;	 feature.

;; If you use this, you will probably also want to enable the
;; VX-Rexx completion and documentation file.  Look in
;; vxrexx-doc.el for details.

;; You might also want to check out my frame-server package.
;; It causes Emacs to open a new frame for each emacsclient.
;; These frames then may be closed as if they were all separate
;; editors, i.e. hitting [Alt-F4] or selecting Close from the
;; system menu.


(defvar vxrexx-build-master-table nil
  "*If non-nil, rexx-mode will use grep to get all of the
procedure names associated with the current file of the
current project.")

(defvar vxrexx-table-alist nil
  "Contains list of VX-Rexx tables for different projects.")

(add-hook 'rexx-mode-hook 'vxrexx-check)

(defun vxrexx-check ()
  (if (looking-at "/\\*:VRX \\*/")
      (let ((here (rexx-forward-to-noncomment))
	    (there (rexx-forward-sexp 1)))
	(rename-buffer (buffer-substring here there))
	(setq mode-name "VX-Rexx")
	(setq rexx-build-eval '(vxrexx-build-procedure-table)))))

(defun vxrexx-build-procedure-table ()
  (if vxrexx-build-master-table
      (let ((first-vrm (car (directory-files "./" t "\.+\.VRM"))))
	(if first-vrm
	    (let* (move
		   (time (elt (file-attributes first-vrm) 5))
		   (dir (file-name-directory first-vrm))
		   (old (assoc dir vxrexx-table-alist)))
	      (setq rexx-user-procedure-table
		    (append
		     (if (and old
			      (equal (elt old 1) time))
			 (elt old 2)
		       (if (not old)
			   (progn
			     (setq old (list dir time nil))
			     (setq vxrexx-table-alist (cons old vxrexx-table-alist)))
			 (setcar (cdr old) time))
		       (save-excursion
			 (set-buffer (get-buffer-create " *vxrexx-procedures*"))
			 (erase-buffer)
			 (call-process "grep" nil t t "-h" "^[a-zA-Z][a-zA-Z_0-9]*:" "*.cmd")
			 (goto-char (point-min))
			 (while (re-search-forward "^[a-z][a-z_0-9]*:" nil t)
			   (rexx-add-to-procedure-table
			    (buffer-substring (match-beginning 0) (1- (match-end 0)))))
			 (setq move rexx-user-procedure-table)
			 (kill-buffer " *vxrexx-procedures*"))
		       move) rexx-user-procedure-table))
	      (setcar (cdr (cdr old)) rexx-user-procedure-table))))))
