/* runargs.c (emx+gcc) */

#include <stdlib.h>
#include <stdio.h>
#include <process.h>

static void usage (void)
{
  fputs ("Usage: runargs <count>\n", stderr);
  exit (1);
}

static void out_of_mem (void)
{
  fputs ("Out of memory\n", stderr);
  exit (2);
}

int main (int argc, char *argv[])
{
  long n;
  char *end;
  char **av;
  int i, rc;

  if (argc != 2)
    usage ();
  n = strtol (argv[1], &end, 10);
  if (n < 0 || n > 32766 || *end != 0 || end == argv[1])
    usage ();
  av = calloc ((size_t)(n+2), sizeof (*av));
  if (av == NULL)
    out_of_mem ();
  av[0] = "args.exe";
  for (i = 1; i <= (int)n; ++i)
    {
      char *p = malloc (50);
      if (p == NULL)
        out_of_mem ();
      snprintf (p, 50, "%d xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx",
                i);
      av[i] = p;
    }
  av[n+1] = NULL;
  rc = spawnv (P_WAIT, av[0], av);
  if (rc == -1)
    {
      perror (av[0]);
      exit (2);
    }
  return rc;
}
