/* gethtype.c - get the type of a file

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

unsigned long _rsxnt_get_ht_type(HANDLE h)
{
    DWORD type;

    type = GetFileType(h);

    switch (type) {
        case FILE_TYPE_DISK:
            type = HT_FILE;
            break;

        case FILE_TYPE_CHAR:
            type = HT_DEV_CON;
            break;

        case FILE_TYPE_PIPE:
        {
            TCHAR name[260];

            if (GetNamedPipeHandleState(h, NULL,
                NULL, NULL, NULL, name, 260) == FALSE)
                type = HT_UPIPE;
            else
                type = HT_NPIPE;
            break;
        }

        case FILE_TYPE_UNKNOWN:
            if (GetLastError() != ERROR_INVALID_HANDLE)
                type = HT_DEV_OTHER;
            else
                type = 0xffffffff;
            break;

        default:
            type = 0xffffffff;
            break;
    }
    return type;
}
