/* chmod.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"
#include <string.h>

int __chmod(const char *name, int flag, int attr)
{
    char fname[512];

    if (flag < 0 || flag > 1)
      return _rsxnt_errno(EINVAL);

    /* check pipe */
    if (strncmp(name, "/pipe/", 6) == 0 || strncmp(name, "\\pipe\\", 6) == 0)
      return _rsxnt_errno(ENOENT);

    _rsxnt_truncate_name (fname, name);

    if (_rsxnt_get_process_ptr()->bConsoleApp)
	OemToChar(fname, fname);

    if (flag == 0) {
	DWORD attr = GetFileAttributes(fname);
	if (attr == 0xffffffff)
	    return _rsxnt_get_last_errno();
	else
	    return (attr & 0x7f);
    } else {
	if (!attr)
	    attr = FILE_ATTRIBUTE_NORMAL;
	if (SetFileAttributes(fname, attr) == FALSE)
	    return _rsxnt_get_last_errno();
	else
	    return 0;
    }
}
