/* fcntl.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

#ifndef F_GETOSFD
#define F_GETOSFD 6
#endif

static void InheritHandle(EMXPROCESS *p, int fd, BOOL bInherit)
{
    /*
      There are problems with this code (f.e. gdb)
      Perhaps there is a problem with console handles and dup(), dup2()

      Win32 Help file:
      Console handles can be duplicated for use only in the same process.

      For NT we can use SetHandleInformation !
    */

    if (_rsxnt_win32_version != WIN32NT) {
        HANDLE hproc, hout;
        HANDLE hin = p->file[fd].f_handle;

        hproc = GetCurrentProcess();

        if (DuplicateHandle(hproc, hin, hproc, &hout, 0, bInherit,
                DUPLICATE_SAME_ACCESS) == FALSE)
            return;

        CloseHandle(hin);
        p->file[fd].f_handle = hout;
    }
    else { /* NT */
        HANDLE h = p->file[fd].f_handle;
        SetHandleInformation (h, HANDLE_FLAG_INHERIT,
                    (bInherit) ? HANDLE_FLAG_INHERIT : 0);
    }
}

int __fcntl(int fd, int request, int arg)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    int ret;

    if (fd >= N_FILES || fd < 0 || p->file[fd].f_handle == INVALID_HANDLE_VALUE)
        return _rsxnt_errno(EBADF);

    switch (request) {
        case F_GETFL:
            return p->file[fd].f_flags;

        case F_SETFL:
            ret = 0;

            if (p->file[fd].f_mode == HT_SOCKET &&
                (p->file[fd].f_mode & O_NONBLOCK) != (arg & O_NONBLOCK))
            {
                if (!_rsxnt_socket_fop.fcntl)
                    return _rsxnt_errno (EBADF);
                else
                    ret = (*_rsxnt_socket_fop.fcntl)
                            ((int) p->file[fd].f_handle, F_SETFL, arg);
            }
            if (ret == 0)
                p->file[fd].f_flags = arg;
            return ret;

        case F_GETFD:
            return EMX_FD_ISSET(fd, p->close_on_exec);

        case F_SETFD:
            if (arg & 1) {  /* no inherit */
                if (!EMX_FD_ISSET(fd, p->close_on_exec))
                    InheritHandle(p, fd, FALSE);
                EMX_FD_SET(fd, p->close_on_exec);
            }
            else {  /* inherit files */
                if (EMX_FD_ISSET(fd, p->close_on_exec))
                    InheritHandle(p, fd, TRUE);
                EMX_FD_CLR(fd, p->close_on_exec);
            }
            return 0;

        case F_GETOSFD:
            return (int) p->file[fd].f_handle;
    }
    return -EINVAL;
}
