/* getcwd.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

/* DOS 0x47 have no path nor initial backslash */

int __getcwd(char *name, char drive)
{
    char path[260];

    if (drive == 0) {
	if (GetCurrentDirectory(260, (LPTSTR)path) == 0)
	    return _rsxnt_get_last_errno();
	if (path[1] == ':')
	    lstrcpy(name, path+3);
	else
	    lstrcpy(name, path);
    }
    else {
	static char letter[] = "C:";
	LPTSTR filepos;

	letter[0] = drive;
	GetFullPathName(letter, 260, path, &filepos);
	lstrcpy(name, path+3);
    }

    if (_rsxnt_get_process_ptr()->bConsoleApp)
	CharToOem(name, name);
    return 0;
}
