/* signal.c - emx interface function

   Copyright (c) 1995-1999 Rainer Schnitker

   This file is part of RSXNT.

   RSXNT is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   RSXNT is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with RSXNT; see the file COPYING.  If not, write to
   the Free Software Foundation, 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA. */

#include "rsxnt.h"

void (*__signal (int signum, void (*handler)()))(int sig)
{
    EMXPROCESS *proc = _rsxnt_get_process_ptr();
    SA_HANDLER old_handler;

    if (signum < 1 || signum >= NSIG || signum == SIGKILL)
        return SIG_ERR;

    old_handler = proc->sigaction[SIGSA(signum)].sa_handler;

    if (handler == SIG_ACK) {
        proc->sig_blocked &= ~ SIGMASK(signum);
    }
    else {
      proc->sigaction[SIGSA(signum)].sa_handler = handler;
      proc->sigaction[SIGSA(signum)].sa_flags = 0;
      proc->sigaction[SIGSA(signum)].sa_mask = 0;
  
      if ((proc->uflags & 3) == 1)         /* system V */
          proc->sigaction[SIGSA(signum)].sa_flags = SA_SYSV;
      else if ((proc->uflags & 3) == 2)    /* BSD */
          proc->sigaction[SIGSA(signum)].sa_flags = 0;
      else                                /* old EMX */
        proc->sigaction[SIGSA(signum)].sa_flags = SA_ACK;
    }
#ifdef EMX_SYS_LIB
        _rsxnt_check_signals();
#endif
    return old_handler;
}
