CC	= gcc
OPTIM	= -O2 -m486 -fomit-frame-pointer
# DEBUG	= -g
D	=

CFLAGS	= $(OPTIM) $(DEBUG) -DEMBED -DDOSISH -DOS2=2 -I. -Ios2 $D
LDFLAGS	= $(OPTIM) $(DEBUG)
LDLIBS  = -lx -lsocket -lm -lbsd

.IF $O == .obj
  CFLAGS  += -Zomf
  LDFLAGS += -Zomf -Zcrtdll -Zstack 384
  TARGETS = perl5.exe perl5.dll perl5.lib
  REXX    = os2rexx.obj
  suffix  = dll
  builtin = DynaLoader
.ELSE
  CFLAGS  += -DHAS_FORK
  TARGETS = perl5x.exe
  REXX    =
  suffix  = exe
  builtin = Fcntl FileHandle Socket POSIX Process
.END
.IF $(OPTIM) == $(NULL)
  debug = d
  CFLAGS += -DDEBUGGING
.END

modules	   = DB_File Fcntl FileHandle POSIX Socket
mymodules  = DB2CLI DPI
os2modules = FTP Process REXX UPM

mallocobj = malloc$O
obj1 = $(mallocobj) gv$O toke$O perly$O op$O regcomp$O dump$O util$O mg$O
obj2 = hv$O av$O run$O pp_hot$O sv$O pp$O scope$O pp_ctl$O pp_sys$O
obj3 = doop$O doio$O regexec$O taint$O deb$O perl$O os2$O globals$O
objs = $(obj1) $(obj2) $(obj3)
exts = {$(builtin)}$O

.SOURCE.c : . os2 ext/{$(builtin)} ext/os2/{$(builtin)}
.SOURCE$O : obj$(debug)

all  : config.h preplibrary $(TARGETS) lib/Config.pm modules os2modules
mini : miniperl.exe
bin  : $(TARGETS)
dbg  : perl5d.exe
mod  : modules os2modules

.IF $O == .obj
miniperl.exe miniperl.map .UPDATEALL : miniperlmain$O $(objs)
	$(CC) $(LDFLAGS) $< $(LDLIBS) -Zmap -Zlinker /map -Zlinker /exepack:2 -o $@
.END

perl5.exe : main_dll$O perl5.lib
	$(CC) $(LDFLAGS) $< -o $@

perl5x.exe : main_exe$O $(objs) $(exts)
	$(CC) $(LDFLAGS) $< $(LDLIBS) -o perl5x
	emxbind -b -s perl5x

perl5d.exe : main_exe$O $(objs) $(exts)
	$(CC) $(LDFLAGS) $< $(LDLIBS) -Zmap -Zlinker /map -o $@

perl5.dll : $(objs) $(exts) $(REXX) perl5.def
	$(CC) $(LDFLAGS) -Zdll $< $(LDLIBS) -o $@

perl5.lib : perl5.def
	implib /noign $@ perl5.def

perl5.def : os2/perl5hdr.def miniperl.map os2/mkdef.pl
	echo LIBRARY 'Perl5' INITINSTANCE TERMINSTANCE >$@
	cat os2/perl5hdr.def >>$@
	.\miniperl -n os2/mkdef.pl miniperl.map | sort -u - >>$@

preplibrary : miniperl.exe lib/Config.pm config.sh
	-mkdir lib/auto
	@echo "	AutoSplitting perl library"
	find lib -name "*.pm" ! -name "REXX.pm" -print >tmp1
	.\miniperl -Ilib -e "use AutoSplit; autosplit_lib_modules(@ARGV)" @tmp1
	-$(RM) $(RMFLAGS) tmp1

main_$(suffix).c : writemain os2\os2main.c
	sed -e "s+miniperlmain+os2/os2main+" writemain >tmp2
	ksh tmp2 $(builtin) > $@
	-$(RM) $(RMFLAGS) tmp2

config.h : config.sh
	ksh config_h.sh

lib/Config.pm : config.sh miniperl.exe
	.\miniperl.exe configpm

DynaLoader.c .SETDIR=ext/DynaLoader : dl_os2.xs
	..\..\miniperl ../../lib/ExtUtils/xsubpp dl_os2.xs > DynaLoader.c

modules :
	cmd /c "for %x in ($(modules) $(mymodules)) do call os2\ext %x"
os2modules :
	cmd /c "for %x in ($(os2modules)) do call os2\ext2 OS2 %x"

#############################################################################

install :
	emxload -qw
	-cp -t perl5.exe perl5.dll perl5x.exe $(ROOTDIR)/usr/binp
	-cp -t perl5.exe $(ROOTDIR)/usr/binp/perl.exe
