/*
\begin{verbatim}
*/

#ifndef snmp_lDPIH
#define snmp_lDPIH

/*********************************************************************/
/*                                                                   */
/* SNMP-DPI API - SNMP Distributed Protocol Interface                */
/*                Application Programming Interface                  */
/*                                                                   */
/* Sep 07, 1995 - Version 0.14i                                      */
/*                                                                   */
/* Copyright    - (C) International Business Machines Corp. 1994     */
/*                                                                   */
/*   Permission to use, copy, modify, and distribute this software   */
/*   and its documentation for any lawful purpose and without fee is */
/*   hereby granted, provided that this notice be retained unaltered,*/
/*   and that the names of IBM and all other contributors shall not  */
/*   be used in advertising or publicity pertaining to distribution  */
/*   of the software without specific written prior permission.      */
/*   No contributor makes any representations about the suitability  */
/*   of this software for any purpose.  It is provided "as is"       */
/*   without express or implied warranty.                            */
/*                                                                   */
/*   IBM AND ALL OTHER CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH     */
/*   REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF    */
/*   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, TITLE,    */
/*   AND NON-INFRINGEMENT.                                           */
/*                                                                   */
/*   IN NO EVENT SHALL IBM OR ANY OTHER CONTRIBUTOR BE LIABLE FOR    */
/*   ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES, WHETHER IN      */
/*   CONTRACT, TORT, OR OTHER FORM OF ACTION, ARISING OUT OF OR IN   */
/*   CONNECTION WITH, THE USE OR PERFORMANCE OF THIS SOFTWARE.       */
/*                                                                   */
/* snmp_lDPI.h  - Include file for SNMP DPI sub-agent support.       */
/*              - This one is normally not exposed to DPI sub-agent  */
/*                programmers. It defines things for internal calls  */
/*                between the DPI library functions that reside in   */
/*                different source files                             */
/*              - It may also be tailored for platform dependent     */
/*                things, because the target end-user (DPI sub-agent */
/*                programmer) in principle only uses the interface   */
/*                as defined in snmp_dpi.h                           */
/*-------------------------------------------------------------------*/

/* Change activitity:
 *
 * $Log: snmp_lDPI.h,v $
 * Revision 3.1  1995/09/07  20:36:53  snmpdev
 * add invalid prototype define
 *
 * Revision 3.0  1995/04/05  21:30:00  snmpdev
 * new level for snmpv2 development
 *
 * Revision 2.9  1995/04/05  21:29:17  snmpdev
 * rfc1440 freeze
 *
 * Revision 2.0  1994/10/29  01:19:29  pederson
 * Revision 2.0
 *
 *
 */

#include "snmp_dpi.h"

/*********************************************************************/
/* This macro defines how we do tracing for DPI internal debugging   */
/* It uses an external variable dpi_debug, that is normally defined  */
/* in the source file snmp_mDPI.c. That variable can be set to on or */
/* off by the DPI programmer with a DPIdebug(..) call.               */
/* The definition is:   DPI_DEBUG(minimum_level,code_to_execute)     */
/* So if the debug_level in dpi_debug is GE than minimum_level, then */
/* the code_to_executed is executed.                                 */
/*********************************************************************/
#ifndef DPI_DEBUG                         /* if no DPI_DEBUG wanted  */
#define DPI_DEBUG(a,b) ;                  /* ignore DPI_DEBUG stuff  */
#else                                     /* if DPI_DEBUG wanted     */
#undef DPI_DEBUG                          /* undefine and then       */
#define DPI_DEBUG_CODE                    /* for conditional code    */
#define DPI_DEBUG(a,b)                    /* use this instead       */\
        if (dpi_debug>=(a)) (b)           /* to generate debug code */
extern  int dpi_debug;                    /* holds debug level       */
#endif /* def DPI_DEBUG */

/*********************************************************************/
/* We do not use plain text in our DPI interface routines but we use */
/* the following defined strings. Currently the code also does not   */
/* use any printf statements, but instead uses the DPI_DM (display   */
/* Message) macro. So this allows us to do different things in the   */
/* future. For instance call a dynamically loadable NLS module to    */
/* print NLS specific messages. DPI_M_xxx definitions would then     */
/* probably change to message numbers, but the code does not need    */
/* to change.                                                        */
/*********************************************************************/
#define DPI_DM printf              /* Display Message this way       */
/*#define DPI_DM printf("DPI_M %s(%d): ",__FILE__,__LINE__);printf   */
#define DPI_M_NONE            "** NONE **" /* used as text string    */
#define DPI_M_DEBUG_ON        "ON"         /* used as text string    */
#define DPI_M_DEBUG_OFF       "OFF"        /* used as text string    */
#define DPI_M_YES             "Yes"        /* used as text string    */
#define DPI_M_NO              "No"         /* used as text string    */
#define DPI_M_CSET_ASCII      "ASCII"      /* used as text string    */
#define DPI_M_CSET_NATIVE     "Native"     /* used as text string    */
#define DPI_M_DEBUG_ONOFF          "DPI Debug turned %s (level %d)\n"
#define DPI_M_NO_DEBUG_CODE        "DPI Debug code not available\n"
#define DPI_M_OUT_OF_MEMORY        "Out of memory\n"
#define DPI_M_DPI_BUFFER_OVERFLOW  "DPI buffer overflow\n"
#define DPI_M_PDU_BUFFER_OVERFLOW  "PDU buffer overflow\n"
#define DPI_M_DPI_ENCODING_ERROR   "DPI encoding error\n"
#define DPI_M_DPI_DECODING_ERROR   "DPI decoding error\n"
#define DPI_M_INVALID_DPI_TYPE     "Invalid DPI packet type\n"
#define DPI_M_INVALID_SNMP_TYPE    "%s: Invalid value type %d\n"
#define DPI_M_INVALID_DPI_LEVEL    "%s: Unsupported DPI level\n"
#define DPI_M_INVALID_DPI_VERSION  "Invalid/Unsupported DPI version\n"
#define DPI_M_INVALID_DPI_RELEASE  "Invalid/Unsupported DPI release\n"
#define DPI_M_INVALID_DPI_PORT     "Invalid/Unsupported DPI port\n"
#define DPI_M_INVALID_DPI_T_PROTO  "Invalid/Unsupported transport %s\n"
#define DPI_M_INVALID_SNMP_VERSION "Invalid/Unsupported SNMP version\n"
#define DPI_M_INVALID_INT_LENGTH   "%s: invalid integer length %hu\n"
#define DPI_M_INVALID_I64_LENGTH   "%s: invalid 64-bit length %hu\n"
#define DPI_M_INVALID_NSAP_LENGTH  "%s: invalid NSAP length %hu\n"
#define DPI_M_INVALID_NULL_LENGTH  "%s: invalid NULL length %hu\n"
#define DPI_M_INVALID_OID          "%s: invalid objectID: %s\n"
#define DPI_M_INVALID_GROUPID      "%s: invalid groupID: %s\n"
#define DPI_M_INVALID_INSTANCE     "%s: invalid instanceID: %s\n"
#define DPI_M_INVALID_TIMEOUT      "%s: invalid timeout: %lu\n"
#define DPI_M_INVALID_MAXVB        "%s: invalid maxVarbinds: %lu\n"
#define DPI_M_INVALID_PWLEN        "%s: invalid password_len: %lu\n"
#define DPI_M_INVALID_VAL_LENGTH   "%s: Value length is invalid\n"
#define DPI_M_INVALID_TRAP_GEN     "%s: Invalid generic type %ld\n"
#define DPI_M_INVALID_TRAP_SPEC    "%s: Invalid specific type %ld\n"
#define DPI_M_COMMUNITY_TOO_LONG   "Community name too long\n"
#define DPI_M_SADESC_TOO_LONG      "%s: description too long\n"
#define DPI_M_ZERO_LENGTH          "Length is zero\n"
#define DPI_M_NULL_PTR             "%s: NULL ptr (zero)passed\n"
#define DPI_M_MISSING_VALUE        "Missing value\n"
#define DPI_M_MISSING_SA_OID       "Missing subagent Identifier\n"
#define DPI_M_MISSING_SA_DESCR     "Missing subagent Description\n"
#define DPI_M_MISSING_PRIORITY     "Missing priority\n"
#define DPI_M_MISSING_VIEW_SELECT  "Missing view selection\n"
#define DPI_M_MISSING_BULK_SELECT  "Missing bulk selection\n"
#define DPI_M_MISSING_COMMUNITY    "Missing community name\n"
#define DPI_M_MISSING_REASON_CODE  "Missing reason code\n"
#define DPI_M_MISSING_SUBTREE      "Missing subtree(s)\n"
#define DPI_M_MISSING_GROUP_ID     "%s: Missing groupID\n"
#define DPI_M_MISSING_TRAILING_DOT "Missing trailing dot\n"
#define DPI_M_MISSING_CSET         "Missing selected character set\n"
#define DPI_M_MISSING_OID          "%s: Missing objectID\n"
#define DPI_M_NO_IPADDR_FOR_HOST   "No IP address for host %s\n"
#define DPI_M_ALL_CONNECTIONS_USED "All %d connections in use\n"
#define DPI_M_CLOSING_FD           "Closing connection on fd %d\n"
#define DPI_M_INVALID_HANDLE       "Invalid handle %d\n"
#define DPI_M_INVALID_ERROR_CODE   "%s: Invalid error code: %ld\n"
#define DPI_M_INVALID_ERROR_INDEX  "%s: Invalid error index: %ld\n"
#define DPI_M_OUT_PACKET           "Outgoing DPI packet"
#define DPI_M_IN_PACKET            "Incoming DPI packet"
#define DPI_M_NOT_ALL_BYTES_SENT   "Only %d of %lu bytes sent\n"
#define DPI_M_EOF_RECEIVED         "EOF received on DPI %s fd %d\n"
#define DPI_M_CONNECTION_SETUP     "%s connection setup for fd %d\n"
#define DPI_M_DUMP_OF_BYTES        "Dump of %d byte %s:\n  "
#define DPI_M_INCOMPLETE_IN_PACKET \
            "Incomplete incoming DPI packet on %s fd %d\n"
#define DPI_M_TIMEOUT_ON_FD \
            "Timeout after %d seconds on fd %d\n"
#define DPI_M_CODE_OUT_OF_SYNC \
            "Code out of sync, source file %s, line %d\n"
#define DPI_M_RECEIVED_PACKET_ON_FD \
            "Received %lu byte DPI packet on %s fd %d\n"
#define DPI_M_SENT_PACKET_ON_UDP_FD \
            "Sent %lu byte DPI packet on fd %d to %s port %u\n"
#define DPI_M_SENT_PACKET_ON_TCP_FD \
            "Sent %lu byte DPI packet on fd %d\n"
#define DPI_M_PACKET_DROP \
            "Drop %lu byte DPI packet, too large for %d byte buffer\n"
#define DPI_M_VERSION1 \
            "%s: Major=%d, Version=%d, Release=%d, Id=%u, Type=%s\n"
#define DPI_M_VERSION2 \
            "%*s  Community=%.*s\n"
#define DPI_M_OPEN_PART_1 "%s: subagent Identification=%s\n"
#define DPI_M_OPEN_PART_2 "%*s  Description=%s\n"
#define DPI_M_OPEN_PART_3 "%*s  Selected Character Set is %d (%s)\n"
#define DPI_M_OPEN_PART_4 \
            "%*s  timeout=%lu, max_varBinds=%lu, password=%.*s\n"
#define DPI_M_CLOSE    "%s: close reason_code=%ld (%s)\n"
#define DPI_M_REGISTER1 "%s: subtree=%s, priority=%ld, timeout=%u\n"
#define DPI_M_REGISTER2 "%*s  view_selection=%s\n"
#define DPI_M_REGISTER3 "%*s  bulk_selection=%s\n"
#define DPI_M_REGISTER4 "%*s  community=%.*s\n"
#define DPI_M_UNREGISTER          "%s: subtree=%s reason_code=%d\n"
#define DPI_M_OBJECT_PART_1       "%s: subtree=%s, instance=%s\n"
#define DPI_M_OBJECT_PART_2       "%*s  object=%s\n"
#define DPI_M_VALUE_PART_1 \
            "%*s  value_type=%s ['%2.2x'H], value_len=%d\n"
#define DPI_M_VALUE_PART_2         "%*s  value="
#define DPI_M_VALUE_INTEGER32      "%ld [0x%8.8x]\n"
#define DPI_M_VALUE_IPADDRESS      "%d.%d.%d.%d\n"
#define DPI_M_VALUE_U_INTEGER32    "%lu [0x%8.8x]\n"
#define DPI_M_VALUE_COUNTER64      "%lu.%lu [0x%8.8x%8.8x]\n"
#define DPI_M_VALUE_OID            "%.*s\n"
#define DPI_M_VALUE_NULL           "** NULL **\n"
#define DPI_M_VALUE_DISPLAY_STRING "%.*s\n"
#define DPI_M_VALUE_OCTETS_PART_1  "'"
#define DPI_M_VALUE_OCTETS_PART_2  "%2.2x"
#define DPI_M_VALUE_OCTETS_PART_3  "\n%*s"
#define DPI_M_VALUE_OCTETS_PART_4  "'H\n"
#define DPI_M_RESPONSE "%s: ret_code=%d [0x%x] (%s), ret_index=%lu\n"
#define DPI_M_TRAP \
       "%s: generic=%ld [0x%x], specific=%ld [0x%x], enterprise=%s\n"

/*********************************************************************/
/* These 2 fucntions are defined here and not in snmp_dpi.h, because */
/* they are meant to be used by system specific code only and NOT by */
/* the normal sub-agent programmer (he/she just calls lookup_host and*/
/* qDPIport (or query_DPI_port) to obtain the IP address and the DPI */
/* port from the agent. Following 2 functions are system independent */
/* and are proved as part of snmp_mkDPI.c code.                      */
/*********************************************************************/
extern long int       extract_DPI_port(  /* extract DPI port from    */
  char                  *packet_p,       /* this SNMP response PDU   */
  int                    packet_len);    /* that has this length     */

extern unsigned char *mkDPIqport_packet( /* Make a GET for DPIport   */
  int                    snmp_version,   /* SNMP version (1=SNMPv1)  */
  int                    tcp_udp_port,   /* 0=TCP or 1=UDP port      */
  char                  *community_p,    /* ptr to community name    */
  int                    community_len,  /* length of community name */
  int                   *pdu_len);       /* receives length of result*/

#endif /* snmp_lDPIH */

/*
\end{verbatim}
*/
