use OS2::REXX;

#
# DLL
#
$ydba = load OS2::REXX "ydbautil" or die "load";

#
# function
#
if (1) {
	@pid = $ydba->RxProcId();
	print @pid, "\n";
	@pid = $ydba->RxProcId();
	print @pid, "\n";
}

#
# scalar
#
if (1) {
	tie $s, OS2::REXX, "TEST";
	$s = 1;
	print $s;
	untie $s;
}

#
# hash
#
if (1) {
	tie %all, OS2::REXX, "";	# all REXX vars

	sub show
	{
		# show all REXX vars
		print "--@_--\n";
		foreach (keys %all) {
			$v = $all{$_};
			print "$_ => $v\n";
		}
	}


	tie %h, OS2::REXX, "TEST.";
	show("initial");

	$h{"one"} = 1;
	show("1st item");

	$h{"two"} = 2;
	show("2nd item");

	$h{"one"} = "";
	show("emptied 1st");
	print "one exists\n" if exists $h{"one"};
	print "two exists\n" if exists $h{"two"};

	delete $h{"one"};
	show("deleted 1st");
	print "one exists\n" if exists $h{"one"};
	print "two exists\n" if exists $h{"two"};

	OS2::REXX::drop("TEST.");
	show("dropped TEST.");
	print "one exists\n" if exists $h{"one"};
	print "two exists\n" if exists $h{"two"};

	untie %h;
}

$ydba->nixda();
