# NOTE: Derived from lib/DB2CLI.pm.  Changes made here will be lost.
package DB2CLI;

sub Prepare
{
    my ($connRef, $stmt, $refStmt) = @_;
    my ($hstmt, $rc);
    if ($rc = SQLAllocStmt($connRef->{HDBC}, $hstmt)) {
	$connRef->Message("SQLAllocStmt", $rc);
	return undef;
    }
    if ($refStmt) {
	my $cursor = "-Unknown-";
	SQLGetCursorName($refStmt->{HSTMT}, $cursor);
	$stmt .= " $cursor";
    }
    my $i = index($stmt, "\n", 1);
    my $s = ($i >= 0) ? substr($stmt, 0, $i) : $stmt;
    my $stmtRef = bless { %$connRef, HSTMT => $hstmt, TEXT => $s };
    if ($rc = SQLPrepare($hstmt, $stmt)) {
	$stmtRef->Message("SQLPrepare \"$s\"", $rc);
	return undef;
    }
    return $stmtRef;
}

1;
