/* REXX: updatedb.cmd -- build locate pathname database */

/* Author:  Kai Uwe Rommel <rommel@ars.de>
 * Created: Mon Jan 01 1996
 */

versionstring = 'GNU locate/updatedb 4.1'

/*
   csh original by James Woods
   sh conversion by David MacKenzie
   OS/2 REXX conversion by Kai Uwe Rommel
   Enhancements by Arthur Pool
   Public domain.
   */

Call SetLocal

/* Old or new database format? */
old = 0

/* The database file. */
database = Value('LOCATE_PATH',,'OS2ENVIRONMENT')

/* Directories to put in the database. */
localpaths = 'c:/ d:/ e:/'

/* Entries that match this regular expression are omitted. */
prunepaths = 'c:/temp d:/temp e:/temp'

/* Parse arguments. */

crlf = '0D0A'X
usage = crlf'Usage: updatedb [--localpaths="dir1 dir2..."]'crlf ||,
 '                [--prunepaths="dir1 dir2..."] [--output=dbfile]'crlf ||,
 '                [--old-format] [--version] [--help]'

Parse Arg args

Do i=1 To Words(args)
  
  option = Word(args,i)
  
  Select
    When Left(option,13) = '--localpaths=' Then Do
      localpaths = SubStr(option,14)
    End
    When Left(option,13) = '--prunepaths=' Then Do
      prunepaths = SubStr(option,14)
    End
    When Left(option,9) = '--output=' Then Do
      database = SubStr(option,10)
    End
    When option = '--old-format' Then Do
      old = 1
    End
    When option = '--version' Then Do
      Say crlf || versionstring
      Exit 0
    End
    When option = '--help' Then Do
      Say crlf || versionstring
      Say usage
      Exit 0
    End
    Otherwise Do
      Say crlf'updatedb: invalid option 'option
      Say crlf || versionstring
      Say usage
      Exit 1
    End
  End
  
End

/* Ensure we have a database name */
If database = '' Then Do
  Say 'A database name must be specified, either in the LOCATE_PATH'
  Say 'environment variable, or using the --output= option at execution time.'
  Exit 1
End

/* The environment variable `LOCATE_PATH' may contain multiple
   filenames separated by semi-colons (;); such a parameter is not
   valid for the operations below, so we select only the FIRST
   component to work with. */

Parse Var database database';' .

/* Parse the database path and name. */

database = Translate(database,'\','/')
libdir = FileSpec('D',database) || FileSpec('P',database)
dbname = FileSpec('N',database)

/* The directory for temporary files. */

tmp = Value('TMP',,'OS2ENVIRONMENT')

/* Set up the prune regexp. */

prune = ''

Do i=1 To Words(prunepaths)
  
  If prune = ''
  Then prune = '"\(^'Word(prunepaths,i)'$\)'
  Else prune = prune'\|\(^'Word(prunepaths,i)'$\)'
  
End

prune = prune'"'

/* Now do the work. */

If old = 0
Then Do
  
  /* Temporary file. */
  temp = libdir'locate.tmp'

  /* Make a new database.  */
  '@find 'localpaths' ^( -type d -regex 'prune' ^) -prune -o -print | ',
   'sort -f | frcode >'temp
  
  /* Delete the old and rename the new database. */
  '@if exist' database 'del' database
  '@ren 'temp' 'dbname

End
Else Do
  
  /* Temporary files. */
  bigrams = tmp'bigram.tmp'
  filelist = tmp'filelist.tmp'

  /* Make a file list. Alphabetize '/' before any other char with 'tr'. */
  '@find 'localpaths' ^( -type d -regex 'prune' ^) -prune -o -print | ',
   '( tr "/" "\001" | sort -f | tr "\001" "/" >'filelist' )'

  /* Compute common bigrams. */
  '@bigram <'filelist' | ',
   '( sort | uniq -c | sort -nr ) | ',
   '( gawk "{ if (NR <= 128) print $2 }" | tr -d "\012" >'bigrams' )'

  /* Code the file list. */
  '@code 'bigrams' <'filelist' >'database

  /* Delete temporary files. */
  '@del 'bigrams' 'filelist
  
End

/* end of updatedb.cmd */
