/* stripslash.c -- remove trailing slashes from a string
   Copyright (C) 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if defined(STDC_HEADERS) || defined(HAVE_STRING_H)
#include <string.h>
#else
#include <strings.h>
#endif
#include <ctype.h>

/* Remove trailing slashes from PATH.
   This is useful when using filename completion from a shell that
   adds a "/" after directory names (such as tcsh and bash), because
   the Unix rename and rmdir system calls return an "Invalid argument" error
   when given a path that ends in "/" (except for the root directory).  */

void
strip_trailing_slashes (path)
     char *path;
{
  int last;

  last = strlen (path) - 1;
#ifdef OS2
  UnixFileName (path);
  if (last != 2 || !isalpha(path[0]) || path[1] != ':')
#endif
  while (last > 0 && path[last] == '/')
    path[last--] = '\0';
}

#ifdef OS2
char *
fix_colon (path)
     char *path;
{
  int len = strlen (path);
  char *new_path;
  extern char *xmalloc ();

  if (path[len - 1] == ':') {
    new_path = xmalloc (len + 2);
    strcpy(new_path, path);
    strcat(new_path, ".");
    return new_path;
  }
  else
    return path;
}
#endif
