/* netlogon.c
 * Author:  Kai Uwe Rommel <rommel@ars.muc.de>
 * Created: Mon May 30 1994
 */

#define INCL_BASE
#include <os2.h>

#define INCL_32
#include <netcons.h>
#include <wksta.h>
#include <upm.h>

#include <stdio.h>
#include <string.h>

extern char *getpass(char *prompt);
extern char *getline(char *prompt);

int main (int argc, char **argv)
{
  unsigned short total, rc;
  struct
  {
    struct wksta_info_10 wksta;
    char buffer[256];
  }
  wkstainfo;
  char user[64], password[64], domain[64];

  if (argc > 1 && strcmp(argv[1], "*") != 0)
    strcpy(user, argv[1]);
  else
    strcpy(user, getline("User ID: "));

  if (argc > 2 && strcmp(argv[2], "*") != 0)
    strcpy(password, argv[2]);
  else
    strcpy(password, getpass("Password: "));

  if (argc > 3 && strcmp(argv[3], "*") != 0)
    strcpy(domain, argv[3]);
  else if (argc <= 3 && NetWkstaGetInfo(0, 10, (char *) &wkstainfo, 
					sizeof(wkstainfo), &total) == 0)
    strcpy(domain, wkstainfo.wksta.wki10_logon_domain);
  else
    strcpy(domain, getline("Logon domain: "));

  strupr(password);
  rc = UPMEULGN(user, password, domain, UPM_DOMAIN, UPM_FL_DOMVER);

  switch (rc)
  {
  case 0:
    printf("The command completed successfully\n");
    break;
  case UPM_LOG_INPROC:
    printf("Another logon already in progress from this machine\n");
    break;
  case UPM_LOGGED:
    printf("You are already logged on from this machine with another user ID\n");
    break;
  case UPM_LOGGED_ELSEWHERE:
    printf("This user ID is already logged on from another machine\n");
    break;
  case UPM_FAIL_SECURITY:
    printf("Incorrect user ID or password\n");
    break;
  case UPM_PROF_NOT_FOUND:
    printf("Unknown user ID\n");
    break;
  case UPM_PASSWORD_EXP:
    printf("Your password is expired\n");
    break;
  case UPM_UNAVAIL:
    printf("The remote machine or domain is not available\n");
    break;
  default:
    printf("UPM error %04X\n", rc);
    break;
  }

  return rc;

}

/* end of netlogon.c */
