/* BACKDASD v1 - OS/2 REXX Script               */
/* Copyright (c) Steve  Sharrad, 04/08/1996     */
/* Backs up IBM OS/2 Warp/Lan Server            */
/* DASD Limits to a file.                       */
/*                                              */
/* Program Information: ssha@henleycol.ac.uk    */
/*                                              */
/* The HENLEY College IT Services Unit 1996.    */
/*                                              */
/* For information about the College, contact   */
/* info@henleycol.ac.uk, or visit               */
/* www.henleycol.ac.uk                          */                         

step=1          /* step informs error handler of function with problem, substep indicates sub-routine */
substep=0
/* Changeable defaults follow    */
'@echo off'
version                 =       '1.00'                  /* version number                       */
release_date            =       '04/08/96'              /* release date of version              */
e_report                =       1                       /* default value for error reporting    */
error_log               =       '\DASD.LOG'             /* default name for error log           */
confirm                 =       0                       /* default value for asking confirmation*/
verbose                 =       0                       /* default value for verbose            */
timewrite               =       0                       /* default value of writing time to file*/

DASDInfo.BufferSize='6018000'

			/* DASD buffersize-6018000 does 1600 limits ok */
DASDInfo.recursive      =       1                       /* default value for recursiveness      */
defext                  =       '.DSD'                  /* default extension of DASD backup file*/

/* Internal defaults follow      */

backuppath              =       ''
backupfile              =       ''
NETWKSTA                =       350
param_num               =       ''
params.0                =       0
NETDASD                 =       750
DASDInfo.DirPath        =       ''
DASDInfo.count          =       0
DASDInfo.EntriesAvail   =       0
SrvName                 =       ''
Netcode                 =       0
Loop                    =       0
exitcode                =       0
wcount                  =       1
schk                    =       0
backup_name             =       ''
step                    =       0
local                   =       1
substep                 =       0
msg                     =       ''
rpath                   =       ''
count                   =       1
sftparm                 =       ''
retcode                 =       0
timewr=timewrite
verb=verbose
conf=confirm

main:  
step=2
say 'BACKDASD Version 'version'   Release 'release_date' (c) Steve Sharrad.'
say 'Internet e-mail: ssha@henleycol.ac.uk'
call time 'r'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Signal on Syntax Name util_load
call SysLoadFuncs 
call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
Signal on Syntax Name lsapi_load
call LoadLsRxutFuncs
Signal on Syntax Name bad_problem
Signal on Error Name bad_problem
step=3
parse upper arg params 
if params = '?' then signal help
if params = '/?' then signal help
if params = 'HELP' then signal help
netcode = NetGetInfo(NETWKSTA, 'wkstaInfo', SrvName)
if netcode <> '0' then signal get_info
SrvName = wkstaInfo.computername
if wkstaInfo.ver_major < '4' then signal wrong_ver
drop wkstaInfo
step=4
	do while params \= ''
		parse var params fword params
		parse var fword 1 swtch +3 swval
		schk=0
		if swtch = '/F:' then do
			step=5
			if left(swval,1) = '"' then do
				if right(swval,1) \= '"' then call encap1
				if right(swval,1) = '"' then swval=strip(swval,,'"')
				end
			if left(swval,1) = ':' then signal need_drive
			backupfile = swval
			call set_name
			schk=1
			end
		else
		if swtch = '/P:' then do
			step=6
			if left(swval,1) = '"' then do
				if right(swval,1) \= '"' then call encap1
				if right(swval,1) = '"' then swval=strip(swval,,'"')
				end
			if left(swval,1) = '\' then signal need_drive
			if left(swval,1) = ':' then signal need_drive
			if left(substr(swval,3),1) \= '\' then signal need_drive
			if left(substr(swval,2),1) \= ':' then signal need_drive
			DASDInfo.DirPath = swval
			if DASDInfo.DirPath='' then signal need_drive
			schk=1
			end
		else
		if swtch = '/L:' then do
			step=7
			if left(swval,1) = '"' then do
				if right(swval,1) \= '"' then call encap1
				if right(swval,1) = '"' then swval=strip(swval,,'"')
				end
			if left(swval,1) = '\' then signal need_drive
			if left(swval,1) = ':' then signal need_drive
			error_log = swval
			schk=1
			end
		else
		if swtch = '/S:' then do
			step=8
			if right(left(swval,2),1) = '\' then do
				if left(swval,1) = '\' then do
					if SrvName=swval then local=1
					else local=0
					SrvName = swval
					end
				end
			if right(left(swval,3),1) = '' then SrvName=''
			if SrvName='' then signal bad_server
			
			schk=1
			end
		else
		if swtch = '/R:' then do
				step=9
				if swval='0' then do
					DASDInfo.recursive=0
					DASDInfo.EntriesAvail=1
					DASDInfo.count=1
					end
				if swval='1' then DASDInfo.recursive=1
				if swval='2' then DASDInfo.recursive=2
				if swval>='3' then signal invalid_recur
			schk=1
			end
		else
		if swtch = '/E' then do
			step=10
			schk=1
			e_report=0
			end
		else
		if swtch = '/V' then do
			step=11
			schk=1
			if verbose='0' then verb=1
			if verbose='1' then verb=0
			end
		else
		if swtch = '/C' then do
			step=12
			schk=1
			if confirm= '0' then conf=1
			if confirm= '1' then conf=0
			end
		else
		if swtch = '/T' then do
			step=13
			schk=1
			if timewrite= '0' then timewr=1
			if timewrite= '1' then timewr=0
			end

		else
		if swtch = '/L:' then do
			step=14
			logfile = swval
			schk=1
			end
		else
		if schk = '0' then signal unknown_switch
		if left(swtch,1) = '/' then do
			step=15
			swtch=swtch
			nsw=swval
			end
		p = wordpos(swtch, param_num)
		if p = 0 then do
			step=16
			param_num=param_num swtch
			parno = params.0 + 1
			params.parno = nsw
			params.0 = parno
			end
		else do
			step=17
			params.p = nsw
			end
		end

if local=1 then do
	step=18
	signal on error name bad_dir 
	if right(DASDInfo.DirPath,2)='\"' | right(DASDInfo.DirPath,1) = '\' then do
		cmdline='dir "'DASDInfo.DirPath'" >nul'
		cmdline
		end
	else 
	cmdline='dir "'DASDInfo.DirPath'\" >nul'
	cmdline
	end
	signal on error name bad_problem
step=19
if local=0 then call chk_remote
if DASDInfo.DirPath='' then signal nobackup_path
if backupfile='' then signal nobackup_file
if conf='1' then do
	step=20
	call display_info
	call confirm_first
	end
if verb=1 then
	if conf='0' then do
		call display_info
	end

if filefind(backupfile) then do
	step=21
	call get_name
	call create_backup
	end
step=22
dataline='DASD BACKUP FILE PRODUCED BY BACKDASD (programmed by Steve Sharrad).'
wcount = lineout(backupfile,dataline)
if wcount=1 then signal fail_write
say ' DASD limit backup file is 'backupfile
say ' Enumerating DASD limit(s)...'
step=23
if DASDInfo.recursive=2 then do
	step=24
	origpath=DASDInfo.DirPath
	if rpath \= '' then do
		step=25
		rpath=rpath'\'
		DASDInfo.DirPath='"'rpath'"'
		end
	step=26
	if right(DASDInfo.DirPath,1) \= '\' then if rpath = '' then rpath=DASDInfo.DirPath'\' 
	if right(DASDInfo.DirPath,1) = '\' then if rpath = '' then rpath=DASDInfo.DirPath
	sftparm='DO'
	count=0
	retrieved.0=1
	loop=0
	end

if DASDInfo.recursive=0 then do
	step=27
	origpath=DASDInfo.DirPath
	if rpath \= '' then rpath='"'rpath'\"'
	if rpath = '' then rpath=DASDInfo.DirPath
	sftparm='DO'
	count=0
	retrieved.0=1
	loop=0
	step=28
	DASDInfo.max=''
	netcode=NetGetInfo(NETDASD, 'DASDInfo',Srvname)
	if left(netcode,4) = '2117' then signal redir_path
	if left(netcode,4) = '2301' then signal not_enabled
	if left(netcode,4) = '2303' then signal not_386hpfs
	if netcode <> '0' then signal unknown_problem
	step=29
	if DASDInfo.max \= '0' then do
	DASDInfo.count.resource_name=right(DASDInfo.DirPath,length(DASDInfo.DirPath)-length(OrigPath))
			step=30
			DASDInfo.0.max=DASDInfo.max
			DASDInfo.0.thresh=DASDInfo.thresh
			DASDInfo.0.delta=DASDInfo.delta
			count=1
			end
	if count=0 then signal no_limits
	end

if DASDInfo.recursive=1 then do
	step=31
	origpath=DASDInfo.DirPath
	if rpath \= '' then rpath='"'rpath'\"'
	if right(DASDInfo.DirPath,1) \= '\' then if rpath = '' then rpath=DASDInfo.DirPath'\' 
	if right(DASDInfo.DirPath,1) = '\' then if rpath = '' then rpath=DASDInfo.DirPath
	count=0
	retrieved.0=0
	loop=1
	sftparm='DOS'
	end

if DASDInfo.recursive = '1' then do
drop count
step=32
netcode = NetEnumerate(NETDASD, 'DASDInfo', SrvName)
if left(netcode,4) = '2117' then signal redir_path
if left(netcode,4) = '2301' then signal not_enabled
if left(netcode,2) = '53' then signal unknown_problem
if left(netcode,4) = '2303' then signal not_386hpfs
if netcode <> '0' then signal unknown_problem
if DASDInfo.EntriesAvail='0' then signal no_limits
if DASDInfo.EntriesAvail>DASDInfo.count then call stack_space
if DASDInfo.EntriesAvail=1 then
	if DASDInfo.1.resource_name='' then
		DASDInfo.1.resource_name=DASDInfo.DirPath
if DASDInfo.recursive='0' then do
	step=33
	if DASDInfo.max='0' then signal no_limits
	DASDInfo.1.max=DASDInfo.max
	DASDInfo.1.thresh=DASDInfo.thresh
	DASDInfo.1.delta=DASDInfo.delta
	DASDInfo.1.resource_name=''
	end
count=DASDInfo.count
end

step=34

if DASDInfo.recursive = 2 then do
retcode=SysFileTree(rpath,'retrieved',sftparm)

if DASDInfo.recursive = 0 then i=0
else i=1
	do i=0 to Retrieved.0
		step=35
		if i>0 then DASDInfo.DirPath=retrieved.i
		if i=0 then DASDInfo.DirPath=origpath
	if i \= 0 then if local=0 then call get_local
		DASDInfo.max=''
		netcode=NetGetInfo(NETDASD, 'DASDInfo',Srvname)
		if left(netcode,4) = '2117' then signal redir_path
		if left(netcode,4) = '2301' then signal not_enabled
		if left(netcode,4) = '2303' then signal not_386hpfs
		if netcode <> '0' then signal unknown_problem
		if DASDInfo.max \= '0' then do
			step=36
			DASDInfo.count.resource_name=right(DASDInfo.DirPath,length(DASDInfo.DirPath)-length(OrigPath))
			DASDInfo.count.max=DASDInfo.max
			DASDInfo.count.thresh=DASDInfo.thresh
			DASDInfo.count.delta=DASDInfo.delta
			count=count+1
			end
	end
if count = '0' then signal no_limits
end
step=37
say ' Writing data to backup file ('count' entries)...'
origpath='"'origpath'"'
dataline='/T:'time('N')' /D:'date('E') '/S:'SrvName' /N:'count' /R:'DASDInfo.recursive' /P:'origpath' /V:'version
call lineout backupfile,dataline

if DASDInfo.recursive = 0 | DASDInfo.recursive = 2 then count=count-1

do until Loop>count
step=38
DASDInfo.Loop.resource_name='"'DASDInfo.Loop.resource_name'"'
if verb=1 | conf=1 then do
	step=25
	say ' '
	say ' Backed up DASD limits for: 'SrvName': 'strip(origpath,,'"')''strip(DASDInfo.Loop.resource_name,,'"') 

	end
	dataline='/1:'DASDInfo.Loop.resource_name' /2:'DASDInfo.Loop.max' /3:'DASDInfo.Loop.thresh' /4:'DASDInfo.Loop.delta
	wcount = lineout(backupfile,dataline)
	if wcount=1 then signal fail_write
	Loop=Loop+1
end
step=39
call stream backupfile,'c','close'
call stream logfile,'c','close'
step=40
if count=0 & if DASDInfo.recursive = 1 | DASDInfo.recursive = 2 then count=count+1
say ' Number of DASD limits backed up to 'backupfile' : ' count
signal end

encap1:
substep=1
lstring=swval
do while params \= ''
	i=length(params) 
	parse var params fword params
	j=length(params)
	if j \=0 then j=j+1
	k=length(fword)
	l=i-j-k
	do while l>=0
		lstring=lstring' '
		l=l-1
		end
	lstring=lstring''fword
	if right(fword,1) = '"' then fin=1
	p = wordpos(swtch, param_num)
		if p = 0 then do
			step=12
			param_num=param_num swtch
			parno = params.0 + 1
			params.parno = nsw
			params.0 = parno
			end
		else do
			step=13
			params.p = nsw
			end
if fin=1 then do
	substep=2
	i=length(lstring)
	swval=strip(lstring,,'"') 
/*      drop i */
	drop fin
	drop j
	drop k
	drop l
	drop lstring
	return
end
return

help:
step=31
say ' '
say 'Backs up DASD directory limits on 386-HPFS DASD-enabled volumes.'
say 'BACKDASD backs up all DASD information for a specified path into'
say 'a backup file. You can then use RESTDASD to restore this file.'
say ' '
say 'The syntax of this command is:'
say 'BACKDASD /F:[filename] /P:[pathname] [/R:[value]] [/L:[filename]] [/S:\\[servername]] [[/E]] [[/C]] [[/V]] [[/T]]'
say ' '
say 'Required Parameters: /F:[filename] Specify a filename to backup to'
say '                                   Default extension is 'defext
say '                /P:[pathname]      Specify the pathname/tree to backup'
say 'Optional Parameters: /R:[value]            Specify 0 to turn off recursive backup'
say '                                   Specify 1 (default) to backup all sub-'
say '                                   directories, or 2 to backup only sub-'
say '                                   directories upto 1 level down.'
say '                /L:[filename]      Specify a different errorlog filename'
say '                                   Defaults to 'error_log
say '                /S:\\[server]      Specify a valid server on domain. If'
say '                                   used, then pathname must be on server'
say '                /E                 Turns-off the error logging to file'
'pause'
say '                /C                 Displays info and asks for confirmation'
say '                /V                 Displays information during process'
say '                /T                 Write the operation time and backup'
say '                                   count to error log upon completion'
say ' '
say 'BACKDASD 1.00      -  Copyright 1996, Steve Sharrad.'
say '                      Copyright 1996, The HENLEY College.'
say 'This program may be freely copied so long as it is not modified.'
say 'All rights reserved. For further information, view help file.'
exitcode=0
signal finito

nobackup_path:
say ' '
say 'BACKDASD 0002: You must specify a valid path for BACKDASD to back up'
say 'with the /P:[path] switch.'
say ' '
say 'This must be a qualified pathname, i.e. C:\USERS, not USERS.'
say 'Type BACKDASD /? for help'
exitcode=2
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0002: Invalid backup path or path not specified.'
call lineout error_log,logline
signal end

nobackup_file:
say ' '
say 'BACKDASD 0003: You must specify a filename for BACKDASD to backup'
say 'DASD limits to with the /F:[filename] switch.'
say ' '
say 'Type BACKDASD /? for help'
exitcode=3
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0003: No backup file specified'
call lineout error_log,logline
signal end

invalid_recur:
say ' '
say 'BACKDASD 0004: You have specified an invalid parameter for the recursive'
say 'option. Use /R:[x] where x is either 1 (default) or 0 to inhibit action'
say 'on sub-directories'
exitcode=4
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0004: Invalid value for /R: (Recursive) specified.'
call lineout error_log,logline
signal end

stack_space:
say ' '
step=42
say "BACKDASD 0005: Warning: Failing due to insufficient stack space."
say " "
say "There are too many DASD limits present for BACKDASD to fully comply."
say "Try increasing BACKDASD's stack space by increasing the"
say "DASDInfo.BufferSize parameter in the BACKDASD.CMD file."
say ' '
say "Continuing to backup the collected limits within the confined stack space."
say " "
say 'Number of entries available (truncated): ' DASDInfo.EntriesAvail
say 'Number of entries actually backed up   : ' DASDInfo.count
say 'Current buffer size                    : ' DASDInfo.BufferSize
say 'Suggested required buffer size         : ' format(DASDInfo.BufferSize/DASDInfo.count * DASDInfo.EntriesAvail,,0)
say ' '
exitcode=5
if e_report = '0' then return
say 'Details will also be written to log file.'
call write_header
logline="BACKDASD 0005: Warning: Failing due to insufficient stack space."
call lineout error_log,logline
logline="There are too many DASD limits present for BACKDASD to fully comply."
call lineout error_log,logline
logline="Try increasing BACKDASD's stack space by increasing the"
call lineout error_log,logline
logline="DASDInfo.BufferSize parameter in the BACKDASD.CMD file."
call lineout error_log,logline
logline="Continuing to backup the collected limits within the confined stack space."
call lineout error_log,logline
logline='Number of entries available (truncated): ' DASDInfo.EntriesAvail
call lineout error_log,logline
logline='Number of entries actually backed up   : ' DASDInfo.count
call lineout error_log,logline
logline='Current buffer size                    : ' DASDInfo.BufferSize
call lineout error_log,logline
logline='Suggested required buffer size         : ' format(DASDInfo.BufferSize/DASDInfo.count * DASDInfo.EntriesAvail,,0)
call lineout error_log,logline
say ' '
return

not_enabled:
say ' '
say 'BACKDASD 0006: (NET 2301) DASD limits are not enabled on the specified'
say '386-HPFS volume. Enable DASD limits using the NET DASD command.'
say 'Use NET HELP DASD for more information.'
exitcode=6
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0006: (NET 2301) DASD limits are not enabled on specified drive.'
call lineout error_log,logline
signal end

not_386hpfs:
say ' '
say 'BACKDASD 0007: (NET 2303) DASD limits are only supported on 386-HPFS'
say 'volumes, not FAT disks. Use NET HELP DASD for more information.'
exitcode=7
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0007: (NET 2303) Not a 386HPFS volume.'
call lineout error_log,logline
signal end

unknown_problem:
say ' '
say 'BACKDASD 0008: (NET 'netcode')'
say 'Could not perform DASD operation for an unknown reason (check error code'
say 'above in brackets). Check that the server 'SrvName' is running and that'
say 'you have specified valid pathnames and/or servernames.'
exitcode=8
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0008: (NET 'netcode')'
call lineout error_log,logline 
logline='Check specified servernames and pathnames.'
call lineout error_log,logline
signal end

need_drive:
say ' '
say 'BACKDASD 0009: You need to specify a fully qualified drive and pathname'
say 'to be backed up:'
say ' '
say '   i.e.    /P:C:\USERS     is acceptable'
say '           /P:\USERS       is not acceptable'
say ' '
say 'If you specify a servername (/S:\\[SrvName]) then you must specify a pathname'
say 'which is not a redirected pathname, i.e. to backup the D drive of server'
say 'APPSRV then you must specifiy /P:D:\ /S:\\APPSRV'
say 'Check also that all filenames that you have given are valid.'
exitcode=9
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0009: Drive and pathname not fully specified or incorrect filename'
call lineout error_log,logline
signal end

fail_write:
say ' '
say 'BACKDASD 0010: An error occurred while writing to disk. '
say 'Could not write to file 'backupfile
say 'If you are using the FAT file system, check the size of the filename. Also'
say 'check disk space and that the backup file is not read-only and that you'
say 'can write to it.'
say ' '
say 'Also check that all pathnames and directory names you have given are valid'
exitcode=10
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0010: Error occurred writing to disk. Check paths, permissions and space.'
call lineout error_log,logline
signal end

bad_server:
say ' '
say 'BACKDASD 0011: The server name you have specified should start with two'
say 'backslashes (\\) and then the servername. The server should be on the'
say 'default domain.'
exitcode=11
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0011: Servername specified does not start "\\" or is empty.'
call lineout error_log,logline
signal end

no_limits:
call stream backupfile,'c','close'
if filefind(backupfile) then rc=SysFileDelete(backupfile)
say ' '
say 'BACKDASD 0012: Warning! No DASD limits found for backing up.'
say 'There may be no DASD limits on the path you have specified.'
exitcode=12     
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0012: Warning! No DASD limits found - check existence of limits.'
call lineout error_log,logline
signal end
end

unknown_switch:
say ' '
say 'BACKDASD 0013: Unknown or incomplete switch on command line.'
say ' '
say 'The option "'swtch''swval'" is unknown.'
say 'Type BACKDASD /? for help.'
exitcode=13
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0013: Incorrect or unknown switch on command line.'
call lineout error_log,logline
signal end

bad_problem:
error:
say ' '
say 'BACKDASD 0014: BACKDASD has encountered an internal error.'
say 'Please check available memory and stack space. Report this'
say 'problem and how you created it together with the information'
say 'below to internet e-mail: ssha@henleycol.ac.uk:'
say ' '
elapsed = time('e') % 1
minutes = elapsed % 60
seconds = elapsed // 60
say 'Debug Information: '
say 'Error RC: 'rc'     Elapsed Time:'minutes' 'seconds
say 'Buffersize:   'DASDInfo.BufferSize'    Error Handler: 00014'
say 'Version: 'version'   Release: 'release_date '   DASD: 'DASDInfo.recursive
say ' Step: 'step'         Substep: 'substep
say 'Count: 'count'          Loop: 'loop'        Local: 'local
say ' Verb: 'verb'           Conf: 'conf'       Timewr: 'timewr
say ' '
say 'Description of error:'
say ' '
msg=SysGetMessage(rc)
say msg
exitcode=14
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0014: Fatal Internal error. Error: 'rc
call lineout error_log,logline
logline='Error Description: 'msg
call lineout error_log,logline
signal end
end

lsapi_load:
If rc=43 Then Do
	say ' '
	say 'BACKDASD 0015: BACKDASD failed to correctly initialise the'
	say 'network API support module, LSRXUT.DLL.'
	say ' '
	say 'Please check that the file LSRXUT.DLL resides in any sub-'
	say 'directory pointed to the LIBPATH statement in your CONFIG.SYS'
	say 'file. If this file exists, then check the amount of available'
	say 'memory and/or stack space available.'
	say ' '
	exitcode=15
	if e_report = '0' then signal end
	call write_header
	logline='BACKDASD 0015: Failed to initialise API module LSRXUT.DLL.'
	call lineout error_log,logline
	signal finito
	end
else signal bad_problem
end

util_load:
If rc=43 Then Do
	say ' '
	say 'BACKDASD 0016: BACKDASD failed to correctly initialise the'
	say 'advanced REXX function module, REXXUTIL.DLL'
	say ' '
	say 'Please check that the file REXXUTIL.DLL resides in any sub-'
	say 'directory pointed to the LIBPATH statement in your CONFIG.SYS'
	say 'file. If this file exists, then check the amount of available'
	say 'memory and/or stack space available.'
	say ' '
	exitcode=16
	if e_report = '0' then signal end
	call write_header
	logline='BACKDASD 0016: Failed to initialise base OS/2 module REXXUTIL.'
	call lineout error_log,logline
	signal finito
	end
else signal bad_problem
end

no_backup:
say ' '
say 'BACKDASD 0017: An error occurred while copying or deleting one of the'
say 'following files: 'backup_name' or 'backupfile
say ' '
say 'Please check that none of these files are read-only and that sufficient'
say 'disk space is available.'
exitcode=13
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0017: The destination file is read only or backup could not be made.'
call lineout error_log,logline
signal finito
end

bad_dir:
say ' '
say 'BACKDASD 0018: You have specified a bad directory or pathname to be'
say 'backed up. Check that the path exists.'
exitcode=18
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0018: The path specified to have its limits backed up does not seem to exist.'
call lineout error_log,logline
signal finito
end

get_info:
say ' '
say 'BACKDASD 0019: Could not get local machine network information.'
say 'Check that the server and requester are running correctly.'
exitcode=19
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0019: Could not get local machine network information.'
call lineout error_log,logline
signal finito
end

wrong_ver:
say ' '
say 'BACKDASD 0020: DASD limits (and BACK/REST DASD) are not'
say 'on versions of IBM OS/2 Lan Server or Warp Server prior to version 4.'
exitcode=20
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0020: Version of Lan Server too old.'
call lineout error_log,logline
signal finito
end

fail_remote:
say ' '
say 'BACKDASD 0023: The path on the remote server cannot be found.'
say 'Check that the remote server is running and that the pathname is'
say 'correct.'
say ' '
say 'Also note that if you are operating on a remote server, then'
say 'you will also need to be logged on to the local workstation.'
exitcode=23
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0023: The path on the remote server cannot be found. '
call lineout error_log,logline
signal finito
end

redir_path:
say ' '
say 'BACKDASD 0024: You cannot specify a redirected resource for DASD'
say 'operations. If you wish to backup a remote server, use the'
say '/S:\\[servername] switch with the /P: switch pointing to a local'
say 'drive on that server'
exitcode=24
if e_report = '0' then signal end
call write_header
logline='BACKDASD 0024: Redirected resources cannot be specified.'
call lineout error_log,logline
signal finito
end

chk_remote:
substep=3
i=length(DASDInfo.DirPath)
signal on error name fail_remote
rpath=SrvName'\'left(DASDInfo.DirPath,1)'$'right(DASDInfo.DirPath,i-2)
if right(rpath,1)='\' then do
	substep=4
	cmdline='dir "'rpath'" >nul'
	cmdline
	end
else do
	substep=5
	cmdline='dir "'rpath'\" >nul'
	cmdline
	end
signal on error name bad_problem
return

get_local:
substep=6
l=length(DASDInfo.DirPath)
s=length(SrvName)
s=s+1
DASDInfo.DirPath=right(DASDInfo.DirPath,l-s)
ldrive=left(DASDInfo.DirPath,1)
s=s+2
substep=7
DASDInfo.DirPath=right(DASDInfo.DirPath,l-s)
DASDInfo.DirPath=ldrive':'DASDInfo.DirPath
drop s
drop l
drop ldrive
return

write_header:
substep=8
logline='--------- Date: 'date('E')' Time: 'time('N')
wlog=lineout(error_log,logline)
if wlog=1 then say 'BACKDASD 0025: Error writing to error log during operations.'
drop wlog
return

filefind: Procedure
substep=9
return ('' \= stream( arg(1), 'c', 'query exists') )

confirm_first:
substep=10
say ' '
say 'Press Y <enter> to continue, or any other key <enter> to abort.'
parse upper pull c
if c='Y' then return
say 'Operation aborted.'
signal end

display_info:
substep=11
say ' '
say 'BACKDASD will perform the following:'
say ' '
say 'Path to backup DASD limits         : 'DASDInfo.DirPath
say 'File to backup DASD limits to      : 'backupfile
if DASDInfo.recursive = '1' then say 'Backup sub-directories (recursive) : Yes'
if DASDInfo.recursive = '0' then say 'Backup sub-directories (recursive) : No'
if DASDInfo.recursive = '2' then say 'Backup sub-directories (recursive) : Down to one level'
if e_report = '0' then say 'Error log file reports             : Disabled'
if e_report = '1' then say 'Error log file reports written to  : 'error_log
if local=1 then say 'Server Name                        : 'srvname' (local machine)'
else say 'Server Name                        : 'srvname' (remote machine)'
if timewr='1' then say 'Operation time will be written to log upon completion.'
substep=12
if filefind(backupfile) then do
	call get_name
	say ' '
	say 'The backup file 'backupfile' already exists. It will'
	say 'be copied to file 'backup_name' before being overwritten.'
end

get_name:
substep=13
backup_name=''
do i=1 to length(backupfile)
	if left(right(backupfile,i),1) = '.' then backup_name=left(backupfile,length(backupfile)-i)'.BAK'
end
if backup_name='' then do
	substep=14
	backupfile=backupfile'.'
	call get_name
	end
return  

set_name:
substep=15
dot=0
do i=1 to length(backupfile)
	if left(right(backupfile,i),1) = '.' then dot=1
end
if dot=0 then backupfile=backupfile''defext
return  


create_backup:
/* remember if <> is the same as if not */
substep=16
if backup_name='' then call get_name
if filefind(backup_name) then do
	substep=17
	rc=SysFileDelete(backup_name)
	if rc <> '0' then signal no_backup
	end
cmdline='copy "'backupfile'" "'backup_name'" >nul'
cmdline
if filefind(backup_name) then do
	substep=18
	rc=SysFileDelete(backupfile)
	if rc <> '0' then signal no_backup
	end
else signal no_backup
say ' Successfully renamed 'backupfile' to 'backup_name
return

end:
step=27
elapsed = time('e') % 1
minutes = elapsed % 60
seconds = elapsed // 60
say ' '
if exitcode <> '0' then do
	say 'BACKDASD ended encountering at least 1 error or warning.'
	call stream logfile,'c','close'
	end
if exitcode = '0' | exitcode = '5' | exitcode = '12' then do
	say 'Total Operation Time:' minutes' minutes, 'seconds 'seconds.'
	say 'BACKDASD completed successfully.'
	end
if exitcode = '0' | exitcode = '5' | exitcode ='12' then
	if timewr='1' then do
	call write_header
	logline='BACKDASD: Operation successful: Total Operation Time:' minutes' minutes, 'seconds 'seconds.'
	call lineout error_log,logline
	logline='          Number of entries backed up: 'count' of path 'DASDInfo.DirPath
	call lineout error_log,logline
	call stream logfile,'c','close'
	end
signal finito

finito:
drop DASDInfo
drop count
if verb = '1' & if exitcode != '0' then exit exitcode
exit

