/* RESTDASD - OS/2 REXX Script                  */
/* Copyright (c) Steve  Sharrad, 04/08/1996     */
/* Restores IBM OS/2 Warp/Lan Server 4/5        */
/* DASD Limits from a BACKDASD file.            */
/*                                              */
/* Program Information: ssha@henleycol.ac.uk    */
/*                                              */
/* The HENLEY College IT Services Unit 1996     */
/*                                              */
/* For information about the College, contact   */
/* info@henleycol.ac.uk, or visit               */
/* www.henleycol.ac.uk                          */                         

/* Changeable defaults follow    */

step=1          /* step informs error handler of function with problem, substep indicates sub-routine */
substep=0
'@echo off'
version                 =       '1.00'                  /* version number                       */
release_date            =       '04/08/96'              /* release date of this version         */
e_report                =       1                       /* default value of logging error file  */
backuppath              =       ''                      /* default backuppath - don't use!      */
backupfile              =       ''                      /* default backupfile - don't use!      */
error_log               =       '\DASD.LOG'             /* default name and location of errorlog*/
confirm                 =       1                       /* default - ask for confirmation y/n   */
verbose                 =       0                       /* default - report verbosely           */
defext                  =       '.DSD'                  /* default extension for DASD files     */
timewrite               =       0

/* Internal defaults follow      */
bakdir                  =       0
NETWKSTA                =       350                     /* API function number */
param_num               =        ''
params.0                =        0
head_num                =        ''
header.0                =        0
dinfo_num               =        ''
dinfo.0                 =        0
NETDASD                 =       750
DASDInfo.recursive      =       1
DASDInfo.DirPath        =       ''
SrvName                 =       ''
BackupSrvName           =       ''
Netcode                 =       0
Loop                    =       1
exitcode                =       0
wcount                  =       1
schk                    =       0
backup_name             =       ''
step                    =       0
overpath                =       0
overrec                 =       0
overserv                =       0
local                   =       1
difserv                 =       0
fitter                  =       0
larger                  =       0
local                   =       1
substep                 =       0
msg                     =       ''
dispinf                 =       0
whead                   =       0
rcount                  =       0
timewr=timewrite
fit=fitter
large=larger
verb=verbose
conf=confirm

parameter               = 'max'
parmValue               = 512

RESTInfo.resource_name  = ''
RESTInfo.max            = 0
RESTInfo.thresh         = 0
RESTInfo.delta          = 0

main:  
say 'RESTDASD Version 'version'   Release 'release_date' (c) Steve Sharrad'
say 'Internet e-mail: ssha@henleycol.ac.uk'
call time 'r'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Signal on Syntax Name util_load
call SysLoadFuncs 
call RxFuncAdd 'LoadLsRxutFuncs', 'LSRXUT', 'LoadLsRxutFuncs'
Signal on Syntax Name lsapi_load
call LoadLsRxutFuncs
Signal on Syntax Name bad_problem
Signal on Error Name bad_problem 
step=2
parse upper arg params 
if params = '?' then signal help
if params = '/?' then signal help
if params = 'HELP' then signal help
netcode = NetGetInfo(NETWKSTA, 'wkstaInfo', SrvName)
if netcode <> '0' then signal get_info
SrvName = wkstaInfo.computername
if wkstaInfo.ver_major < '4' then signal wrong_ver
step=3
drop wkstaInfo
if params='' then signal nobackup_file
	do while params \= ''      
		parse var params fword params
		parse var fword 1 swtch +3 swval
		schk=0
		if swtch = '/F:' then do
			step=4
			if left(swval,1) = '"' then do
				if right(swval,1) \= '"' then call encap1
				if right(swval,1) = '"' then swval=strip(swval,,'"')
				end
			if left(swval,1) = ':' then signal need_drive
			backupfile = swval
			call set_name
			if filefind(backupfile) then do
				call read_header
				end
			else signal fail_write
			schk=1
			end

		else
		if swtch = '/P:' then do
			step=5
			if left(swval,1) = '"' then do
				if right(swval,1) \= '"' then call encap1
				if right(swval,1) = '"' then swval=strip(swval,,'"')
				end
			if left(swval,1) = '\' then signal need_drive
			if left(swval,1) = ':' then signal need_drive
			if right(swval,1) = ':' then signal need_drive
			if length(swval) >= 4 & right(swval,1) = '\' then signal need_drive
			if left(substr(swval,3),1) \= '\' then signal need_drive
			if left(substr(swval,2),1) \= ':' then signal need_drive
			DASDInfo.DirPath = swval
			if DASDInfo.DirPath='' then signal need_drive
			schk=1
			end

		else
		if swtch = '/L:' then do
			step=6
			if left(swval,1) = '"' then do
				if right(swval,1) \= '"' then call encap1
				if right(swval,1) = '"' then swval=strip(swval,,'"')
				end
			if left(swval,1) = '\' then signal need_drive
			if left(swval,1) = ':' then signal need_drive
			error_log = swval
			schk=1
			end
		else
		if swtch = '/S:' then do
			step=7
			overserv=1
			if right(left(swval,2),1) = '\' then do
				if left(swval,1) = '\' then do
					if SrvName=swval then local=1
					else local=0
					BackupSrvName = swval
					end
				end
			if right(left(swval,3),1) = '' then BackupSrvName=''
			if BackupSrvName='' then signal bad_server
			schk=1
			end
		else
		if swtch = '/R:' then do
				step=8
				if swval \= DASDInfo.recursive then overrec=1
				if swval='0' then do
					DASDInfo.recursive=0
					DASDInfo.EntriesAvail=1
					DASDInfo.count=1
					end
				if swval='1' then DASDInfo.recursive=1
				if swval='2' then DASDInfo.recursive=2
				if swval>='3' then signal invalid_recur
			schk=1
			end
		else
		if swtch = '/E' then do
			step=9
			schk=1
			e_report=0
			end
		else
		if swtch = '/V' then do
			step=10
			schk=1
			if verbose='0' then verb=1
			if verbose='1' then verb=0
			end
		else
		if swtch = '/L' then do
			step=11
			schk=1
			if larger='0' then large=1
			if larger='1' then large=0
			end
		else
		if swtch = '/F' then do
			step=12
			schk=1
			if fitter='0' then fit=1
			if fitter='1' then fit=0
			end
		else

		if swtch = '/I' then do
			step=13
			dispinf=1
			schk=1
			end
		else

		if swtch = '/T' then do
			step=14
			schk=1
			if timewrite= '0' then timewr=1
			if timewrite= '1' then timewr=0
			end

		else

		if swtch = '/A' then do
			step=15
			schk=1
			if confirm= '0' then conf=1
			if confirm= '1' then conf=0
			end
		else
		if swtch = '/L:' then do
			step=16
			logfile = swval
			schk=1
			end
		else
		if schk = '0' then signal unknown_switch
		if left(swtch,1) = '/' then do
			step=17
			swtch=swtch; 
			nsw=swval
			end
		p = wordpos(swtch, param_num)
		if p = 0 then
			do
			step=18
			param_num=param_num swtch
			parno = params.0 + 1
			params.parno = nsw
			params.0 = parno
			end
		else do
			step=19
			params.p = nsw
			end
		end

if backupfile='' then signal nobackup_file

if dispinf='1' then do
	say ' '
	step=20
	call display_info
	step=21
	call stream backupfile,'c','close'
	signal end
	end

step=23
if filerec = '2' & if DASDInfo.Recursive = '1' then signal recur_not
if filerec = '0' & if DASDInfo.Recursive \='0' & if overrec = '1' then signal recur_not
if filerec = '0' then DASDInfo.Recursive = 0

step=24
if local=1 then do
	signal on error name bad_dir 
	if right(DASDInfo.DirPath,1)='\' then do
		step=25
		cmdline='dir 'DASDInfo.DirPath' >nul'
		cmdline
		end
	else do 
	step=26
	cmdline='dir 'DASDInfo.DirPath'\ >nul'
	cmdline
	signal on error name bad_problem
	end
end
step=27
if local=0 then call chk_remote
if BackupSrvName \= fileserv & overserv=1 then difserv=1
if BackupSrvName \= SrvName & BackupSrvName \= fileserv then difserv=1
if bakdir=1 then signal bad_bakfiledir
if conf='1' then do
		step=28
		call display_info
		call display_perform
		call confirm_first
		end

if verb=1 then
	if conf='0' then do
		step=29
		call display_info
		call display_perform
	end

say ' '
say ' Restoring limit(s)...'
step=30
dest=DASDInfo.DirPath
recur=DASDInfo.recursive
SrvName=BackupSrvName
do until loop>backentries
call read_data
step=31
doit=1
drop DASDInfo
drop DirPath
if right(dest,1) \= '\' & left(RESTInfo.Resource_name,1) \= '\' & length(RESTInfo.Resource_name) >= 2 then RESTInfo.Resource_name='\'RESTInfo.resource_name
DASDInfo.DirPath=dest''RESTInfo.Resource_name
if DASDInfo.DirPath=dest | recur=1 | recur=2 & lastpos('\',right(DASDInfo.DirPath,length(DASDInfo.DirPath)-length(dest),1)) <= '1' then do
	step=32
	netcode = NetGetInfo(NETDASD, 'DASDInfo', SrvName)
	if left(netcode,1) = '3' then do
		step=33
		dataline='RESTDASD 0026: Path 'SrvName'\'DASDInfo.DirPath' does not exist or cannot be accessed'
		say dataline
		if e_report = '1' then do
			step=34
			if whead=0 then call write_header
				call lineout error_log,dataline
				end
		doit=0
		netcode = 0
	end
if left(netcode,4) = '2117' then signal redir_path
if left(netcode,4) = '2301' then signal not_enabled
if left(netcode,2) = '53' then signal unknown_problem
if left(netcode,4) = '2303' then signal not_386hpfs
if netcode <> '0' then  signal unknown_problem
step=35
/* next line ensures upper case */
RESTInfo.resource_name=DASDInfo.resource_name
if fit=1 then
if RESTInfo.max < DASDInfo.use then
	if doit=1 then
		if RESTInfo.max \= DASDInfo.use then do
		step=36
		doit=0
		dataline='RESTDASD 0027: 'SrvName'\'DASDInfo.DirPath' would not fit within proposed limit of 'RESTInfo.max
		say ' '
		say dataline
		if e_report = '1' then do
			step=37
			if whead=0 then call write_header
				call lineout error_log,dataline
				end
		
end
if large=1 then
if DASDInfo.max > RESTInfo.max then 
	if doit=1 then 
		if RESTInfo.max \= DASDInfo.max then do
		doit=0
		step=38
		dataline='RESTDASD 0028: 'SrvName'\'DASDInfo.DirPath' already has a larger limit than 'RESTInfo.max
		say ' '
		say dataline
		if e_report = '1' then do
			step=39
			if whead=0 then call write_header
				call lineout error_log,dataline
				end
		end
step=40
DASDInfo.resource_name=RESTInfo.resource_name
DASDInfo.flag=1
DASDInfo.max=RESTInfo.max
DASDInfo.thresh=RESTInfo.thresh
DASDInfo.delta=RESTInfo.delta
if doit=1 then do
	step=41
	Flag=1
	parameter="max"
	parmValue=RESTInfo.max
	netcode = NetSetInfo(NETDASD, parameter, RESTInfo.max, SrvName, DASDInfo.resource_name, Flag)
	if left(netcode,4) = '2306' then do
		step=42
		drop Flag
		DASDInfo.flag=1;
		netcode = NetAdd(NETDASD, 'DASDInfo', SrvName)
		if left(netcode,4) = '2301' then signal not_enabled
		if left(netcode,2) = '53' then signal unknown_problem
		if left(netcode,4) = '2303' then signal not_386hpfs
		if netcode <> '0' then signal unknown_problem
		rcount=rcount+1
		if verb=1 then do
			step=43
			say ' '
			say ' New limit restored to 'SrvName'\'DASDInfo.DirPath', values 'DASDInfo.max','DASDInfo.thresh','DASDInfo.delta
			end
		end
	else do
		step=44
		parameter='thresh'
		parmValue=RESTInfo.thresh
		netcode = NetSetInfo(NETDASD, parameter, RESTInfo.thresh, SrvName, DirPath, Flag)
		step=45
		parameter='delta'
		parmValue=RESTInfo.delta
		step=46
		netcode = NetSetInfo(NETDASD, parameter, RESTInfo.delta, SrvName, DirPath, Flag)
		rcount=rcount+1
		if verb=1 then do
			step=47
			say ' '
			say ' Existing limit reset to 'SrvName'\'DASDInfo.DirPath', size 'DASDInfo.max','DASDInfo.thresh','DASDInfo.delta
			end
	end
end 
/* loop=loop+1 */
end
loop=loop+1
end
say ' '
say 'Limits successfully restored: 'rcount' ('backentries-rcount' failed).'
signal finito

else do
loop=loop+1
end
signal finito

encap1:
substep=1
lstring=swval
do while params \= ''
	i=length(params) 
	parse var params fword params
	j=length(params)
	if j \=0 then j=j+1
	k=length(fword)
	l=i-j-k
	do while l>=0
		lstring=lstring' '
		l=l-1
		end
	lstring=lstring''fword
	if right(fword,1) = '"' then fin=1
	p = wordpos(swtch, param_num)
		if p = 0 then do
			param_num=param_num swtch
			parno = params.0 + 1
			params.parno = nsw
			params.0 = parno
			end
		else do
			params.p = nsw
			end
if fin=1 then do
	substep=2
	i=length(lstring)
	swval=strip(lstring,,'"') 
	drop fin
	drop j
	drop k
	drop l
	drop lstring
	return
end
return

encap2:
substep=3
lstring=swval2
do while header \= ''
	i=length(header) 
	parse var header hword header
	j=length(header)
	if j \=0 then j=j+1
	k=length(hword)
	l=i-j-k
	do while l>=0
		lstring=lstring' '
		l=l-1
		end
	lstring=lstring''hword
	if right(hword,1) = '"' then fin=1
	pp = wordpos(swtch2, head_num)
		if pp = 0 then do
			head_num=head_num swtch2
			headp = header.0 + 1
			header.headp = nsw2
			header.0 = headp
			end
		else do
			header.pp = nsw2
			end

if fin=1 then do
	substep=4
	i=length(lstring)
	swval2=strip(lstring,,'"') 
/*      drop i */
	drop fin
	drop j
	drop k
	drop l
	drop lstring
	return
end
return

encap3:
substep=5
lstring=swval3
do while dinfo \= ''
	i=length(dinfo) 
	parse var dinfo dword dinfo
	j=length(dinfo)
	if j \=0 then j=j+1
	k=length(dword)
	l=i-j-k
	do while l>=0
		lstring=lstring' '
		l=l-1
		end
	lstring=lstring''dword
	if right(dword,1) = '"' then fin=1
	dpp = wordpos(swtch3, dinfo_num)
		if dpp = 0 then
			do
			dinfo_num=dinfo_num swtch3
			dinfop = dinfo.0 + 1
			dinfo.dinfop = nsw3
			dinfo.0 = dinfop
			end
		else do
			dinfo.dpp = nsw3
			end
if fin=1 then do
	substep=6
	swval3=strip(lstring,,'"') 
	drop i 
	drop fin
	drop j
	drop k
	drop l
	drop lstring
	return
end
return

help:
step=48
say ' '
say 'Restores DASD directory limits on 386-HPFS DASD-enabled volumes'
say 'from backup files created using BACKDASD.'
say ' '
say 'The syntax of this command is:'
say 'RESTDASD /F:[filename] /P:[pathname] [/R:[value]] [/L:[filename]] [/S:\\[servername]] [[/E]] [[/A]] [[/V]] [[/L]] [[F]] [[/T]] [[/I]]'
say ' '
say 'Required Parameters: /F:[filename] Specify a filename to restore from'
say '                                   Default extension is 'defext
say 'Optional Parameters: /P:[pathname] Specify the pathname/tree to restore'
say '                                   to. Defaults to value in backup file'
say '                /R:[value]         Specify 0 to turn off recursive restore'
say '                                   Defaults to value in backup file (which'
say '                                   may be 0, 1 or 2 (see help). You may'
say '                                   also specify 2 even if the file con-'
say '                                   tains all sub-directories'
say '                /L:[filename]      Specify a different errorlog filename'
say '                                   Defaults to 'error_log
say '                /S:\\[server]      Specify a valid server on domain. If'
say '                                   used, then pathname must be on server'
'pause'
say '                /E                 Turns-off the error logging to file'
say '                /A                 Bypasses any stop for confirmation'
say '                                   and does not display information'
say '                /V                 Displays information during process'
say '                /L                 Do not restore a DASD limit if any'
say '                                   existing limit is larger'
say '                /F                 Do not restore a DASD limit if the'
say '                                   resource would already not fit in limit'
say '                /T                 Write the operation time and backup'
say '                                   count to error log upon completion'
say '                /I                 Identify the named backup file and'
say '                                   report details, then quit.'
say ' '
say 'RESTDASD 1.00      -  Copyright 1996, Steve Sharrad.'
say '                      Copyright 1996, The HENLEY College.'
say 'This program may be freely copied so long as it is not modified.'
say 'All rights reserved. For further information, view help file.'
exitcode=0
signal finito

nobackup_path:
substep=7
say ' '
say 'RESTDASD 0002: You must specify a valid path for RESTDASD to back up'
say 'with the /P:[path] switch.'
say ' '
say 'Type RESTDASD /? for help'
exitcode=2
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0002: Invalid backup path or path not specified.'
call lineout error_log,logline
signal end

nobackup_file:
substep=8
say ' '
say 'RESTDASD 0003: You must specify a filename for RESTDASD to restore'
say 'DASD limits from with the /F:[filename] switch.'
say ' '
say 'Type RESTDASD /? for help'
exitcode=3
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0003: No backup file specified'
call lineout error_log,logline
signal end

invalid_recur:
substep=9
say ' '
say 'RESTDASD 0004: You have specified an invalid parameter for the recursive'
say 'option. Use /R:[x] where x is either 0 to inhibit action on sub-directories.'
say 'Otherwise, this option defaults to the value held in the backup file.'
say 'To find out what value is in the backup file, use the /I option.'
say ' '
say 'You may also specify /R:2 to restore only one level down, even if the backup'
say 'file holds data for all sub-directories.'
exitcode=4
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0004: Invalid value for /R: (Recursive) specified.'
call lineout error_log,logline
signal end

stack_space:
say ' '
say 'Under RESTDASD, this function should never be called. Program terminates'
signal end

not_enabled:
substep=10
say ' '
say 'RESTDASD 0006: (NET 2301) DASD limits are not enabled on the specified'
say '386-HPFS volume. Enable DASD limits using the NET DASD command.'
say 'Use NET HELP DASD for more information.'
exitcode=6
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0006: (NET 2301) DASD limits are not enabled on specified drive.'
call lineout error_log,logline
signal end

not_386hpfs:
substep=11
say ' '
say 'RESTDASD 0007: (NET 2303) DASD limits are only supported on 386-HPFS'
say 'volumes, not FAT disks. Use NET HELP DASD for more information.'
exitcode=7
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0007: (NET 2303) Not a 386HPFS volume.'
call lineout error_log,logline
signal end

unknown_problem:
substep=12
say ' '
say 'RESTDASD 0008: (NET 'netcode')'
say 'Could not perform DASD operation for an unknown reason (check error code'
say 'above in brackets). Check that the server 'SrvName' is running and that'
say 'you have specified valid pathnames and/or servernames.'
exitcode=8
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0008: (NET 'netcode')'
call lineout error_log,logline 
logline='Check specified servernames and pathnames.'
call lineout error_log,logline
signal end

need_drive:
substep=13
say ' '
say 'RESTDASD 0009: You need to specify a fully qualified drive and pathname'
say 'to restore to.'
say ' '
say '   i.e.    /F:C:\USERS     is acceptable'
say '           /F:C:\USERS\    is not acceptable'
say '           /F:\USERS       is not acceptable'
say ' '
say ' If you specify a servername (/S:\\[SrvName]) then you must specify a pathname'
say ' which is not a redirected pathname, i.e. to restore to the D drive of server'
say ' APPSRV then you must specifiy /F:D:\ /S:\\APPSRV'
exitcode=9
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0009: Drive and pathname not fully specified'
call lineout error_log,logline
signal end

fail_write:
substep=14
say ' '
say 'RESTDASD 0010: Could not read from file. '
say 'Could not read file 'backupfile
say 'Check that the file exists and that you have given a valid filename.'
say ' '
say 'Also check that all pathnames and directory names you have given are valid'
exitcode=10
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0010: Error reading file. Check paths and filenames.'
call lineout error_log,logline
signal end

bad_server:
substep=15
say ' '
say 'RESTDASD 0011: The server name you have specified should start with two'
say 'backslashes (\\) and then the servername. The server should be on the'
say 'default domain.'
exitcode=11
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0011: Servername specified does not start "\\" or is empty.'
call lineout error_log,logline
signal end

no_limits:
substep=16
say ' '
say 'RESTDASD 0012: Warning! No DASD limits found for restoring.'
say 'The file you have specified may not contain any valid DASD'
say 'limits and/or the information in it may be corrupted.'
exitcode=12     
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0012: Warning! No valid DASD limits restored from backup file.'
call lineout error_log,logline
signal end
end

unknown_switch:
substep=17
say ' '
say 'RESTDASD 0013: Unknown or incomplete switch on command line.'
say ' '
say 'The option "'swtch''swval'" is unknown.'
say 'Type RESTDASD /? for help.'
exitcode=13
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0013: Incorrect or unknown switch on command line.'
call lineout error_log,logline
signal end

bad_problem:
error:
say ' '
say 'RESTDASD 0014: RESTDASD has encountered an internal error.'
say 'Please check available memory. Report this'
say 'problem and how you created it together with the information'
say 'below to internet e-mail: ssha@henleycol.ac.uk:'
say ' '
elapsed = time('e') % 1
minutes = elapsed % 60
seconds = elapsed // 60
say 'Debug Information: '
say 'Error RC: 'rc'     Elapsed Time:'minutes' 'seconds
say 'Backentries: 'backentries'         Error Handler: 00014'
say 'Version: 'version'   Release: 'release_date '   DASD: 'DASDInfo.recursive
say ' Step: 'step'         Substep: 'substep
say 'Count: 'count'          Loop: 'loop'        Local: 'local
say ' Verb: 'verb'           Conf: 'conf'       Timewr: 'timewr
say ' '
say 'Description of error:'
say ' '
msg=SysGetMessage(rc)
say msg
exitcode=14
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0014: Fatal Internal error. Error: 'rc
call lineout error_log,logline
logline='Error Description: 'msg
call lineout error_log,logline
signal end
end

lsapi_load:
substep=18
If rc=43 Then Do
	say ' '
	say 'RESTDASD 0015: RESTDASD failed to correctly initialise the'
	say 'network API support module, LSRXUT.DLL.'
	say ' '
	say 'This file is installed as one of the productivity aids.'
	say ' '
	say 'Please check that the file LSRXUT.DLL resides in any sub-'
	say 'directory pointed to the LIBPATH statement in your CONFIG.SYS'
	say 'file. If this file exists, then check the amount of available'
	say 'memory and/or stack space available.'
	say ' '
	exitcode=15
	if e_report = '0' then signal end
	call write_header
	logline='RESTDASD 0015: Failed to initialise API module LSRXUT.DLL.'
	call lineout error_log,logline
	signal finito
	end
else signal bad_problem
end

util_load:
substep=19
If rc=43 Then Do
	say ' '
	say 'RESTDASD 0016: RESTDASD failed to correctly initialise the'
	say 'advanced REXX function module, REXXUTIL.DLL'
	say ' '
	say 'Please check that the file REXXUTIL.DLL resides in any sub-'
	say 'directory pointed to the LIBPATH statement in your CONFIG.SYS'
	say 'file. If this file exists, then check the amount of available'
	say 'memory and/or stack space available.'
	say ' '
	exitcode=16
	if e_report = '0' then signal end
	call write_header
	logline='RESTDASD 0016: Failed to initialise base OS/2 module REXXUTIL.'
	call lineout error_log,logline
	signal finito
	end
else signal bad_problem
end

bad_dir:
substep=20
say ' '
say 'RESTDASD 0018: You have specified a bad directory or pathname to be'
say 'restored to. Check that the path exists. If you are not using the'
say '/P: switch, then check what path the backup file defaults to, by using'
say 'RESTDASD /F:<filename> /I'
say ' '
exitcode=18
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0018: The path specified to have its limits restored does not seem to exist.'
call lineout error_log,logline
signal finito
end

get_info:
substep=21
say ' '
say 'RESTDASD 0019: Could not get local machine network information.'
say 'Check that the server and requester are running correctly.'
exitcode=19
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0019: Could not get local machine network information.'
call lineout error_log,logline
signal finito
end

wrong_ver:
substep=22
say ' '
say 'RESTDASD 0020: DASD limits (and BACK/REST DASD) are not available'
say 'on versions of IBM OS/2 Lan Server or Warp Server prior to version 4.0'
exitcode=20
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0020: Version of Lan Server too old - DASD not supported.'
call lineout error_log,logline
signal finito
end

bad_filetype:
substep=23
say ' '
say 'RESTDASD 0021: Bad filetype, or file is corrupted.'
say 'The filename you have specified to restore limits from, 'backupfile' does'
say 'not appear to be a valid file, or is not a BACKDASD version 1 or compatible'
say 'file.'
exitcode=21
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0021: Bad filetype specified for input file.'
call lineout error_log,logline
signal finito
end

bad_bakfiledir:
substep=24
say ' '
say 'RESTDASD 0022: The backup file indicates a path to restore to which'
say 'cannot be found. Either correct the problem or use the /P: switch to'
say 'force restoration to a different destination.'
exitcode=18
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0018: The path specified to have its limits restored up does not seem to exist.'
call lineout error_log,logline
signal finito
end

fail_remote:
substep=25
say ' '
say 'RESTDASD 0023: The path on the remote server cannot be found.'
say 'This may be the remote server that you have either specified'
say 'on the command line or the remote server indicated in the backup'
say 'file. To see what server is pointed to by the backup file, type'
say 'RESTDASD /F:[filename] /I'
say ' '
say 'Check that the remote server is running and that the pathname is'
say 'correct. You also need to be logged on as an administrator to'
say 'perform remote restores.'
exitcode=23
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0023: The path on the remote server cannot be found.'
call lineout error_log,logline
signal finito
end

redir_path:
substep=26
say ' '
say 'RESTDASD 0024: You cannot specify a redirected resource for DASD'
say 'operations. If you wish to backup a remote server, use the'
say '/S:\\[servername] switch with the /P: switch pointing to a local'
say 'drive on that server'
exitcode=24
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0024: Redirected resource specified.'
call lineout error_log,logline
signal finito
end

recur_not:
substep=27
say ' '
say 'RESTDASD 0025: You have specified to restore all directory entries,'
say 'but the backup file is either not recursive at all or only contains'
say 'entries to one level down.'
say ' '
say 'Either omit the /R switch, or use a different backup file.'
exitcode=25
if e_report = '0' then signal end
call write_header
logline='RESTDASD 0025: Cannot restore information not held in backup file.'
call lineout error_log,logline
signal finito
end

chk_remote:
substep=28
i=length(DASDInfo.DirPath)
signal on error name fail_remote
cmdline='dir 'BackupSrvName'\'left(DASDInfo.DirPath,1)'$'right(DASDInfo.DirPath,i-2)
if right(cmdline,1)='\' then do
	cmdline=cmdline' >nul'
	cmdline
	end
else do
	cmdline=cmdline'\ >nul'
	cmdline
	end
signal on error name bad_problem
return

read_header:
substep=29
guff=linein(backupfile)
if left(guff,37) \='DASD BACKUP FILE PRODUCED BY BACKDASD' then signal bad_filetype
header=linein(backupfile)
do while header \= ''
	parse var header hword header
	parse var hword 1 swtch2 +3 swval2
	schk2=0
	if swtch2 = '/P:' then do
		substep=30
		schk2=1
		origpath=swval2
		if DASDInfo.DirPath = '' then do
			if left(swval2,1) = '"' then do
				substep=31
				if right(swval2,1) \= '"' then call encap2
				if right(swval2,1) = '"' then swval2=strip(swval2,,'"')
				end
		if left(swval2,1) = '\' then signal need_drive
		if left(swval2,1) = ':' then signal need_drive
		if right(left(swval2,3),1) = '\' then do
			call on error name bakdir_notfound
			if right(swval2,1)='\' then do
				cmdline='dir 'swval2' >nul'
				cmdline
				end
			else 
				cmdline='dir 'swval2'\ >nul'
				cmdline
			end
			signal on error name bad_problem
			DASDInfo.DirPath = swval2
			if DASDInfo.DirPath='' then signal need_drive
			end
		end
		else

		if swtch2 = '/S:' then do
			schk2=1
			substep=32
			fileserv=swval2
			if BackupSrvName = '' then 
			if right(left(swval2,2),1) = '\' then
				if left(swval2,1) = '\' then do
						if SrvName=swval2 then do
							local=1
							end
						else 
							local=0
							end
				BackupSrvName = swval2
				if right(left(swval2,3),1) = '' then BackupSrvName=''
				if BackupSrvName='' then signal bad_server
			
			end
		else

		if swtch2 = '/R:' then do
				substep=33
				if overrec='0' then
				if swval2='0' then do
					DASDInfo.recursive=0
					DASDInfo.EntriesAvail=1
					DASDInfo.count=1
					end
				if swval2='1' then DASDInfo.recursive=1
				if swval2='2' then DASDInfo.recursive=2
				if swval2>='3' then signal invalid_recur
			filerec=swval2
			schk2=1
			end
		else

		if swtch2 = '/V:' then do
			schk2=1
			backver=swval2
			end
		else

		if swtch2 = '/N:' then do
			schk2=1
			backentries=swval2
			end
		else

		if swtch2 = '/D:' then do
			schk2=1
			backdate=swval2
			end
		else
		if swtch2 = '/T:' then do
			schk2=1
			backtime=swval2
			end
		else

		if schk2 = '0' then say 'Extra data in backup file header ignored. Check versions.'
		if left(swtch2,1) = '/' then do
			swtch2=swtch2; 
			nsw2=swval2
			end
		pp = wordpos(swtch2, head_num)
		if pp = 0 then
			do
			head_num=head_num swtch2
			headp = header.0 + 1
			header.headp = nsw2
			header.0 = headp
			end
		else do
			header.pp = nsw2
			end
	end
return

bakdir_notfound:
bakdir=1
return

read_data:
substep=34
dinfo=linein(backupfile)
do while dinfo \= ''
	parse var dinfo dword dinfo
	parse var dword 1 swtch3 +3 swval3
	schk2=0
		if swtch3 = '/1:' then do
			schk3=1
			substep=35
			if left(swval3,1) = '"' then do
				if right(swval3,1) \= '"' then call encap3
				if right(swval3,1) = '"' then swval3=strip(swval3,,'"')
				end
			DirPath=swval3
			RESTInfo.resource_name=swval3
			DASDInfo.DirPath=swval3
			end
		else

		if swtch3 = '/2:' then do
			schk3=1
			substep=36
			RESTInfo.max=swval3
			end
		else

		if swtch3 = '/3:' then do
			schk3=1
			substep=37
			RESTInfo.thresh=swval3
			end
		else
		if swtch3 = '/4:' then do
			schk3=1
			substep=38
			RESTInfo.delta=swval3
			end

		if schk3 = '0' then say 'Extra data in backup file content ignored. Check versions.'
		if left(swtch3,1) = '/' then do
			swtch3=swtch3; 
			nsw3=swval3
			end
		dpp = wordpos(swtch3, dinfo_num)
		if dpp = 0 then
			do
			dinfo_num=dinfo_num swtch3
			dinfop = dinfo.0 + 1
			dinfo.dinfop = nsw3
			dinfo.0 = dinfop
			end
		else do
			dinfo.dpp = nsw3
			end
	end
return

get_local:
substep=39
l=length(DASDInfo.DirPath)
s=length(BackupSrvName)
s=s+1
say DASDInfo.DirPath
DASDInfo.DirPath=right(DASDInfo.DirPath,l-s)
ldrive=left(DASDInfo.DirPath,1)
s=s+2
substep=40
DASDInfo.DirPath=right(DASDInfo.DirPath,l-s)
DASDInfo.DirPath=ldrive':'DASDInfo.DirPath
drop s
drop l
drop ldrive
return

write_header:
substep=41
whead=1
logline='--------- Date: 'date('E')' Time: 'time('N')
wlog=lineout(error_log,logline)
if wlog=1 then say 'RESTDASD 0025: Error writing to error log during operations.'
drop wlog
return

filefind: Procedure
substep=42
return ('' \= stream( arg(1), 'c', 'query exists') )

confirm_first:
substep=43
say ' '
say 'Press Y <enter> to continue, or any other key <enter> to abort.'
parse upper pull c
if c='Y' then return
signal end

display_info:
substep=44
say 'Backup File Statistics:'
say 'Backup Created on: 'backdate'      at: 'backtime
say 'BACKDASD version used to create    :' backver
say 'Number of DASD limits held in file :' backentries
say ' '
say 'Backup file containing DASD limits : 'backupfile
if bakdir=0 & local=1 then say 'Original backup directory          :' origpath
if bakdir=1 & local=1 then say 'Original backup directory          :' origpath' (unavailable)'
if bakdir=1 & local=0 then say 'Original backup directory          :' origpath' (remote)'
if bakdir=0 & local=0 then say 'Original backup directory          :' origpath 
say 'Original backup Server             :' fileserv
if filerec = '1' then say 'Type of backup                          : Recursive'
if filerec = '0' then say 'Type of backup                          : Not recursive'
if filerec = '2' then say 'Type of backup                          : Recursive (down to one level)'
if left(backver,1) \= '1' then do
	say ' '
	say 'Warning! BACKDASD version used to backup is different than the'
	say 'version of RESTDASD you are using.'
	'pause' 
	end
say ' '
return


display_perform:
substep=45
say 'RESTDASD will perform the following:'
say ' '
say 'Path to restore DASD limits to     : 'DASDInfo.DirPath
if local=1 then say 'Restore to Server (name)           : 'Backupsrvname' (local machine)'
else say 'Restore to Server (name)           : 'Backupsrvname' (remote machine)'
if DASDInfo.recursive = '2' then say 'Restore sub-directories (recursive): Yes (only one level down)'
if DASDInfo.recursive = '1' then say 'Restore sub-directories (recursive): Yes'
if DASDInfo.recursive = '0' then say 'Restore sub-directories (recursive): No'
if e_report = '0' then say 'Error log file reports             : Disabled'
if e_report = '1' then say 'Error log file reports written to  : 'error_log
if fit=1 then say 'Force restore DASD resource limit  : No, not if resource is already larger'
if fit=0 then say 'Force restore DASD resource limit  : Yes, even if resource is already larger'
if large=1 then say 'Overwrite existing DASD limit      : Not if existing limit is larger'
if large=0 then say 'Overwrite existing DASD limit      : Always'
if timewr='1' then say 'Operation time will be written to log upon completion.'
say ' '
if overpath = '1' then say 'Command line switches will overide the destination recorded in the backup file!'
if difserv = '1' then say 'Command line switches indicate a different destination server!'
if overrec = '1' then say 'Command line switches indicate a different value for recursive!'
return

get_name:
substep=46
backup_name=''
do i=1 to length(backupfile)
	if left(right(backupfile,i),1) = '.' then backup_name=left(backupfile,length(backupfile)-i)'.BAK'
end
if backup_name='' then do
	backupfile=backupfile'.'
	call get_name
	end
return  

set_name:
substep=47
dot=0
do i=1 to length(backupfile)
	if left(right(backupfile,i),1) = '.' then dot=1
end
if dot=0 then backupfile=backupfile''defext
return  

end:
substep=48
elapsed = time('e') % 1
minutes = elapsed % 60
seconds = elapsed // 60
say ' '
if exitcode <> '0' then do
	substep=49
	say 'RESTDASD ended encountering at least 1 error or warning.'
	call stream logfile,'c','close'
	end
if exitcode = '0' | exitcode = '5' | exitcode = '12' then do
	say 'Total Operation Time:' minutes' minutes, 'seconds 'seconds.'
	say 'RESTDASD completed successfully.'
	end
if exitcode = '0' | exitcode = '5' | exitcode ='12' then
	substep=50
	if timewr='1' then do
	call write_header
	logline='RESTDASD: Operation successful: Total Operation Time:' minutes' minutes, 'seconds 'seconds.'
	call lineout error_log,logline
	logline='          Number of entries restored to disk: 'DASDInfo.count' to path 'DASDInfo.DirPath
	call lineout error_log,logline
	call stream logfile,'c','close'
	end

signal finito

finito:
if verb = '1' & if exitcode != '0' then exit exitcode
exit
