/*----------------------------------------------------------
   Exports e-mail addresses from the PMMail address book.

           Author:       Peter Moylan
           Started:      17 July 1998
           Last revised: 17 July 1998

   Usage:
           pmmab SourceDirectory DestinationDirectory

           where SourceDirectory is the directory that
           contains the files BOOK.DB and ADDR.DB, and
           DestinationDirectory is the directory where the
           output files will be created.

           The arguments are optional; the program assumes
           the current directory as the default.

   The *.DB file formats are for PMMail version 1.96.
------------------------------------------------------------*/

/* Check command line arguments. */

parse arg InDirectory OutDirectory
if InDirectory \= "" & LASTPOS('\', InDirectory) \= LENGTH(InDirectory) then
    InDirectory = InDirectory'\'
if OutDirectory \= "" & LASTPOS('\', OutDirectory) \= LENGTH(OutDirectory) then
    OutDirectory = OutDirectory'\'

/* Read the books database, create output files. */

DataFile = InDirectory"BOOKS.DB"

do while lines(DataFile) = 1
    parse value linein(DataFile) with BookName '' . '' . '' BookNumber ''
    call MakeFileName( BookNumber )
    say OutputFile.BookNumber '=' BookName
    ret = lineout( OutputFile.BookNumber, '-'BookName )
end

/* Now read the address database. */

DataFile = InDirectory"ADDR.DB"
do while lines(DataFile) = 1

    /* PMMail (v1.96) ADDR.DB format */

    parse value linein(DataFile) with,
        EMail '' Alias '' Name '' Popup '' Company '' Title '',
        H_Street '' H_Building '' H_City '' H_State '' H_Code '',
        H_Phone '' H_Ext '' H_Fax '',
        B_Street '' B_Building '' B_City ''B_State '' B_Code '',
        B_Phone '' B_Ext '' B_Fax '',
        Notes '' BookNumber '' H_Country '' B_Country ''

    result = '  'EMail
    if Name \= '' & Name \= "" THEN result = result' ('Name')'

    /* Special case to watch out for: a single entry can be in  */
    /* more than one address book.                              */

    do while pos(';', BookNumber) \= 0
         parse var BookNumber j ';' BookNumber
         ret = lineout( OutputFile.j, result )
    end /* do */
    ret = lineout( OutputFile.BookNumber, result )

end
exit

/*-------------------------------------------------*/
/* Procedure to create the name of an output file, */
/* creating a backup if necessary.                 */
/*-------------------------------------------------*/

MakeFileName:
    arg j
    name = OutDirectory"BOOK"j
    bakname = name'.bak'
    name = name'.txt'
    if stream(name, 'c', 'query exists') \= "" then
        do
            if stream(bakname, 'c', 'query exists') \= "" then
                '@'del bakname
            '@'rename name bakname
        end
    OutputFile.j = name
    return

