:userdoc.
:title.Weasel documentation
:docprof toc=12.

.***********************************
.*   INTRODUCTION
.***********************************

:h1.Introduction

:artwork name='weasel.bmp' align=center.
:p.
Weasel is a combined POP3 and SMTP daemon (Post Office server) for OS/2.
The POP3 and SMTP sections can be enabled or disabled separately.
It is distributed as :link reftype=hd refid=register.optional shareware:elink..
:p.This documentation is for version 0.90.
:p.
:hp2.Disclaimer of Warranty:ehp2.

:sl compact.
:li.
:hp8.
This Product is provided "as-is", without warranty of any
kind, either expressed or implied, including, but not limited to,
the implied warranties of merchantability and fitness for a
particular purpose.  The entire risk as to the quality and
performance of the Product is with you.  Should the Product prove
defective, the full cost of repair, servicing, or correction lies
with you.
:ehp8.
:esl.

:p.
The author of Weasel is Peter Moylan, peter@ee.newcastle.edu.au.

:p.
The latest version of Weasel is normally kept at ftp&colon.&slash.&slash.eepjm.newcastle.edu.au/software.
Information about other software on this site may be found at
http&colon.&slash.&slash.eepjm.newcastle.edu.au/os2.

:p.
:hp2.Getting information about new versions:ehp2.

:p.
You can, if you wish, send an e-mail to peter@ee.newcastle.edu.au
and ask to be put on the list of people who receive e-mail notification of
new releases of my software.  This mailing list is not used for any other
purposes, and the addresses will not be given to anyone else.

.***********************************
.*   REGISTRATION
.***********************************

:h1 id=register.Registration

:hp2.Registration:ehp2.

:p.This software is "optional shareware".  What this means is that you
decide whether you want to register as a paid owner of the software.
The software is not crippled in any way, and I will continue to provide
support and free releases of new versions to all users, whether or
not they are registered, for at least the short-term future.

:p.If you decide that this software is worth supporting, you have the
following payment options.
:p.
:hp2.Payment through BMT Micro:ehp2.

:p.This is likely to be the most convenient method for most people,
because BMT Micro has a number of different payment methods, including
credit cards.  It also has agents in several countries.  For full
details, see the file register.bmt included in the Weasel distribution.
The price is $20 (US dollars).

:p.
:hp2.From Europe:ehp2.

:p.This works best for people living in the European Union.  (Warning:
check first whether your bank is going to charge you transfer fees.
They shouldn't, but I've heard of exceptions.)  You have two options:
:ul.
:li.Transfer 750 Belgian francs to the following bank account
:sl.
:li.Marion Gevers
.br
Account number 220-0586389-60
.br
G&ea.n&ea.rale de Banque (Belgium)
.br
Mention: Weasel
:esl.
:p.and send an e-mail to peter@ee.newcastle.edu.au to confirm that you've done it.

:li.Send a Eurocheque for 750 Belgian francs to
:sl.
:li.Peter Moylan
.br
91 Harriet Street
.br
Waratah, NSW 2298
.br
Australia
:esl.
:eul.

:p.
:hp2.Payment directly to me in Australia:ehp2.

:p.This is a more attractive option for people in Australia.  From
other countries, it's not a good idea because of the bank charges on
international transfers.  (Please don't send non-Australian currency
to an Australian bank, because then I get hit with exorbitant bank fees.)
You can do it in either of two ways.

:ul.
:li.Send a cheque, or equivalent, for $25 (Australian dollars) to
:sl.
:li.Peter Moylan
.br
91 Harriet Street
.br
Waratah, NSW 2298
.br
Australia
:esl.

:li.Transfer the amount of $25 (Australian dollars) to the following bank
account.
:sl.
:li.Marion Gevers
.br
Account number (06 2831) 00626468
.br
Commonwealth Bank
.br
University of Newcastle, Australia
:esl.
:eul.

.***********************************
.*   EXPLANATION OF HOW E-MAIL WORKS
.***********************************

:h1.How e-mail is transported
:hp2.How e-mail is transported:ehp2.
:p.
Although it is possible to send e-mail directly from one
computer to another, a more common arrangement is to go via a
third machine, which we can call the Post Office machine.  The
advantage of such an arrangement is that the Post Office machine
is the only one that needs to be on-line all the time.  The
sender and receiver only need to go on-line when sending or
collecting their mail.

:p.Initially, the sender composes the message by using a program
known as a User Agent. (This is optional - it is possible
to send mail without having a User Agent - but most people like
to have the high-level features, such as automatic construction
of mail headers, that are supplied as part of the User Agent.)
The default OS/2 User Agent is the program called Ultimail Lite,
but of course you're free to replace this by one of the alternatives
sold by various suppliers.

:p.When the mail is ready to be sent, a piece of software called
an SMTP client is used to send it. (SMTP stands for Simple Mail
Transport Protocol.) This must talk to an SMTP server on another
machine. In the scenario we're considering here, the other machine
is the Post Office machine.

:p.The default OS/2 SMTP client is called "sendmail", and the
default SMTP server is also called sendmail. That is, the same
program does either job, depending on what parameters you give
it when sendmail is started. Typically one copy of sendmail is
running all the time, acting as a server for incoming mail.
Another copy is
started each time you want to send a piece of outgoing mail.

:p.The message received by the SMTP server remains stored on the
disk of the Post Office machine, until the recipient checks in
to see whether any mail has arrived. This is done with a POP client.
(POP stands for Post Office Protocol.) The Post Office machine must
therefore be running both an SMTP server and a POP server.

:p.This appears to add up to five different programs, but often
their functions are combined in various ways. For example, the
POP and SMTP clients are very often included as built-in parts
of the User Agent program.
In the case of Weasel, I've put both servers (POP and SMTP) into
the same program. This makes it easier for the two servers to
cooperate with each other.  It also means that total memory usage is
lower than if you ran separate POP and SMTP servers.

.***********************************
.*   SERVER FEATURES
.***********************************

:h1 res=002.Server features
:hp2.Server features:ehp2.

:p.Weasel is a post office mail server based on the POP3 standard, known as
RFC 1939 or STD 53.  Weasel implements all features of the POP3 standard.

:p.Weasel also includes an SMTP server to receive the mail, and
SMTP client software to handle outgoing mail. The SMTP software is based
on the standard known as RFC 821.  If you wish, you can disable the
built-in SMTP server and use a separate SMTP server from another source.

:p.:hp2.The POP3 subsystem:ehp2.

:p.The Weasel POP3 server, which is what clients contact to fetch
their mail, is a complete implementation of the POP3 standard,
therefore it should be compatible with any standard POP3 client.

:p.All clients are required to supply a username and password.
(The username is what comes before the '@' in that user's e-mail
address.) Passwords are set by a separate program called Setup,
which is described later in this document.

:p.:hp2.The SMTP subsystem:ehp2.

:p.The SMTP server is the part of the system that accepts incoming
mail. The Weasel SMTP is a stripped-down version that implements
all of the required commands in the standard, but not all the optional
commands. The optional extensions are not, in my opinion, needed
by a small-to-medium-sized mail-handling computer, and we cut out
a lot of system overhead by deciding not to include them.

:p.:hp2.Mail relaying:ehp2.

:p.An e-mail address has the form user@domain, where 'user' is a
username, and 'domain' is either a machine name or something that
will be mapped to a machine name by a nameserver. If 'domain' is
a domain for which the current machine is supposed to be handling
the mail, then we have mail for a local destination.
Obviously, every SMTP server must be able to handle this case.
If 'user' is a valid username on the current machine, the mail
will be delivered; otherwise, it will be rejected.

:p.Most SMTP servers will also accept mail for addresses on
other machines. If the server accepts such a non-local address,
it accepts the mail and then forwards it on towards its final
destination. This is to allow for the case - which used to be
very common - where there is no direct mail path from the sender
to the final destination. In such a case the SMTP server is said
to be acting as a "relay host".

:p.Junk mailers love relay hosts. Sending out a million pieces of
junk mail can be expensive, because it can tie up your machine
for hours. To avoid that overhead, the people who send junk mail
often choose to use another machine, selected more or less
randomly, as a relay host. (They can't use the same machine every
time, or they'd be caught.) The relay host is usually an innocent
victim in this case, but the owner of the relay host is often
blamed for the junk mail. Using a relay host also helps in
disguising the original sender of the mail.

:p.Because of this abuse, Weasel has strong restrictions on
relaying.  It will accept relay requests only in two cases:
:ol compact.
:li.when the destination domain is on a list of domains for which
we agree to pass on mail; or
:li.when the host sending us the mail is on the list of "trusted hosts".
:eol.

:p.All other requests to pass mail on to another machine are rejected.

:p.Case 1 above allows for the situation where your machine
is a mail gateway for your organisation's local network. The purpose
of case 2 is to let you give your POP users an outgoing mail service,
in addition to the incoming mail service that they automatically have
by virtue of being registered POP users.

:p.:hp2.How mail is stored:ehp2.

:p.After an e-mail message is accepted by the SMTP server, but
before it is picked up by a POP client, the message is stored as
a file on the local disk. When setting up Weasel, you specify one
directory to be used as the "mail root". This directory has one
subdirectory for each user. Each message is stored as a file
xxxxxxxx.MSG, where xxxxxxx is an internally-generated identifier.

:p.Apart from the *.MSG files, a user's mail directory might contain
a file called LOCK.!!!. This is created when a POP client starts to
access the directory, and it is deleted when the POP session ends.
While this file exists, no other POP client is allowed to get at the
directory. The SMTP server can still store new mail during this
period, but the new mail will not be seen by the POP client until
the next time the client logs in. The time delay is not particularly
important, because most POP clients check for new mail every few
minutes.

:p.The Setup program creates an extra directory called "forward",
as a subdirectory of the mail root directory, to hold outgoing mail
that is still waiting to be sent.  In most cases mail files will
remain in this directory for only a short time, but sometimes the
transmission is not successful.  (The destination host might be
unreachable, for example.)  Weasel attempts to re-send the unsuccessful
mail a number of times over a period of about four days.  If
these attempts are still not successful, the mail is returned to
the original sender with a note saying that it could not be delivered.

.***********************************
.*   INSTALLATION
.***********************************

:h1.Installation
:hp2.Installation:ehp2.
:p.
See also :link reftype=hd refid=deinstall.De-installation:elink.

:p.To operate your machine as a post office, you need to run both
a POP server and an SMTP server.  For the SMTP part, you can choose
to run either Weasel's built-in SMTP server, or to run a separate
SMTP server.  For now, let's assume that you will use the built-in
server. The other option is explained on a
:link reftype=hd refid=otherSMTP.later page:elink..

:ol.

:li.You should have received this package in the form of a zip file.
The first step is to unzip the file into a directory of your choice.
(Presumably you've already done this.)

:li.Create a new directory to hold the users' mail. For example, you
could create a subdirectory called "MailRoot" in your Weasel directory;
or you might choose to use the directory \MPTN\ETC\MAIL.

:li.Run the program SETUP.EXE, and use the arrow keys to go to the
field called "Root directory for mail". Fill in the full path name,
including the drive letter, of the directory you created in the
previous step.

:li.Use the arrow keys to go to the "Enable servers" line, and use
the left/right arrow keys to choose the "Both" option. Once you've
done this, use the Enter key, or alternatively one of the up/down
arrow keys, to confirm your menu selection.

:li.While still in SETUP.EXE, press F5 until you reach a screen
called "Weasel User Editor", containing a list of
users.  This list will initially be empty.  Type the 'A' key to
add a new user.

:li.Type in the username and password for one user. (You can add
the others after you're satisfied that everything is working correctly.)
If you make a mistake, you can use the E (edit) or Del (delete) keys
to correct your error.

:li.Use the arrow keys to go back to the list of users, and then
type X to get out of the Setup program.

:eol.

:p.
The server is the program called weasel.exe.  You can run it
either by double-clicking on the desktop icon, or by entering the
command "weasel" in a command-line session.  Most people will want to
put a program object or shadow for weasel into the startup folder,
or to start it from TCPSTART.CMD; but that's up to you.

:p.After you've done some testing, you'll probably want to run the
Setup program again to add more users. You don't have to restart
Weasel to get the new users recognised.

:p.
For some other options, see
:ul compact.
:li.:link reftype=hd refid=inetd.Running from inetd:elink.
:li.:link reftype=hd refid=detached.Running Weasel detached:elink.
:li.:link reftype=hd refid=otherSMTP.Using a different SMTP server:elink.
:eul.

.***********************************
.*   DEINSTALLATION
.***********************************

:h1 id=deinstall.De-installation
:hp2.De-installation:ehp2.
:p.
Weasel does not tamper with CONFIG.SYS or with other system files.
If you decide that you don't want to keep Weasel, simply delete
the directory into which you installed it. Before doing this, you
should probably check the user mail directories, to see whether
there's any undelivered mail remaining.

:p.Depending on how you did the installation, you might have modified
files like INETD.LST or SENDMAIL.CF. If so, don't forget to reverse
these changes.

.***********************************
.*   CONFIGURATION
.***********************************

:h1 id=configuration.Configuration

:p.You have the choice of two different configuration programs,
:link reftype=hd refid=configuser.Setup:elink. and
:link reftype=hd refid=pmconfiguser.PMSetup:elink.. PMSetup has one
option (remote configuration) that is not supported by Setup, but in
all other respects the two programs perform exactly the same function.
You can choose to use either one, depending on whether you prefer
a text-mode program or a PM "notebook" application.

:p.
The parameter settings are stored in a file WEASEL.INI.  Weasel reads its
INI file as it starts up, so any changes you make will not take effect until
the next time you start the server.
:p.
Exception 1: the user information is not read until a user attempts
to log in.  You may therefore alter the user information while the server
is running, and the alterations will affect the next user to log in.
:p.
Exception 2: an alias is not expanded until incoming mail arrives for
that alias.  You may therefore alter alias lists while the server
is running, and the alterations will affect the next incoming e-mail
addressed to that alias.

.***********************************
.*   THE SETUP UTILITY
.***********************************

:h2 id=configuser toc=123.The Setup utility

:p.The program SETUP.EXE has two functions:
:ul compact.
:li.To set the parameters that Weasel.exe will use when it starts up.
:li.To define which users may access the POP server.
:eul.

:p.The configuration details are split up into a number of different
screens.  Use the F4 and F5 function keys on the keyboard to cycle
around the different screens.

:p.
Now read

:ul compact.
:li.:link reftype=hd refid=configuser1.Setting the server parameters:elink.
:li.:link reftype=hd refid=configuser2.Modifying the list of users:elink.
:li.:link reftype=hd refid=aliases.Aliases:elink.
:li.:link reftype=hd refid=configoptions.Optional settings:elink.
:li.:link reftype=hd refid=configuser3.Names for the local host:elink.
:li.:link reftype=hd refid=configuser4.Trusted sources for relay mail:elink.
:li.:link reftype=hd refid=configuser4a.Acceptable destinations for relay mail:elink.
:li.:link reftype=hd refid=configuser5.Banned hosts:elink.
:eul.

:h3 id=configuser1.Setting the server parameters
:hp2.Setting the server parameters:ehp2.
:p.
When you run SETUP.EXE, you get a screen showing the following items.

:dl break=all.
:dt.SMTP port
:dd.Unless you are doing something nonstandard (for example, running two mail servers
on the same machine) this should always be 25.
:p.Hint: One use for nonstandard ports is to allow you to test Weasel without
disabling your existing mail software. You don't have to switch to the standard
port numbers until you've decided that you trust Weasel not to lose your mail.
:dt.Maximum number of SMTP users
:dd.This specifies how many SMTP clients will be allowed to use the server simultaneously.
I usually set this to 10.  The number is not particularly critical; you'd have to
have a very busy mail node before getting simultaneous access from many clients.
:dt.SMTP timeout (seconds)
:dd.The time that an SMTP session may remain idle before it is forcibly closed.
Most SMTP clients will log out cleanly, but occasionally the server has to
terminate a "dangling" session where, for example, the client machine crashed.
:dt.POP port
:dd.Unless you are doing something nonstandard (for example, running two mail servers
on the same machine) this should always be 110.
:dt.Maximum number of POP users
:dd.This specifies how many POP clients will be allowed to use the server simultaneously.
I usually set this to 10.  The number is not particularly critical; you'd have to
have a very busy mail node before getting simultaneous access from many clients.
:dt.POP timeout (seconds)
:dd.The time that an POP session may remain idle before it is forcibly closed.
Most POP clients will log out cleanly, but occasionally the server has to
terminate a "dangling" session where, for example, the client machine crashed.
:dt.Root directory for mail
:dd.The full path name of the directory that will be used for storing users'
mail files. This directory should exist, and preferably shouldn't be used
for anything else.
:dt.Enable servers
:dd.This specifies whether Weasel should run as an SMTP server, or as a POP server,
or as both kinds of server simultaneously. Choose the "Both" option if Weasel
is the only mail server software that you're running.
:dt.POP user logging
:dd.If this feature is enabled a brief summary of each POP session is written
to a file called POP.LOG.
:dt.SMTP logging
:dd.If this feature is enabled a record of received mail is written to a file
called SMTP.LOG. Each line in this file described one received mail item: date,
time, sending host, size, and a list of recipients.
:dt.Detailed transaction log
:dd.You can choose to send a detailed log to the screen, or to a disk file, or both.
The disk file is called WEASEL.LOG, and it is updated approximately once every
15 minutes if this feature is enabled.
:p.Warning: Transaction logging can create very large log files.  I suggest that
you don't enable this feature unless you're trying to track down a problem.
:edl.

:p.
To modify any of these parameters, use the up/down arrow keys to get to the
desired item, then type in the new value.  (The backspace, Insert, Delete, Home,
and End keys
will also work during editing.)  The new value is accepted when you type the
Enter key, or when you use the function keys to go to another field.
:p.
When you've finished editing, use the Esc key to exit from the Setup program, or
type F5 to get to the :link reftype=hd refid=configuser2.user editor:elink..

.***********************************
.*        USER EDITOR
.***********************************

:h3 id=configuser2 toc=1234.Modifying the list of users
:hp2.Modifying the list of users:ehp2.
:p.
To modify the user list, run SETUP.EXE, and then type the F5 function key
to get the the "Users" screen page.  This will give you a list of
all existing users.  (The first time you run the program, the list will probably
be empty.)
:p.
From this screen, you can add, delete, or modify users.  When you've finished,
use the F5 function key to get back to the main Setup screen.
:p.
:hp2.Deleting a user:ehp2.
:p.
Use the up/down arrow keys to get to the user you want to delete, and type
the Del (delete) key.
:p.
:hp2.Adding a new user:ehp2.
:p.
Type A, and then proceed as for :link reftype=hd refid=edituser.Editing a user record:elink..
:p.
:hp2.Editing the details for an existing user:ehp2.
:p.
Type E, and then follow the instructions in the section :link reftype=hd refid=edituser.Editing a user record:elink..

:h4 id=edituser.Editing a user record
:hp2.Editing a user record:ehp2.
:p.
You get to this point by running the Setup program, typing F5 to get to
the user editor, and then using one of the "A" (add user) or "E" (edit user)
options.
:p.
By now you should have two fields near the top of the screen.
:dl break=all.
:dt.    User name
:dd.The name that the user will use when logging in.
:dt.    Password
:dd.This user's password.
:edl.
:p.
Use the up/down arrow keys to get to the field you want to edit, and
then modify it as necessary.  When you've finished, use the Enter key
or the Cursor Down key to confirm the changes.

:warning.If you change the user name, the data for the previous
user name will be deleted.  You should also avoid using a user name
that is the same as for some other user.:ewarning.
:p.
When you've finished setting up all users, type the F5 key to get
to the next page of the Setup program, or type X to leave
the Setup program.

.***********************************
.*           ALIASES
.***********************************

:h3 id=aliases toc=1234.Aliases
:hp2.Aliases:ehp2.
:p.
An alias looks like a username from the viewpoint of incoming mail,
but the name does not correspond to the name of any POP user.  Instead,
the alias refers to a list of e-mail addresses.  Whenever an e-mail
arrives addressed to that alias, a copy is sent to everyone on the
list.

:p.:hp2.Example 1.:ehp2. Suppose you have a user called Bill Smith who
wants to receive all mail in duplicate, with one copy to each of his two
computers.  You can do this by giving him two user accounts called bill1
and bill2, and setting up an alias "bill.smith" defined as
:xmp.
      bill1
      bill2
:exmp.
:p.With this arrangement, people send mail to Bill by addressing it to
Bill.Smith@yourdomain, but Bill collects his mail by logging in as
bill1 from one of his computers, and as bill2 from the other.

:p.:hp2.Example 2.:ehp2. You can use an alias to set up a simple
mailing list.  Suppose, for example, you have a group of friends who
are interested in chess and want to discuss it as a group.  If you
create an alias called "chessgroup", with entries like
:xmp.
      "Alan Jones" <alanj@xyz.org>
      Bill.Smith
      susan@alpha.beta.uk (Susan G.)
      kw123
      "Me" <myself>
:exmp.
:p.then anyone can send mail to chessgroup@yourdomain, and copies will
be distributed to everyone on the list.

:p.Alias lists may themselves contain aliases.  To guard against circular
definitions, duplicate names are stripped out during the expansion.

:p.As Example 2 shows, an alias list may contain both local and non-local
e-mail addresses, and this can generate relay mail even if the sender is
not otherwise permitted to send relay mail.  As a guard against abuses,
an alias can be set up to be either "public" or "private".  Anyone can
send mail to a public alias.  A private alias can be accessed only by
those senders with "relay mail" privilege.

:p.The following two pages explain how to create and modify aliases.

.***********************************
.*        ALIAS EDITOR
.***********************************

:h4.Adding and changing aliases
:hp2.Adding and changing aliases:ehp2.
:p.
To create or change aliases, run SETUP.EXE, and then type the F5 function key
until you get to the "Aliases" screen page.  This will give you a list of
all existing aliases.  (The first time you run the program, the list will probably
be empty.)
:p.
From this screen, you can add, delete, or modify aliases.  When you've finished,
use the F4 or F5 function key to go to other sections of the Setup program, or
type X to exit completely from Setup.
:p.
:hp2.Deleting an alias:ehp2.
:p.
Use the up/down arrow keys to get to the alias you want to delete, and type
the Del (delete) key.
:p.
:hp2.Adding a new alias:ehp2.
:p.
Type A, and then proceed as for :link reftype=hd refid=editalias.Editing an alias list:elink..
:p.
:hp2.Editing the expansion of an existing alias:ehp2.
:p.
Type E, and then follow the instructions in the section :link reftype=hd refid=editalias.Editing an alias list:elink..
:p.
:hp2.Renaming an existing alias:ehp2.
:p.
Type R, and then type the new name.  The name will be changed when you type the
<Enter> key, or when you use the up/down arrow keys to move to another entry.

:h4 id=editalias.Editing an alias list
:hp2.Editing an alias list:ehp2.
:p.
You get to this point by running the Setup program, typing F5 until you get to
the alias editor, and then using one of the "A" (add alias) or "E" (edit alias)
options.
:p.
Initially the word "Private" or "Public" will be highlighted at the top left
of the screen.  If you want to change this, use the "cursor left" or
"cursor right" key.  Then type the "cursor down" key to get to the list itself.

:p.At this point you have the following choices.
:p.
:hp2.Adding a new entry:ehp2.
:p.
Type A, and then type an e-mail address.  Use the <Enter> key or the up/down
arrow keys to confirm your choice, or the Esc key if you change your mind.
:p.
:hp2.Editing an existing entry:ehp2.
:p.
Type E, and then modify the e-mail address.  Use the <Enter> key or the up/down
arrow keys to confirm your choice, or the Esc key if you change your mind.
:p.
:hp2.Deleting an existing entry:ehp2.
:p.
Type the Delete key.
:p.
:hp2.Changing the Public/Private status of the alias:ehp2.
:p.
Use the Home, PageUp, and/or the up arrow key until the cursor is at the
top of the screen, and then use the left or right arrow key.

:p.
When you've finished making modifications on this page, type Esc to
complete the operation.  If you leave the Setup program before doing this,
your changes will not be saved.

.***********************************
.*   OPTIONAL SETTINGS
.***********************************

:h3 id=configoptions.Optional settings
:hp2.Optional settings:ehp2.
:p.
You get to this page by running SETUP.EXE, and then pressing the F5 function
key until the "Options" page appears.  This gives you a screen showing the following items.

:dl break=all.
:dt.Filter for incoming mail.
:dd.Normally this should be left blank.  If it is not blank, it should contain
the file name of a program (a CMD or EXE file) that will filter all incoming
mail.  This adds some processing overhead, but allows you to do things like
virus scanning, junk mail filtering, etc., on the incoming items.  Filter
programs are described in :link reftype=hd refid=filters.a separate section:elink..
:dt.Relay host for forwarding mail.
:dd.Normally this should be left blank.  If it is not blank, it should
contain the hostname of another computer that is running an SMTP server and
that will accept relay mail.  All outgoing mail from Weasel will be sent to
that computer, which should accept responsibility for forwarding it on to
its final destination.
:p.Note: This option is provided for the case where, for example, you have
to send all your mail through a gateway.  If you use it, make sure that you
have permission to use the relay host this way.  If you abuse a relay
facility, you might end up discovering that you have been blacklisted and
can no longer send mail to anyone.
:edl.

:p.
To modify any of these parameters, use the up/down arrow keys to get to the
desired item, then type in the new value.  (The backspace, Insert, Delete, Home,
and End keys
will also work during editing.)  The new value is accepted when you type the
Enter key, or when you use the function keys to go to another field.
:p.
When you've finished editing, use the Esc key to exit from the Setup program, or
use the F4 and F5 function keys to get to the other Setup pages.

.***********************************
.*   NAMES FOR THE LOCAL HOST
.***********************************

:h3 id=configuser3.Names for the local host
:hp2.Names for the local host:ehp2.

:p.
To reach this page, run Setup and type F5 several times, until the
"local host" page appears.

:p.An e-mail address has the form "user@domain".  If your local
nameserver has an MX record for your machine that matches the "domain"
part, then this is mail to be delivered locally.

:p.In the case where the "domain" part is actually the hostname of
your machine, or an alias known to your local nameserver, Weasel can work
this out for itself.  Many users, therefore, can afford to leave this
list empty.  Unfortunately Weasel can't (yet) handle the case where the
domain is not a hostname, but is instead something mapped to a hostname
by a nameserver MX record.  (The catch here is that we can't tell
whether the MX record identifies the final destination, or simply a
relay host.  If there's a way to make this distinction, I haven't
yet worked it out.)  In such cases, then, you must explicitly list
the domain name(s) on this page.

:p.Instructions for creating or modifying the list are given on
the manual page called :link reftype=hd refid=hostlist.Editing a list of host names:elink..

:p.Note, by the way, that you can't define hostname aliases simply by adding
extra entries to this list.  The aliases are no good unless they're
also recognised by the nameserver.  If the nameserver does not
define a name, then there's no way for people at other sites to use
that name as part of an e-mail address; their own SMTP client will
report an "unknown host" error.

:p.Note, too, that some mail clients will refuse to send mail to
your machine if they can't find an MX record for it.  You should ask
your local network manager - the person who looks after the
nameserver - to include MX records for your computer in the
nameserver tables.

.***********************************
.*   SOURCES FOR RELAY MAIL
.***********************************

:h3 id=configuser4.Trusted sources for relay mail
:hp2.Trusted sources for relay mail:ehp2.

:p.
To reach this page, run Setup and type F5 several times, until the
"acceptable sources for relay mail" page appears.

:p.Relay mail is mail that the SMTP server accepts and agrees to
pass on to another host.  The Weasel philosophy is that unlimited
relay mail should not be permitted.  It puts an extra load on your
computer, and it helps junk mailers to hide the real origin of
their junk mail.

:p.There are just two cases where it can make sense to permit
your machine to be used as a relay host.
:ul.
:li.Where your computer is acting as a gateway to a network that
would otherwise be unable to receive mail from the outside world.
This "gateway" function is described on the following page.
:li.Where you want to offer an "outgoing mail" service to the users
that have accounts on your POP server.  This function is the subject
of the current page.
:eul.
:p.The "trusted sources" list is a list of host names.  Mail sent
from those hosts, and addressed to some third host, will be accepted
to be forwarded.  Mail sent from elsewhere will not be accepted
unless it is addressed to the machine on which Weasel is running, or
to a domain on the "acceptable destinations" list.
In other words, Weasel will not accept mail for relaying except
when it comes from one of the hosts on this list, or when it's
going to an approved destination.

:p.Note: there are no default trusted hosts.  Even mail from your
own computer will be rejected if it does not satisfy one of the
above two conditions.

:p.Instructions for creating or modifying the list are given on
the manual page called :link reftype=hd refid=hostlist.Editing a list of host names:elink..

.***********************************
.*   ACCEPTABLE RELAY DESTINATIONS
.***********************************

:h3 id=configuser4a.Acceptable destinations for relay mail
:hp2.Acceptable destinations for relay mail:ehp2.

:p.
To reach this page, run Setup and type F5 several times, until the
"acceptable destinations for relay mail" page appears.

:p.Relay mail is mail that the SMTP server accepts and agrees to
pass on to another host.  The Weasel philosophy is that unlimited
relay mail should not be permitted.  It puts an extra load on your
computer, and it helps junk mailers to hide the real origin of
their junk mail.

:p.There are just two cases where it can make sense to permit
your machine to be used as a relay host.
:ul.
:li.Where your computer is acting as a gateway to a network that
would otherwise be unable to receive mail from the outside world.
This "gateway" function is the subject of the present page.
:li.Where you want to offer an "outgoing mail" service to the users
that have accounts on your POP server.  This function was described
on the previous page.
:eul.
:p.The "acceptable destinations" list is a list of domain names.  Mail
addressed to those domains will be accepted
to be forwarded, whether or not it comes from one of the "trusted hosts".

:p.Instructions for creating or modifying the list are given on
the manual page called :link reftype=hd refid=hostlist.Editing a list of host names:elink..

.***********************************
.*   BANNED HOSTS
.***********************************

:h3 id=configuser5.Banned hosts
:hp2.Banned hosts:ehp2.

:p.
To reach this page, run Setup and type F5 several times, until the
"banned hosts" page appears.

:p.This page contains your personal blacklist of hosts that are not
allowed to send you mail.  Weasel will refuse to accept any mail
from hosts on this list.

:p.Instructions for creating or modifying this list are given on
the manual page called :link reftype=hd refid=hostlist.Editing a list of host names:elink..

.***********************************
.*   EDITING A HOST LIST
.***********************************

:h3 id=hostlist.Editing a list of host names
:hp2.Editing a list of host names:ehp2.

:p.When Setup presents you with a list of host names to be edited,
you have the following options:

:dl.
:dt.   A
:dd.Add a new entry.  Once you've typed the new entry, use the
Enter key or the "cursor up" key to complete the operation.
:dt.   P
:dd.Promote: move the current entry up in the list.  You can use
this for changing the order of the entries in the list.
:dt.   Del
:dd.(The Delete key.)  Deletes the current entry.
:dt.   X
:dd.Exit completely from the Setup program.
:dt.   F5
:dd.Move to the next page of the Setup options.
:edl.

:p.In addition, you can of course use the cursor up/down keys to
move through the entries on the list.  The Home, End, PageUp,
and PageDown keys may also be used.

:p.:hp2.The format of a list entry:ehp2.

:p.Entries in this list can be in one of four forms:

:ul.
:li.An IP address enclosed in square brackets, for example [123.45.6.78].
This must be a fixed number; wildcards are not allowed in this format.
:li.An IP address range, for example [123.45.6.78-99].  This means all
addresses in the range [123.45.6.78] to [123.45.6.99], inclusive.  You
may only have a single number after the '-' character.  As a more
complicated example, [1.2.3-8] means all addresses in the range from
[1.2.3.0] up to [1.2.8.255].
:li.A hostname, for example alpha.beta.com.  In this case wildcards are
allowed - see below.
:li.A domain name starting with the '.' character.  This is a "wildcard"
entry that will match any hostname that ends with that domain name.
This form is supported for compatibility with older versions of Weasel,
but it is being phased out now that the '*' form of wildcard is
available.
:eul.

:p.Where possible - that is, when ranges or wildcard characters are not used -
Weasel will query the local nameserver, as it
is reading in the list, to find out whether the specified machine has
alternative names or multiple IP addresses.  This means that you don't
normally need to specify aliases when setting up the list of names.

:p.:hp2.Wildcards:ehp2.

:p.When you are specifying a host name or domain name string, you may
include the wildcard characters '?' and '*'.  When comparing names, the
character '?' matches any single character.  The wildcard character '*'
matches a substring of any length, including a string of zero length.

:p.For example, the string x*.com* would match things like xyz.com,
or x.y.com, and it would also match things like xxx.com.au.

:p.Note that
:ul.
:li.Alphabetic case is not significant in host and domain names; 'Abc' is
considered to be the same as 'abc'.
:li.For the purposes of wildcard matching, punctuation marks like '.' do
not have any special status; they are treated like any other character.
:li.Wildcards are not allowed when you specify a numeric IP address.
:eul.

.*******************************************************************************
.*   THE PMSETUP UTILITY
.***********************************

:h2 id=PMconfiguser toc=123.The PMSetup utility

:p.The program PMSETUP.EXE has two functions:
:ul compact.
:li.To set the parameters that Weasel.exe will use when it starts up.
:li.To define which users may access the POP server.
:eul.

:p.When you run PMSetup, you will get a small screen window with Local/Remote
radio buttons and three pushbuttons. The Remote option is for remote
configuration, which is described in a
:link reftype=hd refid=remoteconfig.separate section:elink.. Normally you
should choose the Local option, which will edit the Weasel.INI file that
resides in the same directory as PMSETUP.EXE. Click on the "GO" button to
start the editing.

:p.The configuration details are split up into a number of different
notebook pages.  Click on the tabs at the bottom of the notebook to select
the page you need.

:p.
The page tabs are

:ul compact.
:li.:link reftype=hd refid=pmconfiguser1.Basic:elink.
:li.:link reftype=hd refid=pmconfigoptions.Options:elink.
:li.:link reftype=hd refid=pmconfiguser2.Users:elink.
:li.:link reftype=hd refid=pmaliases.Aliases:elink.
:li.:link reftype=hd refid=pmconfiguser3.Local:elink.
:li.:link reftype=hd refid=pmconfiguser4.Trusted:elink.
:li.:link reftype=hd refid=pmconfiguser4a.GateFor:elink.
:li.:link reftype=hd refid=pmconfiguser5.Banned:elink.
:eul.

:p.The instructions on the following pages talk of clicking on various
screen controls - that is, pointing the mouse cursor to the control and
clicking mouse button 1.  As with all OS/2 dialogue controls, you can
of course also move around a dialogue using the tab key and the cursor
movement keys on the keyboard.


:h3 id=pmconfiguser1.Setting the basic server parameters
:hp2.Setting the basic server parameters:ehp2.
:p.
The first page in the PMSetup notebook starts with an SMTP section and a POP
section. The SMTP server is for receiving incoming mail (and for forwarding it
to other SMTP servers, if appropriate).  The POP server is the software that
lets your users pick up the mail that has arrived for them.  If Weasel is the
only e-mail software you are running, then you would normally enable both
of these.

:p.Both servers have the options&colon.

:dl break=all.
:dt.Port
:dd.The TCP/IP port on which the server listens for connections.  Unless you are
doing something nonstandard (for example, running two mail servers
on the same machine) this should always be 25 for the SMTP server and 110 for
the POP server.
:p.Hint: One use for nonstandard ports is to allow you to test Weasel without
disabling your existing mail software. You don't have to switch to the standard
port numbers until you've decided that you trust Weasel not to lose your mail.
:dt.Timeout (seconds)
:dd.The time that a session may remain idle before it is forcibly closed.
Most SMTP and POP clients will log out cleanly, but occasionally the server has to
terminate a "dangling" session where, for example, the client machine crashed.
A typical choice for the timeout would be 900 seconds (i.e. 15 minutes).
:dt.Max users
:dd.This specifies how many clients will be allowed to use the server simultaneously.
I usually set this to 10.  The number is not particularly critical; you'd have to
have a very busy mail node before getting simultaneous access from many clients.
:dt.Enabled
:dd.This box must be checked in order to allow the corresponding server to run.
You can disable one of the servers if you are running Weasel in conjunction with
a different POP or SMTP server, or if you have any other reason for running Weasel
as a POP-only or SMTP-only system.  (It would not make sense to disable both
sections, because then Weasel would have nothing to do.)
:edl.

:p.The next item on this page is the root directory for mail. This should be the
full path name of the directory that will be used for storing users'
mail files. This directory should exist, and preferably shouldn't be used
for anything else. Note that PMSetup will create subdirectories in this directory,
if they're not already there, to hold the mail for each user.

:p.Finally, you have a choice of enabling any or all of three different kinds
of log file.

:dl break=all.
:dt.SMTP logging
:dd.If this feature is enabled a record of received mail is written to a file
called SMTP.LOG. Each line in this file described one received mail item: date,
time, sending host, size, and a list of recipients.
:dt.POP user logging
:dd.If this feature is enabled a brief summary of each POP session is written
to a file called POP.LOG.
:dt.Detailed transaction log
:dd.You can choose to send a detailed log to the screen, or to a disk file, or both.
The disk file is called WEASEL.LOG, and it is updated approximately once every
15 minutes if this feature is enabled.
:p.Warning: Transaction logging can create very large log files.  I suggest that
you don't enable this feature unless you're trying to track down a problem.
:edl.

.***********************************
.*   PMSETUP OPTIONAL SETTINGS
.***********************************

:h3 id=pmconfigoptions toc=1234.Options
:hp2.Options:ehp2.
:p.
There are two entry fields on this page; they should be left blank if you
are not using these options.

:dl break=all.
:dt.Filter for incoming mail.
:dd.Normally this should be left blank.  If it is not blank, it should contain
the file name of a program (a CMD or EXE file) that will filter all incoming
mail.  This adds some processing overhead, but allows you to do things like
virus scanning, junk mail filtering, etc., on the incoming items.  Filter
programs are described in :link reftype=hd refid=filters.a separate section:elink..
:dt.Relay host for forwarding mail.
:dd.Normally this should be left blank.  If it is not blank, it should
contain the hostname of another computer that is running an SMTP server and
that will accept relay mail.  All outgoing mail from Weasel will be sent to
that computer, which should accept responsibility for forwarding it on to
its final destination.
:p.Note: This option is provided for the case where, for example, you have
to send all your mail through a gateway.  If you use it, make sure that you
have permission to use the relay host this way.  If you abuse a relay
facility, you might end up discovering that you have been blacklisted and
can no longer send mail to anyone.
:edl.

.***********************************
.*        USER EDITOR
.***********************************

:h3 id=pmconfiguser2 toc=1234.Users
:hp2.Users:ehp2.
:p.
Adding a username on this page has two results&colon.

:ul compact.
:li.It tells the Weasel SMTP server to accept mail for that user on
this machine.
:li.It allows the user to log in to the Weasel POP server and collect any
mail that has arrived.
:eul.

:p.
:hp2.Adding a new user:ehp2.
:p.
Click on the "Add" button, and then proceed as for :link reftype=hd refid=pmedituser.Editing a user record:elink..
:p.
:hp2.Editing the details for an existing user:ehp2.
:p.
Click on the "Edit" button, and then follow the instructions in the section :link reftype=hd refid=pmedituser.Editing a user record:elink..
:p.
:hp2.Deleting a user:ehp2.
:p.
Click on the username to be deleted, and then click on the "Delete" button.

:h4 id=pmedituser.Editing a user record
:hp2.Editing a user record:ehp2.
:p.
When you add a new user, or edit an existing user, you get a new dialogue
box with two entry fields
:dl break=all.
:dt.    User name
:dd.The name that the user will use when logging in.
:dt.    Password
:dd.This user's password.
:edl.
:p.
Alter these as desired, and then either type the Enter key or click on
the "OK" button to confirm the change. If you change your mind, click on
the "Cancel" button and your changes will be ignored.

:warning.If you change the user name, the data for the previous
user name will be deleted.  You should also avoid using a user name
that is the same as for some other user.:ewarning.

.***********************************
.*           ALIASES
.***********************************

:h3 id=pmaliases toc=1234.Aliases
:hp2.Aliases:ehp2.
:p.
An alias looks like a username from the viewpoint of incoming mail,
but the name does not correspond to the name of any POP user.  Instead,
the alias refers to a list of e-mail addresses.  Whenever an e-mail
arrives addressed to that alias, a copy is sent to everyone on the
list.

:p.:hp2.Example 1.:ehp2. Suppose you have a user called Bill Smith who
wants to receive all mail in duplicate, with one copy to each of his two
computers.  You can do this by giving him two user accounts called bill1
and bill2, and setting up an alias "bill.smith" defined as
:xmp.
      bill1
      bill2
:exmp.
:p.With this arrangement, people send mail to Bill by addressing it to
Bill.Smith@yourdomain, but Bill collects his mail by logging in as
bill1 from one of his computers, and as bill2 from the other.

:p.:hp2.Example 2.:ehp2. You can use an alias to set up a simple
mailing list.  Suppose, for example, you have a group of friends who
are interested in chess and want to discuss it as a group.  If you
create an alias called "chessgroup", with entries like
:xmp.
      "Alan Jones" <alanj@xyz.org>
      Bill.Smith
      susan@alpha.beta.uk (Susan G.)
      kw123
      "Me" <myself>
:exmp.
:p.then anyone can send mail to chessgroup@yourdomain, and copies will
be distributed to everyone on the list.

:p.Alias lists may themselves contain aliases.  To guard against circular
definitions, duplicate names are stripped out during the expansion.

:p.As Example 2 shows, an alias list may contain both local and non-local
e-mail addresses, and this can generate relay mail even if the sender is
not otherwise permitted to send relay mail.  As a guard against abuses,
an alias can be set up to be either "public" or "private".  Anyone can
send mail to a public alias.  A private alias can be accessed only by
those senders with "relay mail" privilege.

:p.The following two pages explain how to create and modify aliases.

.***********************************
.*        ALIAS EDITOR
.***********************************

:h4.Adding and changing aliases
:hp2.Adding and changing aliases:ehp2.
:p.
In the "Aliases" page of the PMSetup notebook, you have the following options&colon.
:p.
:hp2.Adding a new alias:ehp2.
:p.
Click on the "Add" button, and type the alias name into the entry field that
appears.  (The entry field will close when you type the Return key.)  Then
proceed as for :link reftype=hd refid=pmeditalias.Editing an alias list:elink..
:p.
:hp2.Editing the expansion of an existing alias:ehp2.
:p.
Click on the listbox entry that you want to change, then click on the "Edit"
button and follow the instructions in the section :link reftype=hd refid=pmeditalias.Editing an alias list:elink..
:p.
:hp2.Renaming an existing alias:ehp2.
:p.
Click on the listbox entry that you want to change, then click on the "Rename"
button.  Edit the name in the entry field that appears.  The name will be changed
when you type the <Enter> key, or when you close the entry window.
:p.
:hp2.Deleting an alias:ehp2.
:p.
Click on the entry you want to delete, then click on the Delete button.

:h4 id=pmeditalias.Editing an alias list
:hp2.Editing an alias list:ehp2.
:p.
An alias expands out to a list of e-mail addresses; these can be either local
or remote addresses.  When you add or edit an alias, you can manipulate this list.
:p.
First, you should decide whether this is to be a private or public alias, and
select the "Private" or "Public" radio button as appropriate.  Anyone can send
mail to a public alias, but only people sending from one of the "Trusted" hosts
can send mail to a private alias.

:p.
:hp2.Adding a new e-mail address:ehp2.
:p.
Click on the "Add" button, and then type an e-mail address.  Use the <Enter> key
when finished, to close the entry-field window.
:p.
:hp2.Editing an existing entry:ehp2.
:p.
Click on the listbox entry to be changed; click on the "Revise" button; and then
edit the e-mail address in the entry field that appears.
:p.
:hp2.Deleting an existing entry:ehp2.
:p.
Click on the listbox entry to be removed, and then click on the "Delete" button.

:p.
When you've finished making modifications on this page, click on the "OK" button
to confirm your changes, or click on the "Cancel" button to throw away the
changes.

.***********************************
.*   NAMES FOR THE LOCAL HOST
.***********************************

:h3 id=pmconfiguser3.Local
:hp2.Local:ehp2.

:p.
This notebook page lists the domain names that Weasel should accept as
names for the machine on which it's running.

:p.An e-mail address has the form "user@domain".  If your local
nameserver has an MX record for your machine that matches the "domain"
part, then this is mail to be delivered locally.

:p.In the case where the "domain" part is actually the hostname of
your machine, or an alias known to your local nameserver, Weasel can work
this out for itself.  Many users, therefore, can afford to leave this
list empty.  Unfortunately Weasel can't (yet) handle the case where the
domain is not a hostname, but is instead something mapped to a hostname
by a nameserver MX record.  (The catch here is that we can't tell
whether the MX record identifies the final destination, or simply a
relay host.  If there's a way to make this distinction, I haven't
yet worked it out.)  In such cases, then, you must explicitly list
the domain name(s) on this page.

:p.Instructions for creating or modifying the list are given on
the manual page called :link reftype=hd refid=pmhostlist.Editing a list of host names:elink..

:p.Note, by the way, that you can't define hostname aliases simply by adding
extra entries to this list.  The aliases are no good unless they're
also recognised by the nameserver.  If the nameserver does not
define a name, then there's no way for people at other sites to use
that name as part of an e-mail address; their own SMTP client will
report an "unknown host" error.

:p.Note, too, that some mail clients will refuse to send mail to
your machine if they can't find an MX record for it.  You should ask
your local network manager - the person who looks after the
nameserver - to include MX records for your computer in the
nameserver tables.

.***********************************
.*   SOURCES FOR RELAY MAIL
.***********************************

:h3 id=pmconfiguser4.Trusted
:hp2.Trusted:ehp2.

:p.
This notebook page lists the hosts that are "trusted", in the sense that
they are allowed to send relay mail to Weasel.

:p.Relay mail is mail that the SMTP server accepts and agrees to
pass on to another host.  The Weasel philosophy is that unlimited
relay mail should not be permitted.  It puts an extra load on your
computer, and it helps junk mailers to hide the real origin of
their junk mail.

:p.There are just two cases where it can make sense to permit
your machine to be used as a relay host.
:ul.
:li.Where your computer is acting as a gateway to a network that
would otherwise be unable to receive mail from the outside world.
This "gateway" function is described on the following page.
:li.Where you want to offer an "outgoing mail" service to the users
that have accounts on your POP server.  This function is the subject
of the current page.
:eul.
:p.The "Trusted" list is a list of host names.  Mail sent
from those hosts, and addressed to some third host, will be accepted
to be forwarded.  Mail sent from elsewhere will not be accepted
unless it is addressed to the machine on which Weasel is running, or
to a domain on the "GateFor" list.
In other words, Weasel will not accept mail for relaying except
when it comes from one of the hosts on this list, or when it's
going to an approved destination.

:p.Note: there are no default trusted hosts.  Even mail from your
own computer will be rejected if it does not satisfy one of the
above two conditions.

:p.Instructions for creating or modifying the list are given on
the manual page called :link reftype=hd refid=pmhostlist.Editing a list of host names:elink..

.***********************************
.*   ACCEPTABLE RELAY DESTINATIONS
.***********************************

:h3 id=pmconfiguser4a.GateFor
:hp2.GateFor:ehp2.

:p.
This page lists the acceptable destinations for relay mail&colon. the
addresses for which Weasel will accept relay mail even from
non-trusted hosts.

:p.Relay mail is mail that the SMTP server accepts and agrees to
pass on to another host.  The Weasel philosophy is that unlimited
relay mail should not be permitted.  It puts an extra load on your
computer, and it helps junk mailers to hide the real origin of
their junk mail.

:p.There are just two cases where it can make sense to permit
your machine to be used as a relay host.
:ul.
:li.Where your computer is acting as a gateway to a network that
would otherwise be unable to receive mail from the outside world.
This "gateway" function is the subject of the present page.
:li.Where you want to offer an "outgoing mail" service to the users
that have accounts on your POP server.  This function was described
on the previous page.
:eul.
:p.The "acceptable destinations" list is a list of domain names.  Mail
addressed to those domains will be accepted
to be forwarded, whether or not it comes from one of the "trusted hosts".

:p.Instructions for creating or modifying the list are given on
the manual page called :link reftype=hd refid=pmhostlist.Editing a list of host names:elink..

.***********************************
.*   BANNED HOSTS
.***********************************

:h3 id=pmconfiguser5.Banned
:hp2.Banned:ehp2.

:p.This page contains your personal blacklist of hosts that are not
allowed to send mail to (or via) your server.  Weasel will refuse to accept any mail
from hosts on this list.

:p.Instructions for creating or modifying this list are given on
the manual page called :link reftype=hd refid=pmhostlist.Editing a list of host names:elink..

.***********************************
.*   EDITING A HOST LIST
.***********************************

:h3 id=pmhostlist.Editing a list of host names
:hp2.Editing a list of host names:ehp2.

:p.Several of the PMSetup notebook pages have a list of host names.  On
those pages you have the following options:

:dl tsize=15.
:dt.   Add
:dd.Add a new entry.  Once you've typed the new entry, use the
Enter key to complete the operation.
:dt.   Promote
:dd.Move the current entry up in the list.  You can use
this for changing the order of the entries in the list.
:dt.   Delete
:dd.Deletes the current entry.
:edl.

:p.:hp2.The format of a list entry:ehp2.

:p.Entries in the list can be in one of four forms:

:ul.
:li.An IP address enclosed in square brackets, for example [123.45.6.78].
This must be a fixed number; wildcards are not allowed in this format.
:li.An IP address range, for example [123.45.6.78-99].  This means all
addresses in the range [123.45.6.78] to [123.45.6.99], inclusive.  You
may only have a single number after the '-' character.  As a more
complicated example, [1.2.3-8] means all addresses in the range from
[1.2.3.0] up to [1.2.8.255].
:li.A hostname, for example alpha.beta.com.  In this case wildcards are
allowed - see below.
:li.A domain name starting with the '.' character.  This is a "wildcard"
entry that will match any hostname that ends with that domain name.
This form is supported for compatibility with older versions of Weasel,
but it is being phased out now that the '*' form of wildcard is
available.
:eul.

:p.Where possible - that is, when ranges or wildcard characters are not used -
Weasel will query the local nameserver, as it
is reading in the list, to find out whether the specified machine has
alternative names or multiple IP addresses.  This means that you don't
normally need to specify aliases when setting up the list of names.

:p.:hp2.Wildcards:ehp2.

:p.When you are specifying a host name or domain name string, you may
include the wildcard characters '?' and '*'.  When comparing names, the
character '?' matches any single character.  The wildcard character '*'
matches a substring of any length, including a string of zero length.

:p.For example, the string x*.com* would match things like xyz.com,
or x.y.com, and it would also match things like xxx.com.au.

:p.Note that
:ul.
:li.Alphabetic case is not significant in host and domain names; 'Abc' is
considered to be the same as 'abc'.
:li.For the purposes of wildcard matching, punctuation marks like '.' do
not have any special status; they are treated like any other character.
:li.Wildcards are not allowed when you specify a numeric IP address.
:eul.

.*************************************************************************
.*   REMOTE CONFIGURATION
.***********************************

:h2 id=remoteconfig.Remote configuration

:p.PMSetup also offers the option of remote setup.  That
is, you can run PMSetup on one computer and use it to configure a copy
of Weasel that is installed on a different computer.  To do this, you have
to have the freeware utility INIServe running on the same computer as
Weasel.  You can find INIServe at http&colon.&slash.&slash.eepjm.newcastle.edu.au&slash.os2.

:p.If you select the "Remote" radio button after starting PMSetup, a "Setup"
pushbutton is enabled.  Clicking on this gives you four fields to fill in&colon.

:dl break=all.
:dt.Hostname
:dd.The name (or IP address) of the machine on which Weasel is running.
:dt.INIServe port
:dd.The TCP port that INIServe has been configured to listen on.  The default
value is 8000.
:dt.INIServe password
:dd.The password needed to log in to your copy of INIServe.
:dt.Weasel directory
:dd.The full path name of the directory, on the remote machine, where Weasel
is installed.
:edl.

:p.When you close the Setup window, you can click on the "GO" button to connect
to the remote machine.  If this gives a "failed to connect" or similar error
message, it probably means that you don't have INIServe running on the
remote machine, or that you've done something like specifying an incorrect
port number.

:p.Once the connection is made, the operation is the same as for the
case of local configuration.  Note, however, that INIServe will not create
any directories on the remote machine.  If you add users, you'll still
have to use a tool like telnet or ftp to create the users' mail directories.

.***********************************
.*   RUNNING THE SERVER
.***********************************

:h1.Running Weasel
:hp2.Running Weasel:ehp2.
:p.
The server executable is called WEASEL.EXE.  You can run this the way you run
any other OS/2 program: from the command-line, by clicking on an icon, from
the Startup folder, etc.  If you're running several server applications, then
the most obvious choice is to put a command to start the server in the
command file \TCPIP\BIN\TCPSTART.CMD.
:p.
You also have the options of :link reftype=hd refid=inetd.running the server from inetd:elink.
or :link reftype=hd refid=detached.running the server as a detached program:elink..
:p.
To shut down the program, type Ctrl/C.  (That is, hold down the Ctrl key while
typing 'C'.)  There might be a delay before the program terminates, because
Weasel will allow any transactions in progress to complete before shutting down.

:p.If you type Ctrl/C more than once, Weasel shuts down even if there are
POP clients who have not yet logged out. Even in this case there can still
be a delay if the program is in the middle of a slow operation.  If you
really need to shut down Weasel without a delay, use a process killer (e.g.
the one that comes with the WarpCenter); but if you do this there is a risk
of lost mail because the program has not tidied up properly.

:p.The 'G' and 'Q' keyboard commands, which were used for shutdown in older
versions of Weasel, are no longer supported.  (Keyboard support was removed
because it was conflicting with the spawning of user-written filters.)

:h2 id=inetd.Running from inetd
:hp2.Running the server from inetd:ehp2.

:note.The inetd option has been implemented, but not yet tested.

:p.
Inetd, which is part of the Warp 4 distribution, is a "listener"
program that can intercept incoming connection attempts, and
start up a server when needed.
:p.
The advantage is that Weasel doesn't actually get loaded into
main memory until a client wants to connect.  Thus, it might be
a good option if you expect clients to connect only occasionally.
:p.
The disadvantage is that a separate copy of the server is
started for each logged-in user.  This makes inetd a bad choice
if you expect lots of connections.
:p.
If you want to run Weasel from inetd, the way to do it is
as follows:
:ol.
:li.Ensure that inetd will be run the next time you boot.
The usual way of doing this is to include the line
.br
           start /min inetd
.br
in your TCPSTART.CMD, and to invoke TCPSTART.CMD from
your startup folder.  TCPSTART.CMD may be found in the
directory \tcpip\bin.

:li.Edit the file \mptn\etc\inetd.lst so that it contains one
or both of the lines
.br
     pop3 tcp start /C /min d&colon.\Apps2\Weasel\weasel.exe
.br
     smtp tcp start /C /min d&colon.\Apps2\Weasel\weasel.exe
.br
(adjusting the path so that it refers to the directory
where you've installed Weasel).
:eol.

:p.In principle you can now start inetd.  In practice I've found
that inetd doesn't release ports reliably, so if you already
have inetd running you'll probably have to re-boot.
:p.
Remark: I'm starting to suspect that inetd adds more overhead
than it saves, so I've reverted to not using it on my own
machine.

:h2 id=detached.Running Weasel detached
:hp2.Running the server as a detached program:ehp2.

:p.If you want to run the server detached, the appropriate command is
.br
       DETACH WEASEL
.br
Note that a detached program
does not have any way of doing screen output or keyboard input,
so you can't get any screen messages in this case.

:p.The only time that you need screen output from this program is
when you're testing it. Once you've decided to use it permanently,
it's probably a good idea to leave it detached, so that it doesn't
get in the way of the things you really want on your screen.

:h2.Operating with a dial-up connection
:hp2.Operating with a dial-up connection:ehp2.

:p.A mail server normally needs a permanent network connection, so
that it can accept incoming mail. If, however, you can arrange for
another machine to act as an MX relay for you then it might be
feasible to run Weasel with only an intermittent network connection.
In such a situation we would like to be able to specify that
outbound mail be stored for later delivery.

:p.Periodically - about once every five minutes, or more often in
some situations - Weasel checks for the existence of a file called 'ONLINE'
(without the quote marks) in its own directory.  The content of this file is
not important, only the question of whether the file exists.  If it exists,
Weasel assumes that there is an on-line connection and it will attempt to
deliver waiting mail.  If the file does not exist, Weasel queues the outbound
mail for later delivery.

:p.With a dial-up connection, therefore, you should create the file ONLINE
when you have established a connection, and delete that file (or move it to
another directory) when you disconnect from the network.  You can do this
manually, or - depending on what sort of dialler software you are using - you
can make it a part of your dial-up script.

:h2.Setting the time zone
:hp2.Setting the time zone:ehp2.

:p.Incoming mail has a "Received:" line added as the first line of
the header.  (If the mail went through one or more relay hosts, there
will be several "Received:" lines.  If you're trying to trace the origin
of junk mail, this is the first place to look.)  The last thing that
Weasel puts on that line is a time zone indicator, for example +1000.
Many OS/2 installations, however, don't have their time zone set.
If you find that the "Received:" header line has a date and time, but
no time zone, you need to set the time zone on your machine.

:p.One way to do this is with my TZSet utility.  You can find this
at http&colon.&slash.&slash.eepjm.newcastle.edu.au/os2.

.***********************************
.*   FILTERS
.***********************************

:h1 id=filters.Filters
:hp2.Filters:ehp2.

:p.You have the option in the Weasel setup of specifying a
pre-delivery filter.  The filter, if present, is executed after
the Weasel SMTP server has received a mail item (header + body), but before
it has put it into a local mailbox or forwarded it.

:p.At this point the message is in a temporary message file, in
the standard e-mail format: the header lines, one blank line, and
then the message body.  The first header line is the "Return-path:"
line, and this is followed by one or more "Received:" lines.
Header lines after this can occur in any order, depending on
the sender.

:p.The filter can examine the temporary message file, optionally
copy it or change its contents, and then return a reply code to
Weasel saying whether or not the message should be delivered.

:p.The filter can be written as a REXX script, or alternatively it
can be written in any programming language you like and
compiled and linked into EXE format.

:p.The filter is invoked by Weasel with the command
:xmp.
         CMD.EXE /C filterprog messagefile namefile

:exmp.
where "filterprog" is the name of the CMD or EXE file to be
executed, "messagefile" is the full pathname of the
temporary message file, and "namefile" is the full pathname of a
text file containing a list of e-mail addresses, one per line.
(The line terminator is carriage return followed by line feed.)
The first line identifies the sender, and the remaining
lines are the e-mail addresses of the recipients.

:p.The filter should return one of the following values.

:dl.
:dt.    0
:dd.handle message normally, i.e. deliver it as if there had been no filter.
:dt.    1
:dd.reconstruct the list of recipients from the namefile,
because the filter has altered the namefile; and then
continue handling the message normally.
:dt.    2
:dd.don't deliver the message (we presume that the filter
has already taken care of the delivery, if desired), and return the reply
:xmp.           250 OK
:exmp.
to the client.
:dt.    3
:dd.don't deliver the message, and return the reply
:xmp.           554 Mail rejected by server
:exmp.
to the client.
:edl.

:p.NOTE: In all four cases, the temporary message file is deleted
after the filter has seen it and Weasel has copied it into the
user's mailboxes.  If the filter wants to take care
of delivery (case 2) then it must take a copy of the message file.

:p.If the filter exits with an error, or returns a result code
outside the range [0..3], then Weasel acts as if the result had
been 0, i.e. the filter has no effect.  This is to guard against
badly written filters.

.***********************************
.*   USING A DIFFERENT SMTP SERVER
.***********************************

:h1 id=otherSMTP.Using a different SMTP server

:p.It is possible to run the Weasel POP server without running the
Weasel SMTP server. (Or vice versa.) To do this, use the Setup
program and change the menu selection in the "Enable servers" field.
The change will take effect the next time you start Weasel.

:p.You have to make sure, of course, that the other SMTP server
you're running will store mail in a place where Weasel can find it.
The details depend on which SMTP server you're using. See

:ul compact.
:li.:link reftype=hd refid=SMTPsendmail.Using IBM's sendmail:elink.
:li.:link reftype=hd refid=SMTPother.Using a third-party SMTP server:elink.
:eul.

:h2 id=SMTPsendmail.Using IBM's sendmail
:hp2.Using IBM's sendmail:ehp2.

:p.The sendmail program is a standard part of the OS/2 Warp Connect and
Warp 4 distributions.  For Warp 3, it's either standard or part
of the "Bonus Pack" for Warp 3 - I've forgotten which.

:p.I've never been happy with sendmail.  It's difficult to configure,
and it seems to consume a huge amount of processor time.  (That's one
of the reasons I decided to write Weasel.)  However, it supports some
things that Weasel does not support, such as unrestricted relay mail.
If you need those features, sendmail might be your best solution.

:p.To support this option, the Weasel distribution includes a
program called "endmail.exe".  This is a program that sendmail
can invoke, to deliver the incoming mail to Weasel's mailboxes.

:p.:hp2.Installation:ehp2.

:ol.
:li.Make a backup copy of your SENDMAIL.CF.  For Warp 4 users, this
file is in the directory \MPTN\ETC.  In Warp 3, it's either
there or in \TCPIP\ETC.

:note text='Warning 1.'.I'm not joking about the backup.  If you make a
mistake while editing SENDMAIL.CF, it can be very difficult
to recover.

:note text='Warning 2.'.In the next step, you'll need a text editor to
edit SENDMAIL.CF.  Make sure that you :hp1.do not:ehp1. use an editor
that converts tabs to spaces or that re-wraps lines.  The
OS/2 System Editor (E.EXE) is safe.  The Enhanced Editor
(EPM.EXE) is not safe.  If you prefer some other editor,
first check on what it does to tab characters.

:li. (Most experienced users can probably skip this step.)
If you've never run sendmail as a server before, run the TCP/IP
Configuration Program and fill in the e-mail details for the
case where Ultimail Lite is :hp1.not:ehp1. your e-mail program.  This
will insert a few basic definitions (domain name, etc.) into
your SENDMAIL.CF.

:li. Find the line in SENDMAIL.CF that starts with the characters
"Mlocal" (without the quote marks).  Edit it so that it looks
like this (all in one line):

:xmp.
 Mlocal, P=d&colon.\apps\weasel\endmail.exe, F=lnsDFP, S=10, R=0, A=d&colon.\apps\weasel\MailRoot\ $i $u
:exmp.

:p.Note that:
:ul.
:li.the filename after "P=" should be the complete pathname of endmail.exe.
:li.the first letter after "F=" is a lower-case "L", not
an upper-case "i".  (If you're confused, re-read the
Mlocal line in something like a Times font.)
:li.the name after "A=" should be the name of the directory
that you set up as your "mail root" when installing Weasel.
The final '\' in the directory name must be included.
:li.the line should end with the parameters "$i $u" (without the quotes).
I mention this only because you might have missed seeing it in the long
line above.
:eul.

:li.Make a backup copy of the altered SENDMAIL.CF (but don't overwrite
the backup you created in step 1, just in case you have to restore
your original configuration).  You'll need this backup if you ever
run the TCP/IP Configuration Program, because that program destroys
any changes you've made to SENDMAIL.CF.

:li. If sendmail.exe is already running, kill it.  It needs to be
restarted so that it will read the modified SENDMAIL.CF.

:li. Start sendmail as an SMTP server with the command
:xmp.
           sendmail -bd
:exmp.

:li. Send yourself some test mail to check that everything is working.
If something went wrong, it's probably caused by an error in SENDMAIL.CF.

:li. Once you're satisfied with the results, ensure that
TCPIP\BIN\TCPSTART.CMD contains a line like the following
:xmp.
      detach sendmail -bd -q15m -CE&colon.\MPTN\ETC\sendmail.cf
:exmp.
:p.(with, of course, the correct drive letter after the "-C").
Alternatively, make whatever other arrangements you prefer
to ensure that sendmail will be started with the -bd parameter
each time you connect to the network.

:eol.

:p.:hp2.Limitations, warnings, etc.:ehp2.
:ul.
:li.You did remember to disable the SMTP part of Weasel, didn't
you?  If Weasel is listening on port 25, sendmail won't work.

:li.I almost forgot: the filenames generated by endmail.exe might
not be compatible with the FAT 8.3 rule.  To get this to work
properly, your mailroot directory should be on an HPFS partition.

:p.(But then, you should never run :hp1.any:ehp1. e-mail program on a
FAT partition.  E-mail software almost always generates lots
of small files, and on FAT partitions this can cause horrible
fragmentation.

:p.The same is true, by the way, for FAT32 and NTFS.  If you
have any friends using Windows NT, you should advise them to
create an HPFS partition to hold their mail software.  If
they're running Windows 95 or Fixpack 98, tell them to get hold
of a good defragger, or to avoid using e-mail.)
:eul.

:h2 id=SMTPother.Using a third-party SMTP server

:p.The Weasel POP server can work in conjunction with any SMTP server that
satisfied the following conditions.

:ul.
:li.A user's mail is stored in a directory whose name has the form mailroot\user,
where "mailroot" is a fixed directory and "user" matches the user's e-mail
address.
:li.Each e-mail message is stored as a single "plain text" file, in the
standard e-mail format (header, blank line, body); and the file name is
of the form "something.MSG".
:eul.

:p.Of course, there's no guarantee that any given SMTP server will satisfy
these conditions; but it's often easy to write a little conversion
program that will copy the files across. (If there's enough demand,
I might be able to write the conversion programs. I won't do it for something that's
used only by two or three people, but I'll certainly consider it if
some particular program turns out to be widely used.)


.***********************************
.*   TROUBLESHOOTING
.***********************************

:h1.Troubleshooting

:p.:hp2.Unlocking a locked mailbox:ehp2.

:p.Sometimes a POP client will get a "mailbox is locked" message
while trying to fetch mail. If this happens, go to the user's mail
directory and delete the file LOCK.!!!

:p.Normally Weasel deletes this file when a POP session finishes.
The lock file might, however, be left undeleted if your computer
crashes, or if you shut down Weasel while a POP session is in progress.
Although Weasel checks for locked mailboxes on startup, it might
fail to clear the lock in unusual circumstances - e.g. if the
lock file attributes somehow got set to be read-only.

:p.:hp2.Slow startup?:ehp2.

:p.If you're getting a long time delay while Weasel is starting,
it's probably caused by Weasel having to wait for responses from
your local nameserver.  There are two likely causes for a slow
response:
:ul.
:li.The nameserver is not responding, because of a network problem
or because the nameserver has crashed.  If this is the problem then
you'll simply have to accept the delay, because the problem is on
some other computer.
:li.One of the host names in your master lists (local hosts, acceptable
relay hosts, banned hosts) does not exist.  In this case the nameserver
responds slowly because it must, in effect, search the entire world
for the nonexistent name.  The solution for this is to run Setup and
remove the useless name from the list.
:eul.

:p.:hp2.Outgoing mail is rejected?:ehp2.

:p.If outgoing mail is accumulating in the "forward" directory without
being sent out, the likely problem is that you don't have a file called
ONLINE in the same directory as Weasel.exe.  If this file doesn't exist,
Weasel won't try to send out the mail.

:p.If mail is being rejected with a message that says "User not local,
please try ...", it means that the sender is not authorised to send relay
mail.  To authorise it, you have to include the sending host in the
list of "Acceptable sources for relay mail".

:p.:hp2.Stopping PMMail from crashing:ehp2.

:p.There is something that PMMail doesn't like about Weasel's
response to the TOP command, and I haven't yet figured out what it is.
If you find that PMMail crashes when trying to fetch mail, open the
PMMail Account Settings, go to the Receive page, and enable the
"Quick Interrogation" option.

:p.(The problem appears to have been fixed in the latest version of PMMail.)

.***********************************
.*   DEVELOPMENT NOTES
.***********************************

:h1.Development notes

:ul.
:li.:link reftype=hd refid=tools.Development tools:elink.
:li.:link reftype=hd refid=whyM2.Why Modula-2?:elink.
:li.:link reftype=hd refid=bugs.Known bugs:elink.
:li.:link reftype=hd refid=wishlist.Wish list:elink.
:li.:link reftype=hd refid=reporting.Reporting errors:elink.
:eul.

:h2 id=tools.Development tools
:hp2.Development tools:ehp2.

:p.Some people have asked about the compiler I'm using.  (I guess a
lot of people didn't realise that there were Modula-2 compilers
for OS/2.)  It's XDS Modula-2, OS/2 native mode version.

You can find out about this, and other Modula-2 compilers for OS/2,
at the web page
.br
     http&colon.//www.ee.newcastle.edu.au/users/staff/peter/os2/os2m2.html
.br
(I'm getting a little behind on keeping my web pages up to date,
but the information is still basically correct, only the version
numbers have changed.)
:p.The XDS home page is at
.br
      http&colon.//www.xds.ru/
.br
This is well worth visiting, because the XDS development team often
has "try before you buy" versions of their compilers available for download.
:p.
Weasel uses some of the modules from the PMOS/2 library.
If you want to know more about PMOS/2, you'll also find that on
my web pages.  Source code is available.  My web pages are at
http&colon.//www.ee.newcastle.edu.au/users/staff/peter/Moylan.html.

:p.The PMSetup utility was built with the aid of a dialogue editor (available free
from IBM) called DrDialog.

:p.
This documentation was prepared with IBM's IPFC help compiler.

:h2 id=whyM2.Why Modula-2?
:hp2.Why Modula-2?:ehp2.
:p.
I'm often asked why I chose to code my software in Modula-2.  Everyone
else seems to be using C or C++, so why don't I?
:p.
The short answer is that I don't think much of the "everyone else uses it"
argument.  If popularity was more important to me than technical merit,
I wouldn't be using OS/2.
:p.
The long answer is contained in a document called "The Case Against C",
which can be found at
http&colon.//murray.newcastle.edu.au/users/ftp/pub/reports/CaseAgainstC.ps.Z.
This is a compressed Postscript file.  If you can't handle compressed
Postscript, a text-only version (CaseAgainstC.txt) can be found in the
same directory.
:p.
And the medium-length answer is on this page.
:p.
To begin with, run-time efficiency is not as big an issue as most people
seem to think it is.  With modern compiler technology, the main programming
languages (apart from things like BASIC and its derivatives) give about
the same run-time efficiency.  C and C++ lose out a little because their
low-level constructs make it hard for the compiler to do a good job at
optimisation; the figures I've seen tend to suggest that a program written in
Modula-2 runs a little faster than the same program written in C or C++.
However, the difference is typically less than 5%, and hardly worth worrying
about.
:p.
So the big issue is development efficiency.  For a job like this we can
rule out languages like BASIC and REXX because they're a little too crude;
and we can rule out languages like Fortran because of their poor support
for "systems programming" tasks.  We can also rule out a host of lesser-known
languages because of the unavailability of OS/2 compilers.  That leaves us
with Pascal, Ada, Oberon, Modula-2, C, and C++.
:p.
I don't use Pascal because Modula-2 is basically an upgraded Pascal, and I
might as well use the improved version.
:p.
I haven't looked into the availability of Ada compilers for OS/2; but in any
case I don't like Ada because of its complexity.  The bigger a language is,
the more things there are to go wrong.
:p.
Oberon is a more subjective matter.  Some people will tell you that Oberon
is the successor to Modula-2, and is a superior programming language.  My
personal opinion is that Oberon has deleted some of the features that make
Modula-2 a good language.  I agree, however, that this issue is not entirely
clear-cut.
:p.
That brings us to C and C++.  I've done a lot of C and C++ programming over
the years, and it's left me with the feeling that those languages are major
barriers to programming efficiency.  It takes me roughly twice the time
to get a C or C++ program working as it does to get a comparable Modula-2
program working.  (On some projects I've kept logs to verify this.)  The
coding time is roughly the same, but there's a major difference in
debugging time.  Everyone I know writes buggy software in C and C++, and
then they take forever trying to track down the bugs.  Some developers
give up, and sell the software with the bugs still included.
:p.
There are two main reasons why C software is so bug-prone.
:ol.
:li.Lack of type safety.  C is designed in such a way that the compiler can't
do much error checking, so the compiler gives no warnings for things that, in
a type-safe language, would be reported as errors at compile time.  You don't
see the errors until execution time, and then you're left wondering what caused
the error.
:li.Poor support for modular programming.  You can break up a C program into
modules, but they're not truly independent of one another.  A slight change
in one module can have catastrophic effects on other modules.  Once a project
grows moderately large, you lose control of your own code.
:eol.
:p.
C++ is a little better in these two respects, but C++ has problems of its own.
The language designers tried to graft high-level features onto a low-level
language, and the result is a mass of inconsistency.  A C++ reference manual
is typically several times as thick as manuals for other programming languages,
because every rule has a maze of exceptions and special cases.
:p.
In addition, I've noticed that a lot of C++ programmers seem to have
adopted the philosophy of "let's try this, and hope that it works".  The notion
that you shouldn't write code that you don't understand seems to have become
unfashionable.  Maybe that's the fault of the language (and its libraries),
maybe not.  In any case, it's not the way I prefer to work.
:p.
Ultimately, the reason I use Modula-2 is that it lets me get applications
working quickly, it gives me control of large projects, and it doesn't force
me to spend huge amounts of time on debugging.  I'm too old to enjoy the
thrill of tracking down obscure bugs.  I like to get something working, and
then be free to move on to other projects.
:p.
Of course, it's difficult to guarantee that any piece of software is bug-free,
no matter what development tools you use.  But I can have the next-best
thing, which is an acceptably small error rate.

:h2 id=bugs.Known bugs
:p.:hp2.Known bugs and limitations in Weasel:ehp2.

:ul.
:li.The option of running from inetd is untested.
:eul.

:h2 id=wishlist.Wish list
:p.:hp2.Wish List:ehp2.

:p.
A list of things that various people have asked for, and that
I might (or might not) implement in a future version.

:p.For now there's nothing on the list.  (I've received some
requests, but haven't yet sorted them.)

:note.I'm trying very hard to keep Weasel lightweight and simple,
so I don't want to add lots of fancy features. My main goal for
the future is to add checks that will eliminate some of the junk mail.

:h2 id=reporting.Reporting errors

:p.If you find any error that's not mentioned
in this document, please report it to peter@ee.newcastle.edu.au.

:p.If you need to send me paper mail, the address is
.br
:lm margin=8.
.br
P.J. Moylan
.br
Department of Electrical and Computer Engineering
.br
The University of Newcastle
.br
NSW 2308, Australia.

.***********************************
.*   POP GOES THE WEASEL
.***********************************

:h1.Why did the weasel go pop?
:hp2.Why did the weasel go pop?:ehp2.

:p.Many children learn a traditional song from England called
"Pop goes the weasel".  There are many versions; this is the one
that I learnt as a child.
:xmp.
        Half a pound of tuppeny rice
        Half a pound of treacle
        That's the way the money goes
        Pop goes the weasel
:exmp.
:p.If English is not your native language, you won't understand this. It uses
words that aren't properly explained in the dictionary.

:p.Tuppeny rice is rice that costs two pennies per pound.  This doesn't
sound like much money, but it's a very old song.

:p.Your dictionary will probably tell you that a weasel is a small
animal. It's true, that is the most common meaning. But not in this song.
There are a few different theories on the meaning here.  The most
commonly accepted theory is that a weasel was a tailor's iron.
This is such an old and unusual meaning of the word that it's
missing from even relatively large dictionaries.

:p."Pop" is the noise that you hear when you stick a pin into a balloon.
Perhaps it's also the noise that happens when you pump too much air into
a small furry animal; but I'm not sure, because I've never tried that
experiment.

:p.In English, though, short words usually have more than one meaning.
In this song, "pop" means "pawn". You pawn something by taking it to a
pawnshop. A pawnshop is a place that will lend you money in exchange for
anything valuable. Maybe next week you'll have enough money to buy back
the items that you pawned. Maybe not. A pawnshop is a method for making
poor people even poorer.

:p.By now you should be able to guess the meaning of the song. The
poor fellow has had to pawn his weasel in order to buy food (rice and treacle).

:p.In case you're feeling sorry for him, I'll tell you the second
verse of the song.
:xmp.
        Up and down the City Road,
        In and out of the Eagle
        That's the way the money goes
        Pop goes the weasel
:exmp.
:p.In this verse, "The Eagle" is the name of a pub: a place that
sells alcoholic drinks. Alcohol is usually more expensive
than rice and treacle. I'll leave you to draw your own conclusions.

:p.There is, I've been told, still a pub called "The Eagle" near the
City Road in London.  That one was built somewhere near the beginning
of the 19th century.  Before that, there was another pub with the
same name and in approximately the same location.  The song "Pop
goes the weasel" probably comes from a long time earlier than the
19th century; I don't know whether anyone knows exactly how old
it is.

:euserdoc.


