MODULE EndMail;

        (********************************************************)
        (*                                                      *)
        (*         Accepts incoming mail from sendmail          *)
        (*                                                      *)
        (*  This requires a line in sendmail.cf similar to the  *)
        (*  following (all in one line):                        *)
        (*    Mlocal, P=d:\apps\weasel\endmail.exe, F=lnsDFP,   *)
        (*      S=10, R=0, A=d:\apps\weasel\MailRoot\ $i $u     *)
        (*                                                      *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Started:            25 April 1998                   *)
        (*  Last edited:        28 October 1999                 *)
        (*  Status:             OK except for problem below     *)
        (*                                                      *)
        (*     Problem: if user does not exist, the sender      *)
        (*     gets back an "internal error 0" message.         *)
        (*     I don't yet know how to tell sendmail how        *)
        (*     to return a "no such user" reply.                *)
        (*                                                      *)
        (*     The user "postmaster" also receives a copy of    *)
        (*     the error report.                                *)
        (*                                                      *)
        (*     I have now changed the error code from 3 to      *)
        (*     67.  This should fix the problem, but I have     *)
        (*     not yet tested the change.                       *)
        (*                                                      *)
        (********************************************************)

FROM SYSTEM IMPORT ADR;

IMPORT STextIO, TextIO, Strings, OS2, IOChan, IOConsts,
       ChanConsts, SeqFile, SIOResult, FileSys;

FROM ProgramArgs IMPORT
    (* proc *)  ArgChan, IsArgPresent;

FROM FinalExit IMPORT
    (* proc *)  SetTerminationProcedure;

(********************************************************************************)

CONST Nul = CHR(0);

TYPE
    FilenameString = ARRAY [0..511] OF CHAR;

VAR
    MailRoot, MessageID, userID: FilenameString;

(********************************************************************************)

PROCEDURE GetParameters (VAR (*OUT*) MessageID, userID: FilenameString);

    (* Picks up program arguments from the command line. *)

    TYPE CharNumber = [0..511];

    VAR j: CARDINAL;
        ArgString: ARRAY CharNumber OF CHAR;

    (****************************************************************************)

    PROCEDURE GetArg (VAR (*OUT*) result: ARRAY OF CHAR);

        (* Loads a text string from the argument channel. *)

        VAR k: CARDINAL;

        BEGIN
            (* Skip any leading blanks. *)

            LOOP
                IF ArgString[j] <> ' ' THEN EXIT(*LOOP*) END(*IF*);
                IF j = MAX(CharNumber) THEN
                    ArgString[j] := Nul;  EXIT (*LOOP*);
                ELSE
                    INC (j);
                END (*IF*);
            END (*LOOP*);

            (* Read string, terminator is space or end-of-input. *)

            k := 0;
            WHILE (ArgString[j] <> ' ') AND (ArgString[j] <> Nul) DO
                result[k] := ArgString[j];
                INC (j);  INC(k);
            END (*WHILE*);
            result[k] := Nul;
        END GetArg;

    (****************************************************************************)

    VAR args: IOChan.ChanId;

    BEGIN
        args := ArgChan();
        IF IsArgPresent() THEN
            j := 0;
            TextIO.ReadString (args, ArgString);
            GetArg (MailRoot);
            GetArg (MessageID);
            GetArg (userID);
        END (*IF*);
    END GetParameters;

(********************************************************************************)

PROCEDURE CopyFromStdIn (outfile: IOChan.ChanId);

    VAR MoreToGo, AtEOL: BOOLEAN;
        buffer: ARRAY [0..2047] OF CHAR;
        result: IOConsts.ReadResults;

    BEGIN
        AtEOL := TRUE;
        MoreToGo := TRUE;
        WHILE MoreToGo DO
            STextIO.ReadString (buffer);

            (* Result is set to the value allRight, endOfLine, or endOfInput. *)

            result := SIOResult.ReadResult ();
            IF result = IOConsts.endOfInput THEN

                MoreToGo := FALSE;

            ELSIF result = IOConsts.endOfLine THEN

                TextIO.WriteLn (outfile);
                STextIO.SkipLine;
                AtEOL := TRUE;

            ELSE

                TextIO.WriteString (outfile, buffer);
                AtEOL := FALSE;

            END (*IF*);

        END (*WHILE*);

        IF NOT AtEOL THEN
            TextIO.WriteLn (outfile);
        END (*IF*);

    END CopyFromStdIn;

(********************************************************************************)

PROCEDURE CopyFile (VAR (*IN*) filename: FilenameString): BOOLEAN;

    VAR outfile: IOChan.ChanId;
        res: ChanConsts.OpenResults;
        success: BOOLEAN;

    BEGIN
        SeqFile.OpenWrite (outfile, filename,
                        SeqFile.write + SeqFile.text, res);
        success := res = ChanConsts.opened;
        IF success THEN
            CopyFromStdIn (outfile);
            SeqFile.Close (outfile);
        END (*IF*);
        RETURN success;
    END CopyFile;

(********************************************************************************)

PROCEDURE DeliverTheMessage(): BOOLEAN;

    VAR targetname, tempname: FilenameString;
        success, dummy: BOOLEAN;

    BEGIN
        GetParameters (MessageID, userID);
        Strings.Assign (MailRoot, targetname);
        Strings.Append (userID, targetname);
        Strings.Append ('\', targetname);
        Strings.Append (MessageID, targetname);
        Strings.Assign (targetname, tempname);
        Strings.Append (".###", tempname);
        Strings.Append (".MSG", targetname);
        success := CopyFile (tempname);
        IF success THEN
            FileSys.Rename (tempname, targetname, success);
        END (*IF*);
        IF NOT success THEN
            FileSys.Remove (tempname, dummy);
        END (*IF*);
        RETURN success;
    END DeliverTheMessage;

(********************************************************************************)
(*                               FAILURE EXIT                                   *)
(********************************************************************************)

PROCEDURE FailureExit;

    (* This procedure is called, during termination processing, if the mail     *)
    (* was undeliverable.                                                       *)

    CONST result = 67;

    BEGIN
        OS2.DosExit (OS2.EXIT_THREAD, result);
    END FailureExit;

(********************************************************************************)
(*                                 MAIN PROGRAM                                 *)
(********************************************************************************)

VAR result: CARDINAL;

BEGIN
    IF DeliverTheMessage() THEN
        result := 0;
    ELSE
        result := 3;
        SetTerminationProcedure (FailureExit);
    END (*IF*);
END EndMail.

