MODULE ExecTest;

        (********************************************************)
        (*                                                      *)
        (*         Test of invoking another program             *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Started:            11 June 1999                    *)
        (*  Last edited:        18 June 1999                    *)
        (*  Status:             OK                              *)
        (*                                                      *)
        (*  Conclusions so far:                                 *)
        (*   DosExecPgm works fine for invoking an EXE, but to  *)
        (*   get it to start a REXX script you have to hand     *)
        (*   the script over to CMD.EXE.                        *)
        (*   Parameter passing is a little tricky, the trick    *)
        (*   seems to be to pass a pointer to a pointer, and    *)
        (*   to ensure that the string is terminated with       *)
        (*   TWO nul characters.                                *)
        (*                                                      *)
        (*   Serious problem: CMD.EXE hangs if module Keyboard  *)
        (*   is imported.  It appears that the problem can be   *)
        (*   solved by using module KB instead of Keyboard.     *)
        (*                                                      *)
        (********************************************************)

FROM SYSTEM IMPORT ADR;

IMPORT OS2;

FROM STextIO IMPORT
    (* proc *)  WriteChar, WriteString, WriteLn;

FROM Semaphores IMPORT
    (* type *)  Semaphore,
    (* proc *)  CreateSemaphore, Wait, Signal;

FROM TaskControl IMPORT
    (* proc *)  CreateTask;

IMPORT KB;

(************************************************************************)

CONST Nul = CHR(0);

VAR
    DoneSem: Semaphore;

(************************************************************************)

PROCEDURE WriteCard (val: CARDINAL);

    BEGIN
        IF val > 9 THEN
            WriteCard (val DIV 10);
            val := val MOD 10;
        END (*IF*);
        WriteChar (CHR(ORD('0')+val));
    END WriteCard;

(************************************************************************)

PROCEDURE TestThread;

    CONST ONLength = 256;

    VAR rc: CARDINAL;
        FailureObjectName: ARRAY [0..ONLength-1] OF CHAR;
        pArg, pEnv: POINTER TO CHAR;
        ExitStatus: OS2.RESULTCODES;
        ScriptName: ARRAY [0..255] OF CHAR;

    BEGIN
        ScriptName := "/C CALLED.CMD hello Dolly";
        rc := LENGTH(ScriptName);
        ScriptName[rc] := Nul;
        ScriptName[rc+1] := Nul;
        pArg := ADR(ScriptName);
        pEnv := NIL;
        rc := OS2.DosExecPgm (FailureObjectName,    (*VAR Objname   : ARRAY OF CHAR*)
                       ONLength,
                       OS2.EXEC_SYNC,
                       ADR(pArg), NIL,
                       ExitStatus,               (*;VAR Res       : RESULTCODES*)
                       "CMD.EXE");
        WriteString ("Back from DosExecPgm, result code is ");
        WriteCard (rc);  WriteLn;
        WriteString ("FailureObjectName is ");  WriteString (FailureObjectName);
        WriteLn;
        WriteString ("codeTerminate is ");  WriteCard (ExitStatus.codeTerminate);
        WriteLn;
        WriteString ("codeResult is ");  WriteCard (ExitStatus.codeResult);
        WriteLn;
        Signal (DoneSem);

    END TestThread;

(************************************************************************)

PROCEDURE RunTheTest;

    BEGIN
        CreateSemaphore (DoneSem, 0);
        CreateTask (TestThread, 3, "test thread");
        Wait (DoneSem);
    END RunTheTest;

(************************************************************************)

BEGIN
    WriteString ("Starting test");  WriteLn;
    RunTheTest;
    WriteString ("ExecTest finished");  WriteLn;
END ExecTest.
