MODULE Setup;

        (********************************************************)
        (*                                                      *)
        (*              Weasel set-up utility                   *)
        (*                                                      *)
        (*  Programmer:         P. Moylan                       *)
        (*  Started:            24 April 1998                   *)
        (*  Last edited:        2 September 1999                *)
        (*  Status:             Basically OK                    *)
        (*                                                      *)
        (********************************************************)

FROM SYSTEM IMPORT LOC;

IMPORT OS2, Strings, EditHosts, SUOptions;

FROM LowLevel IMPORT
    (* proc *)  EVAL;

FROM EditUsers IMPORT
    (* proc *)  CheckUserDirectories;

FROM Windows IMPORT
    (* type *)  Window, Colour, FrameType, DividerType,
    (* proc *)  OpenWindow, CloseWindow, WriteChar, WriteString, WriteLn,
                SetCursor, GetKey, GetScreenSize;

FROM InetUtilities IMPORT
    (* proc *)  INIGet, INIGetString, INIPut;

FROM Menus IMPORT
    (* type *)  Menu, ItemText,
    (* proc *)  CreateMenu, MenuColours;

FROM ScreenEditor IMPORT
    (* type *)  Structure,
    (* proc *)  CardinalField, StringField, MenuField, Combine,
                ScreenEdit, DeleteStructure;

FROM MultiScreen IMPORT
    (* proc *)  EnableHotKeys;

FROM Names IMPORT
    (* type *)  ServiceType, CardArray;

FROM SetupINI IMPORT
    (* proc *)  OurINIHandle;

(************************************************************************)

VAR
    (* Number of display rows on screen.  *)

    ScreenRows: CARDINAL;

    (* Prompt line at bottom of screen.  *)

    bottombar: Window;

(************************************************************************)
(*                        INI FILE EDITING                              *)
(************************************************************************)

PROCEDURE EditDefaultParameters;

    VAR w: Window;
        R: Structure;
        port, MaxUsers, TimeoutLimit: CardArray;
        TransactionLogLevel, LogPOPLevel, LogSMTPLevel, ServerEnable: CARDINAL;
        LogPOPusers, LogSMTPItems: BOOLEAN;
        MailRoot: ARRAY [0..511] OF CHAR;
        abort: BOOLEAN;  ch: CHAR;
        hini: OS2.HINI;
        M1, M1a, M1b, M2: Menu;
        TrlOption: ARRAY [0..4] OF ItemText;
        POPLogOption: ARRAY [0..2] OF ItemText;
        EnableOption: ARRAY [0..3] OF ItemText;
        j: CARDINAL;

    (********************************************************************)

    PROCEDURE LoadINIData;

        (* Loads setup parameters from "weasel.ini". *)

        PROCEDURE GetItem (name: ARRAY OF CHAR;
                             VAR (*OUT*) variable: ARRAY OF LOC): BOOLEAN;

            BEGIN
                RETURN INIGet (hini, "$SYS", name, variable);
            END GetItem;

        (****************************************************************)

        PROCEDURE GetStringItem (name: ARRAY OF CHAR;
                             VAR (*OUT*) variable: ARRAY OF CHAR): BOOLEAN;

            BEGIN
                RETURN INIGetString (hini, "$SYS", name, variable);
            END GetStringItem;

        (****************************************************************)

        BEGIN
            hini := OurINIHandle();
            IF hini = OS2.NULLHANDLE THEN
                WriteString (w, "Could not open WEASEL.INI");
                WriteLn (w);
            ELSE
                TransactionLogLevel := 3;
                IF NOT GetItem ("Enable", ServerEnable) THEN
                    ServerEnable := 3;
                END (*IF*);
                IF NOT GetItem ("ServerPort", port) THEN
                    port := CardArray {25, 110};
                END (*IF*);
                IF NOT GetItem ("MaxUsers", MaxUsers) THEN
                    MaxUsers := CardArray {10, 10};
                END (*IF*);
                IF GetItem ("TransLevel", TransactionLogLevel) THEN
                    INC (TransactionLogLevel);
                END (*IF*);
                IF GetItem ("LogPOPusers", LogPOPusers) THEN
                    LogPOPLevel := ORD(LogPOPusers) + 1;
                ELSE
                    LogPOPLevel := 1;
                END (*IF*);
                IF GetItem ("LogSMTPItems", LogSMTPItems) THEN
                    LogSMTPLevel := ORD(LogSMTPItems) + 1;
                ELSE
                    LogSMTPLevel := 1;
                END (*IF*);
                IF NOT GetItem ("TimeOut", TimeoutLimit) THEN
                    TimeoutLimit := CardArray {900, 900};
                END (*IF*);
                IF NOT GetStringItem ("MailRoot", MailRoot) THEN
                    MailRoot := "C:\MPTN\ETC\MAIL\";
                END (*IF*);
            END (*IF*);
        END LoadINIData;

    (********************************************************************)

    PROCEDURE StoreINIData;

        (* Writes data back to the INI file. *)

        PROCEDURE PutItem (name: ARRAY OF CHAR;  VAR (*OUT*) variable: ARRAY OF LOC);

            BEGIN
                INIPut (hini, "$SYS", name, variable);
            END PutItem;

        (****************************************************************)

        BEGIN
            IF hini <> OS2.NULLHANDLE THEN
                PutItem ("Enable", ServerEnable);
                PutItem ("ServerPort", port);
                PutItem ("MaxUsers", MaxUsers);
                IF TransactionLogLevel > 0 THEN
                    DEC (TransactionLogLevel);
                END (*IF*);
                PutItem ("TransLevel", TransactionLogLevel);
                LogPOPusers := LogPOPLevel > 1;
                PutItem ("LogPOPusers", LogPOPusers);
                LogSMTPItems := LogSMTPLevel > 1;
                PutItem ("LogSMTPItems", LogSMTPItems);
                PutItem ("TimeOut", TimeoutLimit);
                PutItem ("MailRoot", MailRoot);
            END (*IF*);
        END StoreINIData;

    (********************************************************************)

    BEGIN
        OpenWindow (w, white, blue, ScreenRows DIV 2 - 6, ScreenRows DIV 2 + 11,
                                                  0, 79, noframe, nodivider);
        LoadINIData;

        SetCursor (w, 1, 6);  WriteString (w, "SMTP port");
        SetCursor (w, 2, 6);  WriteString (w, "Maximum number of SMTP users");
        SetCursor (w, 3, 6);  WriteString (w, "SMTP timeout (seconds)");

        SetCursor (w, 5, 6);  WriteString (w, "POP port");
        SetCursor (w, 6, 6);  WriteString (w, "Maximum number of POP users");
        SetCursor (w, 7, 6);  WriteString (w, "POP timeout (seconds)");

        SetCursor (w, 9, 6);  WriteString (w, "Root directory for mail");
        SetCursor (w, 12, 16);  WriteString (w, "Enable servers");
        SetCursor (w, 14, 12);  WriteString (w, "POP user logging");
        SetCursor (w, 15, 12);  WriteString (w, "SMTP logging");
        SetCursor (w, 16, 12);  WriteString (w, "Detailed transaction log");

        R := CardinalField (port[SMTP], 1, 36, 8);
        Combine (R, CardinalField (MaxUsers[SMTP], 2, 36, 8));
        Combine (R, CardinalField (TimeoutLimit[SMTP], 3, 36, 8));

        Combine (R, CardinalField (port[POP], 5, 36, 8));
        Combine (R, CardinalField (MaxUsers[POP], 6, 36, 8));
        Combine (R, CardinalField (TimeoutLimit[POP], 7, 36, 8));

        Combine (R, StringField (MailRoot, 10, 7, 65));

        (* Create the menu of "enable server" options. *)

        EnableOption[1] := "SMTP";
        EnableOption[2] := "POP";
        EnableOption[3] := "Both";
        CreateMenu (M2, 3, EnableOption, 3);
        MenuColours (M2, white, blue, blue, cyan, yellow);
        Combine (R, MenuField (ServerEnable, 12, 38, 1, 21, M2));

        (* Create the menus of POP and SMTP log options. *)

        POPLogOption[1] := "Disable";
        POPLogOption[2] := "Enable";
        CreateMenu (M1a, 2, POPLogOption, 2);
        MenuColours (M1a, white, blue, blue, cyan, yellow);
        Combine (R, MenuField (LogPOPLevel, 14, 38, 1, 20, M1a));
        CreateMenu (M1b, 2, POPLogOption, 2);
        MenuColours (M1b, white, blue, blue, cyan, yellow);
        Combine (R, MenuField (LogSMTPLevel, 15, 38, 1, 20, M1b));

        (* Create the menu of transaction log options. *)

        TrlOption[1] := "None";
        TrlOption[2] := "Disk";
        TrlOption[3] := "Screen";
        TrlOption[4] := "Both";
        CreateMenu (M1, 4, TrlOption, 4);
        MenuColours (M1, white, blue, blue, cyan, yellow);
        Combine (R, MenuField (TransactionLogLevel, 16, 38, 1, 28, M1));

        SetCursor (w, 1, 36);
        LOOP
            ScreenEdit (w, R, abort);

            (* Make sure that MailRoot ends with a trailing '\'. *)

            j := LENGTH (MailRoot);
            IF (j = 0) OR ((MailRoot[j-1] <> '/') AND (MailRoot[j-1] <> '\')) THEN
                Strings.Append ('\', MailRoot);
            END (*IF*);

            IF abort THEN EXIT(*LOOP*) END(*IF*);

            (* Consume the character that took us off the edge. *)

            ch := GetKey (w);
            IF ch = CHR(0) THEN
                EVAL (GetKey (w));
            END (*IF*);

        END (*LOOP*);

        DeleteStructure (R);
        StoreINIData;
        CheckUserDirectories (MailRoot);
        CloseWindow (w);

    END EditDefaultParameters;

(************************************************************************)
(*                              MAIN PROGRAM                            *)
(************************************************************************)

PROCEDURE RunTheProgram;

    CONST Esc = CHR(1BH);

    VAR w0, w1: Window;

    BEGIN
        OpenWindow (w0, yellow, red, 0, 5, 0, 43, noframe, nodivider);
        WriteLn (w0);
        WriteString (w0, "    SETUP FOR WEASEL POP3/SMTP SERVER");
        WriteLn (w0);  WriteLn (w0);
        WriteString (w0, "  Type F4 or F5 for other setup details");
        WriteLn (w0);
        WriteString (w0, "          Esc to exit program");

        OpenWindow (w1, black, green, 0, 5, 44, 79, noframe, nodivider);
        WriteLn (w1);
        WriteString (w1, "   NOTE: Parameters set on this");  WriteLn (w1);
        WriteString (w1, "    page will take effect the");  WriteLn (w1);
        WriteString (w1, "   next time the server is run");  WriteLn (w1);
        WriteString (w1, "         on this machine");

        EditDefaultParameters;
        CloseWindow (w1);
        CloseWindow (w0);

    END RunTheProgram;

(************************************************************************)

VAR dummy: CARDINAL;

BEGIN
    GetScreenSize (ScreenRows, dummy);
    EnableHotKeys (TRUE, CHR(62), TRUE, CHR(63), TRUE, CHR(64));
    OpenWindow (bottombar, yellow, red, ScreenRows-1, ScreenRows-1, 0, 79, noframe, nodivider);
    WriteString (bottombar, " Esc exit");
    SetCursor (bottombar, 0, 55);
    WriteString (bottombar, "F4,F5 previous/next page");
    RunTheProgram;
FINALLY
    CloseWindow (bottombar);
END Setup.

