/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         __VXREXX____APPENDS__
*/
__VXREXX____APPENDS__: 

return

/*:VRX         AddLogLine
*/
AddLogLine: 
/**********
    Add a line to the error log.
*/
    procedure expose Globals.
    parse arg msg

    msg = Strip( msg )
    if( msg \= "" ) then do
        /*  Remove carriage return & line feeds
        */
        p = Pos( "0d"x, msg )
        if( p \= 0 ) then do
            msg = Overlay( " ", msg, p, 1 )
        end
        p = Pos( "0a"x, msg )
        if( p \= 0 ) then do
            msg = Overlay( " ", msg, p, 1 )
        end

        /*  Add the message to the error log
        */    
        position = VRMethod( "LB_Install_Status_Errors", "AddString", msg )
        call VRSet "LB_Install_Status_Errors", "Selected", position 
    end
return
/*:VRX         CNCT_Connect
*/
CNCT_Connect: 
    if( Globals.!database_type = "WSQL" ) then do
        /*  Make sure the SQLSTART environment variable has -q in it.
            This suppresses the banner that WSQL usually prints.
        */
        ev = Translate( Value( "SQLSTART",,"OS2ENVIRONMENT" ) )
        if( ev \= "" & Pos( "-Q", ev ) = 0 ) then do
            call Value "SQLSTART", ev "-q", "OS2ENVIRONMENT"
        end
        
        if( Globals.!Local ) then do
            vxdir = VXDir_Get( )
            if( LENGTH(vxdir) = 0 ) then do 
                call Error_VXDir
                ok = 0
                signal CNCT_Connect_Done
            end
            else do
                call VRSet "CNCT_Database", "Database", vxdir || '\wsample'
            end
        end
        else do
            Globals.!Server = "WSAMPLE"
            button.0 = 1
            button.1 = "~OK"
            id = VRPrompt( VRWindow(), "Server name:", "Globals.!Server",,
                           "VX-REXX Sample Database Generator",,
                           "button.", 1 )
            call VRSet "CNCT_Database", "Database", Globals.!Server
        end

        call VRSet "CNCT_Database", "Userid", "dba"
        call VRSet "CNCT_Database", "Password", "sql"
        call VRSet "CNCT_Database", "DataSource", "WATCOM SQL"
        ok = VRMethod( "CNCT_Database", "Connect" )
        if ok then do
            /* To comply with the manual
            */
            call VRMethod "CNCT_Database", "Execute" ,,
                "GRANT CONNECT TO ADMIN IDENTIFIED BY SCHOOL"
            call VRMethod "CNCT_Database", "Execute" ,,
                "GRANT DBA TO ADMIN"
        end
    end
    else if( Globals.!database_type = "DB22" ) then do

        /*  Try to guess the userid and password
        */
        call VRSet "CNCT_Database", "database", "WSAMPLE"
        call VRSet "CNCT_Database", "userid", ""
        call VRSet "CNCT_Database", "password", ""
        call VRSet "CNCT_Database", "DataSource", "IBM DB2/2"
        ok = VRMethod( "CNCT_Database", "Connect" )
    end

    CNCT_Connect_Done:
return \ok

/*:VRX         CNCT_Disconnect
*/
CNCT_Disconnect: 
    call VRMethod "CNCT_Database", "Disconnect" 
return

/*:VRX         DB_Bind
*/
DB_Bind: 
/*******
    Bind the database
*/
    procedure expose Globals.
    "binddbi -dWSAMPLE -q"
    return 0
/*:VRX         DB_Database_Create
*/
DB_Database_Create: procedure expose Globals.
    ret_code = 1    /* If Globals.!database_type is not 'WSQL' or 'DB22' */

    if( Globals.!Local ) then do
        if( Globals.!database_type = "WSQL" ) then do
            vxdir = VXDir_Get( )
            if( LENGTH(vxdir) = 0 ) then do 
                call Error_VXDir
                ret_code = 1
            end
            else do
                ret_code = WSQL_DB_Database_Create( vxdir || '\wsample',,
                                                    'VX-REXX Sample Database', 'D' )
            end
        end
        else if ( Globals.!database_type = "DB22" ) then do       
            ret_code = DB22_DB_Database_Create( 'wsample', 'Watcom Sample Database',,
                                                Globals.!Drive )
        end
    end
    else do
        /*  We don't have to create remote databases
        */
        ret_code = 0
    end

return ret_code

/*:VRX         DB_Engine_Start
*/
DB_Engine_Start: procedure expose Globals.
    interpret 'ret_code =  ' || Globals.!database_type || '_DB_Engine_Start( )'    
return ret_code

/*:VRX         DB_Funcs_DB22
*/
/* All the IBM DB2/2 specific code is in this section
*/

DB22_DB_Database_Create: procedure expose Globals.
    parse arg database_name, comment, drive

    if( drive = '<default>' ) then do
        call SQLDBS 'CREATE DATABASE ' || database_name || ' WITH ' || '"' || comment || '"' 
    end
    else do
        call SQLDBS 'CREATE DATABASE ' || database_name || ' ON ' || drive || ' WITH ' || '"' || comment || '"' 
    end

    if( SQLCA.SQLCODE = -1005 ) then do
        Lines.1 = "WSAMPLE Database already exists!"
        Lines.2 = "Would you like to delete it?"
        Lines.0 = 2
        
        Buttons.1 = "~Delete"
        Buttons.2 = "Cancel"
        Buttons.0 = 2
        id = VRMessageStem( VRWindow(), "Lines.", "Installation Error", "Error", "Buttons.", ,  )

        if( id = 1 ) then do
            call SQLDBS 'DROP DATABASE ' || database_name

            if( drive = '<default>' ) then do
                call SQLDBS 'CREATE DATABASE ' || database_name || ' WITH ' || '"' || comment || '"' 
            end
            else do
                call SQLDBS 'CREATE DATABASE ' || database_name || ' ON ' || drive || ' WITH ' || '"' || comment || '"' 
            end

            ret_code = SQLCA.SQLCODE
        end
        else do
            ret_code = 0
            Globals.!Error = "Abort"            
        end
    end
    else do
        ret_code = SQLCA.SQLCODE
    end

return ret_code


DB22_DB_Engine_Start: procedure expose Globals.
    call SQLDBS 'START DATABASE MANAGER'

    /* Allowable error
    */

    if( SQLCA.SQLCODE = -1026 ) then do
        ret_code = 0
    end
    else do
        ret_code = SQLCA.SQLCODE
    end
return ret_code

DB22_DB_Table_Create: procedure expose Globals.
    parse arg name, columns

    sql = "CREATE TABLE " || name || " ("
    current = columns

    do while ( LENGTH(current) > 0  ) 
        parse value current with first","rest
        if( LENGTH( rest ) > 0 ) then do
            sql = sql || first || ", " 
        end
        else do
            sql = sql || first 
        end
        current = rest
    end

    sql = sql || " )"

return sql

DB22_DB_Key_Primary_Create: procedure expose Globals.
    parse arg name, columns

    sql = "ALTER TABLE " || name || " PRIMARY KEY ("
    current = columns

    do while ( LENGTH(current) > 0  ) 
        parse value current with first","rest
        if( LENGTH( rest ) > 0 ) then do
            sql = sql || first || ", " 
        end
        else do
            sql = sql || first 
        end
        current = rest
    end

    sql = sql || " )"
return sql


DB22_DB_Key_Foreign_Create: procedure expose Globals.
    parse arg name, name2, columns, refer

    sql = "ALTER TABLE " || name || " FOREIGN KEY " || name2 || " ("
    current = columns

    do while ( LENGTH(current) > 0  ) 
        parse value current with first","rest
        if( LENGTH( rest ) > 0 ) then do
            sql = sql || first || ", " 
        end
        else do
            sql = sql || first 
        end
        current = rest
    end

    sql = sql || " ) REFERENCES " || refer
return sql

DB22_DB_Table_Data_Import: procedure expose Globals.
    parse arg filename, tablename

    /* Get the input line
    */
    input_line = LineIn( filename )

    /* Insert into the database
    */
    ok = 0  /* if no line can be read */
    linenum = 0

    do while( LENGTH(input_line) > 0 )
        linenum = linenum + 1
        if( (linenum // 50) = 0 ) then do
            call VRMethod "CNCT_Database", "Execute", "Commit Work"
        end

        sql = "INSERT INTO " || tablename || " VALUES ("
        input_line = input_line || ','
        do while ( LENGTH(input_line) > 0  ) 
            if( LEFT(input_line, 1) = "'" ) then do
                first = ''
                input_line = RIGHT( input_line, LENGTH(input_line) - 1)
                do until \ (SUBSTR(input_line, 1, 1 ) = "'" )
                    parse value input_line with current"'"input_line
                    first = first || current
                end
                parse value input_line with jnk","input_line
                first = "'" || first || "'"
            end
            else do
                parse value input_line with first","input_line
            end
        
            if( LENGTH( first ) = 0 ) then do
                first = 'NULL'
            end
                 
            if( LENGTH( input_line ) > 0 ) then do
                sql = sql || first || ", " 
            end
            else do
                sql = sql || first 
            end
        end
        sql = sql || " )"

        ok = VRMethod( "CNCT_Database", "Execute", sql )
        if( ok = 0 ) then do
            Globals.!LastError = VRGet( "CNCT_Database", "Status" )
            signal DB22_Done
        end

        input_line = LineIn( filename )
    end

DB22_Done:
    call Stream filename, 'c', 'close' 
    call VRMethod "CNCT_Database", "Execute", "Commit Work"
return \ok

/*:VRX         DB_Funcs_WSQL
*/
/* All WATCOM SQL specific code is in this section.
*/

WSQL_DB_Database_Create: procedure expose Globals.
    parse arg database_name, comment, drive
    
    interpret 'address cmd ' || "'dbinit " || database_name || " >NUL 2>NUL'"

    /* An allowable error
    */

    if( RC = 3 ) then do        
        Lines.1 = "WSAMPLE.DB already exists!"
        Lines.2 = "Would you like to delete it?"
        Lines.0 = 2
        
        Buttons.1 = "~Delete"
        Buttons.2 = "Cancel"
        Buttons.0 = 2
        id = VRMessageStem( VRWindow(), "Lines.", "Installation Error", "Error", "Buttons.", ,  )

        if( id = 1 ) then do
           interpret 'address cmd ' || "'dberase -y -q " || database_name || ".db >NUL 2>NUL'"
           interpret 'address cmd ' || "'dbinit " || database_name || " >NUL 2>NUL'" 

           ret_code = RC
        end
        else do
            ret_code = 0
            Globals.!Error = "Abort"            
        end
    end
    else do
        ret_code = RC
    end
return ret_code

WSQL_DB_Engine_Start: procedure expose Globals.
   /* Do nothing for now
   */
return 0

WSQL_DB_Table_Create: procedure expose Globals.
    parse arg name, columns

    sql = "CREATE TABLE " || name || " ("
    current = columns

    do while ( LENGTH(current) > 0  ) 
        parse value current with first","rest
        if( LENGTH( rest ) > 0 ) then do
            sql = sql || first || ", " 
        end
        else do
            sql = sql || first 
        end
        current = rest
    end

    sql = sql || " )"
return sql

WSQL_DB_Key_Primary_Create: procedure expose Globals.
    parse arg name, columns

    sql = "ALTER TABLE " || name || " add primary key ("
    current = columns

    do while ( LENGTH(current) > 0  ) 
        parse value current with first","rest
        if( LENGTH( rest ) > 0 ) then do
            sql = sql || first || ", " 
        end
        else do
            sql = sql || first 
        end
        current = rest
    end

    sql = sql || " )"
return sql

WSQL_DB_Key_Foreign_Create: procedure expose Globals.
    parse arg name, name2, columns, refer

    sql = "ALTER TABLE " || name || " ADD FOREIGN KEY " || name2 || " ("
    current = columns

    do while ( LENGTH(current) > 0  ) 
        parse value current with first","rest
        if( LENGTH( rest ) > 0 ) then do
            sql = sql || first || ", " 
        end
        else do
            sql = sql || first 
        end
        current = rest
    end

    sql = sql || " ) REFERENCES " || refer
return sql

WSQL_DB_Table_Data_Import: procedure expose Globals.
    parse arg filename, tablename

    /* Get the input line
    */

    input_line = LINEIN( filename )

    /* Insert into the database
    */

    ok = 0  /* if no line can be read */
    linenum = 0 

    do while( LENGTH(input_line) > 0 )
        linenum = linenum + 1
        if( (linenum % 50) = 0 ) then do
            call VRMethod "CNCT_Database", "Execute", "Commit Work"
        end

        sql = "INSERT INTO " || tablename || " VALUES ("
        input_line = input_line || ','
        do while ( LENGTH(input_line) > 0  ) 
            if( LEFT(input_line, 1) = "'" ) then do
                first = ''
                input_line = RIGHT( input_line, LENGTH(input_line) - 1)
                do until \ (SUBSTR(input_line, 1, 1 ) = "'" )
                    parse value input_line with current"'"input_line
                    first = first || current
                end
                parse value input_line with jnk","input_line
                first = "'" || first || "'"
            end
            else do
                parse value input_line with first","input_line
            end
        
            if( LENGTH( first ) = 0 ) then do
                first = 'NULL'
            end
                 
            if( LENGTH( input_line ) > 0 ) then do
                sql = sql || first || ", " 
            end
            else do
                sql = sql || first 
            end
        end
        sql = sql || " )"

        ok = VRMethod( "CNCT_Database", "Execute", sql )
        if( ok = 0 ) then do
            signal WSQL_Done
        end
        
        input_line = LINEIN( filename )
    end

    WSQL_Done:
    call VRMethod "CNCT_Database", "Execute", "Commit Work"
    call stream filename, 'c', 'close' 
return \ok

/*:VRX         DB_Key_Foreign_Create
*/
DB_Key_Foreign_Create: 
    parse arg name, name2, columns, refer

    parameters = "'" || name || "'" || ", " || "'" || name2 || "'" || "," || "'" || columns || "'" || "," || "'" || refer || "'" 
    interpret "sql = " || Globals.!database_type || "_DB_Key_Foreign_Create(" || parameters || ") "

    ok = VRMethod( "CNCT_Database", "Execute", sql )

    if( \ok ) then do
        /*  Handle allowable errors (warnings) 
        */
        value = VRGet( 'CNCT_Database', 'Status' )
        if( LEFT(value, 8) = 'SQL0541W' ) then do
            ok = 1
        end
        else do
            if( ok \= 1 ) then do
                call AddLogLine value
            end
        end
    end

return \ok
/*:VRX         DB_Key_Foreign_Create_All
*/
DB_Key_Foreign_Create_All: procedure expose Globals.
    errors = 0

    call VRMethod "CNCT_Database", "Execute", "Commit Work"
    
    errors = errors + DB_Key_Foreign_Create( "Employee", "Room", "roomnum,", "Room" )
    errors = errors + DB_Key_Foreign_Create( "Assign", "Course", "course,", "Course")
    errors = errors + DB_Key_Foreign_Create( "Lab", "Course", "course," , "Course")
    errors = errors + DB_Key_Foreign_Create( "Lab", "Lab", "course,", "Course" )
    errors = errors + DB_Key_Foreign_Create( "Section", "Course", "course,", "Course")
    errors = errors + DB_Key_Foreign_Create( "Section", "Employee", "empnum,", "Employee" )
    errors = errors + DB_Key_Foreign_Create( "Class", "Room", "roomnum,", "Room" )
    errors = errors + DB_Key_Foreign_Create( "Class", "Section", "course,section,", "Section")
    errors = errors + DB_Key_Foreign_Create( "Register", "Student", "studnum,", "Student" )
    errors = errors + DB_Key_Foreign_Create( "Register", "Section", "course,section,", "Section")

    if( Globals.!database_type = "WSQL" ) then do
        errors = errors + DB_Key_Foreign_Create( "Mark", "Register", "studnum,course,", "Register" )
    end
    else do
        errors = errors + DB_Key_Foreign_Create( "Mark", "Register", "course,studnum,", "Register" )
    end

    errors = errors + DB_Key_Foreign_Create( "Mark", "Assign", "course,number,", "Assign" )
    errors = errors + DB_Key_Foreign_Create( "OrderItm", "Product", "prodnum,", "Product" )
    errors = errors + DB_Key_Foreign_Create( "OrderItm", "Orders", "ordernum,", "Orders" )
    errors = errors + DB_Key_Foreign_Create( "Orders", "Customer", "custnum,", "Customer" )

    call VRMethod "CNCT_Database", "Execute", "Commit Work" 

return errors

/*:VRX         DB_Key_Primary_Create
*/
DB_Key_Primary_Create: procedure expose Globals.
    parse arg name, columns

    parameters = "'" || name || "'" || ", " || "'" || columns || "'" 
    interpret "sql = " || Globals.!database_type || "_DB_Key_Primary_Create(" || parameters || ") "

    ok = VRMethod( "CNCT_Database", "Execute", sql )
    if( ok \= 1  ) then do
        call AddLogLine VRGet( "CNCT_Database", "Status" )
    end

return \ok
/*:VRX         DB_Key_Primary_Create_All
*/
DB_Key_Primary_Create_All:  procedure expose Globals.
    error = 0
    
    error = error + DB_Key_Primary_Create( "Student", "studnum," )
    error = error + DB_Key_Primary_Create( "Room", "roomnum," )
    error = error + DB_Key_Primary_Create( "Employee", "Empnum," )
    error = error + DB_Key_Primary_Create( "Course", "course," )
    error = error + DB_Key_Primary_Create( "Lab", "course," )
    error = error + DB_Key_Primary_Create( "Assign", "course,number," )
    error = error + DB_Key_Primary_Create( "Section", "course,section," )
    error = error + DB_Key_Primary_Create( "Class", "course,section,day,times" )
    error = error + DB_Key_Primary_Create( "Register", "course,studnum," )
    error = error + DB_Key_Primary_Create( "Mark", "course,studnum,number" )
    error = error + DB_Key_Primary_Create( "OrderItm", "ordernum,item," )
    error = error + DB_Key_Primary_Create( "Product", "prodnum," )
    error = error + DB_Key_Primary_Create( "Orders", "Ordernum," )
    error = error + DB_Key_Primary_Create( "Customer", "custnum," )

    ok = VRMethod( "CNCT_Database", "Execute", "Commit Work" )

return error


/*:VRX         DB_Present
*/
DB_Present: procedure expose Globals.

    /*  Make sure that the database is properly installed
    */
    if( Globals.!Database_Type = "WSQL" ) then do
        if( Globals.!Local ) then do
            /*   Make sure DBINIT is in the path.
            */
            if( RXfuncquery('SysSearchPath') <> 0 ) then do
                rcy = RXFuncAdd('SysSearchPath', 'RexxUtil', 'SysSearchPath' )
                if( rcy \= 0 ) then do            
                    id = VRMessage( VRWindow(), "Can't find REXX function 'SysSearchPath'.", "Install Error", "Error", , ,  )
                    call Halt
                end
            end    
            fspec = SysSearchPath( 'PATH', 'dbinit.exe' )
            if( LENGTH(fspec) = 0 ) then do
                id = VRMessage( VRWindow(), "Watcom SQL is not properly installed. Make sure the",
                                "Watcom SQL directory is listed in the LIBPATH and PATH",
                                "in your CONFIG.SYS file.",,
                                "Install Error", "Error" )            
                call Halt
            end
        end
    end
    else do
        /*   Load the DB2/2 REXX functions
        */
        if( RXFuncQuery('SQLDBS') <> 0 ) then do
            rcy = RXFuncAdd('SQLDBS', 'SQLAR', 'SQLDBS' )
            if( rcy \= 0 ) then do            
                id = VRMessage( VRWindow(), "Can't find DB2/2 REXX function 'SQLDBS'.", "Install Error", "Error", , ,  )            
                call Halt
            end
        end    
        if( RXFuncQuery('SQLEXEC') <> 0 ) then do
            rcy = RXFuncAdd('SQLEXEC', 'SQLAR', 'SQLEXEC' )
            if( rcy \= 0 ) then do
                id = VRMessage( VRWindow(), "Can't find DB2/2 REXX functions 'SQLEXEC'.", "Install Error", "Error", , ,  )            
                call Halt
            end
        end    
    end

return

/*:VRX         DB_Table_Create
*/
DB_Table_Create: procedure expose Globals.
    parse arg name, columns;

    parameters = "'" || name || "'" || ", " || "'" || columns || "'" 
    interpret "sql = " || Globals.!database_type || "_DB_Table_Create(" || parameters || ") "

    /* SQL is the returned sql statement
    */
    ok = VRMethod( "CNCT_Database", "Execute", sql )
    if( ok \= 1  ) then do
        call AddLogLine "Could not create table '" || Translate(name) || "'"
        call AddLogLine VRGet( "CNCT_Database", "Status" )
    end

return \ok
/*:VRX         DB_Table_Create_All
*/
DB_Table_Create_All: 
/*******************
    Create database tables.
*/
    procedure expose Globals.
    error = 0

    /*  Create the Student Tables
    */
    error = error + DB_Table_Create( 'Student', 'Studnum  integer NOT NULL,',
                                               'Surname  char(20) NOT NULL,',
                                               'Initials  char(6),',
                                               'Address  char(40),',
                                               'Birthdat  date,',
                                               'Sex char(1) NOT NULL,')

    error = error + DB_Table_Create( 'Room', 'Roomnum  char(6) NOT NULL,',
                                               'Type  char(4) NOT NULL,',
                                               'Capacity  smallint,' )

    error = error + DB_Table_Create( 'Employee', 'Empnum  integer NOT NULL,',
                                               'Empname  char(20) NOT NULL,',
                                               'Initials  char(6) NOT NULL,',
                                               'Address  char(40),',
                                               'Phone  char(8),',
                                               'Labpay  numeric(6,2),',
                                               'Rank  char(5) NOT NULL,',
                                               'Roomnum char(6),' )

    error = error + DB_Table_Create( 'Course', 'Course  char(5) NOT NULL,',
                                               'Credit  numeric(3,2) NOT NULL,',
                                               'Hours  smallint NOT NULL,',
                                               'Descript  char(80) NOT NULL,' )

    error = error + DB_Table_Create( 'Assign', 'Course char(5) NOT NULL,',
                                               'Number smallint NOT NULL,',
                                               'Weight numeric(5,2) NOT NULL,',
                                               'Descript char(25),',
                                               'DateDue date,' )

    error = error + DB_Table_Create( 'Lab', 'Course char(5) NOT NULL,',
                                           'Lab char(5) NOT NULL,' )

    error = error + DB_Table_Create( 'Section', 'Empnum  integer NOT NULL,',
                                               'Course  char(5) NOT NULL,',
                                               'Section  smallint NOT NULL,' )

    error = error + DB_Table_Create( 'Class', 'Course char(5) NOT NULL,',
                                               'Section  smallint NOT NULL,',
                                               'Day  char(3) NOT NULL,',
                                               'Times  char(5) NOT NULL,',
                                               'Hours smallint NOT NULL,',
                                               'Roomnum char(6) NOT NULL,')

    error = error + DB_Table_Create( 'Register', 'Studnum  integer NOT NULL,',
                                               'Course  char(5) NOT NULL,',
                                               'Section smallint NOT NULL,' )

    error = error + DB_Table_Create( 'Mark', 'Studnum  integer NOT NULL,',
                                            'Course char(5) NOT NULL,',
                                            'Number smallint NOT NULL,',
                                            'Mark smallint NOT NULL,' )

    /* The Order tables
    */

    error = error + DB_Table_Create( 'OrderItm', 'ordernum integer NOT NULL,',
                                               'item integer NOT NULL,',
                                               'prodnum integer,',
                                               'price numeric(13,2),',
                                               'quantity integer,' )

    error = error + DB_Table_Create( 'Product', 'prodnum integer NOT NULL,',
                                               'price numeric(13,2),',
                                               'descript  char(40) NOT NULL,',
                                               'icon char(15),' )

    error = error + DB_Table_Create( 'Orders', 'ordernum integer NOT NULL,',
                                               'orderdat date,',
                                               'note char(80),',
                                               'custnum integer,' )

    error = error + DB_Table_Create( 'Customer', 'custnum integer NOT NULL,',
                                               'name char(40) NOT NULL,',
                                               'street char(40),',
                                               'city  char(40),',
                                               'state char(20),',
                                               'zip char(20),',
                                               'phone char(15),' )

return error


/*:VRX         DB_Table_Data_Import
*/
DB_Table_Data_Import: procedure expose Globals.
    parse arg filename, tablename

    parameters = "'" || filename || "'" || ", " || '"' || tablename || '"'
    interpret "ret_code = " || Globals.!database_type || "_DB_Table_Data_Import(" || parameters || ") "
    if( ret_code \= 0 ) then do
        call AddLogLine Globals.!LastError
    end
return ret_code


/*:VRX         DDCB_DBType_Change
*/
DDCB_DBType_Change: procedure expose Globals.   

    /*  Set the value of:
            Globals.!database_type      IBM or WSQL
            Globals.!Local              0 or 1
    */
    dbType = Translate( VRGet( "DDCB_DBType", "Value" ) )
    if( Pos( "IBM", dbType ) \= 0 ) then do
        Globals.!database_type = "DB22"
    end
    else do
        Globals.!database_type = "WSQL"    
    end
    Globals.!Local = ( Pos( "STANDALONE", dbType ) > 0 )

    enabled = ( Globals.!database_type = "DB22" ) & Globals.!Local
    call VRSet "SPIN_Drive", "Enabled", enabled

return

/*:VRX         DDCB_DBType_Fill
*/
DDCB_DBType_Fill: procedure expose Globals.
    dbType.1 = "IBM DB2/2 (standalone)"
    dbType.2 = "IBM DB2/2 (network)"
    dbType.3 = "Watcom SQL (standalone)"
    dbType.4 = "Watcom SQL (network)"
    dbType.0 = 4
    call VRMethod "DDCB_DBType", "AddStringList", "dbType."
    call VRSet "DDCB_DBType", "Value", dbType.1
return

/*:VRX         Defaults_Set
*/
Defaults_Set: procedure expose Globals.
    /* Set the defaults
    */
    Globals.!Drive = "<default>"
    Globals.!Error = "Pause"
    Globals.!DB_Name = "wsample"
return

/*:VRX         Error_Report
*/
Error_Report: procedure 
    parse arg error_name, error_msg

    /* The default error report
    */
    message.0 = 3
    message.1 = error_name
    message.2 = ""
    message.3 = error_msg
       
    id = VRMessageStem( VRWindow(), "message.", "Error!", "Information", , ,  )       
return

/*:VRX         Error_VXDir
*/
/* Called if an error finding the VX-Rexx directory is encountered.
*/

Error_VXDir: procedure expose Globals.
    Lines.0 = 4
    Lines.1 = "Could not find environment variable VXREXX!"
    Lines.2 = ""
    Lines.3 = "Please add this environment variable to you"     
    Lines.4 = "CONFIG.SYS"
    id = VRMessageStem( VRWindow(), "Lines.", "Installation Error", "Error", , ,  )
return

/*:VRX         Fini
*/
Fini:
    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Index_Create
*/
Index_Create: procedure 
    /* This procedure assumes that a connection has already
        been made
    */      
    call SQL_Exec 'create index studentnames on student ( surname ASC, initials ASC )'
    call SQL_Exec 'create index employeenames on employee ( empname ASC )'

return 

/*:VRX         Init
*/
Init:
    /* Get the working directory
    */
    Globals.!wd = WD_Get()

    /* Set the defaults
    */
    call Defaults_Set

    /* Fill the Spin button and DDCB
    */
    call SPIN_Drive_Fill
    call DDCB_DBType_Fill

    /* Create the window
    */
    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

return

/*:VRX         Install_Finished
*/
Install_Finished: 
    /* Installation complete message
    */
    finished_msg.0 = 1
    if( Globals.!database_type = "DB22" ) then do
        finished_msg.1 = "The sample database name is 'WSAMPLE'"
    end
    else if( Globals.!database_type = "WSQL" ) then do
        if( Globals.!Local ) then do
            finished_msg.1 = "The sample database path is " || VXDir_Get() || "\WSAMPLE.DB"
        end
        else do
            finished_msg.1 = "The sample database has been created on server '" || Globals.!Server || "'."
        end
    end
    id = VRMessageStem( VRWindow(), "finished_msg.", "Installation Complete", "Information", , ,  )


    /*  Restore the installation program
    */
    call CNCT_Disconnect
    call Install_Restore
return

/*:VRX         Install_Init
*/
Install_Init:     
    /* Clear the messages list box
    */
    call VRMethod "LB_Install_Status_Errors", "Clear" 

    /* Disable the appropriate objects
    */
    call VRSet "PB_Install", "Enabled", 0 
    call VRSet "PB_Close", "Enabled", 0 
    call VRSet "DDCB_DBType", "Enabled", 0 
    call VRSet "SPIN_Drive", "Enabled", 0
    
    /* Check the database software
    */
    call DB_Present

    /* Set the new installation hint text.
    */
    call VRSet "MainScreen", "HintText", "WSAMPLE Database installation in progress..."

return
/*:VRX         Install_Main
*/
Install_Main: 
    /* Set working directory
    */
    wd = Globals.!wd  
    datadir = wd || "\"

    /* Start the Install    
    */
    call Install_Step 'Starting database engine',,
                      'DB_Engine_Start( )',,
                      'Can''t start database engine'

    call Install_Step 'Creating the database',,
                      'DB_Database_Create( )',,
                      'Error creating database'

    if( Globals.!database_type = "DB22" ) then do
        call Install_Step 'Binding the database',,
                          'DB_Bind( )',,
                          'Error binding database'
    end

    call Install_Step 'Connecting to database',,
                      'CNCT_Connect( )',,
                      'Can''t connect to database'

    call Install_Step 'Creating the tables',,
                      'DB_Table_Create_All( )',,
                      'Error creating one or more tables'

    call Install_Step 'Creating primary keys',,
                      'DB_Key_Primary_Create_All( )',,
                      'Error creating one or more primary keys'

   /*   Import all the data into the tables  
   */
   call Install_Step 'Importing ''Assign'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'assignme.dat'', ''Assign'')',,
                      'Error importing data into ''Assign'' table'

   call Install_Step 'Importing ''Class'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'class.dat'', ''Class'')',,
                      'Error importing data into ''Class'' table'

   call Install_Step 'Importing ''Course'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'course.dat'', ''course'')',,
                      'Error importing data into ''Course'' table'

   call Install_Step 'Importing ''Customer'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'customer.dat'', ''Customer'')',,
                      'Error importing data into ''Customer'' table'

   call Install_Step 'Importing ''Employee'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'employee.dat'', ''employee'')',,
                      'Error importing data into ''Employee'' table'

   call Install_Step 'Importing ''Lab'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'lab.dat'', ''lab'')',,
                      'Error importing data into ''Lab'' table'

   call Install_Step 'Importing ''Mark'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'mark.dat'', ''mark'')',,
                      'Error importing data into ''Mark'' table'

   call Install_Step 'Importing ''Orders'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'orders.dat'', ''Orders'')',,
                      'Error importing data into ''Orders'' table'

   call Install_Step 'Importing ''OrderItm'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'orderite.dat'', ''orderitm'')',,
                      'Error importing data into ''OrderItm'' table'

   call Install_Step 'Importing ''Product'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'product.dat'', ''product'')',,
                      'Error importing data into ''Product'' table'

   call Install_Step 'Importing ''Register'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'register.dat'', ''register'')',,
                      'Error importing data into ''Register'' table'

   call Install_Step 'Importing ''Room'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'room.dat'', ''room'')',,
                      'Error importing data into ''Room'' table'

   call Install_Step 'Importing ''Section'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'section.dat'', ''section'')',,
                      'Error importing data into ''Section'' table'

   call Install_Step 'Importing ''Student'' table data',,
                      'DB_Table_Data_Import( ''' || datadir || 'student.dat'', ''student'')',,
                      'Error importing data into ''Student'' table'

   call Install_Step 'Creating foreign keys',,
                      'DB_Key_Foreign_Create_All( )',,
                      'Error creating one or more foreign keys'
return

/*:VRX         Install_Pause
*/
Install_Pause: procedure expose Globals.
    parse arg error_msg

    message.0 = 1
    message.1 = error_msg

    buttons.0 = 3
    buttons.1 = "~Ignore"
    buttons.2 = "Ignore ~All"
    buttons.3 = "Cancel"

    id = VRMessageStem( VRWindow(), "message.", "Installation Error", "Error", "buttons.", ,  )
    
    if( id = 1 ) then do
        /* Do nothing */        
    end
    else if( id = 2 ) then do
        Globals.!Error = "Ignore"       
    end
    else if( id = 3 ) then do
        Globals.!Error = "Abort"
    end
return

/*:VRX         Install_Restore
*/
Install_Restore: 
    /* Enable the appropriate buttons/DDCB'S
    */

    call VRSet "PB_Install", "Enabled", 1
    call VRSet "DDCB_DBType", "Enabled", 1 
    call VRSet "PB_Close", "Enabled", 1
    call DDCB_DBType_Change

    /* Reset all the defaults
    */

    call Defaults_Set    
    call VRSet "DT_Status", "Caption", "Ready to begin installation." 

    /* Set the window hint 
    */
           
    ok = VRSet( "MainScreen", "HintText", "Select 'Install' to begin the installation" )
    
return

/*:VRX         Install_Step
*/
Install_Step: procedure expose Globals.
    parse arg message, command, error_msg, error_allow

    if( Globals.!Error = "Abort" ) then do
        return      /* Skip all install steps */
    end

    /* Change the current message and pointer
    */
    ok = VRSet( "DT_Status", "Caption", message )
    window = VRWindow()

    /* Execute the command
    */
    call VRSet window, "Pointer", "Wait"
    interpret "ret_code = " || command 
    call VRSet window, "Pointer", "<default>"

    /* Check for an error code 
    */
    if( ret_code \= 0) then do
        If( Globals.!Error = "Pause" ) then do
            call Install_Pause error_msg
        end
        call AddLogLine error_msg
    end
return

/*:VRX         MainScreen_Close
*/
MainScreen_Close:
    call Quit
return

/*:VRX         PB_Close_Click
*/
PB_Close_Click: 
    call Quit
return

/*:VRX         PB_Install_Click
*/
PB_Install_Click: 

    call Install_Init
    call Install_Main

    if( Globals.!Error = "Abort" ) then do
        call Install_Restore
    end
    else do    
        call Install_Finished
    end
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         SPIN_Drive_Change
*/
SPIN_Drive_Change: Procedure expose Globals.
    Globals.!Drive = VRGet( "SPIN_drive", "Value" )    
return

/*:VRX         SPIN_Drive_Fill
*/
SPIN_Drive_Fill: 
    /* Fill the drive spin button with all the valid drives.
    */
    window = VRWindow()
    call VRSet window, "Pointer", "Wait"
    old_drive = VRCurrDrive()

    j = 1
    do i = C2D( "A" ) to C2D( "Z" )
        call VRChDrive D2C( i )
        if( Left( VRCurrDrive(), 1 ) = D2C( i ) ) then do
            j = j + 1
            drives.j = D2C( i )
        end
    end

    call VRChDrive( old_drive )
    drives.0 = j
    drives.1 = "<default>"
    call VRSet window, "Pointer", "<default>"

    call VRMethod "SPIN_Drive", "SetStringList", "drives."
    call VRSet "SPIN_Drive", "Value", Globals.!Drive

return

/*:VRX         VXDir_Get
*/
VXDir_Get: procedure expose Globals.
    vxdir = value( 'vxrexx', , 'os2environment' )
    if( RIGHT(vxdir, 1) = '\' ) then do
        vxdir = LEFT( vxdir, LENGTH(vxdir) -1 )
    end
return vxdir

/*:VRX         WD_Get
*/
WD_Get: procedure
    /* Get the directory the application was run from 
    */
    wd = VRGet( "Application", "Program" )
    if( Length( wd ) > 0 ) then do    
        do while( \(substr( wd, Length( wd ), 1 ) = '\') ) 
            wd = substr( wd, 1, Length( wd ) - 1)
        end
        wd = substr( wd, 1, Length( wd ) -1 )
    end
return wd

