/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         AddLine
*/
AddLine:
    call VRMethod 'MLE', 'Insert', arg(1) || '0d'x
return

/*:VRX         BeginWait
*/
BeginWait:
    if( arg(1) \= '' )then call AddLine arg(1)
    call VRSet VRWindow(), 'Pointer', 'Wait'
return

/*:VRX         EndWait
*/
EndWait:
    call VRSet VRWindow(), 'Pointer', '<Default>'
return

/*:VRX         Error
*/
Error:
    msg = arg(1) '-- binding aborted!'

    call AddLine ''
    call AddLine msg
    call AddLine ''
    call AddLine 'Click on the window or press a key to continue...'

    call VRCopyFile EXEName_nrz, EXEName_exe
    window = VRWindow()

    call VRSet 'MLE', 'Click', 'call Quit'
    call VRSet window, 'Click', 'call Quit'
    call VRSet window, 'KeyPress', 'call Quit'

    call beep 440, 250
    call beep 440, 250
return

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    EXEName  = InitArgs.2
    if( EXEName = '' )then do
        call Quit
        return
    end

    if( pos( '\', VREProjPermPath() ) = 0 )then do
        call Quit
        return
    end

    VXPath   = VREPath()
    ProjPath = VRParseFileName( VREProjPermPath(), "DP" )
    ProjName = VRParseFileName( VREProjPermPath(), "N" )
    RCFile   = ProjPath || "\" || ProjName || ".RC"
    ResFile  = ProjPath || "\" || ProjName || ".RES"
    NewResFile = VXPath || EXEName || ".RES"

    if( translate( VXPath ) = translate( ProjPath || '\' ) )then do
        call Quit
        return
    end

    EXEName_prj = ProjPath || "\" || EXEName || ".EXE"
    EXEName_exe = VXPath || EXEName || ".EXE"
    EXEName_nrz = VXPath || EXEName || ".NRZ"

    if( VRFileExists( EXEName_nrz ) = 0 )then do
        ok = VRCopyFile( EXEName_exe, EXEName_nrz )
        if( ok = 0 ) then do
            call Quit
            return
        end
    end

    /* If a *.EXE exists in the project directory,
       use it, otherwise use the *.NRZ in the 
       VX-REXX directory */

    if( VRFileExists( EXEName_prj ) \= 0 )then do
        file = EXEName_prj
    end; else do
        file = EXEName_nrz
    end
  
    ok = VRCopyFile( file, EXEName_exe )
    if( ok = 0 )then do
        call Error 'Could not copy' file 'to' EXEName_exe
        return
    end

    /* Quit if no .RC file exists in the project
       directory... */

    if( VRFileExists( RCFile ) = 0 )then do
        call Quit
        return
    end

    call AddLine 'Binding resources for' ProjName

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

    /* Compile up the resources... should really 
       check here that the .RES file's timestamp
       is later than the .RC file's... */

    if( VRFileExists( ResFile ) = 0 )then do
        call BeginWait 'Compiling resources...'
        old = directory()
        call directory ProjPath
        address cmd 'rc -r "' || RCFile || '">__out'
        call directory old
        call EndWait
        if( rc \= 0 )then do
            call Error 'Compilation error'
            return
        end
    end

    call AddLine 'Copying resource file...'
    ok = VRCopyFile( ResFile, NewResFile )
    if( ok = 0 )then do
        call Error 'Could not copy resource file'
        return
    end

    call AddLine 'Binding to executable...'

    /* Run the resource compiler to bind to the exe... */

    call BeginWait
    old = directory()
    call directory VXPath
    address cmd 'rc' NewResFile EXEName_exe '>__out'
    call VRDeleteFile '__out'
    call directory old   
    call EndWait

    if( rc \= 0 )then do
        call Error 'Could not bind to' EXEName_exe
        return
    end 

    call Quit
return
/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

