/* Limited manual (non-WarpIn) PipeMix installation by Lesha Bogdanow.
   Requires wic.exe from WarpIn 0.96 or above to be available in
   one of PATH directories.
*/
wicx="wic -x"
src="PipeMix.wpi"

call RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"
call SysLoadFuncs

src=stream(src,'c',"query exists")
if src="" then do
   say "You have to place PipeMix.wpi file into the current directory."
   exit(1)
   end
say "This is a limited manual Pipe Mix Backend installation utility. It will unpack"
say "Pipe Mixer Backend base package, REXX scripts and all backend executables into"
say "the current directory and create Pipe Mixer Backend WPS objects."
say "Proceed with installation? (Y/N):"
do until rsp='Y'
   parse pull rsp
   rsp=translate(left(rsp,1))
   if rsp='N' then do
      say "Installation aborted."
      exit(1)
      end
   else if rsp<>'Y' then say "Invalid input. Enter Y(es) or N(o):"
   end
dir=directory()
call Unpack 1
call Unpack 2
call Unpack 3
call Unpack 4
call Unpack 5
call Unpack 6
call Unpack 7
call Unpack 8
say "Creating Pipe Mixer Backend objects."
fdir=dir
if right(fdir,1)<>"\" then fdir=fdir||"\"
call SysCreateObject "WPFolder","Pipe Mixer Backend","<WP_DESKTOP>","OBJECTID=<PIPEMIX_FOLDER>;ICONFILE="||fdir||"PMixFld.ico;ICONNFILE=1,"||fdir||"PMixFlO.ico"
call SysCreateObject "WPProgram","Pipe Mixer Backend Configuration","<PIPEMIX_FOLDER>","OBJECTID=<PIPEMIX_CONFIG>;EXENAME="||fdir||"PMixCfg.cmd;ICONFILE="||fdir||"PMixCfg.ico;STARTUPDIR="||dir
call SysCreateObject "WPProgram","Uninstall Pipe Mixer Backend","<PIPEMIX_FOLDER>","OBJECTID=<PIPEMIX_UNINSTALL>;EXENAME="||fdir||"PMixRmv.cmd;ICONFILE="||fdir||"PMixRmv.ico;STARTUPDIR="||dir
call SysCreateObject "WPProgram","Pipe Mixer Backend Manual","<PIPEMIX_FOLDER>","OBJECTID=<PIPEMIX_MANUAL>;EXENAME=VIEW.EXE;ICONFILE="||fdir||"PMixInf.ico;PARAMETERS="||fdir||"PipeMix.inf"
say "Installation complete. A Pipe Mixer Backend folder was created. See Pipe Mixer"
say "Backend manual in this folder for details on configuration and usage."
say "You can delete PMixIns.cmd and PipeMix.wpi now."
exit(0)

Unpack:
   wicx src arg(1)
   if rc<>0 then do
      say "Failed to decompress .wpi archive. Make sure wic.exe from WarpIn 0.96 or"
      say "above is available in one of PATH directories."
      exit(1)
      end
   return
