/* example REXX script to test PMsndX syntax...no errors should be returned */

x=pmsndx(test_mode,no)
x=pmsndx(IGNORE_SYNTAX_ERRORS,YES)

x=pmsndx(test_mode,yes)
x=display(tools,yes)
x=display(toolpage,format)
x=display(toolpage,channels)
x=display(toolpage,average)
x=display(toolpage,dupe)
x=display(toolpage,sample)
x=display(toolpage,rate)
x=display(toolpage,speed)
x=display(toolpage,filter)
x=display(toolpage,bandpass)
x=display(toolpage,lowpass)
x=display(toolpage,effect)
x=display(toolpage,echo)
x=display(toolpage,invert)
x=display(toolpage,reverse)
x=display(toolpage,vibro)
x=display(toolpage,volume)
x=display(toolpage,fade)
x=display(toolpage,limit)
x=display(toolpage,balance)
x=display(toolpage,info)
x=display(tools,no)
x=pmsndx(test_mode,no)


x=pmsndx(test_mode,yes)
x=display(properties,yes)
x=display(proppage,audio)
x=display(proppage,memory)
x=display(proppage,misc)
x=display(proppage,rexx)
x=display(proppage,startup)
x=display(properties,no)
x=pmsndx(test_mode,no)

x=pmsndx(TEST_MODE,YES)
x=display(properties,yes)
x=display(open,yes)
x=pmsndx(TEST_MODE,NO)

x=pmsndx(test_mode,yes)
data=message(ask,ok,text,"testtext 1",title,"ok noicon application moveable",icon,noicon,mode,application,moveable,yes)
say "message result:" data
data=message(ask,okcancel,text,"test text 2",title,"okcancel iconhand systemmodal moveable",icon,iconhand,mode,system,moveable,yes)
say "message result:" data
data=message(ask,cancel,text,"test text 3",title,"cancel question notmodal notmoveable",icon,question,moveable,yes)
say "message result:" data
data=message(ask,enter,text,"test text 4",title,"enter exclamation notmodal notmoveable",icon,exclamation,moveable,yes)
say "message result:" data
data=message(ask,entercancel,text,"test text 5",title,"entercancel asterisk notmodal notmoveable",icon,asterisk,moveable,yes)
say "message result:" data
data=message(ask,retrycancel,text,"test text 6",title,"retrycancel information notmodal notmoveable",icon,information,moveable,yes)
say "message result:" data
data=message(ask,abortretryignore,text,"test text 7",title,"abortretryignore query notmodal notmoveable",icon,query,moveable,yes)
say "message result:" data
data=message(ask,yesno,text,"test text 8",title,"yesno warning notmodal notmoveable",icon,warning,moveable,yes)
say "message result:" data
data=message(ask,yesnocancel,text,"test text 9",title,"yesnocancel error notmodal notmoveable",icon,error,moveable,yes)
say "message result:" data
x=pmsndx(test_mode,no)

data=file(openpath,'d:\WSH\samples')
say "fully qualified path: " data
data=file(savepath,'d:\WSH')
say "fully qualified path: " data

filehandle=file(open,'brettapp.wav')
say "file handle: " filehandle
x=pmsndx(test_mode,yes)
x=edit(handle,filehandle,MANIPULATE,1)
x=edit(handle,filehandle,AREA,ENTIRE_SAMPLE)
x=edit(handle,filehandle,COPY)
x=pmsndx(test_mode,no)

x=pmsndx(test_mode,yes)
x=audio(volume,80)
x=audio(handle,filehandle,play,SYNC)
x=pmsndx(test_mode,no)

x=pmsndx(output,NO)
data=query(handle,filehandle,"file","openpath");
say "FILE OPENPATH:" data
data=query(handle,filehandle,"file","savepath");
say "FILE SAVEPATH:" data
data=query(handle,filehandle,"file","filename");
say "FILE FILENAME:" data
data=query(handle,filehandle,"info","format");
say "INFO FORMAT:" data
data=query(handle,filehandle,"info","datastyle");
say "INFO DATASTYLE:" data
data=query(handle,filehandle,"info","channels");
say "INFO CHANNELS:" data
data=query(handle,filehandle,"info","rate");
say "INFO RATE:" data
data=query(handle,filehandle,"info","datasize");
say "INFO DATASIZE:" data
data=query(handle,filehandle,"info","samples");
say "INFO SAMPLES:" data
data=query(handle,filehandle,"info","time");
say "INFO TIME:" data
data=query(handle,filehandle,"info","memory");
say "INFO MEMORY:" data
data=query(handle,filehandle,"info","comment");
say "INFO COMMENT:" data
data=query(handle,filehandle,"info","byteorder");
say "AUDIO BYTEORDER:" data
data=query(handle,filehandle,"audio","repeat");
say "AUDIO REPEAT:" data
data=query(handle,filehandle,"audio","time");
say "AUDIO TIME:" data
data=query(handle,filehandle,"audio","count");
say "AUDIO COUNT:" data
data=query(handle,filehandle,"audio","memory");
say "AUDIO MEMORY:" data
data=query(handle,filehandle,"audio","input");
say "AUDIO INPUT:" data
data=query(handle,filehandle,"audio","quality");
say "AUDIO QUALITY:" data
data=query(handle,filehandle,"audio","channels");
say "AUDIO CHANNELS:" data
data=query(handle,filehandle,"audio","rate");
say "AUDIO RATE:" data
data=query(handle,filehandle,"audio","overwrite");
say "AUDIO OVERWRITE:" data
data=query(handle,filehandle,"audio","monitor");
say "AUDIO MONITOR:" data
data=query(handle,filehandle,"properties","save_positions");
say "PROPERTIES SAVE_POSITIONS:" data
data=query(handle,filehandle,"properties","save_openpath");
say "PROPERTIES SAVE_OPENPATH:" data
data=query(handle,filehandle,"properties","save_savepath");
say "PROPERTIES SAVE_SAVEPATH:" data
data=query(handle,filehandle,"properties","footnotes");
say "PROPERTIES FOOTNOTES:" dtaa
data=query(handle,filehandle,"properties","memory");
say "PROPERTIES MEMORY:" data
data=query(handle,filehandle,"properties","enable_mmpm");
say "PROPERTIES ENABLE_MMPM:" data
data=query(handle,filehandle,"properties","share_audio");
say "PROPERTIES SHARE_AUDIO:" data
data=query(handle,filehandle,"properties","play_ON_COMMANDLINE_LOAD");
say "PROPERTIES PLAY_ON_COMMANDLINE_LOAD:" data
data=query(handle,filehandle,"properties","exit_after_commandline_play");
say "PROPERTIES EXIT_AFTER_COMMANDLINE_PLAY:" data
data=query(handle,filehandle,"properties","play_16on8");
say "PROPERTIES PLAY_16ON8:" data
data=query(handle,filehandle,"properties","device");
say "PROPERTIES DEVICE:" data
data=query(handle,filehandle,"properties","undo");
say "PROPERTIES UNDO:" data
data=query(handle,filehandle,"properties","ignore_header_style");
say "PROPERTIES IGNORE_HEADER_STYLE:" data
data=query(handle,filehandle,"properties","require_au_header");
say "PROPERTIES REQUIRE_AU_HEADER:" data
data=query(handle,filehandle,"properties","force_ulaw");
say "PROPERTIES FORCE_ULAW:" data
data=query(handle,filehandle,"properties","rexx_display_history");
say "PROPERTIES REXX_DISPLAY_HISTORY:" data
data=query(handle,filehandle,"properties","ini_path");
say "PROPERTIES INI_PATH:" data
data=query(handle,filehandle,"pmsndx","registered");
say "PMSNDX REGISTERED:" data
data=query(handle,filehandle,pmsndx,ignore_syntax_errors)
say "PMSNDX IGNORE_SYNTAX_ERRORS:" data
data=query(handle,filehandle,pmsndx,error_occurred)
say "PMSNDX ERROR_OCCURRED:" data
data=query(handle,filehandle,pmsndx,test_mode)
say "PMSNDX TEST_MODE:" data
data=query(handle,filehandle,pmsndx,output)
say "PMSNDX OUTPUT:" data
data=query(handle,filehandle,pmsndx,close)
say "PMSNDX CLOSE:" data
x=pmsndx(output,yes)

x=pmsndx(test_mode,yes)
x=audio(volume,70)
x=audio(record,sync,monitor,yes,input,mic,quality,8,channels,1,rate,11025,overwrite,yes,count,10000)
x=pmsndx(test_mode,no)

say "testing pull capability...type anything and then press ENTER"
pull data
say "pull result: " data

x=pmsndx(test_mode,yes)
filehandle1=file(open,'d:\wsh\samples\applause.au')
say "file handle: " filehandle1
filehandle2=file(open,'d:\wsh\samples\applause.au',format,au)
say "file handle: " filehandle2
x=audio(handle,filehandle,play,SYNC)
filehandle3=file(open,'\wsh\samples\brettapp.au')
say "file handle: " filehandle3
x=audio(handle,filehandle,play,ASYNC)
x=pmsndx(test_mode,no)

x=pmsndx(test_mode,yes)
x=properties(save_positions,no)
x=properties(save_openpath,no)
x=properties(save_savepath,no)
x=properties(memory,auto)
x=properties(enable_mmpm,yes)
x=properties(play_ON_COMMANDLINE_LOAD,no)
x=properties(exit_after_commandline_play,yes)
x=properties(play_16on8,no)
x=properties(device,waveaudio01)
x=properties(undo,yes)
x=properties(ignore_header_style,yes)
x=properties(require_au_header,no)
x=properties(rexx_display_history,256)
x=properties(ini_path,'d:\wsh\pmsndx')
x=pmsndx(TEST_MODE,NO)

x=pmsndx(TEST_MODE,no)
x=display(tools,no)
x=display(properties,no)
x=display(open,no)
x=pmsndx(TEST_MODE,NO)

x=pmsndx(test_mode,yes)
data=file(open,'applause.au')
data=file(open,'applause.au',format,au)
data=file(open,'applause.au',format,aif)
data=file(open,'applause.au',format,hcm)
data=file(open,'applause.au',format,sf)
data=file(open,'applause.au',format,voc)
data=file(open,'applause.au',format,smp)
data=file(open,'applause.au',format,wav)
data=file(open,'applause.au',format,iff)
data=file(open,'applause.au',format,UB,rate,1,channels,1)
data=file(open,'applause.au',format,SB,rate,1,channels,2)
data=file(open,'applause.au',format,UL,rate,1,channels,2)
data=file(open,'applause.au',format,UW,rate,1,channels,2,endian,little)
data=file(open,'applause.au',format,UW,rate,1,channels,2,endian,big)
data=file(open,'applause.au',format,SW,rate,1,channels,2,endian,little)
x=pmsndx(test_mode,no)

x=pmsndx(test_mode,yes)
say "Starting AUDIO section>"
x=audio(record,sync,memory,1,monitor,yes,input,mic,quality,8,channels,1,rate,1,overwrite,yes)
x=audio(record,sync,time,'1:2.3',input,mic,quality,8,channels,1,rate,1)
x=audio(record,async,time,'1:2.3',input,mic,quality,8,channels,1,rate,1)
x=audio(record,sync,time,'1:2.3',input,line,quality,8,channels,1,rate,1)
x=audio(record,sync,time,'1:2.3',input,mic,quality,16,channels,1,rate,1)
x=audio(record,sync,time,'1:2.3',input,mic,quality,8,channels,2,rate,1)
x=audio(record,sync,time,'1:2.3',input,mic,quality,8,channels,2,rate,1)
x=audio(record,sync,time,'1:2.3',input,mic,quality,8,channels,1,rate,1,overwrite,yes)
x=audio(record,sync,time,'1:2.3',input,mic,quality,8,channels,2,rate,1,overwrite,no)
x=audio(record,sync,time,'1:2.3',input,mic,quality,8,channels,2,rate,1,monitor,yes)
x=audio(record,sync,time,'1:2.3',input,mic,quality,8,channels,2,rate,1,monitor,no)
x=audio(record,sync,time,'1:2.3',input,mic,quality,8,channels,1,rate,1,overwrite,yes,monitor,yes)
x=audio(record,sync,time,'1:2.3',quality,8,channels,1,rate,1,overwrite,yes,monitor,yes,input,mic)
x=audio(record,sync,time,'1:2.3',channels,1,rate,1,overwrite,yes,monitor,yes,input,mic,quality,8)
x=audio(record,sync,time,'1:2.3',rate,1,overwrite,yes,monitor,yes,input,mic,quality,8,channels,1)
x=audio(record,sync,time,'1:2.3',overwrite,yes,monitor,yes,input,mic,quality,8,channels,1,rate,1)
x=audio(record,sync,time,'1:2.3',monitor,yes,input,mic,quality,8,channels,1,rate,1,overwrite,yes)
x=audio(record,sync,count,1,monitor,yes,input,mic,quality,8,channels,1,rate,1,overwrite,yes)
x=pmsndx(test_mode,no)

x=pmsndx(test_mode,yes)
x=audio(volume,80)
x=audio(handle,filehandle,play,async)
x=audio(handle,filehandle,play,sync)
x=audio(handle,filehandle,rewind)
x=pmsndx(test_mode,no)

x=pmsndx(test_mode,yes)
x=properties(enable_mmpm,no)
x=properties(enable_mmpm,yes)
x=properties(share_audio,yes)
x=properties(share_audio,no)
x=properties(play_16on8,yes)
x=properties(play_16on8,no)
x=properties(device,waveaudio01)
x=properties(memory,auto)
x=properties(memory,1)
x=properties(ignore_header_style,yes)
x=properties(ignore_header_style,no)
x=properties(require_au_header,yes)
x=properties(require_au_header,no)
x=properties(force_ulaw,yes)
x=properties(force_ulaw,no)
x=properties(force_ulaw,maybe)
x=properties(ini_path,'d:\wsh\pmsndx')
x=properties(rexx_stdin_color,black)
x=properties(rexx_stdin_color,blue)
x=properties(rexx_stdin_color,red)
x=properties(rexx_stdin_color,pink)
x=properties(rexx_stdin_color,green)
x=properties(rexx_stdin_color,cyan)
x=properties(rexx_stdin_color,yellow)
x=properties(rexx_stdin_color,grey)
x=properties(rexx_stdin_color,dgrey)
x=properties(rexx_stdin_color,dblue)
x=properties(rexx_stdin_color,dred)
x=properties(rexx_stdin_color,dpink)
x=properties(rexx_stdin_color,dgreen)
x=properties(rexx_stdin_color,dcyan)
x=properties(rexx_stdin_color,dyellow)
x=properties(rexx_stdin_color,lgrey)

x=properties(rexx_stdin_color,BLACK)
x=properties(rexx_stdout_color,BLACK)
x=properties(rexx_stderr_color,RED)
x=properties(rexx_command_color,BLUE)
x=properties(rexx_display_history,64)
x=properties(rexx_display_history,32767)
x=properties(footnotes,yes)
x=properties(footnotes,no)
x=properties(save_positions,yes)
x=properties(save_positions,no)
x=properties(save_openpath,yes)
x=properties(save_openpath,no)
x=properties(save_savepath,yes)
x=properties(save_savepath,no)
x=properties(play_on_commandline_load,yes)
x=properties(play_on_commandline_load,no)
x=properties(exit_after_commandline_play,yes)
x=properties(exit_after_commandline_play,no)
x=properties(free_memory_after_loading,yes)
x=properties(free_memory_after_loading,no)
x=properties(auto_rate_adjust,yes)
x=properties(auto_rate_adjust,no)
x=properties(undo,yes)
x=properties(undo,no)
x=properties(use_displayed_channel,yes)
x=properties(use_displayed_channel,no)
x=properties(use_displayed_range,yes)
x=properties(use_displayed_range,no)
x=properties(editor_info,yes)
x=properties(editor_info,no)
x=properties(editor_all_channels,yes)
x=properties(editor_all_channels,no)
x=properties(editor_delay_audio_loading,yes)
x=properties(editor_delay_audio_loading,no)
x=properties(editor_setup_audio_at_play,yes)
x=properties(editor_setup_audio_at_play,no)
x=properties(editor_auto_repeat,yes)
x=properties(editor_auto_repeat,no)
x=properties(editor_format_time,yes)
x=properties(editor_format_time,no)
x=properties(editor_play_mode_range,yes)
x=properties(editor_play_mode_range,no)

x=edit(handle,filehandle,manipulate,all)
x=edit(handle,filehandle,manipulate,1)
x=edit(handle,filehandle,manipulate,2)
x=edit(handle,filehandle,manipulate,3)
x=edit(handle,filehandle,manipulate,4)
x=edit(handle,filehandle,area,entire_sample)
x=edit(handle,filehandle,area,part,start,'1:1.1',end,'1:1.1')
x=edit(handle,filehandle,copy)
x=edit(handle,filehandle,cut)
x=edit(handle,filehandle,paste)
x=edit(handle,filehandle,zero)
x=edit(handle,filehandle,remove)
x=edit(handle,filehandle,clear)
x=edit(handle,filehandle,merge)
x=edit(handle,filehandle,pastefrom,filehandle1)
x=edit(handle,filehandle,mergefrom,filehandle1)
x=edit(handle,filehandle,undo)
x=pmsndx(test_mode,no)

x=pmsndx(test_mode,yes)
x=tools(handle,filehandle,format,au)
x=tools(handle,filehandle,format,aif)
x=tools(handle,filehandle,format,hcm)
x=tools(handle,filehandle,format,sf)
x=tools(handle,filehandle,format,voc)
x=tools(handle,filehandle,format,smp)
x=tools(handle,filehandle,format,wav)
x=tools(handle,filehandle,format,iff)
x=tools(handle,filehandle,format,ub)
x=tools(handle,filehandle,format,sb)
x=tools(handle,filehandle,format,ul)
x=tools(handle,filehandle,format,uw)
x=tools(handle,filehandle,format,sw)
x=tools(handle,filehandle,format,sw)

x=tools(handle,filehandle,average,2_to_1,from,left)
x=tools(handle,filehandle,average,2_to_1,from,center)
x=tools(handle,filehandle,average,2_to_1,from,right)

x=tools(handle,filehandle,average,4_to_1,from,fl,from,fr,from,rl,from,rr)

/*x=tools(handle,filehandle,average,4_to_2,from,fl,to,l)
x=tools(handle,filehandle,average,4_to_2,from,fr,to,l)
x=tools(handle,filehandle,average,4_to_2,from,rl,to,l)
x=tools(handle,filehandle,average,4_to_2,from,rr,to,l)
x=tools(handle,filehandle,average,4_to_2,from,fl,to,r)
x=tools(handle,filehandle,average,4_to_2,from,fr,to,r)
x=tools(handle,filehandle,average,4_to_2,from,rl,to,r)
x=tools(handle,filehandle,average,4_to_2,from,rr,to,r) */
x=tools(handle,filehandle,average,4_to_2,from,fl,to,l,from,rl,to,l,from,fr,to,r,from,rr,to,r)

x=tools(handle,filehandle,dupe,1_to_2)
x=tools(handle,filehandle,dupe,1_to_4)
/*x=tools(handle,filehandle,dupe,2_to_4,from,l,to,fl)
x=tools(handle,filehandle,dupe,2_to_4,from,l,to,fr)
x=tools(handle,filehandle,dupe,2_to_4,from,l,to,rl)
x=tools(handle,filehandle,dupe,2_to_4,from,l,to,rr)
x=tools(handle,filehandle,dupe,2_to_4,from,r,to,fl)
x=tools(handle,filehandle,dupe,2_to_4,from,r,to,fr)
x=tools(handle,filehandle,dupe,2_to_4,from,r,to,rl)
x=tools(handle,filehandle,dupe,2_to_4,from,r,to,rr) */
x=tools(handle,filehandle,dupe,2_to_4,from,l,to,fl,from,l,to,rl,from,r,to,fr,from,r,to,rr)

x=tools(handle,filehandle,rate,1)
x=tools(handle,filehandle,speed,1)
x=tools(handle,filehandle,speed,double)
x=tools(handle,filehandle,speed,half)

x=tools(handle,filehandle,filter,bandpass,start,1,cutoff,1)
x=tools(handle,filehandle,filter,bandpass,start,1,cutoff,1,add_noise,no)
x=tools(handle,filehandle,filter,bandpass,center,1,width,1)
x=tools(handle,filehandle,filter,bandpass,center,1,width,1,add_noise,yes)
x=tools(handle,filehandle,filter,lowpass,center,1,gain,0.8)

x=tools(handle,filehandle,effect,echo,mark,'1:1.1',volume,0.4,mark,'2:2.2',volume,0.4)
x=tools(handle,filehandle,effect,invert)
x=tools(handle,filehandle,effect,reverse)
x=tools(handle,filehandle,effect,vibro,speed,15,depth,0.5)
x=tools(handle,filehandle,effect,fade,direction,in,method,linear)
x=tools(handle,filehandle,effect,fade,direction,out,method,linear)
x=tools(handle,filehandle,effect,fade,direction,in,method,slow)
x=tools(handle,filehandle,effect,fade,direction,in,method,fast)
x=tools(handle,filehandle,effect,limit,max,80)
x=tools(handle,filehandle,effect,limit,multiple,1.0)
x=tools(handle,filehandle,effect,balance2,l,80,r,80,direction,in,method,linear)
x=tools(handle,filehandle,effect,balance2,l,80,r,80,direction,out,method,linear)
x=tools(handle,filehandle,effect,balance2,l,80,r,80,direction,in,method,slow)
x=tools(handle,filehandle,effect,balance2,l,80,r,80,direction,in,method,fast)
x=tools(handle,filehandle,effect,balance2,l,80,r,80,direction,in,method,step)
x=tools(handle,filehandle,effect,balance4,fl,80,fr,80,rl,80,rr,80,direction,in,method,linear)
x=tools(handle,filehandle,effect,balance4,fl,80,fr,80,rl,80,rr,80,direction,out,method,linear)
x=tools(handle,filehandle,effect,balance4,fl,80,fr,80,rl,80,rr,80,direction,in,method,slow)
x=tools(handle,filehandle,effect,balance4,fl,80,fr,80,rl,80,rr,80,direction,in,method,fast)
x=tools(handle,filehandle,effect,balance4,fl,80,fr,80,rl,80,rr,80,direction,in,method,step)
x=pmsndx(test_mode,no)

x=pmsndx(close,no)
return 'rexx done'

